/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TmfEventFieldValueEqualsTest {
    private static final @NonNull String FIELD_NAME = "Field1";
    private TmfEventField fField1;
    private TmfEventField fField2;

    @After
    public void tearDown() {
        this.fField1 = null;
        this.fField2 = null;
    }

    private void createFields(Object value1, Object value2) {
        this.fField1 = new TmfEventField(FIELD_NAME, value1, null);
        this.fField2 = new TmfEventField(FIELD_NAME, value2, null);
    }

    @Test
    public void testValueArrayObject() {
        Object object1 = new Object();
        Object object2 = new Object();
        Assert.assertNotEquals((Object)object1, (Object)object2);
        Object[] value1 = new Object[]{object1, object2};
        Object[] value2 = new Object[]{object1, object2};
        Assert.assertNotEquals((Object)value1, (Object)value2);
        Assert.assertTrue((boolean)Arrays.equals(value1, value2));
        this.createFields(value1, value2);
        Assert.assertEquals((Object)this.fField1, (Object)this.fField2);
    }

    @Test
    public void testValueArrayPrimitives() {
        long[] value1 = new long[]{10L, 20L};
        long[] value2 = new long[]{10L, 20L};
        Assert.assertNotEquals((Object)value1, (Object)value2);
        Assert.assertTrue((boolean)Arrays.equals(value1, value2));
        this.createFields(value1, value2);
        Assert.assertEquals((Object)this.fField1, (Object)this.fField2);
    }

    @Test
    public void testValueArrayPrimitivesNotEquals() {
        long[] value1 = new long[]{10L, 20L};
        long[] value2 = new long[]{10L, 30L};
        this.createFields(value1, value2);
        Assert.assertNotEquals((Object)this.fField1, (Object)this.fField2);
    }

    @Test
    public void testValueArrayOfArrays() {
        long[][] value1 = new long[][]{{10L, 20L}, {10L, 30L}};
        long[][] value2 = new long[][]{{10L, 20L}, {10L, 30L}};
        Assert.assertNotEquals((Object)value1, (Object)value2);
        Assert.assertTrue((boolean)Arrays.deepEquals((Object[])value1, (Object[])value2));
        this.createFields(value1, value2);
        Assert.assertEquals((Object)this.fField1, (Object)this.fField2);
    }

    @Test
    public void testValueArrayOfArraysNotEquals() {
        long[][] value1 = new long[][]{{10L, 20L}, {10L, 30L}};
        long[][] value2 = new long[][]{{10L, 20L}, {15L, 40L}};
        Assert.assertNotEquals((Object)value1, (Object)value2);
        Assert.assertFalse((boolean)Arrays.deepEquals((Object[])value1, (Object[])value2));
        this.createFields(value1, value2);
        Assert.assertNotEquals((Object)this.fField1, (Object)this.fField2);
    }

    @Test
    public void testValueArrayMismatchedTypes() {
        Object[] value1 = new Object[]{new Object(), new Object()};
        long[] value2 = new long[]{10L, 20L};
        this.createFields(value1, value2);
        Assert.assertNotEquals((Object)this.fField1, (Object)this.fField2);
    }

    @Test
    public void testValueArrayAndOther() {
        long[] value1 = new long[]{10L, 20L};
        Integer value2 = 10;
        this.createFields(value1, value2);
        Assert.assertNotEquals((Object)this.fField1, (Object)this.fField2);
    }
}

