/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.log.Log;

public abstract class AbstractHandler
extends AggregateLifeCycle
implements Handler {
    private Server _server;

    protected void doStart() throws Exception {
        Log.debug((String)"starting {}", (Object)this);
        super.doStart();
    }

    protected void doStop() throws Exception {
        Log.debug((String)"stopping {}", (Object)this);
        super.doStop();
    }

    public void setServer(Server server) {
        Server old_server = this._server;
        if (old_server != null && old_server != server) {
            old_server.getContainer().removeBean((Object)this);
        }
        this._server = server;
        if (this._server != null && this._server != old_server) {
            this._server.getContainer().addBean((Object)this);
        }
    }

    public Server getServer() {
        return this._server;
    }

    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        super.destroy();
        if (this._server != null) {
            this._server.getContainer().removeBean((Object)this);
        }
    }

    public void dumpThis(Appendable out) throws IOException {
        out.append(this.toString()).append(' ').append(this.getState()).append('\n');
    }
}

