/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.eclipse.equinox.internal.cm.reliablefile.ReliableFile;
import org.eclipse.equinox.internal.cm.reliablefile.ReliableFileInputStream;
import org.eclipse.equinox.internal.cm.reliablefile.ReliableFileOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;

class ConfigurationStore {
    private final ConfigurationAdminFactory configurationAdminFactory;
    private static final String STORE_DIR = "store";
    private static final String PID_EXT = ".pid";
    private final Map configurations = new HashMap();
    private int createdPidCount = 0;
    private final File store;

    public ConfigurationStore(ConfigurationAdminFactory configurationAdminFactory, BundleContext context) {
        this.configurationAdminFactory = configurationAdminFactory;
        this.store = context.getDataFile(STORE_DIR);
        if (this.store == null) {
            return;
        }
        this.store.mkdir();
        File[] configurationFiles = this.store.listFiles();
        int i = 0;
        while (i < configurationFiles.length) {
            String configurationFileName = configurationFiles[i].getName();
            if (configurationFileName.endsWith(PID_EXT)) {
                boolean deleteFile;
                block32: {
                    ReliableFileInputStream ris;
                    block34: {
                        ris = null;
                        ObjectInputStream ois = null;
                        deleteFile = false;
                        try {
                            ris = new ReliableFileInputStream(configurationFiles[i]);
                            ois = new ObjectInputStream(ris);
                            Dictionary dictionary = (Dictionary)ois.readObject();
                            ConfigurationImpl config = new ConfigurationImpl(configurationAdminFactory, this, dictionary);
                            this.configurations.put(config.getPid(), config);
                        }
                        catch (IOException e) {
                            String message = e.getMessage();
                            String pid = configurationFileName.substring(0, configurationFileName.length() - 4);
                            String errorMessage = "{Configuration Admin - pid = " + pid + "} could not be restored." + (message == null ? "" : " " + message);
                            configurationAdminFactory.log(1, errorMessage);
                            deleteFile = true;
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (ris != null) {
                                try {
                                    ((InputStream)ris).close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block32;
                        }
                        catch (ClassNotFoundException e) {
                            block33: {
                                try {
                                    configurationAdminFactory.log(1, e.getMessage());
                                    if (ois == null) break block33;
                                }
                                catch (Throwable throwable) {
                                    if (ois != null) {
                                        try {
                                            ois.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (ris != null) {
                                        try {
                                            ((InputStream)ris).close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    throw throwable;
                                }
                                try {
                                    ois.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (ris != null) {
                                try {
                                    ((InputStream)ris).close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block32;
                        }
                        if (ois == null) break block34;
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (ris != null) {
                        try {
                            ((InputStream)ris).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (deleteFile) {
                    ReliableFile.delete(configurationFiles[i]);
                    configurationFiles[i].delete();
                }
            }
            ++i;
        }
    }

    public void saveConfiguration(String pid, ConfigurationImpl config) throws IOException {
        if (this.store == null) {
            return;
        }
        config.checkLocked();
        final File configFile = new File(this.store, String.valueOf(pid) + PID_EXT);
        final Dictionary configProperties = config.getAllProperties();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ConfigurationStore.this.writeConfigurationFile(configFile, configProperties);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    void writeConfigurationFile(File configFile, Dictionary configProperties) throws IOException {
        ReliableFileOutputStream ros = null;
        ObjectOutputStream oos = null;
        try {
            configFile.createNewFile();
            ros = new ReliableFileOutputStream(configFile);
            oos = new ObjectOutputStream(ros);
            oos.writeObject(configProperties);
        }
        catch (Throwable throwable) {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            if (ros != null) {
                try {
                    ((OutputStream)ros).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (oos != null) {
            try {
                oos.close();
            }
            catch (IOException iOException) {}
        }
        if (ros != null) {
            try {
                ((OutputStream)ros).close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void removeConfiguration(String pid) {
        this.configurations.remove(pid);
        if (this.store == null) {
            return;
        }
        final File configFile = new File(this.store, String.valueOf(pid) + PID_EXT);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ConfigurationStore.this.deleteConfigurationFile(configFile);
                return null;
            }
        });
    }

    void deleteConfigurationFile(File configFile) {
        ReliableFile.delete(configFile);
        configFile.delete();
    }

    public synchronized ConfigurationImpl getConfiguration(String pid, String location) {
        ConfigurationImpl config = (ConfigurationImpl)this.configurations.get(pid);
        if (config == null) {
            config = new ConfigurationImpl(this.configurationAdminFactory, this, null, pid, location);
            this.configurations.put(pid, config);
        }
        return config;
    }

    public synchronized ConfigurationImpl createFactoryConfiguration(String factoryPid, String location) {
        String pid = String.valueOf(factoryPid) + "-" + new Date().getTime() + "-" + this.createdPidCount++;
        ConfigurationImpl config = new ConfigurationImpl(this.configurationAdminFactory, this, factoryPid, pid, location);
        this.configurations.put(pid, config);
        return config;
    }

    public synchronized ConfigurationImpl findConfiguration(String pid) {
        return (ConfigurationImpl)this.configurations.get(pid);
    }

    public synchronized ConfigurationImpl[] getFactoryConfigurations(String factoryPid) {
        ArrayList<ConfigurationImpl> resultList = new ArrayList<ConfigurationImpl>();
        Iterator it = this.configurations.values().iterator();
        while (it.hasNext()) {
            ConfigurationImpl config = (ConfigurationImpl)it.next();
            String otherFactoryPid = config.getFactoryPid();
            if (otherFactoryPid == null || !otherFactoryPid.equals(factoryPid)) continue;
            resultList.add(config);
        }
        return resultList.toArray(new ConfigurationImpl[0]);
    }

    public synchronized ConfigurationImpl[] listConfigurations(Filter filter) {
        ArrayList<ConfigurationImpl> resultList = new ArrayList<ConfigurationImpl>();
        Iterator it = this.configurations.values().iterator();
        while (it.hasNext()) {
            ConfigurationImpl config = (ConfigurationImpl)it.next();
            Dictionary properties = config.getAllProperties();
            if (properties == null || !filter.match(properties)) continue;
            resultList.add(config);
        }
        int size = resultList.size();
        return size == 0 ? null : resultList.toArray(new ConfigurationImpl[size]);
    }

    public synchronized void unbindConfigurations(Bundle bundle) {
        Iterator it = this.configurations.values().iterator();
        while (it.hasNext()) {
            ConfigurationImpl config = (ConfigurationImpl)it.next();
            config.unbind(bundle);
        }
    }
}

