/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jpa.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.jpa.core.resource.java.NestableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationContainerTools {
    public static <T extends NestableAnnotation> NestableAnnotation addNestedAnnotation(int index, AnnotationContainer<T> annotationContainer) {
        int sourceIndex = annotationContainer.getNestedAnnotationsSize();
        T nestedAnnotation = annotationContainer.addNestedAnnotation();
        nestedAnnotation.newAnnotation();
        AnnotationContainerTools.moveNestedAnnotation(index, sourceIndex, annotationContainer);
        return nestedAnnotation;
    }

    public static <T extends NestableAnnotation> void moveNestedAnnotation(int targetIndex, int sourceIndex, AnnotationContainer<T> annotationContainer) {
        if (targetIndex != sourceIndex) {
            AnnotationContainerTools.moveNestedAnnotation_(targetIndex, sourceIndex, annotationContainer);
        }
    }

    private static <T extends NestableAnnotation> void moveNestedAnnotation_(int targetIndex, int sourceIndex, AnnotationContainer<T> annotationContainer) {
        T nestedAnnotation = annotationContainer.moveNestedAnnotation(targetIndex, sourceIndex);
        AnnotationContainerTools.syncAstAnnotationsAfterMove(targetIndex, sourceIndex, annotationContainer, nestedAnnotation);
    }

    private static <T extends NestableAnnotation> void syncAstAnnotationsAfterMove(int targetIndex, int sourceIndex, AnnotationContainer<T> annotationContainer, NestableAnnotation nestedAnnotation) {
        nestedAnnotation.moveAnnotation(annotationContainer.getNestedAnnotationsSize());
        ArrayList nestableAnnotations = CollectionTools.list(annotationContainer.getNestedAnnotations());
        if (sourceIndex < targetIndex) {
            int i = sourceIndex;
            while (i < targetIndex) {
                ((NestableAnnotation)nestableAnnotations.get(i)).moveAnnotation(i);
                ++i;
            }
        } else {
            int i = sourceIndex;
            while (i > targetIndex) {
                ((NestableAnnotation)nestableAnnotations.get(i)).moveAnnotation(i);
                --i;
            }
        }
        nestedAnnotation.moveAnnotation(targetIndex);
    }

    public static <T extends NestableAnnotation> void removeNestedAnnotation(int index, AnnotationContainer<T> annotationContainer) {
        T nestedAnnotation = annotationContainer.removeNestedAnnotation(index);
        nestedAnnotation.removeAnnotation();
        AnnotationContainerTools.syncAstAnnotationsAfterRemove(index, annotationContainer);
    }

    private static <T extends NestableAnnotation> void syncAstAnnotationsAfterRemove(int index, AnnotationContainer<T> annotationContainer) {
        ArrayList nestableAnnotations = CollectionTools.list(annotationContainer.getNestedAnnotations());
        int i = index;
        while (i < nestableAnnotations.size()) {
            ((NestableAnnotation)nestableAnnotations.get(i)).moveAnnotation(i);
            ++i;
        }
    }

    public static <T extends NestableAnnotation> void initialize(AnnotationContainer<T> annotationContainer, CompilationUnit astRoot) {
        int size = AnnotationContainerTools.getNestedAstAnnotations(astRoot, annotationContainer).size();
        int i = 0;
        while (i < size) {
            T nestedAnnotation = annotationContainer.addNestedAnnotation();
            nestedAnnotation.initialize(astRoot);
            ++i;
        }
    }

    private static <T extends NestableAnnotation> List<Annotation> getNestedAstAnnotations(CompilationUnit astRoot, AnnotationContainer<T> annotationContainer) {
        Annotation astContainerAnnotation = annotationContainer.getAstAnnotation(astRoot);
        if (astContainerAnnotation == null) {
            return Collections.emptyList();
        }
        if (astContainerAnnotation.isMarkerAnnotation()) {
            return Collections.emptyList();
        }
        if (astContainerAnnotation.isSingleMemberAnnotation()) {
            return AnnotationContainerTools.getNestedAstAnnotations((SingleMemberAnnotation)astContainerAnnotation, annotationContainer);
        }
        if (astContainerAnnotation.isNormalAnnotation()) {
            return AnnotationContainerTools.getNestedAstAnnotations((NormalAnnotation)astContainerAnnotation, annotationContainer);
        }
        throw new IllegalStateException("unknown annotation type: " + astContainerAnnotation);
    }

    private static <T extends NestableAnnotation> List<Annotation> getNestedAstAnnotations(SingleMemberAnnotation astContainerAnnotation, AnnotationContainer<T> annotationContainer) {
        return annotationContainer.getElementName().equals("value") ? AnnotationContainerTools.getAstAnnotations(astContainerAnnotation.getValue(), annotationContainer) : Collections.emptyList();
    }

    private static <T extends NestableAnnotation> List<Annotation> getNestedAstAnnotations(NormalAnnotation astContainerAnnotation, AnnotationContainer<T> annotationContainer) {
        MemberValuePair pair = AnnotationContainerTools.getMemberValuePair(astContainerAnnotation, annotationContainer.getElementName());
        return pair != null ? AnnotationContainerTools.getAstAnnotations(pair.getValue(), annotationContainer) : Collections.emptyList();
    }

    private static <T extends NestableAnnotation> List<Annotation> getAstAnnotations(Expression expression, AnnotationContainer<T> annotationContainer) {
        return expression != null ? AnnotationContainerTools.getAstAnnotations_(expression, annotationContainer.getNestedAnnotationName()) : Collections.emptyList();
    }

    private static <T extends NestableAnnotation> List<Annotation> getAstAnnotations_(Expression expression, String annotationName) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        AnnotationContainerTools.addAstAnnotationsTo(expression, annotationName, result);
        return result;
    }

    private static void addAstAnnotationsTo(Expression expression, String annotationName, ArrayList<Annotation> astAnnotations) {
        if (expression.getNodeType() == 4) {
            AnnotationContainerTools.addAstAnnotationsTo((ArrayInitializer)expression, annotationName, astAnnotations);
        } else {
            AnnotationContainerTools.addAstAnnotationTo(expression, annotationName, astAnnotations);
        }
    }

    private static void addAstAnnotationsTo(ArrayInitializer arrayInitializer, String annotationName, ArrayList<Annotation> astAnnotations) {
        List expressions = arrayInitializer.expressions();
        for (Expression expression : expressions) {
            if (expression == null) continue;
            AnnotationContainerTools.addAstAnnotationTo(expression, annotationName, astAnnotations);
        }
    }

    private static void addAstAnnotationTo(Expression expression, String annotationName, ArrayList<Annotation> astAnnotations) {
        switch (expression.getNodeType()) {
            case 77: 
            case 78: 
            case 79: {
                Annotation astAnnotation = (Annotation)expression;
                if (!AnnotationContainerTools.getQualifiedName(astAnnotation).equals(annotationName)) break;
                astAnnotations.add(astAnnotation);
                break;
            }
        }
    }

    private static String getQualifiedName(Annotation astAnnotation) {
        String resolvedName;
        ITypeBinding typeBinding = astAnnotation.resolveTypeBinding();
        if (typeBinding != null && (resolvedName = typeBinding.getQualifiedName()) != null) {
            return resolvedName;
        }
        return astAnnotation.getTypeName().getFullyQualifiedName();
    }

    private static MemberValuePair getMemberValuePair(NormalAnnotation annotation, String elementName) {
        List pairs = annotation.values();
        for (MemberValuePair pair : pairs) {
            if (!pair.getName().getFullyQualifiedName().equals(elementName)) continue;
            return pair;
        }
        return null;
    }

    public static <T extends NestableAnnotation> void synchronize(AnnotationContainer<T> annotationContainer, CompilationUnit astRoot) {
        List<Annotation> astAnnotations = AnnotationContainerTools.getNestedAstAnnotations(astRoot, annotationContainer);
        Iterator<Annotation> astAnnotationStream = astAnnotations.iterator();
        for (NestableAnnotation nestedAnnotation : annotationContainer.getNestedAnnotations()) {
            if (astAnnotationStream.hasNext()) {
                astAnnotationStream.next();
                nestedAnnotation.synchronizeWith(astRoot);
                continue;
            }
            annotationContainer.syncRemoveNestedAnnotations(astAnnotations.size());
            return;
        }
        while (astAnnotationStream.hasNext()) {
            annotationContainer.syncAddNestedAnnotation(astAnnotationStream.next());
        }
    }

    private AnnotationContainerTools() {
        throw new UnsupportedOperationException();
    }
}

