import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

import net.y3n20u.aeszip.AesZipEncrypter;
import net.y3n20u.aeszip.ArchiveProgressListener;
import net.y3n20u.aeszip.ArchiveProgressStatus;

public class AesZipSample {
	
	public static void main(String[] args) {
		File destFile = new File("c:\\temp\\abc.zip");
		AesZipEncrypter zip = new AesZipEncrypter(destFile);
		
		zip.setProgressListener(new ArchiveProgressListener() {
			@Override
			public void start() {
				System.out.println("start archive.");
			}
			
			@Override
			public void notifyStatus(ArchiveProgressStatus status) {
				System.out.println(MessageFormat.format("[{0}] to [{1}].", status.getProcessedSourceName(), status.getDestinationName()));
				System.out.print(MessageFormat.format("current {0}%, total {1}%.  ", status.getProgressPercentageCurrent(), status.getProgressPercentageTotal()));
				System.out.print(MessageFormat.format("count [{0} / {1}].  ", status.getProcessedElementCount(), status.getTotalElementCount()));
				System.out.print(MessageFormat.format("current [{0} / {1}].  ", status.getProcessedSizeCurrent(), status.getEstimatedSizeCurrent()));
				System.out.println(MessageFormat.format("total [{0} / {1}].", status.getProcessedSizeTotal(), status.getEstimatedSizeTotal()));
			}
			
			@Override
			public void finishedAll() {
				System.out.println("finished.");
			}
		});
		
		zip.add("abc", new File("c:\\temp\\abc"), "password");
		zip.add("abc/cde", new File("c:\\temp\\abc\\def"), "password");
		zip.add("abc/cde.txt", new File("c:\\temp\\abc\\cde.txt"), "password");
		try {
			zip.archive();
		} catch (IOException e) {
			destFile.delete();
			e.printStackTrace();
		}
	}

}
