package net.y3n20u.aeszip;

import java.io.File;

import de.idyl.crypto.zip.AesZipFileDecrypter;
import de.idyl.crypto.zip.impl.ExtZipEntry;

public class ExternalDecrypterImpl implements ExternalDecrypter {

	@Override
	public void decryptAndExtractFile(File sourceFile, File destination, String password) throws Exception {
		if (!destination.isDirectory()) {
			throw new IllegalArgumentException();
		}
		AesZipFileDecrypter dec = new AesZipFileDecrypter(sourceFile);
		dec.charset = "UTF-8";
		for (ExtZipEntry entry : dec.getEntryList()) {
			File destinationFile = new File(destination, entry.getName());
			System.out.println(destinationFile.getAbsolutePath());
			if (entry.isDirectory()) {
				destinationFile.mkdir();
			}
			else {
				dec.extractEntry(entry, destinationFile, password);
			}
		}
	}

}
