/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class CreateSequenceNode
extends DDLStatementNode {
    private TableName _sequenceName;
    private DataTypeDescriptor _dataType;
    private Long _initialValue;
    private Long _stepValue;
    private Long _maxValue;
    private Long _minValue;
    private Boolean _cycle;
    public static final int SEQUENCE_ELEMENT_COUNT = 1;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws StandardException {
        this._sequenceName = (TableName)object;
        this.initAndCheck(this._sequenceName);
        this._dataType = object2 != null ? (DataTypeDescriptor)object2 : DataTypeDescriptor.INTEGER;
        Long l = this._stepValue = object4 != null ? (Long)object4 : new Long(1L);
        if (this._dataType.getTypeId().equals(TypeId.SMALLINT_ID)) {
            this._minValue = object6 != null ? (Long)object6 : new Long(-32768L);
            this._maxValue = object5 != null ? (Long)object5 : new Long(32767L);
        } else if (this._dataType.getTypeId().equals(TypeId.INTEGER_ID)) {
            this._minValue = object6 != null ? (Long)object6 : new Long(Integer.MIN_VALUE);
            this._maxValue = object5 != null ? (Long)object5 : new Long(Integer.MAX_VALUE);
        } else {
            this._minValue = object6 != null ? (Long)object6 : new Long(Long.MIN_VALUE);
            Long l2 = this._maxValue = object5 != null ? (Long)object5 : new Long(Long.MAX_VALUE);
        }
        this._initialValue = object3 != null ? (Long)object3 : (this._stepValue > 0L ? this._minValue : this._maxValue);
        this._cycle = object7 != null ? (Boolean)object7 : Boolean.FALSE;
        this.implicitCreateSchema = true;
    }

    public String toString() {
        return "";
    }

    public void bindStatement() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        if (this._sequenceName.getSchemaName() == null) {
            this._sequenceName.setSchemaName(schemaDescriptor.getSchemaName());
        }
        if (this._dataType.getTypeId().equals(TypeId.SMALLINT_ID)) {
            if (this._minValue < -32768L || this._minValue >= 32767L) {
                throw StandardException.newException("42XAE", "MINVALUE", (Object)"SMALLINT", (Object)"-32768", (Object)"32767");
            }
            if (this._maxValue <= -32768L || this._maxValue > 32767L) {
                throw StandardException.newException("42XAE", "MAXVALUE", (Object)"SMALLINT", (Object)"-32768", (Object)"32767");
            }
        } else if (this._dataType.getTypeId().equals(TypeId.INTEGER_ID)) {
            if (this._minValue < Integer.MIN_VALUE || this._minValue >= Integer.MAX_VALUE) {
                throw StandardException.newException("42XAE", "MINVALUE", (Object)"INTEGER", (Object)"-2147483648", (Object)"2147483647");
            }
            if (this._maxValue <= Integer.MIN_VALUE || this._maxValue > Integer.MAX_VALUE) {
                throw StandardException.newException("42XAE", "MAXVALUE", (Object)"INTEGER", (Object)"-2147483648", (Object)"2147483647");
            }
        } else {
            if (this._minValue < Long.MIN_VALUE || this._minValue >= Long.MAX_VALUE) {
                throw StandardException.newException("42XAE", "MINVALUE", (Object)"BIGINT", (Object)"-9223372036854775808", (Object)"9223372036854775807");
            }
            if (this._maxValue <= Long.MIN_VALUE || this._maxValue > Long.MAX_VALUE) {
                throw StandardException.newException("42XAE", "MAXVALUE", (Object)"BIGINT", (Object)"-9223372036854775808", (Object)"9223372036854775807");
            }
        }
        if (this._minValue >= this._maxValue) {
            throw StandardException.newException("42XAF", (Object)this._minValue.toString(), (Object)this._maxValue.toString());
        }
        if (this._initialValue < this._minValue || this._initialValue > this._maxValue) {
            throw StandardException.newException("42XAG", (Object)this._initialValue.toString(), (Object)this._minValue.toString(), (Object)this._maxValue.toString());
        }
        if (this._stepValue == 0L) {
            throw StandardException.newException("42XAC");
        }
    }

    public String statementToString() {
        return "CREATE SEQUENCE";
    }

    public ConstantAction makeConstantAction() {
        return this.getGenericConstantActionFactory().getCreateSequenceConstantAction(this._sequenceName, this._dataType, this._initialValue, this._stepValue, this._maxValue, this._minValue, this._cycle);
    }
}

