/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.MatchError;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterator;
import scala.collection.Parallelizable;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Vector$;
import scala.collection.immutable.Vector$$anon$1;
import scala.collection.immutable.VectorPointer;
import scala.collection.mutable.FlatHashTable$class;

public final class Vector
implements Serializable,
IndexedSeq,
IndexedSeqLike,
Parallelizable,
GenericTraversableTemplate,
VectorPointer {
    private int startIndex;
    private int endIndex;
    private int focus;
    private boolean dirty;
    private int depth;
    private Object[] display0;
    private Object[] display1;
    private Object[] display2;
    private Object[] display3;
    private Object[] display4;
    private Object[] display5;

    public final GenericCompanion companion() {
        return Vector$.MODULE$;
    }

    public final int length() {
        return this.endIndex - this.startIndex;
    }

    public final int lengthCompare(int n) {
        return this.length() - n;
    }

    public final Iterator reverseIterator() {
        return new Vector$$anon$1(this);
    }

    public final Object apply(int n) {
        Vector vector = this;
        int n2 = n + vector.startIndex;
        if (n < 0 || n2 >= vector.endIndex) {
            throw new IndexOutOfBoundsException(((Object)n).toString());
        }
        int n3 = n2;
        return this.getElem(n3, n3 ^ this.focus);
    }

    private Vector drop(int n) {
        if (this.startIndex + 1 < this.endIndex) {
            boolean bl;
            int n2 = this.startIndex + 1;
            Vector vector = this;
            int n3 = n2 & 0xFFFFFFE0;
            int n4 = Vector.requiredDepth(n2 ^ vector.endIndex - 1);
            int n5 = n2 & ~((1 << n4 * 5) - 1);
            Vector vector2 = new Vector(n2 - n5, vector.endIndex - n5, n3 - n5);
            vector2.initFrom(vector);
            vector2.dirty = bl = vector.dirty;
            vector2.gotoPosWritable(vector.focus, n3, vector.focus ^ n3);
            vector2.preClean(n4);
            int n6 = n2 - n5;
            Vector vector3 = vector2;
            if (n6 < 32) {
                Vector.zeroLeft(vector3.display0(), n6);
            } else if (n6 < 1024) {
                Vector.zeroLeft(vector3.display0(), n6 & 0x1F);
                vector3.display1_$eq(Vector.copyRight(vector3.display1(), n6 >>> 5));
            } else if (n6 < 32768) {
                Vector.zeroLeft(vector3.display0(), n6 & 0x1F);
                vector3.display1_$eq(Vector.copyRight(vector3.display1(), n6 >>> 5 & 0x1F));
                vector3.display2_$eq(Vector.copyRight(vector3.display2(), n6 >>> 10));
            } else if (n6 < 0x100000) {
                Vector.zeroLeft(vector3.display0(), n6 & 0x1F);
                vector3.display1_$eq(Vector.copyRight(vector3.display1(), n6 >>> 5 & 0x1F));
                vector3.display2_$eq(Vector.copyRight(vector3.display2(), n6 >>> 10 & 0x1F));
                vector3.display3_$eq(Vector.copyRight(vector3.display3(), n6 >>> 15));
            } else if (n6 < 0x2000000) {
                Vector.zeroLeft(vector3.display0(), n6 & 0x1F);
                vector3.display1_$eq(Vector.copyRight(vector3.display1(), n6 >>> 5 & 0x1F));
                vector3.display2_$eq(Vector.copyRight(vector3.display2(), n6 >>> 10 & 0x1F));
                vector3.display3_$eq(Vector.copyRight(vector3.display3(), n6 >>> 15 & 0x1F));
                vector3.display4_$eq(Vector.copyRight(vector3.display4(), n6 >>> 20));
            } else if (n6 < 0x40000000) {
                Vector.zeroLeft(vector3.display0(), n6 & 0x1F);
                vector3.display1_$eq(Vector.copyRight(vector3.display1(), n6 >>> 5 & 0x1F));
                vector3.display2_$eq(Vector.copyRight(vector3.display2(), n6 >>> 10 & 0x1F));
                vector3.display3_$eq(Vector.copyRight(vector3.display3(), n6 >>> 15 & 0x1F));
                vector3.display4_$eq(Vector.copyRight(vector3.display4(), n6 >>> 20 & 0x1F));
                vector3.display5_$eq(Vector.copyRight(vector3.display5(), n6 >>> 25));
            } else {
                throw new IllegalArgumentException();
            }
            return vector2;
        }
        return Vector$.MODULE$.NIL();
    }

    public final Object head() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.head");
        }
        return this.apply(0);
    }

    public final Object last() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.last");
        }
        return this.apply(this.length() - 1);
    }

    public final Object $plus$plus(GenTraversableOnce genTraversableOnce, CanBuildFrom canBuildFrom) {
        return FlatHashTable$class.$plus$plus(this, genTraversableOnce.seq(), canBuildFrom);
    }

    private void gotoPosWritable(int n, int n2, int n3) {
        if (this.dirty) {
            this.gotoPosWritable1(n, n2, n3);
            return;
        }
        this.gotoPosWritable0$255f295(n2);
        this.dirty = true;
    }

    private static void zeroLeft(Object[] objectArray, int n) {
        for (int i = 0; i < n; ++i) {
            objectArray[i] = null;
        }
    }

    private static void zeroRight(Object[] objectArray, int n) {
        for (int i = n; i < objectArray.length; ++i) {
            objectArray[i] = null;
        }
    }

    private static Object[] copyLeft(Object[] objectArray, int n) {
        Object[] objectArray2;
        Object[] objectArray3 = objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        return objectArray2;
    }

    private static Object[] copyRight(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, n, objectArray2, n, objectArray2.length - n);
        return objectArray2;
    }

    private void preClean(int n) {
        this.depth_$eq(n);
        int n2 = n - 1;
        switch (n2) {
            default: {
                throw new MatchError(n2);
            }
            case 4: {
                this.display5_$eq(null);
                return;
            }
            case 3: {
                this.display4_$eq(null);
                this.display5_$eq(null);
                return;
            }
            case 2: {
                this.display3_$eq(null);
                this.display4_$eq(null);
                this.display5_$eq(null);
                return;
            }
            case 1: {
                this.display2_$eq(null);
                this.display3_$eq(null);
                this.display4_$eq(null);
                this.display5_$eq(null);
                return;
            }
            case 0: {
                this.display1_$eq(null);
                this.display2_$eq(null);
                this.display3_$eq(null);
                this.display4_$eq(null);
                this.display5_$eq(null);
            }
            case 5: 
        }
    }

    private static int requiredDepth(int n) {
        if (n < 32) {
            return 1;
        }
        if (n < 1024) {
            return 2;
        }
        if (n < 32768) {
            return 3;
        }
        if (n < 0x100000) {
            return 4;
        }
        if (n < 0x2000000) {
            return 5;
        }
        if (n < 0x40000000) {
            return 6;
        }
        throw new IllegalArgumentException();
    }

    public Vector(int n, int n2, int n3) {
        this.startIndex = n;
        this.endIndex = n2;
        this.focus = n3;
        this.dirty = false;
    }
}

