/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.BtreeCursor;
import org.h2.index.BtreeIndex;
import org.h2.index.BtreePage;
import org.h2.index.BtreePosition;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.table.Column;
import org.h2.util.IntArray;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class BtreeNode
extends BtreePage {
    private boolean writePos;
    private IntArray pageChildren;

    BtreeNode(BtreeIndex index, DataPage s) throws SQLException {
        super(index);
        int len = s.readInt();
        int[] array = new int[len];
        for (int i = 0; i < array.length; ++i) {
            array[i] = s.readInt();
        }
        this.pageChildren = new IntArray(array);
        this.pageData = index.readRowArray(s);
    }

    BtreeNode(BtreeIndex index, BtreePage left, SearchRow pivot, BtreePage right) {
        super(index);
        this.pageChildren = new IntArray();
        this.pageChildren.add(left.getPos());
        this.pageChildren.add(right.getPos());
        this.pageData = new ObjectArray();
        this.pageData.add(pivot);
    }

    BtreeNode(BtreeIndex index, IntArray pageChildren, ObjectArray pageData) {
        super(index);
        this.pageChildren = pageChildren;
        this.pageData = pageData;
    }

    protected SearchRow getData(int i) throws SQLException {
        SearchRow r = (SearchRow)this.pageData.get(i);
        if (r == null) {
            int p = this.pageChildren.get(i + 1);
            Session sysSession = this.index.getDatabase().getSystemSession();
            BtreePage page = this.index.getPage(sysSession, p);
            r = page.getFirst(sysSession);
            this.pageData.set(i, r);
        }
        return r;
    }

    public int add(Row newRow, Session session) throws SQLException {
        int l = 0;
        int r = this.pageData.size();
        while (l < r) {
            int i = l + r >>> 1;
            SearchRow row = this.getData(i);
            int comp = this.index.compareRows(row, newRow);
            if (comp == 0) {
                if (this.index.indexType.isUnique() && !this.index.isNull(newRow)) {
                    throw this.index.getDuplicateKeyException();
                }
                comp = this.index.compareKeys(row, newRow);
            }
            if (comp > 0) {
                r = i;
                continue;
            }
            l = i + 1;
        }
        int at = l;
        BtreePage page = this.index.getPage(session, this.pageChildren.get(at));
        int splitPoint = page.add(newRow, session);
        if (splitPoint == 0) {
            return 0;
        }
        SearchRow pivot = page.getData(splitPoint);
        BtreePage page2 = page.split(session, splitPoint);
        this.index.deletePage(session, this);
        this.pageChildren.add(at + 1, page2.getPos());
        this.pageData.add(at, pivot);
        splitPoint = this.getSplitPoint();
        if (splitPoint > 1) {
            return splitPoint;
        }
        this.index.updatePage(session, this);
        return 0;
    }

    public SearchRow remove(Session session, Row oldRow) throws SQLException {
        int l = 0;
        int r = this.pageData.size();
        int comp = 0;
        while (l < r) {
            int i = l + r >>> 1;
            SearchRow row = this.getData(i);
            comp = this.index.compareRows(row, oldRow);
            if (comp == 0) {
                comp = this.index.compareKeys(row, oldRow);
            }
            if (comp > 0) {
                r = i;
                continue;
            }
            l = i + 1;
        }
        int at = l;
        BtreePage page = this.index.getPage(session, this.pageChildren.get(at));
        SearchRow first = page.remove(session, oldRow);
        if (first == null) {
            return null;
        }
        if (first == oldRow) {
            this.index.deletePage(session, this);
            this.pageChildren.remove(at);
            if (this.pageChildren.size() == 0) {
                return oldRow;
            }
            if (at == 0) {
                first = this.getData(0);
                this.pageData.remove(0);
            } else {
                first = null;
                this.pageData.remove(at == 0 ? 0 : at - 1);
            }
            this.index.updatePage(session, this);
            return first;
        }
        if (at == 0) {
            return first;
        }
        this.index.deletePage(session, this);
        this.pageData.set(at - 1, first);
        this.index.updatePage(session, this);
        return null;
    }

    public BtreePage split(Session session, int splitPoint) throws SQLException {
        ObjectArray data = new ObjectArray();
        IntArray children = new IntArray();
        ++splitPoint;
        int max = this.pageData.size();
        if (SysProperties.CHECK && this.index.getDatabase().getLogIndexChanges() && !this.getDeleted()) {
            throw Message.getInternalError();
        }
        for (int i = splitPoint; i < max; ++i) {
            data.add(this.getData(splitPoint));
            children.add(this.getChild(splitPoint));
            this.pageData.remove(splitPoint);
            this.pageChildren.remove(splitPoint);
        }
        children.add(this.getChild(splitPoint));
        this.pageData.remove(splitPoint - 1);
        this.pageChildren.remove(splitPoint);
        BtreeNode n2 = new BtreeNode(this.index, children, data);
        this.index.updatePage(session, this);
        this.index.addPage(session, n2);
        return n2;
    }

    int getChild(int i) {
        return this.pageChildren.get(i);
    }

    public boolean findFirst(BtreeCursor cursor, SearchRow compare, boolean bigger) throws SQLException {
        int i;
        int l = 0;
        int r = this.pageData.size();
        while (l < r) {
            int i2 = l + r >>> 1;
            SearchRow row = this.getData(i2);
            int comp = this.index.compareRows(row, compare);
            if (comp > 0 || !bigger && comp == 0) {
                r = i2;
                continue;
            }
            l = i2 + 1;
        }
        if (l >= this.pageData.size()) {
            BtreePage page = this.index.getPage(cursor.getSession(), this.pageChildren.get(l));
            cursor.push(this, l);
            boolean result = page.findFirst(cursor, compare, bigger);
            if (result) {
                return true;
            }
            cursor.pop();
            return false;
        }
        BtreePage page = this.index.getPage(cursor.getSession(), this.pageChildren.get(l));
        cursor.push(this, l);
        if (page.findFirst(cursor, compare, bigger)) {
            return true;
        }
        cursor.pop();
        for (i = l + 1; i < this.pageData.size(); ++i) {
            SearchRow row = this.getData(i);
            int comp = this.index.compareRows(row, compare);
            if (comp < 0) continue;
            page = this.index.getPage(cursor.getSession(), this.pageChildren.get(i));
            cursor.push(this, i);
            if (page.findFirst(cursor, compare, bigger)) {
                return true;
            }
            cursor.pop();
        }
        page = this.index.getPage(cursor.getSession(), this.pageChildren.get(i));
        cursor.push(this, i);
        boolean result = page.findFirst(cursor, compare, bigger);
        if (result) {
            return true;
        }
        cursor.pop();
        return false;
    }

    public void next(BtreeCursor cursor, int i) throws SQLException {
        if (++i <= this.pageData.size()) {
            cursor.setStackPosition(i);
            BtreePage page = this.index.getPage(cursor.getSession(), this.pageChildren.get(i));
            page.first(cursor);
            return;
        }
        this.nextUpper(cursor);
    }

    public void previous(BtreeCursor cursor, int i) throws SQLException {
        if (--i >= 0) {
            cursor.setStackPosition(i);
            BtreePage page = this.index.getPage(cursor.getSession(), this.pageChildren.get(i));
            page.last(cursor);
            return;
        }
        this.previousUpper(cursor);
    }

    private void nextUpper(BtreeCursor cursor) throws SQLException {
        cursor.pop();
        BtreePosition upper = cursor.pop();
        if (upper == null) {
            cursor.setCurrentRow(null);
        } else {
            cursor.push(upper.page, upper.position);
            upper.page.next(cursor, upper.position);
        }
    }

    private void previousUpper(BtreeCursor cursor) throws SQLException {
        cursor.pop();
        BtreePosition upper = cursor.pop();
        if (upper == null) {
            cursor.setCurrentRow(null);
        } else {
            cursor.push(upper.page, upper.position);
            upper.page.previous(cursor, upper.position);
        }
    }

    public void first(BtreeCursor cursor) throws SQLException {
        cursor.push(this, 0);
        BtreePage page = this.index.getPage(cursor.getSession(), this.pageChildren.get(0));
        page.first(cursor);
    }

    public void last(BtreeCursor cursor) throws SQLException {
        int last = this.pageChildren.size() - 1;
        cursor.push(this, last);
        BtreePage page = this.index.getPage(cursor.getSession(), this.pageChildren.get(last));
        page.last(cursor);
    }

    public void prepareWrite() throws SQLException {
        this.writePos = this.getRealByteCount() >= 1024;
    }

    public void write(DataPage buff) throws SQLException {
        buff.writeByte((byte)78);
        int len = this.pageChildren.size();
        buff.writeInt(len);
        for (int i = 0; i < len; ++i) {
            buff.writeInt(this.pageChildren.get(i));
        }
        len = this.pageData.size();
        buff.writeInt(len);
        Column[] columns = this.index.getColumns();
        for (int i = 0; i < len; ++i) {
            if (this.writePos) {
                buff.writeInt(-1);
                continue;
            }
            SearchRow row = this.getData(i);
            buff.writeInt(row.getPos());
            for (int j = 0; j < columns.length; ++j) {
                Value v = row.getValue(columns[j].getColumnId());
                buff.writeValue(v);
            }
        }
        if (buff.length() > 1024) {
            throw Message.getInternalError("indexed data overflow");
        }
    }

    int getRealByteCount() throws SQLException {
        DataPage dummy = this.index.getDatabase().getDataPage();
        int len = this.pageChildren.size();
        int size = 2 + dummy.getIntLen() + dummy.getIntLen() * len;
        len = this.pageData.size();
        size += dummy.getIntLen();
        size += len * dummy.getIntLen();
        for (int i = 0; i < len; ++i) {
            SearchRow row = this.getData(i);
            size += this.getRowSize(dummy, row);
        }
        return size + this.index.getRecordOverhead();
    }

    SearchRow getFirst(Session session) throws SQLException {
        for (int i = 0; i < this.pageChildren.size(); ++i) {
            BtreePage page = this.index.getPage(session, this.pageChildren.get(i));
            if (page == null) continue;
            return page.getFirst(session);
        }
        return null;
    }
}

