/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystemDatabase;

public class FileObjectDatabase
implements FileObject {
    private FileSystemDatabase db;
    private String fileName;
    private byte[] data;
    private int pos;
    private int length;
    private boolean changed;

    FileObjectDatabase(FileSystemDatabase db, String fileName, byte[] data, boolean changed) {
        this.db = db;
        this.fileName = fileName;
        this.data = data;
        this.length = data.length;
        this.changed = changed;
    }

    public void close() throws IOException {
        this.sync();
    }

    public long getFilePointer() throws IOException {
        return this.pos;
    }

    public long length() throws IOException {
        return this.length;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.pos + len > this.length) {
            throw new EOFException();
        }
        System.arraycopy(this.data, this.pos, b, off, len);
        this.pos += len;
    }

    public void seek(long pos) throws IOException {
        this.pos = (int)pos;
    }

    public void setFileLength(long newLength) throws IOException {
        this.length = (int)newLength;
        if (this.length != this.data.length) {
            byte[] n = new byte[this.length];
            System.arraycopy(this.data, 0, n, 0, Math.min(this.data.length, n.length));
            this.data = n;
            this.changed = true;
        }
        this.pos = Math.min(this.pos, this.length);
    }

    public void sync() throws IOException {
        if (this.changed) {
            this.db.write(this.fileName, this.data, this.length);
            this.changed = false;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.pos + len > this.data.length) {
            int newLen = Math.max(this.data.length * 2, this.pos + len);
            byte[] n = new byte[newLen];
            System.arraycopy(this.data, 0, n, 0, this.length);
            this.data = n;
        }
        System.arraycopy(b, off, this.data, this.pos, len);
        this.pos += len;
        this.length = Math.max(this.length, this.pos);
        this.changed = true;
    }
}

