/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.retrieve;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.retrieve.EndRetrieveArtifactEvent;
import org.apache.ivy.core.event.retrieve.RetrieveEvent;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveEngine$1;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public final class RetrieveEngine {
    private RetrieveEngineSettings settings;
    private EventManager eventManager;

    public RetrieveEngine(RetrieveEngineSettings retrieveEngineSettings, EventManager eventManager) {
        this.settings = retrieveEngineSettings;
        this.eventManager = eventManager;
    }

    /*
     * Unable to fully structure code
     */
    public final int retrieve(ModuleRevisionId var1_1, String var2_2, RetrieveOptions var3_3) {
        var4_4 = var1_1.getModuleId();
        if ("default".equals(var3_3.getLog())) {
            Message.info(":: retrieving :: " + var4_4 + "");
        } else {
            Message.verbose(":: retrieving :: " + var4_4 + "");
        }
        Message.verbose("\tcheckUpToDate=" + this.settings.isCheckUpToDate());
        var5_5 = System.currentTimeMillis();
        var2_2 = IvyPatternHelper.substituteVariables(var2_2, this.settings.getVariables());
        var7_6 = IvyPatternHelper.substituteVariables(null, this.settings.getVariables());
        var8_7 = this.getConfs(var1_1, var3_3);
        if ("default".equals(var3_3.getLog())) {
            Message.info("\tconfs: " + Arrays.asList(var8_7));
        } else {
            Message.verbose("\tconfs: " + Arrays.asList(var8_7));
        }
        if (this.eventManager != null) {
            this.eventManager.fireIvyEvent(new RetrieveEvent(var1_1, var8_7, var3_3));
        }
        try {
            var9_8 = this.determineArtifactsToCopy(var1_1, var2_2, var3_3);
            var10_10 = this.settings.resolveFile(IvyPatternHelper.getTokenRoot(var2_2));
            var11_11 = var7_6 == null ? null : this.settings.resolveFile(IvyPatternHelper.getTokenRoot(var7_6));
            var12_12 = new HashSet<E>();
            var13_13 = new HashSet<E>();
            var14_14 = 0;
            var15_15 = 0;
            var16_16 = 0L;
            var18_17 = var9_8.keySet().iterator();
            while (var18_17.hasNext()) {
                var19_19 = (ArtifactDownloadReport)var18_17.next();
                var20_20 = var19_19.getLocalFile();
                if (var20_20 == null) {
                    Message.verbose("\tno local file available for " + var19_19 + ": skipping");
                    continue;
                }
                var21_21 = (Set)var9_8.get(var19_19);
                Message.verbose("\tretrieving " + var20_20);
                var22_22 = var21_21.iterator();
                while (var22_22.hasNext()) {
                    IvyContext.getContext().checkInterrupted();
                    var23_23 = this.settings.resolveFile((String)var22_22.next());
                    if (!this.settings.isCheckUpToDate()) ** GOTO lbl-1000
                    var26_26 = var3_3;
                    var25_25 = var23_23;
                    var24_24 = var20_20;
                    if (!var25_25.exists() || "always".equals(var27_27 = var26_26.getOverwriteMode())) ** GOTO lbl-1000
                    if ("never".equals(var27_27)) {
                        v0 = true;
                    } else if ("newer".equals(var27_27)) {
                        v0 = var24_24.lastModified() <= var25_25.lastModified();
                    } else if ("different".equals(var27_27)) {
                        v0 = var24_24.lastModified() == var25_25.lastModified();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (!v0) lbl-1000:
                    // 2 sources

                    {
                        Message.verbose("\t\tto " + var23_23);
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new RetrieveEvent(var19_19, var23_23));
                        }
                        FileUtil.copy((File)var20_20, var23_23, null, true);
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new EndRetrieveArtifactEvent(var19_19, var23_23));
                        }
                        var16_16 += var23_23.length();
                        ++var14_14;
                    } else {
                        Message.verbose("\t\tto " + var23_23 + " [NOT REQUIRED]");
                        ++var15_15;
                    }
                    if ("ivy".equals(var19_19.getType())) {
                        var13_13.addAll(FileUtil.getPathFiles(var11_11, var23_23));
                        continue;
                    }
                    var12_12.addAll(FileUtil.getPathFiles(var10_10, var23_23));
                }
            }
            var18_18 = System.currentTimeMillis() - var5_5;
            var20_20 = "\t" + var14_14 + " artifacts copied" + (this.settings.isCheckUpToDate() != false ? ", " + var15_15 + " already retrieved" : "") + " (" + var16_16 / 1024L + "kB/" + var18_18 + "ms)";
            if ("default".equals(var3_3.getLog())) {
                Message.info((String)var20_20);
            } else {
                Message.verbose((String)var20_20);
            }
            Message.verbose("\tretrieve done (" + var18_18 + "ms)");
            if (this.eventManager != null) {
                this.eventManager.fireIvyEvent(new RetrieveEvent(var1_1, var8_7, var18_18, var14_14, var15_15, var16_16, var3_3));
            }
            return var14_14;
        }
        catch (Exception var9_9) {
            throw new RuntimeException("problem during retrieve of " + var4_4 + ": " + var9_9, var9_9);
        }
    }

    private String[] getConfs(ModuleRevisionId moduleRevisionId, RetrieveOptions retrieveOptions) {
        String[] stringArray = retrieveOptions.getConfs();
        if (stringArray == null || stringArray.length == 1 && "*".equals(stringArray[0])) {
            try {
                File file2 = this.getCache().getResolvedIvyFileInCache(moduleRevisionId);
                Message.verbose("no explicit confs given for retrieve, using ivy file: " + file2);
                URL uRL = file2.toURI().toURL();
                URLResource uRLResource = new URLResource(uRL);
                ModuleDescriptorParser moduleDescriptorParser = ModuleDescriptorParserRegistry.getInstance().getParser(uRLResource);
                Message.debug("using " + moduleDescriptorParser + " to parse " + file2);
                stringArray = moduleDescriptorParser.parseDescriptor(this.settings, uRL, false).getConfigurationsNames();
                retrieveOptions.setConfs(stringArray);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception.getMessage());
                iOException.initCause(exception);
                throw iOException;
            }
        }
        return stringArray;
    }

    private ResolutionCacheManager getCache() {
        return this.settings.getResolutionCacheManager();
    }

    private Map determineArtifactsToCopy(ModuleRevisionId moduleRevisionId, String string, RetrieveOptions retrieveOptions) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Collection<ArtifactDownloadReport> collection;
        Object object5;
        String string2;
        ModuleId moduleId = moduleRevisionId.getModuleId();
        if (retrieveOptions.getResolveId() == null) {
            retrieveOptions.setResolveId(ResolveOptions.getDefaultResolveId(moduleId));
        }
        ResolutionCacheManager resolutionCacheManager = this.getCache();
        String[] stringArray = this.getConfs(moduleRevisionId, retrieveOptions);
        String string3 = IvyPatternHelper.substituteVariables(null, this.settings.getVariables());
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        XmlReportParser xmlReportParser = new XmlReportParser();
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            object5 = resolutionCacheManager.getConfigurationResolveReportInCache(retrieveOptions.getResolveId(), string2);
            xmlReportParser.parse((File)object5);
            collection = new ArrayList<ArtifactDownloadReport>(Arrays.asList(xmlReportParser.getArtifactReports()));
            if (string3 != null) {
                object4 = xmlReportParser.getRealDependencyRevisionIds();
                for (int j = 0; j < ((Object)object4).length; ++j) {
                    collection.add(xmlReportParser.getMetadataArtifactReport((ModuleRevisionId)object4[j]));
                }
            }
            object4 = collection.iterator();
            while (object4.hasNext()) {
                ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)object4.next();
                Object object6 = object3 = "ivy".equals(artifactDownloadReport.getType()) ? string3 : string;
                if (!"ivy".equals(artifactDownloadReport.getType()) && !retrieveOptions.getArtifactFilter().accept(artifactDownloadReport.getArtifact())) continue;
                String string4 = IvyPatternHelper.substitute((String)object3, artifactDownloadReport.getArtifact().getModuleRevisionId(), artifactDownloadReport.getArtifact(), string2, artifactDownloadReport.getArtifactOrigin());
                object2 = (Set)hashMap.get(artifactDownloadReport);
                if (object2 == null) {
                    object2 = new HashSet<String>();
                    hashMap.put(artifactDownloadReport, object2);
                }
                object = this.settings.resolveFile(string4).getAbsolutePath();
                object2.add(object);
                HashSet<ArtifactRevisionId> hashSet = (HashSet<ArtifactRevisionId>)hashMap2.get(object);
                HashSet<ArtifactDownloadReport> hashSet2 = (HashSet<ArtifactDownloadReport>)hashMap3.get(object);
                HashSet<String> hashSet3 = (HashSet<String>)hashMap4.get(object);
                if (hashSet == null) {
                    hashSet = new HashSet<ArtifactRevisionId>();
                    hashMap2.put((String)object, hashSet);
                }
                if (hashSet2 == null) {
                    hashSet2 = new HashSet<ArtifactDownloadReport>();
                    hashMap3.put((String)object, hashSet2);
                }
                if (hashSet3 == null) {
                    hashSet3 = new HashSet<String>();
                    hashMap4.put((String)object, hashSet3);
                }
                if (!hashSet.add(artifactDownloadReport.getArtifact().getId())) continue;
                hashSet2.add(artifactDownloadReport);
                hashSet3.add(string2);
            }
        }
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            int n;
            string2 = (String)iterator.next();
            object5 = (Set)hashMap2.get(string2);
            collection = (Set)hashMap4.get(string2);
            if (object5.size() <= 1) continue;
            object4 = new ArrayList((Collection)hashMap3.get(string2));
            Collections.sort(object4, new RetrieveEngine$1());
            object3 = ((ArtifactDownloadReport)object4.get(object4.size() - 1)).getArtifact().getModuleRevisionId();
            for (n = object4.size() - 2; n >= 0; --n) {
                object2 = (ArtifactDownloadReport)object4.get(n);
                if (!((ModuleRevisionId)object3).equals(((ArtifactDownloadReport)object2).getArtifact().getModuleRevisionId())) continue;
                throw new RuntimeException("Multiple artifacts of the module " + object3 + " are retrieved to the same file! Update the retrieve pattern " + " to fix this error.");
            }
            Message.info("\tconflict on " + string2 + " in " + collection + ": " + ((ModuleRevisionId)object3).getRevision() + " won");
            for (n = object4.size() - 2; n >= 0; --n) {
                object2 = (ArtifactDownloadReport)object4.get(n);
                Message.verbose("\t\tremoving conflict looser artifact: " + ((ArtifactDownloadReport)object2).getArtifact());
                object = (Set)hashMap.get(object2);
                object.remove(string2);
                if (!object.isEmpty()) continue;
                hashMap.remove(object2);
            }
        }
        return hashMap;
    }
}

