/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;

public class EnumConverter
extends AbstractConverter {
    public Class getDestClass() {
        return Enum.class;
    }

    public Class[] getSourceClasses() {
        return new Class[]{Object.class};
    }

    public Object convert(Object source, Class destClass, ConversionContext context) {
        if (source == null) {
            return null;
        }
        if (source.getClass() == destClass) {
            return source;
        }
        if (source instanceof Number) {
            int ordinal = ((Number)Number.class.cast(source)).intValue();
            return destClass.getEnumConstants()[ordinal];
        }
        String name = source.toString();
        return Enum.valueOf(destClass, name);
    }
}

