/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.ejb.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;
import org.seasar.framework.ejb.EJB3BusinessMethodDesc;
import org.seasar.framework.ejb.EJB3Desc;
import org.seasar.framework.ejb.EJB3InterceptorDesc;
import org.seasar.framework.ejb.SEJBException;
import org.seasar.framework.ejb.impl.EJB3BusinessMethodDescImpl;
import org.seasar.framework.ejb.impl.EJB3InterceptorDescImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3DescImpl
implements EJB3Desc {
    protected Class<?> beanClass;
    protected String beanClassName;
    protected boolean stateless;
    protected boolean stateful;
    protected String name;
    protected List<Class<?>> businessInterfaces = new ArrayList();
    protected boolean cmt = true;
    protected List<EJB3InterceptorDesc> interceptors = new ArrayList<EJB3InterceptorDesc>();
    protected List<EJB3BusinessMethodDesc> businessMethods = new ArrayList<EJB3BusinessMethodDesc>();
    protected LinkedList<Method> aroundInvokeMethods = new LinkedList();
    protected LinkedList<Method> postConstructMethods = new LinkedList();

    public EJB3DescImpl(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.beanClassName = beanClass.getName();
        this.introspection();
    }

    public boolean isEJB3() {
        return this.stateless || this.stateful;
    }

    @Override
    public boolean isStateless() {
        return this.stateless;
    }

    @Override
    public boolean isStateful() {
        return this.stateful;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public List<Class<?>> getBusinessInterfaces() {
        return this.businessInterfaces;
    }

    @Override
    public boolean isCMT() {
        return this.cmt;
    }

    @Override
    public List<EJB3InterceptorDesc> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public EJB3BusinessMethodDesc getBusinessMethod(Method method) {
        for (EJB3BusinessMethodDesc businessMethodDesc : this.businessMethods) {
            Method businessMethod = businessMethodDesc.getMethod();
            if (!method.getName().equals(businessMethod.getName()) || !Arrays.equals(method.getParameterTypes(), businessMethod.getParameterTypes())) continue;
            return businessMethodDesc;
        }
        return null;
    }

    @Override
    public List<EJB3BusinessMethodDesc> getBusinessMethods() {
        return this.businessMethods;
    }

    @Override
    public List<Method> getAroundInvokeMethods() {
        return this.aroundInvokeMethods;
    }

    @Override
    public List<Method> getPostConstructMethods() {
        return this.postConstructMethods;
    }

    protected void introspection() {
        Stateful sfsb;
        int modifiers = this.beanClass.getModifiers();
        if (this.beanClass.isInterface() || Modifier.isAbstract(modifiers) || Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers)) {
            return;
        }
        Stateless slsb = this.beanClass.getAnnotation(Stateless.class);
        if (slsb != null) {
            this.stateless = true;
            this.name = slsb.name();
        }
        if ((sfsb = this.beanClass.getAnnotation(Stateful.class)) != null) {
            this.stateful = true;
            this.name = sfsb.name();
        }
        if (!this.stateless && !this.stateful) {
            return;
        }
        if (this.stateless && this.stateful) {
            throw new SEJBException("ESSR0400", this.beanClassName);
        }
        this.detectLocalBusinessInterfaces();
        this.detectRemoteBusinessInterfaces();
        if (this.businessInterfaces.isEmpty()) {
            this.detectImplicitBusinessInterfaces();
            if (this.businessInterfaces.isEmpty()) {
                throw new SEJBException("ESSR0401", this.beanClassName);
            }
            if (this.businessInterfaces.size() > 1) {
                throw new SEJBException("ESSR0402", this.beanClassName);
            }
        }
        this.detectTransactionManagementType();
        this.detectInterceptors();
        this.detectBusinessMethods();
        this.detectAroundInvokeMethods();
        this.detectPostConstructMethods();
    }

    protected void detectLocalBusinessInterfaces() {
        Local local = this.beanClass.getAnnotation(Local.class);
        if (local != null) {
            for (Class type : local.value()) {
                if (!this.isBusinessInterface(type)) continue;
                this.businessInterfaces.add(type);
            }
            return;
        }
        for (Class<?> type : this.beanClass.getInterfaces()) {
            Local annotation = type.getAnnotation(Local.class);
            if (annotation == null) continue;
            this.businessInterfaces.add(type);
        }
    }

    protected void detectRemoteBusinessInterfaces() {
        Remote remote = this.beanClass.getAnnotation(Remote.class);
        if (remote != null) {
            for (Class clazz : remote.value()) {
                if (!this.isBusinessInterface(clazz)) continue;
                this.businessInterfaces.add(clazz);
            }
        }
        for (Class clazz : this.beanClass.getInterfaces()) {
            Remote annotation = clazz.getAnnotation(Remote.class);
            if (annotation == null) continue;
            this.businessInterfaces.add(clazz);
        }
    }

    protected void detectImplicitBusinessInterfaces() {
        for (Class<?> type : this.beanClass.getInterfaces()) {
            if (!this.isBusinessInterface(type)) continue;
            this.businessInterfaces.add(type);
        }
    }

    protected void detectTransactionManagementType() {
        TransactionManagementType type;
        TransactionManagement txManegement = this.beanClass.getAnnotation(TransactionManagement.class);
        if (txManegement != null && TransactionManagementType.BEAN.equals((Object)(type = txManegement.value()))) {
            this.cmt = false;
            return;
        }
    }

    protected void detectInterceptors() {
        Interceptors annotation = this.beanClass.getAnnotation(Interceptors.class);
        if (annotation == null) {
            return;
        }
        for (Class interceptor : annotation.value()) {
            this.interceptors.add(new EJB3InterceptorDescImpl(this, interceptor));
        }
    }

    protected void detectBusinessMethods() {
        for (Method method : this.beanClass.getMethods()) {
            int modifier;
            if (method.isBridge() || method.isSynthetic() || Modifier.isStatic(modifier = method.getModifiers()) || Modifier.isFinal(modifier) || !this.isBusinessMethod(method)) continue;
            this.businessMethods.add(new EJB3BusinessMethodDescImpl(this, method));
        }
    }

    public void detectAroundInvokeMethods() {
        HashSet<String> methods = new HashSet<String>();
        for (Class<?> clazz = this.beanClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isBridge()) continue;
                AroundInvoke aroundInvoke = method.getAnnotation(AroundInvoke.class);
                int modifiers = method.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
                    if (aroundInvoke == null) continue;
                    throw new SEJBException("ESSR0409", "AroundInvoke", this.beanClassName, method);
                }
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length != 1 || paramTypes[0] != InvocationContext.class) {
                    if (aroundInvoke == null) continue;
                    throw new SEJBException("ESSR0409", "AroundInvoke", this.beanClassName, method);
                }
                if (method.getReturnType() != Object.class) {
                    if (aroundInvoke == null) continue;
                    throw new SEJBException("ESSR0409", "AroundInvoke", this.beanClassName, method);
                }
                String methodName = method.getName();
                if (methods.contains(methodName)) continue;
                methods.add(methodName);
                if (aroundInvoke == null) continue;
                if (this.isBusinessMethod(method)) {
                    throw new SEJBException("ESSR0409", "AroundInvoke", this.beanClassName, method);
                }
                this.aroundInvokeMethods.addFirst(method);
            }
        }
    }

    public void detectPostConstructMethods() {
        HashSet<String> methods = new HashSet<String>();
        for (Class<?> clazz = this.beanClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isBridge()) continue;
                PostConstruct postConstruct = method.getAnnotation(PostConstruct.class);
                int modifiers = method.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
                    if (postConstruct == null) continue;
                    throw new SEJBException("ESSR0409", "PostConstruct", this.beanClassName, method);
                }
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length != 0) {
                    if (postConstruct == null) continue;
                    throw new SEJBException("ESSR0409", "PostConstruct", this.beanClassName, method);
                }
                if (method.getReturnType() != Void.TYPE) {
                    if (postConstruct == null) continue;
                    throw new SEJBException("ESSR0409", "PostConstruct", this.beanClassName, method);
                }
                String methodName = method.getName();
                if (methods.contains(methodName)) continue;
                methods.add(methodName);
                if (postConstruct == null) continue;
                if (this.isBusinessMethod(method)) {
                    throw new SEJBException("ESSR0409", "PostConstruct", method);
                }
                this.postConstructMethods.addFirst(method);
            }
        }
    }

    protected boolean isBusinessInterface(Class<?> type) {
        if (!type.isInterface()) {
            throw new SEJBException("ESSR0407", this.beanClassName, type.getName());
        }
        if (!type.isAssignableFrom(this.beanClass)) {
            throw new SEJBException("ESSR0408", this.beanClassName, type.getName());
        }
        if (Serializable.class.equals(type)) {
            return false;
        }
        if (Exception.class.equals(type)) {
            return false;
        }
        return !type.getName().startsWith("javax.ejb");
    }

    protected boolean isBusinessMethod(Method method) {
        for (Class<?> type : this.businessInterfaces) {
            try {
                type.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException ignore) {
            }
        }
        return false;
    }
}

