/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericUtil {
    protected GenericUtil() {
    }

    public static boolean isTypeOf(Type type, Class<?> clazz) {
        if (Class.class.isInstance(type)) {
            return clazz.isAssignableFrom((Class)Class.class.cast(type));
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return GenericUtil.isTypeOf(parameterizedType.getRawType(), clazz);
        }
        return false;
    }

    public static Class<?> getRawClass(Type type) {
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return GenericUtil.getRawClass(parameterizedType.getRawType());
        }
        if (WildcardType.class.isInstance(type)) {
            WildcardType wildcardType = (WildcardType)WildcardType.class.cast(type);
            Type[] types = wildcardType.getUpperBounds();
            return GenericUtil.getRawClass(types[0]);
        }
        if (GenericArrayType.class.isInstance(type)) {
            GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            Class<?> rawClass = GenericUtil.getRawClass(genericArrayType.getGenericComponentType());
            return Array.newInstance(rawClass, 0).getClass();
        }
        return null;
    }

    public static Type[] getGenericParameter(Type type) {
        if (ParameterizedType.class.isInstance(type)) {
            return ((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments();
        }
        if (GenericArrayType.class.isInstance(type)) {
            return GenericUtil.getGenericParameter(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType());
        }
        return null;
    }

    public static Type getGenericParameter(Type type, int index) {
        if (!ParameterizedType.class.isInstance(type)) {
            return null;
        }
        Type[] genericParameter = GenericUtil.getGenericParameter(type);
        if (genericParameter == null) {
            return null;
        }
        return genericParameter[index];
    }

    public static Type getElementTypeOfList(Type type) {
        if (!GenericUtil.isTypeOf(type, List.class)) {
            return null;
        }
        return GenericUtil.getGenericParameter(type, 0);
    }
}

