package jp.sf.amateras.functions.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import junit.framework.TestCase;

public class DateUtilsTest extends TestCase {
	
	public void tearDown() throws Exception {
		super.tearDown();
		
		// フォーマットパターンを元に戻す
		Properties properties = FunctionsProperties.getProperties();
		DateUtils.setDatePattern(properties.getProperty("datePattern"));
		DateUtils.setDatetimePattern(properties.getProperty("datetimePattern"));
		DateUtils.setTimePattern(properties.getProperty("timePattern"));
	}
	
	public void testSetDatePattern() throws Exception {
		DateUtils.setDatePattern("yyyy年MM月dd日");
		assertEquals("2010年02月01日", DateUtils.formatDate(createDate("2010/02/01 00:00:00")));
	}

	public void testSetDatetimePattern() throws Exception {
		DateUtils.setDatetimePattern("yyyy年MM月dd日 HH時mm分ss秒");
		assertEquals("2010年02月01日 12時34分56秒", DateUtils.formatDatetime(createDate("2010/02/01 12:34:56")));
	}

	public void testSetTimePattern() throws Exception {
		DateUtils.setTimePattern("HH時mm分ss秒");
		assertEquals("12時34分56秒", DateUtils.formatTime(createDate("2010/02/01 12:34:56")));
	}

	public void testFormatDateDateString() throws Exception {
		assertEquals("", DateUtils.formatDate(null, "yyyy/MM/dd"));
		assertEquals("2010/02/01", DateUtils.formatDate(createDate("2010/02/01 00:00:00"), "yyyy/MM/dd"));
	}

	public void testFormatDateDate() throws Exception {
		assertEquals("", DateUtils.formatDate(null));
		assertEquals("2010/02/01", DateUtils.formatDate(createDate("2010/02/01 00:00:00")));
	}

	public void testFormatDatetime() throws Exception {
		assertEquals("", DateUtils.formatDatetime(null));
		assertEquals("2010/02/01 12:34:56", DateUtils.formatDatetime(createDate("2010/02/01 12:34:56")));
	}

	public void testFormatTime() throws Exception {
		assertEquals("", DateUtils.formatTime(null));
		assertEquals("12:34:56", DateUtils.formatTime(createDate("2010/02/01 12:34:56")));
	}

	private Date createDate(String date) throws ParseException {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		return formatter.parse(date);
	}

}
