package jp.sf.amateras.functions.utils;

import javax.servlet.http.HttpServletResponse;

import jp.sf.amateras.functions.filter.FunctionsFilter;

/**
 * Java Standard EL Functionsの各クラスが<code>HttpServletResponse</code>にアクセスするためのユーティリティです。
 * <p>
 * このユーティリティを使用するには{@link FunctionsFilter}を<tt>web.xml</tt>に適切に設定する必要があります。
 * 
 * @author Naoki Takezoe
 */
public class ResponseUtils {
	
	private static ThreadLocal<HttpServletResponse> responses = new ThreadLocal<HttpServletResponse>();
	
	/**
	 * 現在のスレッドで使用する<code>HttpServletResponse</code>オブジェクトをセットします。
	 * 
	 * @param response 現在のスレッドで使用する<code>HttpServletResponse</code>オブジェクト
	 */
	public static void setResponse(HttpServletResponse response){
		responses.set(response);
	}
	
	/**
	 * 現在のスレッドで使用する<code>HttpServletResponse</code>オブジェクトを取得します。
	 * 
	 * @return 現在のスレッドで使用する<code>HttpServletResponse</code>オブジェクト
	 */
	public static HttpServletResponse getResponse(){
		return responses.get();
	}
	
	public static String getEncoding(){
		HttpServletResponse response = getResponse();
		if(response != null){
			return response.getCharacterEncoding();
		}
		return null;
	}
	
	/**
	 * 現在のスレッドで使用する<code>HttpServletResponse</code>オブジェクトを削除します。
	 * スレッドでの処理が終了する前に必ずこのメソッドを呼び出してください。
	 */
	public static void removeResponse(){
		responses.remove();
	}
	
	public static String encodeURL(String url){
		HttpServletResponse response = getResponse();
		if(response != null){
			return response.encodeURL(url);
		}
		return url;
	}
}
