/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.parameter;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.parameter.LobParameter;
import org.seasar.extension.jdbc.parameter.TemporalParameter;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.tiger.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter {
    public static TemporalParameter date(Date value) {
        return new TemporalParameter(value, TemporalType.DATE);
    }

    public static TemporalParameter date(Calendar value) {
        return new TemporalParameter(value, TemporalType.DATE);
    }

    public static TemporalParameter time(Date value) {
        return new TemporalParameter(value, TemporalType.TIME);
    }

    public static TemporalParameter time(Calendar value) {
        return new TemporalParameter(value, TemporalType.TIME);
    }

    public static TemporalParameter timestamp(Date value) {
        return new TemporalParameter(value, TemporalType.TIMESTAMP);
    }

    public static TemporalParameter timestamp(Calendar value) {
        return new TemporalParameter(value, TemporalType.TIMESTAMP);
    }

    public static LobParameter lob(byte[] value) {
        return new LobParameter(value);
    }

    public static LobParameter lob(Serializable value) {
        return new LobParameter(value);
    }

    public static LobParameter lob(String value) {
        return new LobParameter(value);
    }

    public static Object wrapIfNecessary(PropertyDesc propertyDesc, Object value) {
        Temporal temporal;
        Field field = propertyDesc.getField();
        if (field == null) {
            return value;
        }
        Class clazz = propertyDesc.getPropertyType();
        if (field.isAnnotationPresent(Lob.class)) {
            if (String.class == clazz) {
                return new LobParameter((String)String.class.cast(value));
            }
            if (byte[].class == clazz) {
                return new LobParameter((byte[])byte[].class.cast(value));
            }
            if (Serializable.class.isAssignableFrom(clazz)) {
                return new LobParameter((Serializable)Serializable.class.cast(value));
            }
        }
        if ((temporal = field.getAnnotation(Temporal.class)) != null) {
            if (Date.class == clazz) {
                return new TemporalParameter((Date)Date.class.cast(value), temporal.value());
            }
            if (Calendar.class == clazz) {
                return new TemporalParameter((Calendar)Calendar.class.cast(value), temporal.value());
            }
        }
        return value;
    }

    public static Maps<String, Object> params(String name, Object param) {
        return Maps.map(name, param);
    }
}

