/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import org.h2.engine.Database;
import org.h2.message.TraceSystem;

public class WriterThread
implements Runnable {
    private volatile WeakReference<Database> databaseRef;
    private int writeDelay;
    private Thread thread;
    private volatile boolean stop;

    private WriterThread(Database database, int n) {
        this.databaseRef = new WeakReference<Database>(database);
        this.writeDelay = n;
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
    }

    public static WriterThread create(Database database, int n) {
        try {
            WriterThread writerThread = new WriterThread(database, n);
            writerThread.thread = new Thread(writerThread);
            writerThread.thread.setName("H2 Log Writer " + database.getShortName());
            writerThread.thread.setDaemon(true);
            return writerThread;
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    public void run() {
        Database database;
        while (!this.stop && (database = (Database)this.databaseRef.get()) != null) {
            int n;
            int n2;
            block8: {
                n2 = this.writeDelay;
                try {
                    if (database.isFileLockSerialized()) {
                        n2 = 5;
                        database.checkpointIfRequired();
                    } else {
                        database.flush();
                    }
                }
                catch (Exception exception) {
                    TraceSystem traceSystem = database.getTraceSystem();
                    if (traceSystem == null) break block8;
                    traceSystem.getTrace("database").error(exception, "flush");
                }
            }
            n2 = Math.max(n2, 5);
            do {
                n = Math.min(n2, 100);
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((n2 -= n) > 0 && !this.stop);
        }
        this.databaseRef = null;
    }

    public void stopThread() {
        this.stop = true;
    }

    public void startThread() {
        this.thread.start();
        this.thread = null;
    }
}

