/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.UUID;
import org.h2.message.DbException;
import org.h2.store.fs.FileSystem;
import org.h2.store.fs.FileSystemDisk;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class DbUpgradeFromVersion1 {
    private static boolean scriptInTempDir;
    private static boolean deleteOldDb;
    private String url;
    private Properties info;
    private boolean mustBeConverted;
    private String newName;
    private String newUrl;
    private String oldUrl;
    private File oldDataFile;
    private File oldIndexFile;
    private File oldLobsDir;
    private File newFile;
    private File backupDataFile;
    private File backupIndexFile;
    private File backupLobsDir;
    private boolean successful;

    public DbUpgradeFromVersion1(String string, Properties properties) throws SQLException {
        this.url = string;
        this.info = properties;
        this.init();
    }

    private void init() throws SQLException {
        try {
            String string;
            Object object;
            this.newUrl = this.url;
            this.newUrl = StringUtils.replaceAllIgnoreCase(this.newUrl, ";UNDO_LOG=1", "");
            this.newUrl = StringUtils.replaceAllIgnoreCase(this.newUrl, ";UNDO_LOG=0", "");
            this.newUrl = StringUtils.replaceAllIgnoreCase(this.newUrl, ";LOG=0", "");
            this.newUrl = StringUtils.replaceAllIgnoreCase(this.newUrl, ";LOG=1", "");
            this.newUrl = StringUtils.replaceAllIgnoreCase(this.newUrl, ";LOG=2", "");
            this.newUrl = StringUtils.replaceAllIgnoreCase(this.newUrl, ";LOCK_MODE=0", "");
            this.newUrl = StringUtils.replaceAllIgnoreCase(this.newUrl, ";LOCK_MODE=1", "");
            this.newUrl = StringUtils.replaceAllIgnoreCase(this.newUrl, ";LOCK_MODE=2", "");
            this.newUrl = StringUtils.replaceAllIgnoreCase(this.newUrl, ";LOCK_MODE=3", "");
            this.newUrl = StringUtils.replaceAllIgnoreCase(this.newUrl, ";IFEXISTS=TRUE", "");
            this.newUrl = this.newUrl + ";UNDO_LOG=0;LOG=0;LOCK_MODE=0";
            String string2 = (String)Utils.getStaticField("org.h2.upgrade.v1_1.engine.Constants.START_URL");
            this.oldUrl = this.url;
            this.oldUrl = StringUtils.replaceAll(this.oldUrl, "jdbc:h2:", string2);
            this.oldUrl = StringUtils.replaceAllIgnoreCase(this.oldUrl, ";IGNORE_UNKNOWN_SETTINGS=TRUE", "");
            this.oldUrl = StringUtils.replaceAllIgnoreCase(this.oldUrl, ";IGNORE_UNKNOWN_SETTINGS=FALSE", "");
            this.oldUrl = StringUtils.replaceAllIgnoreCase(this.oldUrl, ";PAGE_STORE=TRUE", "");
            this.oldUrl = this.oldUrl + ";IGNORE_UNKNOWN_SETTINGS=TRUE";
            Object object2 = Utils.newInstance("org.h2.upgrade.v1_1.engine.ConnectionInfo", this.oldUrl, this.info);
            boolean bl = (Boolean)Utils.callMethod(object2, "isRemote", new Object[0]);
            boolean bl2 = (Boolean)Utils.callMethod(object2, "isPersistent", new Object[0]);
            String string3 = (String)Utils.callMethod(object2, "getName", new Object[0]);
            int n = string3.indexOf(58);
            while (n != -1 && (object = FileSystem.getInstance(string = string3.substring(0, n + 1))) != null && !(object instanceof FileSystemDisk)) {
                string3 = string3.substring(n + 1);
                n = string3.indexOf(58);
            }
            if (!bl && bl2) {
                string = string3 + ".data.db";
                object = string3 + ".index.db";
                String string4 = string3 + ".lobs.db";
                this.newName = string3 + ".h2.db";
                this.oldDataFile = new File(string).getAbsoluteFile();
                this.oldIndexFile = new File((String)object).getAbsoluteFile();
                this.oldLobsDir = new File(string4).getAbsoluteFile();
                this.newFile = new File(this.newName).getAbsoluteFile();
                this.backupDataFile = new File(this.oldDataFile.getAbsolutePath() + ".backup");
                this.backupIndexFile = new File(this.oldIndexFile.getAbsolutePath() + ".backup");
                this.backupLobsDir = new File(this.oldLobsDir.getAbsolutePath() + ".backup");
                this.mustBeConverted = this.oldDataFile.exists() && !this.newFile.exists();
            }
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    public boolean mustBeConverted() throws SQLException {
        return this.mustBeConverted;
    }

    public void upgrade() throws SQLException {
        this.successful = true;
        if (!this.mustBeConverted) {
            return;
        }
        File file = null;
        try {
            file = scriptInTempDir ? File.createTempFile("h2dbmigration", "backup.sql") : new File(this.oldDataFile.getAbsolutePath() + "_script.sql");
            Utils.callStaticMethod("org.h2.upgrade.v1_1.Driver.load", new Object[0]);
            Connection connection = DriverManager.getConnection(this.oldUrl, this.info);
            Statement statement = connection.createStatement();
            boolean bl = StringUtils.toUpperEnglish(this.url).indexOf(";CIPHER=") >= 0;
            String string = UUID.randomUUID().toString();
            if (bl) {
                statement.execute("script to '" + file + "' CIPHER AES PASSWORD '" + string + "' --hide--");
            } else {
                statement.execute("script to '" + file + "'");
            }
            statement.close();
            connection.close();
            this.oldDataFile.renameTo(this.backupDataFile);
            this.oldIndexFile.renameTo(this.backupIndexFile);
            this.oldLobsDir.renameTo(this.backupLobsDir);
            connection = DriverManager.getConnection(this.newUrl, this.info);
            statement = connection.createStatement();
            if (bl) {
                statement.execute("runscript from '" + file + "' CIPHER AES PASSWORD '" + string + "' --hide--");
            } else {
                statement.execute("runscript from '" + file + "'");
            }
            statement.execute("analyze");
            statement.execute("shutdown compact");
            statement.close();
            connection.close();
            if (deleteOldDb) {
                this.backupDataFile.delete();
                this.backupIndexFile.delete();
                FileSystem.getInstance(this.backupLobsDir.getAbsolutePath()).deleteRecursive(this.backupLobsDir.getAbsolutePath(), false);
            }
        }
        catch (Exception exception) {
            this.successful = false;
            if (this.backupDataFile.exists()) {
                this.backupDataFile.renameTo(this.oldDataFile);
            }
            if (this.backupIndexFile.exists()) {
                this.backupIndexFile.renameTo(this.oldIndexFile);
            }
            if (this.backupLobsDir.exists()) {
                this.backupLobsDir.renameTo(this.oldLobsDir);
            }
            this.newFile.delete();
            throw DbException.toSQLException(exception);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public boolean wasSuccessful() {
        return this.successful;
    }

    public static void setScriptInTempDir(boolean bl) {
        scriptInTempDir = bl;
    }

    public static void setDeleteOldDb(boolean bl) {
        deleteOldDb = bl;
    }
}

