/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.download.PrepareDownloadEvent;
import org.apache.ivy.core.event.resolve.ResolveEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers$Caller;
import org.apache.ivy.core.resolve.IvyNodeEviction$EvictionData;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.RestartResolveProcess;
import org.apache.ivy.core.resolve.VisitNode;
import org.apache.ivy.core.sort.SortEngine;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.resolver.CacheResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;

public final class ResolveEngine {
    private ResolveEngineSettings settings;
    private EventManager eventManager;
    private SortEngine sortEngine;
    private Set fetchedSet = new HashSet();
    private DependencyResolver dictatorResolver;

    public ResolveEngine(ResolveEngineSettings resolveEngineSettings, EventManager eventManager, SortEngine sortEngine) {
        this.settings = resolveEngineSettings;
        this.eventManager = eventManager;
        this.sortEngine = sortEngine;
    }

    private void setDictatorResolver(DependencyResolver dependencyResolver) {
        this.dictatorResolver = dependencyResolver;
        this.settings.setDictatorResolver(dependencyResolver);
    }

    public final ResolveReport resolve(ModuleDescriptor moduleDescriptor, ResolveOptions resolveOptions) {
        DependencyResolver dependencyResolver = this.dictatorResolver;
        IvyContext ivyContext = IvyContext.getContext();
        if (resolveOptions.isUseCacheOnly()) {
            this.setDictatorResolver(new CacheResolver(this.settings));
        }
        try {
            Object object;
            Object object2;
            String[] stringArray = resolveOptions.getConfs(moduleDescriptor);
            resolveOptions.setConfs(stringArray);
            if (resolveOptions.getResolveId() == null) {
                resolveOptions.setResolveId(ResolveOptions.getDefaultResolveId(moduleDescriptor));
            }
            this.eventManager.fireIvyEvent(new ResolveEvent(moduleDescriptor, stringArray));
            long l = System.currentTimeMillis();
            if ("default".equals(resolveOptions.getLog())) {
                Message.info(":: resolving dependencies :: " + moduleDescriptor.getResolvedModuleRevisionId() + (resolveOptions.isTransitive() ? "" : " [not transitive]"));
                Message.info("\tconfs: " + Arrays.asList(stringArray));
            } else {
                Message.verbose(":: resolving dependencies :: " + moduleDescriptor.getResolvedModuleRevisionId() + (resolveOptions.isTransitive() ? "" : " [not transitive]"));
                Message.verbose("\tconfs: " + Arrays.asList(stringArray));
            }
            Message.verbose("\tvalidate = " + resolveOptions.isValidate());
            Message.verbose("\trefresh = " + resolveOptions.isRefresh());
            ResolveReport resolveReport = new ResolveReport(resolveOptions.getResolveId());
            ResolveData resolveData = new ResolveData(this, resolveOptions);
            ivyContext.setResolveData(resolveData);
            IvyNode[] ivyNodeArray = this.getDependencies(moduleDescriptor, resolveOptions, resolveReport);
            resolveReport.setDependencies(Arrays.asList(ivyNodeArray), resolveOptions.getArtifactFilter());
            if (resolveOptions.getCheckIfChanged()) {
                resolveReport.checkIfChanged();
            }
            ResolutionCacheManager resolutionCacheManager = this.settings.getResolutionCacheManager();
            File file2 = resolutionCacheManager.getResolvedIvyFileInCache(moduleDescriptor.getResolvedModuleRevisionId());
            moduleDescriptor.toIvyFile(file2);
            File file3 = resolutionCacheManager.getResolvedIvyPropertiesInCache(moduleDescriptor.getResolvedModuleRevisionId());
            Properties properties = new Properties();
            if (ivyNodeArray.length > 0) {
                object2 = new HashMap();
                for (int i = 0; i < ivyNodeArray.length; ++i) {
                    if (ivyNodeArray[i].getModuleRevision() == null || !ivyNodeArray[i].getModuleRevision().isForce()) continue;
                    object2.put(ivyNodeArray[i].getModuleId(), ivyNodeArray[i].getResolvedId());
                }
                object = ivyNodeArray[0].getRoot();
                for (int i = 0; i < ivyNodeArray.length; ++i) {
                    DependencyDescriptor dependencyDescriptor;
                    if (ivyNodeArray[i].hasProblem() || (dependencyDescriptor = ivyNodeArray[i].getDependencyDescriptor((IvyNode)object)) == null) continue;
                    ModuleRevisionId moduleRevisionId = ivyNodeArray[i].getResolvedId();
                    ModuleDescriptor moduleDescriptor2 = ivyNodeArray[i].getDescriptor();
                    ModuleRevisionId moduleRevisionId2 = dependencyDescriptor.getDependencyRevisionId();
                    ModuleRevisionId moduleRevisionId3 = (ModuleRevisionId)object2.get(ivyNodeArray[i].getModuleId());
                    if (ivyNodeArray[i].getModuleRevision() != null && ivyNodeArray[i].getModuleRevision().isForce() && !moduleRevisionId.equals(moduleRevisionId2) && !this.settings.getVersionMatcher().isDynamic(moduleRevisionId2)) {
                        moduleRevisionId = moduleRevisionId2;
                        moduleDescriptor2 = null;
                    }
                    if (moduleRevisionId == null) {
                        throw new NullPointerException("getResolvedId() is null for " + ivyNodeArray[i].toString());
                    }
                    if (moduleRevisionId2 == null) {
                        throw new NullPointerException("getDependencyRevisionId() is null for " + dependencyDescriptor.toString());
                    }
                    String string = moduleRevisionId.getRevision();
                    String string2 = moduleRevisionId3 == null ? string : moduleRevisionId3.getRevision();
                    String string3 = moduleDescriptor2 == null ? "?" : moduleDescriptor2.getStatus();
                    properties.put(moduleRevisionId2.encodeToString(), string + " " + string3 + " " + string2);
                }
            }
            object2 = new FileOutputStream(file3);
            properties.store((OutputStream)object2, moduleDescriptor.getResolvedModuleRevisionId() + " resolved revisions");
            ((FileOutputStream)object2).close();
            Message.verbose("\tresolved ivy file produced in " + file2);
            resolveReport.setResolveTime(System.currentTimeMillis() - l);
            if (resolveOptions.isDownload()) {
                Message.verbose(":: downloading artifacts ::");
                this.downloadArtifacts(resolveReport, resolveOptions.getArtifactFilter(), (DownloadOptions)new DownloadOptions().setLog(resolveOptions.getLog()));
            }
            if (resolveOptions.isOutputReport()) {
                ResolveOptions resolveOptions2 = resolveOptions;
                ResolutionCacheManager resolutionCacheManager2 = resolutionCacheManager;
                ResolveReport resolveReport2 = resolveReport;
                ResolveEngine resolveEngine = this;
                if ("default".equals(resolveOptions2.getLog())) {
                    Message.info(":: resolution report :: resolve " + resolveReport2.getResolveTime() + "ms" + " :: artifacts dl " + resolveReport2.getDownloadTime() + "ms");
                } else {
                    Message.verbose(":: resolution report :: resolve " + resolveReport2.getResolveTime() + "ms" + " :: artifacts dl " + resolveReport2.getDownloadTime() + "ms");
                }
                resolveReport2.setProblemMessages(Message.getProblems());
                resolveReport2.output(resolveEngine.settings.getReportOutputters(), resolutionCacheManager2, resolveOptions2);
            }
            Message.verbose("\tresolve done (" + resolveReport.getResolveTime() + "ms resolve - " + resolveReport.getDownloadTime() + "ms download)");
            Message.sumupProblems();
            this.eventManager.fireIvyEvent(new ResolveEvent(moduleDescriptor, stringArray, resolveReport));
            object = resolveReport;
            return object;
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            Message.error(runtimeException.getMessage());
            Message.sumupProblems();
            throw runtimeException2;
        }
        finally {
            ivyContext.setResolveData(null);
            this.setDictatorResolver(dependencyResolver);
        }
    }

    private void downloadArtifacts(ResolveReport resolveReport, Filter filter2, DownloadOptions downloadOptions) {
        long l = System.currentTimeMillis();
        IvyNode[] ivyNodeArray = resolveReport.getDependencies().toArray(new IvyNode[resolveReport.getDependencies().size()]);
        resolveReport.getArtifacts().toArray(new Artifact[resolveReport.getArtifacts().size()]);
        this.eventManager.fireIvyEvent(new PrepareDownloadEvent());
        long l2 = 0L;
        for (int i = 0; i < ivyNodeArray.length; ++i) {
            ResolveEngine.checkInterrupted();
            if (ivyNodeArray[i].isCompletelyEvicted() || ivyNodeArray[i].hasProblem() || ivyNodeArray[i].getModuleRevision() == null) continue;
            DependencyResolver dependencyResolver = ivyNodeArray[i].getModuleRevision().getArtifactResolver();
            Artifact[] artifactArray = ivyNodeArray[i].getSelectedArtifacts(filter2);
            DownloadReport downloadReport = dependencyResolver.download(artifactArray, downloadOptions);
            ArtifactDownloadReport[] artifactDownloadReportArray = downloadReport.getArtifactsReports();
            for (int j = 0; j < artifactDownloadReportArray.length; ++j) {
                if (artifactDownloadReportArray[j].getDownloadStatus() == DownloadStatus.FAILED) {
                    if (artifactDownloadReportArray[j].getArtifact().getExtraAttribute("ivy:merged") != null) {
                        Message.warn("\tmerged artifact not found: " + artifactDownloadReportArray[j].getArtifact() + ". It was required in " + artifactDownloadReportArray[j].getArtifact().getExtraAttribute("ivy:merged"));
                        continue;
                    }
                    Message.warn("\t" + artifactDownloadReportArray[j]);
                    dependencyResolver.reportFailure(artifactDownloadReportArray[j].getArtifact());
                    continue;
                }
                if (artifactDownloadReportArray[j].getDownloadStatus() != DownloadStatus.SUCCESSFUL) continue;
                l2 += artifactDownloadReportArray[j].getSize();
            }
            String[] stringArray = ivyNodeArray[i].getRootModuleConfigurations();
            for (int j = 0; j < stringArray.length; ++j) {
                if (ivyNodeArray[i].isEvicted(stringArray[j]) || ivyNodeArray[i].isBlacklisted(stringArray[j])) {
                    resolveReport.getConfigurationReport(stringArray[j]).addDependency(ivyNodeArray[i]);
                    continue;
                }
                resolveReport.getConfigurationReport(stringArray[j]).addDependency(ivyNodeArray[i], downloadReport);
            }
        }
        resolveReport.setDownloadTime(System.currentTimeMillis() - l);
        resolveReport.setDownloadSize(l2);
    }

    private IvyNode[] getDependencies(ModuleDescriptor moduleDescriptor, ResolveOptions resolveOptions, ResolveReport resolveReport) {
        if (moduleDescriptor == null) {
            throw new NullPointerException("module descriptor must not be null");
        }
        String[] stringArray = resolveOptions.getConfs(moduleDescriptor);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new NullPointerException("null conf not allowed: confs where: " + Arrays.asList(stringArray));
            }
            if (moduleDescriptor.getConfiguration(stringArray[i]) != null) continue;
            arrayList.add(" '" + stringArray[i] + "' ");
        }
        if (!arrayList.isEmpty()) {
            throw new IllegalArgumentException("requested configuration" + (arrayList.size() > 1 ? "s" : "") + " not found in " + moduleDescriptor.getModuleRevisionId() + ": " + arrayList);
        }
        IvyContext ivyContext = IvyContext.pushNewCopyContext();
        try {
            Object object;
            Object object2;
            resolveOptions.setConfs(stringArray);
            Date date = new Date();
            ResolveData resolveData = ivyContext.getResolveData();
            if (resolveData == null) {
                resolveData = new ResolveData(this, resolveOptions);
                ivyContext.setResolveData(resolveData);
            }
            IvyNode ivyNode = new IvyNode(resolveData, moduleDescriptor);
            for (int i = 0; i < stringArray.length; ++i) {
                Message.verbose("resolving dependencies for configuration '" + stringArray[i] + "'");
                this.fetchedSet.clear();
                object2 = null;
                if (resolveReport != null && (object2 = resolveReport.getConfigurationReport(stringArray[i])) == null) {
                    object2 = new ConfigurationResolveReport(this, moduleDescriptor, stringArray[i], date, resolveOptions);
                    resolveReport.addReport(stringArray[i], (ConfigurationResolveReport)object2);
                }
                resolveData.setReport((ConfigurationResolveReport)object2);
                object = new VisitNode(resolveData, ivyNode, stringArray[i]);
                ((VisitNode)object).setRequestedConf(stringArray[i]);
                ivyNode.updateConfsToFetch(Collections.singleton(stringArray[i]));
                boolean bl = false;
                while (!bl) {
                    try {
                        this.fetchDependencies((VisitNode)object, stringArray[i], false);
                        bl = true;
                    }
                    catch (RestartResolveProcess restartResolveProcess) {
                        Message.verbose("====================================================");
                        Message.verbose("=           RESTARTING RESOLVE PROCESS");
                        Message.verbose("= " + restartResolveProcess.getMessage());
                        Message.verbose("====================================================");
                        this.fetchedSet.clear();
                    }
                }
                Iterator iterator = resolveData.getNodes().iterator();
                while (iterator.hasNext()) {
                    ((IvyNode)iterator.next()).clean();
                }
            }
            Collection collection = resolveData.getNodes();
            object2 = new LinkedHashSet(collection.size());
            object = collection.iterator();
            while (object.hasNext()) {
                IvyNode ivyNode2 = (IvyNode)object.next();
                if (ivyNode2 == null || ivyNode2.isRoot() || ivyNode2.isCompletelyBlacklisted()) continue;
                object2.add(ivyNode2);
            }
            object = this.sortEngine.sortNodes((Collection)object2, SortOptions.SILENT);
            Collections.reverse(object);
            this.handleTransiviteEviction(moduleDescriptor, stringArray, resolveData, (List)object);
            IvyNode[] ivyNodeArray = object2.toArray(new IvyNode[object2.size()]);
            return ivyNodeArray;
        }
        finally {
            IvyContext.popContext();
        }
    }

    private void handleTransiviteEviction(ModuleDescriptor moduleDescriptor, String[] stringArray, ResolveData resolveData, List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            IvyNode ivyNode = (IvyNode)listIterator.next();
            if (ivyNode.isCompletelyEvicted()) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                IvyNodeCallers$Caller[] ivyNodeCallers$CallerArray = ivyNode.getCallers(stringArray[i]);
                if (this.settings.debugConflictResolution()) {
                    Message.debug("checking if " + ivyNode.getId() + " is transitively evicted in " + stringArray[i]);
                }
                boolean bl = ivyNodeCallers$CallerArray.length > 0;
                for (int j = 0; j < ivyNodeCallers$CallerArray.length; ++j) {
                    if (ivyNodeCallers$CallerArray[j].getModuleRevisionId().equals(moduleDescriptor.getModuleRevisionId())) {
                        bl = false;
                        break;
                    }
                    IvyNode ivyNode2 = resolveData.getNode(ivyNodeCallers$CallerArray[j].getModuleRevisionId());
                    if (ivyNode2 == null) {
                        Message.warn("ivy internal error: no node found for " + ivyNodeCallers$CallerArray[j].getModuleRevisionId() + ": looked in " + resolveData.getNodeIds() + " and root module id was " + moduleDescriptor.getModuleRevisionId());
                        continue;
                    }
                    if (!ivyNode2.isEvicted(stringArray[i])) {
                        bl = false;
                        break;
                    }
                    if (!this.settings.debugConflictResolution()) continue;
                    Message.debug("caller " + ivyNode2.getId() + " of " + ivyNode.getId() + " is evicted");
                }
                if (bl) {
                    Message.verbose("all callers are evicted for " + ivyNode + ": evicting too");
                    ivyNode.markEvicted(stringArray[i], null, null, null);
                    continue;
                }
                if (!this.settings.debugConflictResolution()) continue;
                Message.debug(ivyNode.getId() + " isn't transitively evicted, at least one caller was" + " not evicted");
            }
        }
    }

    private void fetchDependencies(VisitNode visitNode, String string, boolean bl) {
        int n;
        String[] stringArray;
        ResolveEngine.checkInterrupted();
        long l = System.currentTimeMillis();
        if (visitNode.getParent() != null) {
            Message.verbose("== resolving dependencies " + visitNode.getParent().getId() + "->" + visitNode.getId() + " [" + visitNode.getParentConf() + "->" + string + "]");
        } else {
            Message.verbose("== resolving dependencies for " + visitNode.getId() + " [" + string + "]");
        }
        ResolveData resolveData = visitNode.getNode().getData();
        VisitNode visitNode2 = resolveData.getCurrentVisitNode();
        resolveData.setCurrentVisitNode(visitNode);
        DependencyDescriptor dependencyDescriptor = visitNode.getDependencyDescriptor();
        VersionMatcher versionMatcher = visitNode.getNode().getData().getSettings().getVersionMatcher();
        if (!(dependencyDescriptor == null || visitNode.getRoot() == visitNode.getParent() && versionMatcher.isDynamic(dependencyDescriptor.getDependencyRevisionId()))) {
            this.resolveConflict(visitNode, string);
        }
        if (visitNode.loadData(string, bl)) {
            this.resolveConflict(visitNode, string);
            if (!visitNode.isEvicted() && !visitNode.isCircular()) {
                stringArray = visitNode.getRealConfs(string);
                for (n = 0; n < stringArray.length; ++n) {
                    this.doFetchDependencies(visitNode, stringArray[n]);
                }
            }
        } else if (!(visitNode.hasProblem() || visitNode.isEvicted() || visitNode.isCircular())) {
            stringArray = visitNode.getRealConfs(string);
            for (n = 0; n < stringArray.length; ++n) {
                this.doFetchDependencies(visitNode, stringArray[n]);
            }
        }
        if (visitNode.isEvicted() && (stringArray = visitNode.getEvictedData()).getSelected() != null) {
            Iterator iterator = stringArray.getSelected().iterator();
            while (iterator.hasNext()) {
                IvyNode ivyNode = (IvyNode)iterator.next();
                if (!ivyNode.isLoaded()) {
                    ivyNode.updateConfsToFetch(Collections.singleton(string));
                    continue;
                }
                this.fetchDependencies(visitNode.gotoNode(ivyNode), string, true);
            }
        }
        if (this.settings.debugConflictResolution()) {
            Message.debug(visitNode.getId() + " => dependencies resolved in " + string + " (" + (System.currentTimeMillis() - l) + "ms)");
        }
        resolveData.setCurrentVisitNode(visitNode2);
    }

    private void doFetchDependencies(VisitNode visitNode, String string) {
        String[] stringArray;
        Configuration configuration = visitNode.getConfiguration(string);
        if (configuration == null) {
            if (!visitNode.isConfRequiredByMergedUsageOnly(string)) {
                Message.warn("configuration not found '" + string + "' in " + visitNode.getResolvedId() + ": ignoring");
                if (visitNode.getParent() != null) {
                    Message.warn("it was required from " + visitNode.getParent().getResolvedId());
                }
            }
            return;
        }
        boolean bl = false;
        if (visitNode.getRequestedConf() == null) {
            visitNode.setRequestedConf(string);
            bl = true;
        }
        if ((stringArray = configuration.getExtends()).length > 0) {
            visitNode.updateConfsToFetch(Arrays.asList(stringArray));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.fetchDependencies(visitNode, stringArray[i], false);
        }
        String string2 = string;
        IvyNode ivyNode = visitNode.getNode();
        ResolveEngine resolveEngine = this;
        String string3 = ResolveEngine.getDependenciesFetchedKey(ivyNode, string2);
        if (!resolveEngine.fetchedSet.contains(string3) && visitNode.isTransitive()) {
            Iterator iterator = visitNode.getDependencies(string).iterator();
            while (iterator.hasNext()) {
                int n;
                VisitNode visitNode2 = (VisitNode)iterator.next();
                visitNode2.useRealNode();
                String[] stringArray2 = visitNode2.getRequiredConfigurations(visitNode, string);
                for (n = 0; n < stringArray2.length; ++n) {
                    this.fetchDependencies(visitNode2, stringArray2[n], true);
                }
                if (visitNode2.isEvicted() || visitNode2.hasProblem()) continue;
                stringArray2 = visitNode2.getConfsToFetch();
                for (n = 0; n < stringArray2.length; ++n) {
                    this.fetchDependencies(visitNode2, stringArray2[n], false);
                }
            }
            string2 = string;
            ivyNode = visitNode.getNode();
            resolveEngine = this;
            string3 = ResolveEngine.getDependenciesFetchedKey(ivyNode, string2);
            resolveEngine.fetchedSet.add(string3);
        }
        if (bl) {
            visitNode.setRequestedConf(null);
        }
    }

    private static String getDependenciesFetchedKey(IvyNode ivyNode, String string) {
        ModuleRevisionId moduleRevisionId = ivyNode.getResolvedId();
        return moduleRevisionId.getOrganisation() + "|" + moduleRevisionId.getName() + "|" + moduleRevisionId.getRevision() + "|" + string;
    }

    private void resolveConflict(VisitNode visitNode, String string) {
        this.resolveConflict(visitNode, visitNode.getParent(), string, Collections.EMPTY_SET);
    }

    private boolean resolveConflict(VisitNode visitNode, VisitNode visitNode2, String string, Collection object) {
        Object object2;
        HashSet<IvyNode> hashSet;
        Collection collection;
        ConflictManager conflictManager;
        Collection collection2;
        boolean bl;
        while (true) {
            Collection collection3;
            Object object3;
            boolean bl2;
            boolean bl3;
            if (visitNode2 == null || visitNode == visitNode2) {
                return true;
            }
            VisitNode visitNode3 = visitNode2;
            VisitNode visitNode4 = visitNode;
            ResolveEngine resolveEngine = this;
            if (visitNode3.getEvictedRevisions(visitNode4.getModuleId()).contains(visitNode4.getResolvedId())) {
                if (resolveEngine.settings.debugConflictResolution()) {
                    Message.debug("conflict resolution already done for " + visitNode4 + " in " + visitNode3);
                }
                bl3 = true;
            } else {
                bl3 = false;
            }
            if (bl3) {
                return true;
            }
            bl = this.settings.debugConflictResolution();
            visitNode3 = visitNode2;
            visitNode4 = visitNode;
            resolveEngine = this;
            if (visitNode3.getResolvedRevisions(visitNode4.getModuleId()).contains(visitNode4.getResolvedId())) {
                if (resolveEngine.settings.debugConflictResolution()) {
                    Message.debug("conflict resolution already done for " + visitNode4 + " in " + visitNode3);
                }
                bl2 = true;
            } else {
                bl2 = false;
            }
            if (bl2) {
                if (this.resolveConflict(visitNode, visitNode2.getParent(), string, (Collection)object)) {
                    object3 = visitNode.getEvictionDataInRoot(visitNode.getRootModuleConf(), visitNode2);
                    if (object3 != null) {
                        if (bl) {
                            Message.debug(visitNode + " was previously evicted in root module conf " + visitNode.getRootModuleConf());
                        }
                        visitNode.markEvicted((IvyNodeEviction$EvictionData)object3);
                        if (bl) {
                            Message.debug("evicting " + visitNode + " by " + object3);
                        }
                    }
                    return true;
                }
                return false;
            }
            object3 = visitNode2.getNode().getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf());
            object3.addAll(visitNode2.getNode().getPendingConflicts(visitNode.getRootModuleConf(), visitNode.getModuleId()));
            collection2 = ResolveEngine.computeConflicts$baa5bc6(visitNode, visitNode2, (Collection)object, (Collection)object3);
            ConflictManager conflictManager2 = conflictManager = visitNode2.getNode().getConflictManager(visitNode.getModuleId());
            Collection collection4 = collection2;
            visitNode3 = visitNode2;
            visitNode4 = visitNode;
            resolveEngine = this;
            if (visitNode4.getParent() != visitNode3 && conflictManager2 == resolveEngine.settings.getConflictManager(visitNode4.getModuleId()) && ((Object)visitNode4.getParent().getNode().getResolvedNodes(visitNode4.getModuleId(), visitNode4.getRootModuleConf())).equals(collection4)) {
                if (resolveEngine.settings.debugConflictResolution()) {
                    Message.debug("no new conflicting revisions for " + visitNode4 + " in " + visitNode3 + ": " + collection4);
                }
                collection3 = collection4;
            } else {
                if (resolveEngine.settings.debugConflictResolution()) {
                    Message.debug("found conflicting revisions for " + visitNode4 + " in " + visitNode3 + ": " + collection4);
                }
                collection3 = collection = conflictManager2.resolveConflicts(visitNode3.getNode(), collection4);
            }
            if (collection3 == null) {
                if (bl) {
                    Message.debug("impossible to resolve conflicts for " + visitNode + " in " + visitNode2 + " yet");
                    Message.debug("setting all nodes as pending conflicts for later conflict resolution: " + collection2);
                }
                visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), collection2);
                return false;
            }
            if (bl) {
                Message.debug("selected revisions for " + visitNode + " in " + visitNode2 + ": " + collection);
            }
            if (!collection.contains(visitNode.getNode())) break;
            object = object3;
            object.removeAll(collection);
            hashSet = object.iterator();
            while (hashSet.hasNext()) {
                object2 = (IvyNode)hashSet.next();
                ((IvyNode)object2).markEvicted(visitNode.getRootModuleConf(), visitNode2.getNode(), conflictManager, collection);
                if (!bl) continue;
                Message.debug("evicting " + object2 + " by " + ((IvyNode)object2).getEvictedData(visitNode.getRootModuleConf()));
            }
            visitNode2.getNode().setResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), collection);
            hashSet = new HashSet<IvyNode>(visitNode2.getNode().getEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()));
            hashSet.removeAll(collection);
            hashSet.addAll((Collection<IvyNode>)object);
            visitNode2.getNode().setEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), hashSet);
            visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), Collections.EMPTY_SET);
            visitNode2 = visitNode2.getParent();
        }
        if (collection.isEmpty() && bl) {
            Message.verbose("conflict manager '" + conflictManager + "' evicted all revisions among " + collection2);
        }
        hashSet = new HashSet(visitNode2.getNode().getEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()));
        object.removeAll(collection);
        hashSet.removeAll(collection);
        hashSet.addAll((Collection<IvyNode>)object);
        hashSet.add(visitNode.getNode());
        visitNode2.getNode().setEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), hashSet);
        visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), Collections.EMPTY_SET);
        visitNode.markEvicted(visitNode2, conflictManager, collection);
        if (bl) {
            Message.debug("evicting " + visitNode + " by " + visitNode.getEvictedData());
        }
        object2 = visitNode2.getNode().getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf());
        boolean bl4 = true;
        if (!object2.equals(collection)) {
            visitNode2.getNode().setResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), collection);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                IvyNode ivyNode = (IvyNode)iterator.next();
                if (object2.contains(ivyNode)) continue;
                bl4 &= this.resolveConflict(visitNode.gotoNode(ivyNode), visitNode2.getParent(), string, (Collection)object);
            }
        }
        return bl4;
    }

    private static Collection computeConflicts$baa5bc6(VisitNode visitNode, VisitNode visitNode2, Collection collection, Collection collection2) {
        LinkedHashSet<IvyNode> linkedHashSet = new LinkedHashSet<IvyNode>();
        linkedHashSet.add(visitNode.getNode());
        if (collection2.removeAll(collection) || collection2.isEmpty() && !visitNode.getParent().getNode().equals(visitNode2.getNode())) {
            Iterator iterator = visitNode2.getNode().getDependencies(visitNode.getRootModuleConf(), visitNode2.getNode().getConfigurations(visitNode.getRootModuleConf())).iterator();
            while (iterator.hasNext()) {
                IvyNode ivyNode = (IvyNode)iterator.next();
                if (ivyNode.getModuleId().equals(visitNode.getModuleId())) {
                    linkedHashSet.add(ivyNode);
                }
                linkedHashSet.addAll(ivyNode.getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()));
            }
        } else if (collection2.isEmpty()) {
            Iterator iterator = visitNode.getParent().getNode().getDependencies(visitNode.getRootModuleConf(), new String[]{visitNode.getParentConf()}).iterator();
            while (iterator.hasNext()) {
                IvyNode ivyNode = (IvyNode)iterator.next();
                if (!ivyNode.getModuleId().equals(visitNode.getModuleId())) continue;
                linkedHashSet.add(ivyNode);
            }
        } else {
            linkedHashSet.addAll(collection2);
        }
        return linkedHashSet;
    }

    public final DependencyDescriptor mediate(DependencyDescriptor dependencyDescriptor, ResolveOptions resolveOptions) {
        String string;
        if (dependencyDescriptor == null) {
            return null;
        }
        String string2 = string = resolveOptions.getResolveMode() == null ? this.settings.getResolveMode(dependencyDescriptor.getDependencyId()) : resolveOptions.getResolveMode();
        if ("dynamic".equals(string) && !dependencyDescriptor.getDynamicConstraintDependencyRevisionId().equals(dependencyDescriptor.getDependencyRevisionId())) {
            return dependencyDescriptor.clone(ModuleRevisionId.newInstance(dependencyDescriptor.getDynamicConstraintDependencyRevisionId(), dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getRevision()));
        }
        return dependencyDescriptor;
    }

    public final EventManager getEventManager() {
        return this.eventManager;
    }

    public final ResolveEngineSettings getSettings() {
        return this.settings;
    }

    public final SortEngine getSortEngine() {
        return this.sortEngine;
    }

    private static void checkInterrupted() {
        IvyContext.getContext().getIvy().checkInterrupted();
    }
}

