/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class FileUtil {
    private static final byte[] EMPTY_BUFFER = new byte[0];

    private FileUtil() {
    }

    public static boolean copy(File file2, File file3, CopyProgressListener copyProgressListener, boolean bl) {
        if (file3.exists()) {
            if (!file3.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + file3);
            }
            if (!file3.canWrite()) {
                file3.delete();
            }
        }
        FileUtil.copy((InputStream)new FileInputStream(file2), file3, copyProgressListener);
        long l = file2.length();
        long l2 = file3.length();
        if (l != l2) {
            file3.delete();
            throw new IOException("size of source file " + file2.toString() + "(" + l + ") differs from size of dest file " + file3.toString() + "(" + l2 + ") - please retry");
        }
        file3.setLastModified(file2.lastModified());
        return true;
    }

    public static void copy(URL uRL, File file2, CopyProgressListener copyProgressListener) {
        URLHandlerRegistry.getDefault().download(uRL, file2, copyProgressListener);
    }

    public static void copy(InputStream inputStream, File file2, CopyProgressListener copyProgressListener) {
        if (file2.getParentFile() != null) {
            file2.getParentFile().mkdirs();
        }
        FileUtil.copy(inputStream, new FileOutputStream(file2), copyProgressListener);
    }

    private static void copy(InputStream inputStream, OutputStream outputStream, CopyProgressListener copyProgressListener) {
        CopyProgressEvent copyProgressEvent = null;
        if (copyProgressListener != null) {
            copyProgressEvent = new CopyProgressEvent();
        }
        try {
            int n;
            byte[] byArray = new byte[65536];
            if (copyProgressListener != null) {
                copyProgressListener.start$15cf7218();
            }
            while ((n = inputStream.read(byArray)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("transfer interrupted");
                }
                outputStream.write(byArray, 0, n);
                if (copyProgressListener == null) continue;
                copyProgressListener.progress(copyProgressEvent.update$565320f6(n));
            }
            if (copyProgressListener != null) {
                copyProgressEvent.update$565320f6(0);
            }
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {}
            inputStream.close();
            outputStream.close();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        try {
            outputStream.close();
        }
        catch (IOException iOException) {}
        if (copyProgressListener != null) {
            copyProgressListener.end(copyProgressEvent);
        }
    }

    public static String readEntirely(BufferedReader bufferedReader) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string + "\n");
                string = bufferedReader.readLine();
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static List getPathFiles(File file2, File file3) {
        ArrayList<File> arrayList = new ArrayList<File>();
        while (file3 != null && !file3.getAbsolutePath().equals(file2.getAbsolutePath())) {
            arrayList.add(file3);
            file3 = file3.getParentFile();
        }
        if (file2 != null) {
            arrayList.add(file2);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static File resolveFile(File file2, String string) {
        File file3 = new File(string);
        if (file3.isAbsolute()) {
            return file3;
        }
        return new File(file2, string);
    }
}

