package jp.sf.amateras.functions.utils;

import java.util.Properties;

/**
 * <tt>functions.properties</tt>を読み込むためのメソッドを提供します。
 *
 * @author Naoki Takezoe
 */
public class FunctionsProperties {

	/**
	 * <tt>functions.properties</tt>を読み込み、
	 * <code>java.util.Properties</code>オブジェクトを返却します。
	 *
	 * @return <tt>functions.properties</tt>で定義されたプロパティを格納した
	 *   <code>java.util.Properties</code>オブジェクト。
	 *   <tt>functions.properties</tt>の読み込みに失敗した場合は<code>null</code>を返却します。
	 */
	public static Properties getProperties(){
		Properties properties = new Properties();

		try {
			properties.load(Thread.currentThread()
					.getContextClassLoader()
					.getResourceAsStream("functions.properties"));

		} catch(Exception ex){
		}

		return properties;
	}

}
