package jp.sf.amateras.functions.utils;

import java.util.Locale;
import java.util.MissingResourceException;

import junit.framework.TestCase;

public class TextUtilsTest extends TestCase {

	public void testGetText_1() {
		assertEquals("message1", TextUtils.getText("key1", new Locale("en", "US")));
		assertEquals("メッセージ1", TextUtils.getText("key1", new Locale("ja", "JP")));
	}

	public void testGetText_2() {
		assertEquals("message2", TextUtils.getText("key2", new Locale("en", "US")));
		assertEquals("message2", TextUtils.getText("key2", new Locale("ja", "JP")));
	}

	public void testGetText_3() {
		assertEquals("key3", TextUtils.getText("key3", new Locale("en", "US")));
		assertEquals("key3", TextUtils.getText("key3", new Locale("ja", "JP")));
	}

	public void testGetText_4() {
		TextUtils.setBundleName("hoge");
		try {
			TextUtils.getText("key1", new Locale("en", "US"));
			fail();
		} catch(MissingResourceException ex){
			assertEquals("Can't find bundle for base name hoge, locale en_US", ex.getMessage());
		}
	}
}
