package jp.sf.amateras.mirage;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.List;

import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.type.ValueType;

/**
 * An interface to creating an entity object from ResultSet.
 * <p>
 * You can implement your own ResultEntityCreator and enable it by {@link SqlManager#setEntityCreator(ResultEntityCreator)}.
 *
 * @author Naoki Takezoe
 */
public interface ResultEntityCreator {

	/**
	 * Creates and returns one entity instance from the ResultSet.
	 *
	 * @param <T> the type parameter of entity class
	 * @param clazz the entity class
	 * @param rs the ResultSet
	 * @param meta the ResultSetMetaData
	 * @param columnCount the column count
	 * @param beanDesc the BeanDesc of the entity class
	 * @param dialect the Dialect
	 * @param valueTypes the list of ValueTypes
	 * @param nameConverter the NameConverter
	 * @return the instance of entity class or Map
	 * @throws EntityCreationFailedException if {@link ResultEntityCreator} failed to create a result entity
	 */
	public <T> T createEntity(Class<T> clazz, ResultSet rs,
			ResultSetMetaData meta, int columnCount, BeanDesc beanDesc,
			Dialect dialect, List<ValueType<?>> valueTypes, NameConverter nameConverter);

}
