package code
package snippet

import org.specs._
import net.liftweb._
import http._
import net.liftweb.util._
import net.liftweb.common._
import org.specs.specification._
import Helpers._
import lib.DependencyFactory

//class IndexSnippetTestSpecsAsTest extends JUnit4(IndexSnippetTestSpecs)
//object IndexSnippetTestSpecsRunner extends ConsoleRunner(IndexSnippetTestSpecs)

class IndexSnippetTestSpecs extends Specification {
  val session = new LiftSession("", randomString(20), Empty)
  val stableTime = now

  override def executeExpectations(ex: Examples, t: =>Any): Any = {
    S.initIfUninitted(session){
      // TODO ここの意味がよくわからない
      DependencyFactory.time.doWith(stableTime) {
        super.executeExpectations(ex, t)
      }
    }
  }

  "IndexSnippet#addForm()" should {
    "makes the add directory form" in {
      val index = new IndexSnippet

      val str = index.addForm(<form:submit />).toString()
      str.indexOf("<input ") must be >= 0
      str.indexOf("type=\"submit\"") must be >= 0
      str.indexOf("value=\"Add\"") must be >= 0
    }
  }
  "IndexSnippet#editForm()" should {
    "makes the edit directory form" in {
      val index = new IndexSnippet

      val str = index.editForm(<form:submit />).toString()
      str.indexOf("<input ") must be >= 0
      str.indexOf("type=\"submit\"") must be >= 0
      str.indexOf("value=\"Save\"") must be >= 0
    }
  }

}
