/*
Copyright (c) 2014, Intel Corporation
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright notice,
    * this list of conditions and the following disclaimer in the documentation
    * and/or other materials provided with the distribution.

    * Neither the name of Intel Corporation nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

# -- Begin  __libm_reduce_pi04l
	.text
       .align    16,0x90
	.hidden __libm_reduce_pi04l
	.globl __libm_reduce_pi04l
__libm_reduce_pi04l:
# parameter 1: 8 + %ebp
# parameter 2: 20 + %ebp
# parameter 3: 24 + %ebp
..B1.1:
        pushl     %ebp
        movl      %esp, %ebp
        andl      $-16, %esp
        pushl     %esi
        pushl     %edi
        pushl     %ebx
        subl      $20, %esp
        movzwl    16(%ebp), %ebx
        andl      $32767, %ebx
        movl      20(%ebp), %eax
        cmpl      $16413, %ebx
        movl      24(%ebp), %esi
        call      ..L2
..L2:
        popl      %edi
        lea       _GLOBAL_OFFSET_TABLE_+[. - ..L2](%edi), %edi
        movl      %eax, 4(%esp)
        jge       ..B1.8
..B1.2:
        fldt      8(%ebp)
        fldl      __4onpi_d@GOTOFF(%edi)
        fmul      %st(1), %st
        fstpt     8(%esp)
        movzwl    16(%esp), %ecx
        negl      %ecx
        addl      $30, %ecx
        movl      12(%esp), %eax
        shrl      %cl, %eax
        cmpl      $0, 4(%esp)
        jne       ..B1.4
..B1.3:
        lea       1(%eax), %ecx
        andl      $-2, %ecx
        jmp       ..B1.5
..B1.4:
        movl      %eax, %ecx
        addl      4(%esp), %eax
        movl      %eax, %edx
        andl      $1, %edx
        addl      %edx, %ecx
..B1.5:
        fldl      _TWO_32H@GOTOFF(%edi)
        cmpl      $16400, %ebx
        movl      %ecx, (%esp)
        fildl     (%esp)
        jge       ..B1.7
..B1.6:
        fldl      _pi04_3d@GOTOFF(%edi)
        fmul      %st(1), %st
        fsubrp    %st, %st(3)
        fxch      %st(1)
        fmul      %st(2), %st
        fld       %st(2)
        fadd      %st(1), %st
        fsubp     %st, %st(1)
        fld       %st(0)
        fxch      %st(1)
        fsubr     %st, %st(3)
        fldl      8+_pi04_3d@GOTOFF(%edi)
        fmul      %st(3), %st
        fsubr     %st, %st(2)
        fxch      %st(1)
        fsub      %st(2), %st
        fsubp     %st, %st(1)
        faddp     %st, %st(3)
        fldl      16+_pi04_3d@GOTOFF(%edi)
        fmulp     %st, %st(2)
        fld       %st(1)
        fsubr     %st(1), %st
        fsubr     %st, %st(1)
        fxch      %st(2)
        fsubrp    %st, %st(1)
        faddp     %st, %st(2)
        fxch      %st(1)
        jmp       ..B1.15
..B1.7:
        fldl      _pi04_5d@GOTOFF(%edi)
        fmul      %st(1), %st
        fsubrp    %st, %st(3)
        fxch      %st(1)
        fmul      %st(2), %st
        fld       %st(2)
        fadd      %st(1), %st
        fsubp     %st, %st(1)
        fld       %st(0)
        fxch      %st(1)
        fsubr     %st, %st(3)
        fldl      8+_pi04_5d@GOTOFF(%edi)
        fmul      %st(3), %st
        fsubr     %st, %st(2)
        fxch      %st(1)
        fsub      %st(2), %st
        fsubp     %st, %st(1)
        faddp     %st, %st(3)
        fldl      16+_pi04_5d@GOTOFF(%edi)
        fmul      %st(2), %st
        fld       %st(0)
        fsubr     %st(2), %st
        fsubr     %st, %st(2)
        fxch      %st(1)
        fsubrp    %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(3)
        fldl      24+_pi04_5d@GOTOFF(%edi)
        fmul      %st(2), %st
        fld       %st(0)
        fsubr     %st(2), %st
        fsubr     %st, %st(2)
        fxch      %st(1)
        fsubrp    %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(3)
        fldl      32+_pi04_5d@GOTOFF(%edi)
        fmulp     %st, %st(2)
        fld       %st(1)
        fsubr     %st(1), %st
        fsubr     %st, %st(1)
        fxch      %st(2)
        fsubrp    %st, %st(1)
        faddp     %st, %st(2)
        fxch      %st(1)
        jmp       ..B1.15
..B1.8:
        fldt      8(%ebp)
        addl      $-16417, %ebx
        fmull     _SCALE@GOTOFF(%edi)
        movl      $-2078209981, %eax
        imull     %ebx
        addl      %ebx, %edx
        movl      %ebx, %ecx
        sarl      $4, %edx
        sarl      $31, %ecx
        subl      %ecx, %edx
        movl      %edx, %eax
        shll      $5, %eax
        fstpt     8(%ebp)
        fldt      8(%ebp)
        subl      %edx, %eax
        movl      $0, 8(%ebp)
        subl      %eax, %ebx
        fldt      8(%ebp)
        cmpl      $17, %ebx
        fsubr     %st, %st(1)
        jl        ..B1.10
..B1.9:
        lea       (,%edx,8), %eax
        lea       (%eax,%edx,4), %ecx
        incl      %edx
        fldt      __4onpi_31l@GOTOFF(%ecx,%edi)
        fmul      %st(2), %st
        fldt      12+__4onpi_31l@GOTOFF(%edi,%ecx)
        fmul      %st(2), %st
        fld       %st(0)
        fadd      %st(2), %st
        fsubr     %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(2)
        fld       %st(1)
        fadd      %st(1), %st
        fstpt     8(%esp)
        andl      $-16777216, 8(%esp)
        fldt      8(%esp)
        fsubrp    %st, %st(1)
        jmp       ..B1.11
..B1.10:
        fldl      _zeros@GOTOFF(%edi)
        fld       %st(0)
..B1.11:
        fld       %st(0)
        lea       (,%edx,8), %eax
        fld       %st(3)
        lea       (%eax,%edx,4), %edx
        fldt      __4onpi_31l@GOTOFF(%edx,%edi)
        fmul      %st(6), %st
        movl      %edx, (%esp)
        fadd      %st, %st(2)
        fxch      %st(2)
        fsubr     %st, %st(3)
        fxch      %st(2)
        faddp     %st, %st(3)
        fxch      %st(2)
        faddp     %st, %st(3)
        fldt      12+__4onpi_31l@GOTOFF(%edx,%edi)
        fmul      %st, %st(2)
        fld       %st(2)
        fadd      %st(2), %st
        fld       %st(0)
        fxch      %st(1)
        fsub      %st, %st(3)
        fxch      %st(3)
        fchs      
        faddp     %st, %st(4)
        fxch      %st(3)
        faddp     %st, %st(4)
        fxch      %st(2)
        fadd      %st(3), %st
        fxch      %st(2)
        fmul      %st(5), %st
        fadd      %st, %st(2)
        fld       %st(4)
        fldt      24+__4onpi_31l@GOTOFF(%edx,%edi)
        fmul      %st, %st(1)
        fxch      %st(1)
        fadd      %st, %st(4)
        fxch      %st(4)
        fstpt     8(%esp)
        movzwl    16(%esp), %ebx
        andl      $32767, %ebx
        cmpl      $16415, %ebx
        jge       ..B1.13
..B1.12:
        negl      %ebx
        addl      $30, %ebx
        movl      %ebx, %ecx
        movl      12(%esp), %eax
        shrl      %cl, %eax
        shll      %cl, %eax
        movl      %eax, 12(%esp)
        movl      $0, 8(%esp)
        shrl      %cl, %eax
        jmp       ..B1.14
..B1.13:
        negl      %ebx
        addl      $30, %ebx
        movl      %ebx, %ecx
        movl      8(%esp), %edx
        shrl      %cl, %edx
        shll      %cl, %edx
        negl      %ecx
        movl      12(%esp), %eax
        shll      %cl, %eax
        movl      %ebx, %ecx
        movl      %edx, 8(%esp)
        shrl      %cl, %edx
        orl       %edx, %eax
..B1.14:
        fldt      8(%esp)
        addl      4(%esp), %eax
        fsubrp    %st, %st(3)
        fmul      %st(6), %st
        fld       %st(4)
        movl      %eax, %edx
        andl      $1, %edx
        fadd      %st(3), %st
        movl      (%esp), %ecx
        fsubr     %st, %st(3)
        fxch      %st(3)
        faddp     %st, %st(5)
        fld       %st(1)
        fxch      %st(3)
        faddl     zero_none@GOTOFF(%edi,%edx,8)
        fadd      %st, %st(3)
        fsub      %st(3), %st
        faddp     %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(4)
        fld       %st(2)
        fadd      %st(2), %st
        fsubr     %st, %st(2)
        fxch      %st(3)
        faddp     %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(3)
        fld       %st(0)
        fadd      %st(2), %st
        fsubr     %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(2)
        fld       %st(2)
        fldt      36+__4onpi_31l@GOTOFF(%ecx,%edi)
        fmul      %st, %st(1)
        fld       %st(1)
        fadd      %st(3), %st
        fsubr     %st, %st(3)
        fxch      %st(2)
        faddp     %st, %st(3)
        fxch      %st(2)
        faddp     %st, %st(3)
        fxch      %st(1)
        fmul      %st(4), %st
        fld       %st(0)
        fadd      %st(2), %st
        fsubr     %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(2)
        fld       %st(2)
        fldt      48+__4onpi_31l@GOTOFF(%ecx,%edi)
        fmul      %st, %st(1)
        fld       %st(1)
        fadd      %st(3), %st
        fsubr     %st, %st(3)
        fxch      %st(2)
        faddp     %st, %st(3)
        fxch      %st(2)
        faddp     %st, %st(3)
        fld       %st(3)
        fxch      %st(2)
        fmul      %st(5), %st
        fldt      60+__4onpi_31l@GOTOFF(%ecx,%edi)
        fmul      %st, %st(3)
        fxch      %st(3)
        faddp     %st, %st(1)
        fld       %st(0)
        fadd      %st(2), %st
        fsubr     %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(3)
        fld       %st(3)
        fxch      %st(2)
        fmul      %st(5), %st
        fldt      72+__4onpi_31l@GOTOFF(%ecx,%edi)
        fmul      %st, %st(3)
        fxch      %st(3)
        faddp     %st, %st(1)
        fld       %st(0)
        fadd      %st(2), %st
        fsubr     %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(2)
        fxch      %st(1)
        faddp     %st, %st(3)
        fxch      %st(1)
        fmulp     %st, %st(4)
        fldt      84+__4onpi_31l@GOTOFF(%edi,%ecx)
        fmulp     %st, %st(3)
        fxch      %st(2)
        faddp     %st, %st(3)
        fld       %st(2)
        fadd      %st(2), %st
        fldl      _TWO_32H@GOTOFF(%edi)
        fmul      %st(1), %st
        fadd      %st, %st(1)
        fsubrp    %st, %st(1)
        fsubr     %st, %st(2)
        fxch      %st(3)
        faddp     %st, %st(2)
        faddp     %st, %st(1)
        fldl      _pi04_2d@GOTOFF(%edi)
        fld       %st(0)
        fmul      %st(2), %st
        fxch      %st(2)
        fadd      %st(3), %st
        fxch      %st(1)
        fmulp     %st, %st(3)
        fmull     8+_pi04_2d@GOTOFF(%edi)
        faddp     %st, %st(1)
..B1.15:
        fldl      _TWO_12H@GOTOFF(%edi)
        fld       %st(2)
        fadd      %st(2), %st
        fmul      %st, %st(1)
        fstpt     8(%esp)
        fldt      8(%esp)
        fadd      %st(1), %st
        fsubp     %st, %st(1)
        fstl      (%esi)
        fsubrp    %st, %st(2)
        faddp     %st, %st(1)
        fstpl     8(%esi)
        addl      $20, %esp
        popl      %ebx
        popl      %edi
        popl      %esi
        movl      %ebp, %esp
        popl      %ebp
        ret       
        .align    16,0x90
	.type	__libm_reduce_pi04l,@function
	.size	__libm_reduce_pi04l,.-__libm_reduce_pi04l
	.data
# -- End  __libm_reduce_pi04l
	.section .rodata, "a"
	.align 8
	.align 8
zero_none:
	.long	0x00000000,0x00000000
	.long	0x00000000,0xbff00000
	.type	zero_none,@object
	.size	zero_none,16
	.align 4
__4onpi_d:
	.long	1841940611
	.long	1072979760
	.type	__4onpi_d,@object
	.size	__4onpi_d,8
	.align 4
_TWO_32H:
	.long	0
	.long	1106771968
	.type	_TWO_32H,@object
	.size	_TWO_32H,8
	.align 4
_pi04_3d:
	.long	1413754112
	.long	1072243195
	.long	2563527040
	.long	1021855384
	.long	3417685868
	.long	3118450936
	.type	_pi04_3d,@object
	.size	_pi04_3d,24
	.align 4
_pi04_5d:
	.long	1413480448
	.long	1072243195
	.long	442499072
	.long	1036039265
	.long	771751936
	.long	999496074
	.long	622854144
	.long	963347354
	.long	1396597664
	.long	922906692
	.type	_pi04_5d,@object
	.size	_pi04_5d,40
	.align 4
_SCALE:
	.long	0
	.long	845152256
	.type	_SCALE,@object
	.size	_SCALE,8
	.align 4
_zeros:
	.long	0
	.long	0
	.long	0
	.long	2147483648
	.type	_zeros,@object
	.size	_zeros,16
	.align 4
_pi04_2d:
	.long	1413480448
	.long	1072243195
	.long	442655537
	.long	1036039265
	.type	_pi04_2d,@object
	.size	_pi04_2d,16
	.align 4
_TWO_12H:
	.long	0
	.long	1085800448
	.type	_TWO_12H,@object
	.size	_TWO_12H,8
	.align 2
__4onpi_31l:
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
	.word	33646
	.word	41721
	.word	16600
	.word	0
	.word	0
	.word	0
	.word	10832
	.word	40072
	.word	16567
	.word	0
	.word	0
	.word	0
	.word	44008
	.word	65043
	.word	16537
	.word	0
	.word	0
	.word	0
	.word	28384
	.word	64154
	.word	16505
	.word	0
	.word	0
	.word	0
	.word	38272
	.word	56162
	.word	16472
	.word	0
	.word	0
	.word	0
	.word	7298
	.word	51682
	.word	16445
	.word	0
	.word	0
	.word	0
	.word	45504
	.word	65320
	.word	16409
	.word	0
	.word	0
	.word	0
	.word	61204
	.word	44922
	.word	16382
	.word	0
	.word	0
	.word	0
	.word	18652
	.word	50030
	.word	16351
	.word	0
	.word	0
	.word	0
	.word	14144
	.word	59657
	.word	16318
	.word	0
	.word	0
	.word	0
	.word	37450
	.word	47105
	.word	16290
	.word	0
	.word	0
	.word	0
	.word	14898
	.word	56641
	.word	16259
	.word	0
	.word	0
	.word	0
	.word	34680
	.word	34623
	.word	16226
	.word	0
	.word	0
	.word	0
	.word	4760
	.word	45515
	.word	16196
	.word	0
	.word	0
	.word	0
	.word	41480
	.word	40187
	.word	16166
	.word	0
	.word	0
	.word	0
	.word	47852
	.word	55252
	.word	16134
	.word	0
	.word	0
	.word	0
	.word	54072
	.word	35081
	.word	16103
	.word	0
	.word	0
	.word	0
	.word	26808
	.word	57421
	.word	16071
	.word	0
	.word	0
	.word	0
	.word	20068
	.word	57232
	.word	16042
	.word	0
	.word	0
	.word	0
	.word	49576
	.word	60188
	.word	16009
	.word	0
	.word	0
	.word	0
	.word	10016
	.word	52861
	.word	15978
	.word	0
	.word	0
	.word	0
	.word	30648
	.word	35825
	.word	15947
	.word	0
	.word	0
	.word	0
	.word	60542
	.word	58528
	.word	15918
	.word	0
	.word	0
	.word	0
	.word	65468
	.word	61743
	.word	15887
	.word	0
	.word	0
	.word	0
	.word	64960
	.word	45825
	.word	15851
	.word	0
	.word	0
	.word	0
	.word	50604
	.word	38792
	.word	15825
	.word	0
	.word	0
	.word	0
	.word	18394
	.word	33435
	.word	15794
	.word	0
	.word	0
	.word	0
	.word	55780
	.word	42703
	.word	15763
	.word	0
	.word	0
	.word	0
	.word	14056
	.word	63841
	.word	15731
	.word	0
	.word	0
	.word	0
	.word	63080
	.word	62563
	.word	15700
	.word	0
	.word	0
	.word	0
	.word	20840
	.word	62207
	.word	15669
	.word	0
	.word	0
	.word	0
	.word	30094
	.word	59983
	.word	15639
	.word	0
	.word	0
	.word	0
	.word	61818
	.word	60389
	.word	15608
	.word	0
	.word	0
	.word	0
	.word	40186
	.word	40579
	.word	15577
	.word	0
	.word	0
	.word	0
	.word	42170
	.word	58004
	.word	15546
	.word	0
	.word	0
	.word	0
	.word	55276
	.word	39678
	.word	15514
	.word	0
	.word	0
	.word	0
	.word	44672
	.word	36806
	.word	15481
	.word	0
	.word	0
	.word	0
	.word	13060
	.word	34144
	.word	15452
	.word	0
	.word	0
	.word	0
	.word	28016
	.word	57231
	.word	15419
	.word	0
	.word	0
	.word	0
	.word	16112
	.word	44995
	.word	15390
	.word	0
	.word	0
	.word	0
	.word	53464
	.word	33387
	.word	15358
	.word	0
	.word	0
	.word	0
	.word	7296
	.word	60751
	.word	15325
	.word	0
	.word	0
	.word	0
	.word	29452
	.word	45231
	.word	15297
	.word	0
	.word	0
	.word	0
	.word	26208
	.word	49689
	.word	15266
	.word	0
	.word	0
	.word	0
	.word	37900
	.word	44002
	.word	15235
	.word	0
	.word	0
	.word	0
	.word	57340
	.word	33800
	.word	15204
	.word	0
	.word	0
	.word	0
	.word	27544
	.word	50178
	.word	15173
	.word	0
	.word	0
	.word	0
	.word	6168
	.word	40132
	.word	15142
	.word	0
	.word	0
	.word	0
	.word	21392
	.word	43702
	.word	15109
	.word	0
	.word	0
	.word	0
	.word	45168
	.word	54372
	.word	15081
	.word	0
	.word	0
	.word	0
	.word	8986
	.word	40688
	.word	15050
	.word	0
	.word	0
	.word	0
	.word	1648
	.word	53745
	.word	15018
	.word	0
	.word	0
	.word	0
	.word	30520
	.word	55795
	.word	14986
	.word	0
	.word	0
	.word	0
	.word	43060
	.word	32914
	.word	14956
	.word	0
	.word	0
	.word	0
	.word	46172
	.word	52771
	.word	14925
	.word	0
	.word	0
	.word	0
	.word	14056
	.word	45285
	.word	14893
	.word	0
	.word	0
	.word	0
	.word	53590
	.word	44868
	.word	14864
	.word	0
	.word	0
	.word	0
	.word	40786
	.word	35970
	.word	14833
	.word	0
	.word	0
	.word	0
	.word	33436
	.word	65411
	.word	14801
	.word	0
	.word	0
	.word	0
	.word	32006
	.word	61382
	.word	14771
	.word	0
	.word	0
	.word	0
	.word	37856
	.word	45239
	.word	14738
	.word	0
	.word	0
	.word	0
	.word	60894
	.word	49555
	.word	14709
	.word	0
	.word	0
	.word	0
	.word	48064
	.word	53065
	.word	14674
	.word	0
	.word	0
	.word	0
	.word	48624
	.word	54844
	.word	14647
	.word	0
	.word	0
	.word	0
	.word	7988
	.word	40762
	.word	14616
	.word	0
	.word	0
	.word	0
	.word	16270
	.word	58745
	.word	14585
	.word	0
	.word	0
	.word	0
	.word	37064
	.word	50168
	.word	14553
	.word	0
	.word	0
	.word	0
	.word	18624
	.word	63736
	.word	14519
	.word	0
	.word	0
	.word	0
	.word	60758
	.word	44966
	.word	14492
	.word	0
	.word	0
	.word	0
	.word	33304
	.word	47465
	.word	14461
	.word	0
	.word	0
	.word	0
	.word	6226
	.word	60503
	.word	14430
	.word	0
	.word	0
	.word	0
	.word	26380
	.word	54900
	.word	14398
	.word	0
	.word	0
	.word	0
	.word	44352
	.word	49860
	.word	14368
	.word	0
	.word	0
	.word	0
	.word	11904
	.word	42646
	.word	14337
	.word	0
	.word	0
	.word	0
	.word	55296
	.word	50279
	.word	14300
	.word	0
	.word	0
	.word	0
	.word	15474
	.word	50606
	.word	14275
	.word	0
	.word	0
	.word	0
	.word	45062
	.word	44137
	.word	14244
	.word	0
	.word	0
	.word	0
	.word	13472
	.word	36063
	.word	14210
	.word	0
	.word	0
	.word	0
	.word	40658
	.word	53854
	.word	14182
	.word	0
	.word	0
	.word	0
	.word	28652
	.word	43690
	.word	14151
	.word	0
	.word	0
	.word	0
	.word	24640
	.word	64348
	.word	14118
	.word	0
	.word	0
	.word	0
	.word	30284
	.word	41980
	.word	14088
	.word	0
	.word	0
	.word	0
	.word	45652
	.word	38222
	.word	14057
	.word	0
	.word	0
	.word	0
	.word	15900
	.word	62940
	.word	14026
	.word	0
	.word	0
	.word	0
	.word	31494
	.word	50741
	.word	13996
	.word	0
	.word	0
	.word	0
	.word	43194
	.word	55096
	.word	13965
	.word	0
	.word	0
	.word	0
	.word	1740
	.word	45646
	.word	13933
	.word	0
	.word	0
	.word	0
	.word	28936
	.word	44150
	.word	13903
	.word	0
	.word	0
	.word	0
	.word	8996
	.word	42955
	.word	13872
	.word	0
	.word	0
	.word	0
	.word	44096
	.word	61205
	.word	13839
	.word	0
	.word	0
	.word	0
	.word	44614
	.word	54550
	.word	13810
	.word	0
	.word	0
	.word	0
	.word	24926
	.word	57347
	.word	13779
	.word	0
	.word	0
	.word	0
	.word	3312
	.word	61415
	.word	13745
	.word	0
	.word	0
	.word	0
	.word	64336
	.word	63884
	.word	13717
	.word	0
	.word	0
	.word	0
	.word	2748
	.word	62259
	.word	13685
	.word	0
	.word	0
	.word	0
	.word	56672
	.word	51775
	.word	13653
	.word	0
	.word	0
	.word	0
	.word	32438
	.word	55423
	.word	13624
	.word	0
	.word	0
	.word	0
	.word	17652
	.word	45713
	.word	13593
	.word	0
	.word	0
	.word	0
	.word	65408
	.word	51586
	.word	13558
	.word	0
	.word	0
	.word	0
	.word	40416
	.word	55736
	.word	13531
	.word	0
	.word	0
	.word	0
	.word	52546
	.word	37734
	.word	13500
	.word	0
	.word	0
	.word	0
	.word	48880
	.word	64238
	.word	13469
	.word	0
	.word	0
	.word	0
	.word	56004
	.word	46833
	.word	13437
	.word	0
	.word	0
	.word	0
	.word	61760
	.word	38110
	.word	13405
	.word	0
	.word	0
	.word	0
	.word	41496
	.word	35659
	.word	13374
	.word	0
	.word	0
	.word	0
	.word	25472
	.word	41269
	.word	13342
	.word	0
	.word	0
	.word	0
	.word	45444
	.word	36018
	.word	13314
	.word	0
	.word	0
	.word	0
	.word	6510
	.word	56417
	.word	13283
	.word	0
	.word	0
	.word	0
	.word	3072
	.word	56837
	.word	13252
	.word	0
	.word	0
	.word	0
	.word	61338
	.word	48440
	.word	13221
	.word	0
	.word	0
	.word	0
	.word	49568
	.word	57088
	.word	13189
	.word	0
	.word	0
	.word	0
	.word	4240
	.word	39283
	.word	13157
	.word	0
	.word	0
	.word	0
	.word	18562
	.word	33537
	.word	13128
	.word	0
	.word	0
	.word	0
	.word	31422
	.word	44487
	.word	13097
	.word	0
	.word	0
	.word	0
	.word	31930
	.word	60459
	.word	13066
	.word	0
	.word	0
	.word	0
	.word	42272
	.word	36641
	.word	13033
	.word	0
	.word	0
	.word	0
	.word	28940
	.word	36150
	.word	13004
	.word	0
	.word	0
	.word	0
	.word	21010
	.word	50925
	.word	12973
	.word	0
	.word	0
	.word	0
	.word	29448
	.word	64886
	.word	12941
	.word	0
	.word	0
	.word	0
	.word	20500
	.word	54600
	.word	12911
	.word	0
	.word	0
	.word	0
	.word	54258
	.word	46233
	.word	12880
	.word	0
	.word	0
	.word	0
	.word	32628
	.word	42502
	.word	12848
	.word	0
	.word	0
	.word	0
	.word	61608
	.word	55072
	.word	12818
	.word	0
	.word	0
	.word	0
	.word	6236
	.word	57871
	.word	12786
	.word	0
	.word	0
	.word	0
	.word	42408
	.word	34616
	.word	12756
	.word	0
	.word	0
	.word	0
	.word	56692
	.word	51963
	.word	12724
	.word	0
	.word	0
	.word	0
	.word	39094
	.word	48526
	.word	12694
	.word	0
	.word	0
	.word	0
	.word	59870
	.word	38783
	.word	12663
	.word	0
	.word	0
	.word	0
	.word	26560
	.word	33165
	.word	12632
	.word	0
	.word	0
	.word	0
	.word	58666
	.word	37666
	.word	12601
	.word	0
	.word	0
	.word	0
	.word	58728
	.word	39788
	.word	12569
	.word	0
	.word	0
	.word	0
	.word	9048
	.word	43530
	.word	12538
	.word	0
	.word	0
	.word	0
	.word	58496
	.word	57659
	.word	12505
	.word	0
	.word	0
	.word	0
	.word	12324
	.word	37025
	.word	12477
	.word	0
	.word	0
	.word	0
	.word	38432
	.word	55856
	.word	12445
	.word	0
	.word	0
	.word	0
	.word	35210
	.word	45960
	.word	12415
	.word	0
	.word	0
	.word	0
	.word	45644
	.word	51345
	.word	12384
	.word	0
	.word	0
	.word	0
	.word	32854
	.word	63883
	.word	12353
	.word	0
	.word	0
	.word	0
	.word	29348
	.word	41450
	.word	12321
	.word	0
	.word	0
	.word	0
	.word	27384
	.word	38024
	.word	12289
	.word	0
	.word	0
	.word	0
	.word	57356
	.word	57291
	.word	12260
	.word	0
	.word	0
	.word	0
	.word	61164
	.word	51521
	.word	12228
	.word	0
	.word	0
	.word	0
	.word	21472
	.word	59151
	.word	12196
	.word	0
	.word	0
	.word	0
	.word	36704
	.word	39943
	.word	12165
	.word	0
	.word	0
	.word	0
	.word	45864
	.word	50151
	.word	12136
	.word	0
	.word	0
	.word	0
	.word	37892
	.word	63687
	.word	12104
	.word	0
	.word	0
	.word	0
	.word	14560
	.word	51615
	.word	12073
	.word	0
	.word	0
	.word	0
	.word	38776
	.word	55684
	.word	12041
	.word	0
	.word	0
	.word	0
	.word	59136
	.word	53570
	.word	12010
	.word	0
	.word	0
	.word	0
	.word	55556
	.word	37955
	.word	11981
	.word	0
	.word	0
	.word	0
	.word	54458
	.word	44670
	.word	11950
	.word	0
	.word	0
	.word	0
	.word	36446
	.word	34084
	.word	11919
	.word	0
	.word	0
	.word	0
	.word	46416
	.word	51693
	.word	11886
	.word	0
	.word	0
	.word	0
	.word	21432
	.word	34376
	.word	11857
	.word	0
	.word	0
	.word	0
	.word	56036
	.word	34809
	.word	11826
	.word	0
	.word	0
	.word	0
	.word	10562
	.word	55654
	.word	11795
	.word	0
	.word	0
	.word	0
	.word	20264
	.word	53052
	.word	11763
	.word	0
	.word	0
	.word	0
	.word	64064
	.word	50415
	.word	11729
	.word	0
	.word	0
	.word	0
	.word	17444
	.word	48295
	.word	11701
	.word	0
	.word	0
	.word	0
	.word	11874
	.word	52677
	.word	11671
	.word	0
	.word	0
	.word	0
	.word	60808
	.word	39275
	.word	11640
	.word	0
	.word	0
	.word	0
	.word	31792
	.word	55677
	.word	11606
	.word	0
	.word	0
	.word	0
	.word	60710
	.word	49006
	.word	11578
	.word	0
	.word	0
	.word	0
	.word	10520
	.word	37403
	.word	11546
	.word	0
	.word	0
	.word	0
	.word	20004
	.word	59470
	.word	11515
	.word	0
	.word	0
	.word	0
	.word	28096
	.word	37612
	.word	11485
	.word	0
	.word	0
	.word	0
	.word	20268
	.word	44280
	.word	11453
	.word	0
	.word	0
	.word	0
	.word	50740
	.word	61588
	.word	11422
	.word	0
	.word	0
	.word	0
	.word	56432
	.word	58835
	.word	11390
	.word	0
	.word	0
	.word	0
	.word	8576
	.word	42496
	.word	11355
	.word	0
	.word	0
	.word	0
	.word	33920
	.word	54912
	.word	11324
	.word	0
	.word	0
	.word	0
	.word	35620
	.word	54843
	.word	11298
	.word	0
	.word	0
	.word	0
	.word	736
	.word	43591
	.word	11264
	.word	0
	.word	0
	.word	0
	.word	39632
	.word	61060
	.word	11235
	.word	0
	.word	0
	.word	0
	.word	63452
	.word	63129
	.word	11206
	.word	0
	.word	0
	.word	0
	.word	56798
	.word	58512
	.word	11175
	.word	0
	.word	0
	.word	0
	.word	13472
	.word	46333
	.word	11141
	.word	0
	.word	0
	.word	0
	.word	37300
	.word	36598
	.word	11112
	.word	0
	.word	0
	.word	0
	.word	41952
	.word	41639
	.word	11079
	.word	0
	.word	0
	.word	0
	.word	52452
	.word	33459
	.word	11050
	.word	0
	.word	0
	.word	0
	.word	58558
	.word	33287
	.word	11020
	.word	0
	.word	0
	.word	0
	.word	7570
	.word	43843
	.word	10989
	.word	0
	.word	0
	.word	0
	.word	59416
	.word	63990
	.word	10957
	.word	0
	.word	0
	.word	0
	.word	65298
	.word	47744
	.word	10927
	.word	0
	.word	0
	.word	0
	.word	21076
	.word	34089
	.word	10896
	.word	0
	.word	0
	.word	0
	.word	7048
	.word	57394
	.word	10865
	.word	0
	.word	0
	.word	0
	.word	12872
	.word	55405
	.word	10832
	.word	0
	.word	0
	.word	0
	.word	12608
	.word	51669
	.word	10798
	.word	0
	.word	0
	.word	0
	.word	5350
	.word	48455
	.word	10772
	.word	0
	.word	0
	.word	0
	.word	23568
	.word	58692
	.word	10740
	.word	0
	.word	0
	.word	0
	.word	40784
	.word	37046
	.word	10708
	.word	0
	.word	0
	.word	0
	.word	38992
	.word	43861
	.word	10678
	.word	0
	.word	0
	.word	0
	.word	10064
	.word	40199
	.word	10648
	.word	0
	.word	0
	.word	0
	.word	26368
	.word	35771
	.word	10611
	.word	0
	.word	0
	.word	0
	.word	23994
	.word	60721
	.word	10586
	.word	0
	.word	0
	.word	0
	.word	25052
	.word	34302
	.word	10554
	.word	0
	.word	0
	.word	0
	.word	39842
	.word	54964
	.word	10524
	.word	0
	.word	0
	.word	0
	.word	11568
	.word	58277
	.word	10491
	.word	0
	.word	0
	.word	0
	.word	26160
	.word	46438
	.word	10461
	.word	0
	.word	0
	.word	0
	.word	23252
	.word	43049
	.word	10431
	.word	0
	.word	0
	.word	0
	.word	35288
	.word	58000
	.word	10400
	.word	0
	.word	0
	.word	0
	.word	14614
	.word	50216
	.word	10369
	.word	0
	.word	0
	.word	0
	.word	1168
	.word	48804
	.word	10336
	.word	0
	.word	0
	.word	0
	.word	60934
	.word	33006
	.word	10307
	.word	0
	.word	0
	.word	0
	.word	64512
	.word	62247
	.word	10272
	.word	0
	.word	0
	.word	0
	.word	59968
	.word	43121
	.word	10240
	.word	0
	.word	0
	.word	0
	.word	25560
	.word	39974
	.word	10212
	.word	0
	.word	0
	.word	0
	.word	1978
	.word	49353
	.word	10183
	.word	0
	.word	0
	.word	0
	.word	16290
	.word	38807
	.word	10152
	.word	0
	.word	0
	.word	0
	.word	8646
	.word	65226
	.word	10121
	.word	0
	.word	0
	.word	0
	.word	56896
	.word	34317
	.word	10088
	.word	0
	.word	0
	.word	0
	.word	40136
	.word	39118
	.word	10057
	.word	0
	.word	0
	.word	0
	.word	14200
	.word	41756
	.word	10026
	.word	0
	.word	0
	.word	0
	.word	59256
	.word	63202
	.word	9995
	.word	0
	.word	0
	.word	0
	.word	22968
	.word	63553
	.word	9965
	.word	0
	.word	0
	.word	0
	.word	736
	.word	44292
	.word	9933
	.word	0
	.word	0
	.word	0
	.word	23186
	.word	37760
	.word	9904
	.word	0
	.word	0
	.word	0
	.word	51008
	.word	34950
	.word	9869
	.word	0
	.word	0
	.word	0
	.word	1664
	.word	64248
	.word	9836
	.word	0
	.word	0
	.word	0
	.word	64352
	.word	35199
	.word	9811
	.word	0
	.word	0
	.word	0
	.word	34656
	.word	63747
	.word	9780
	.word	0
	.word	0
	.word	0
	.word	44330
	.word	49864
	.word	9749
	.word	0
	.word	0
	.word	0
	.word	11654
	.word	35567
	.word	9718
	.word	0
	.word	0
	.word	0
	.word	7924
	.word	58919
	.word	9686
	.word	0
	.word	0
	.word	0
	.word	2532
	.word	32800
	.word	9655
	.word	0
	.word	0
	.word	0
	.word	30024
	.word	53799
	.word	9624
	.word	0
	.word	0
	.word	0
	.word	30172
	.word	64347
	.word	9593
	.word	0
	.word	0
	.word	0
	.word	60036
	.word	51382
	.word	9562
	.word	0
	.word	0
	.word	0
	.word	58576
	.word	33093
	.word	9531
	.word	0
	.word	0
	.word	0
	.word	13888
	.word	38760
	.word	9500
	.word	0
	.word	0
	.word	0
	.word	9322
	.word	52460
	.word	9470
	.word	0
	.word	0
	.word	0
	.word	20944
	.word	41077
	.word	9437
	.word	0
	.word	0
	.word	0
	.word	17976
	.word	41861
	.word	9407
	.word	0
	.word	0
	.word	0
	.word	55176
	.word	55158
	.word	9377
	.word	0
	.word	0
	.word	0
	.word	4976
	.word	35223
	.word	9346
	.word	0
	.word	0
	.word	0
	.word	7816
	.word	39783
	.word	9314
	.word	0
	.word	0
	.word	0
	.word	27656
	.word	55669
	.word	9284
	.word	0
	.word	0
	.word	0
	.word	64944
	.word	53184
	.word	9250
	.word	0
	.word	0
	.word	0
	.word	12544
	.word	49190
	.word	9222
	.word	0
	.word	0
	.word	0
	.word	50612
	.word	44644
	.word	9190
	.word	0
	.word	0
	.word	0
	.word	8832
	.word	63111
	.word	9155
	.word	0
	.word	0
	.word	0
	.word	11744
	.word	36870
	.word	9129
	.word	0
	.word	0
	.word	0
	.word	9404
	.word	63025
	.word	9098
	.word	0
	.word	0
	.word	0
	.word	47316
	.word	43381
	.word	9067
	.word	0
	.word	0
	.word	0
	.word	55716
	.word	47433
	.word	9035
	.word	0
	.word	0
	.word	0
	.word	46414
	.word	48441
	.word	9005
	.word	0
	.word	0
	.word	0
	.word	19116
	.word	39506
	.word	8974
	.word	0
	.word	0
	.word	0
	.word	48060
	.word	53381
	.word	8943
	.word	0
	.word	0
	.word	0
	.word	57112
	.word	50739
	.word	8911
	.word	0
	.word	0
	.word	0
	.word	5840
	.word	60581
	.word	8879
	.word	0
	.word	0
	.word	0
	.word	62112
	.word	57199
	.word	8846
	.word	0
	.word	0
	.word	0
	.word	35908
	.word	59499
	.word	8818
	.word	0
	.word	0
	.word	0
	.word	13760
	.word	48116
	.word	8787
	.word	0
	.word	0
	.word	0
	.word	3136
	.word	56059
	.word	8752
	.word	0
	.word	0
	.word	0
	.word	37596
	.word	39221
	.word	8726
	.word	0
	.word	0
	.word	0
	.word	3232
	.word	48550
	.word	8691
	.word	0
	.word	0
	.word	0
	.word	22872
	.word	42749
	.word	8662
	.word	0
	.word	0
	.word	0
	.word	41948
	.word	40319
	.word	8633
	.word	0
	.word	0
	.word	0
	.word	31196
	.word	64693
	.word	8601
	.word	0
	.word	0
	.word	0
	.word	62052
	.word	52923
	.word	8571
	.word	0
	.word	0
	.word	0
	.word	2750
	.word	33544
	.word	8540
	.word	0
	.word	0
	.word	0
	.word	12462
	.word	46179
	.word	8509
	.word	0
	.word	0
	.word	0
	.word	25128
	.word	45120
	.word	8476
	.word	0
	.word	0
	.word	0
	.word	51634
	.word	62523
	.word	8447
	.word	0
	.word	0
	.word	0
	.word	15758
	.word	42163
	.word	8416
	.word	0
	.word	0
	.word	0
	.word	34022
	.word	36267
	.word	8385
	.word	0
	.word	0
	.word	0
	.word	41252
	.word	39796
	.word	8353
	.word	0
	.word	0
	.word	0
	.word	49782
	.word	54423
	.word	8323
	.word	0
	.word	0
	.word	0
	.word	25428
	.word	42086
	.word	8291
	.word	0
	.word	0
	.word	0
	.word	34388
	.word	44810
	.word	8260
	.word	0
	.word	0
	.word	0
	.word	7456
	.word	64092
	.word	8228
	.word	0
	.word	0
	.word	0
	.word	48336
	.word	62448
	.word	8196
	.word	0
	.word	0
	.word	0
	.word	60912
	.word	61622
	.word	8167
	.word	0
	.word	0
	.word	0
	.word	17852
	.word	37250
	.word	8137
	.word	0
	.word	0
	.word	0
	.word	57940
	.word	56453
	.word	8106
	.word	0
	.word	0
	.word	0
	.word	47256
	.word	59825
	.word	8074
	.word	0
	.word	0
	.word	0
	.word	3774
	.word	59120
	.word	8044
	.word	0
	.word	0
	.word	0
	.word	43448
	.word	62852
	.word	8012
	.word	0
	.word	0
	.word	0
	.word	4840
	.word	57195
	.word	7982
	.word	0
	.word	0
	.word	0
	.word	40862
	.word	52565
	.word	7951
	.word	0
	.word	0
	.word	0
	.word	1440
	.word	60474
	.word	7919
	.word	0
	.word	0
	.word	0
	.word	55520
	.word	38648
	.word	7889
	.word	0
	.word	0
	.word	0
	.word	15316
	.word	52422
	.word	7857
	.word	0
	.word	0
	.word	0
	.word	18704
	.word	47227
	.word	7827
	.word	0
	.word	0
	.word	0
	.word	48892
	.word	54283
	.word	7795
	.word	0
	.word	0
	.word	0
	.word	12670
	.word	41990
	.word	7765
	.word	0
	.word	0
	.word	0
	.word	27570
	.word	49842
	.word	7734
	.word	0
	.word	0
	.word	0
	.word	47230
	.word	47992
	.word	7703
	.word	0
	.word	0
	.word	0
	.word	41020
	.word	56253
	.word	7671
	.word	0
	.word	0
	.word	0
	.word	23404
	.word	58312
	.word	7641
	.word	0
	.word	0
	.word	0
	.word	35176
	.word	51854
	.word	7610
	.word	0
	.word	0
	.word	0
	.word	49188
	.word	59051
	.word	7578
	.word	0
	.word	0
	.word	0
	.word	16656
	.word	54507
	.word	7546
	.word	0
	.word	0
	.word	0
	.word	41320
	.word	48565
	.word	7517
	.word	0
	.word	0
	.word	0
	.word	302
	.word	42490
	.word	7486
	.word	0
	.word	0
	.word	0
	.word	26680
	.word	39967
	.word	7454
	.word	0
	.word	0
	.word	0
	.word	41304
	.word	43638
	.word	7424
	.word	0
	.word	0
	.word	0
	.word	2314
	.word	48533
	.word	7393
	.word	0
	.word	0
	.word	0
	.word	63294
	.word	35693
	.word	7362
	.word	0
	.word	0
	.word	0
	.word	24538
	.word	48319
	.word	7331
	.word	0
	.word	0
	.word	0
	.word	56296
	.word	47263
	.word	7300
	.word	0
	.word	0
	.word	0
	.word	28236
	.word	38599
	.word	7268
	.word	0
	.word	0
	.word	0
	.word	6594
	.word	62116
	.word	7238
	.word	0
	.word	0
	.word	0
	.word	47104
	.word	63573
	.word	7198
	.word	0
	.word	0
	.word	0
	.word	34812
	.word	34303
	.word	7176
	.word	0
	.word	0
	.word	0
	.word	5144
	.word	33695
	.word	7145
	.word	0
	.word	0
	.word	0
	.word	24966
	.word	55768
	.word	7114
	.word	0
	.word	0
	.word	0
	.word	62720
	.word	43946
	.word	7078
	.word	0
	.word	0
	.word	0
	.word	31542
	.word	56062
	.word	7052
	.word	0
	.word	0
	.word	0
	.word	62356
	.word	59096
	.word	7020
	.word	0
	.word	0
	.word	0
	.word	28412
	.word	40533
	.word	6990
	.word	0
	.word	0
	.word	0
	.word	24080
	.word	50467
	.word	6958
	.word	0
	.word	0
	.word	0
	.word	33296
	.word	46841
	.word	6925
	.word	0
	.word	0
	.word	0
	.word	39600
	.word	38627
	.word	6897
	.word	0
	.word	0
	.word	0
	.word	14436
	.word	37607
	.word	6865
	.word	0
	.word	0
	.word	0
	.word	39032
	.word	56421
	.word	6833
	.word	0
	.word	0
	.word	0
	.word	64032
	.word	54987
	.word	6804
	.word	0
	.word	0
	.word	0
	.word	27648
	.word	42212
	.word	6768
	.word	0
	.word	0
	.word	0
	.word	43840
	.word	46107
	.word	6739
	.word	0
	.word	0
	.word	0
	.word	17316
	.word	36574
	.word	6711
	.word	0
	.word	0
	.word	0
	.word	8928
	.word	37652
	.word	6677
	.word	0
	.word	0
	.word	0
	.word	24944
	.word	47433
	.word	6648
	.word	0
	.word	0
	.word	0
	.word	27392
	.word	57430
	.word	6616
	.word	0
	.word	0
	.word	0
	.word	39848
	.word	43340
	.word	6585
	.word	0
	.word	0
	.word	0
	.word	64160
	.word	43542
	.word	6555
	.word	0
	.word	0
	.word	0
	.word	35226
	.word	63015
	.word	6525
	.word	0
	.word	0
	.word	0
	.word	40736
	.word	64368
	.word	6493
	.word	0
	.word	0
	.word	0
	.word	42168
	.word	49526
	.word	6462
	.word	0
	.word	0
	.word	0
	.word	45596
	.word	34243
	.word	6432
	.word	0
	.word	0
	.word	0
	.word	20690
	.word	39705
	.word	6401
	.word	0
	.word	0
	.word	0
	.word	54448
	.word	46856
	.word	6368
	.word	0
	.word	0
	.word	0
	.word	64392
	.word	62736
	.word	6337
	.word	0
	.word	0
	.word	0
	.word	12780
	.word	56461
	.word	6307
	.word	0
	.word	0
	.word	0
	.word	15360
	.word	49145
	.word	6277
	.word	0
	.word	0
	.word	0
	.word	20512
	.word	49931
	.word	6242
	.word	0
	.word	0
	.word	0
	.word	54512
	.word	55820
	.word	6212
	.word	0
	.word	0
	.word	0
	.word	8402
	.word	39333
	.word	6184
	.word	0
	.word	0
	.word	0
	.word	34094
	.word	53593
	.word	6153
	.word	0
	.word	0
	.word	0
	.word	31960
	.word	38817
	.word	6121
	.word	0
	.word	0
	.word	0
	.word	16954
	.word	39291
	.word	6091
	.word	0
	.word	0
	.word	0
	.word	49600
	.word	48765
	.word	6056
	.word	0
	.word	0
	.word	0
	.word	59580
	.word	56541
	.word	6029
	.word	0
	.word	0
	.word	0
	.word	35624
	.word	44550
	.word	5998
	.word	0
	.word	0
	.word	0
	.word	4142
	.word	47316
	.word	5967
	.word	0
	.word	0
	.word	0
	.word	43520
	.word	43612
	.word	5935
	.word	0
	.word	0
	.word	0
	.word	20976
	.word	40896
	.word	5902
	.word	0
	.word	0
	.word	0
	.word	63576
	.word	57729
	.word	5874
	.word	0
	.word	0
	.word	0
	.word	37288
	.word	33122
	.word	5843
	.word	0
	.word	0
	.word	0
	.word	24384
	.word	52079
	.word	5809
	.word	0
	.word	0
	.word	0
	.word	47952
	.word	58719
	.word	5779
	.word	0
	.word	0
	.word	0
	.word	44242
	.word	55445
	.word	5750
	.word	0
	.word	0
	.word	0
	.word	61232
	.word	38847
	.word	5716
	.word	0
	.word	0
	.word	0
	.word	63232
	.word	46039
	.word	5683
	.word	0
	.word	0
	.word	0
	.word	13396
	.word	42933
	.word	5657
	.word	0
	.word	0
	.word	0
	.word	27392
	.word	43305
	.word	5622
	.word	0
	.word	0
	.word	0
	.word	40708
	.word	35319
	.word	5595
	.word	0
	.word	0
	.word	0
	.word	44408
	.word	55685
	.word	5564
	.word	0
	.word	0
	.word	0
	.word	42090
	.word	44607
	.word	5533
	.word	0
	.word	0
	.word	0
	.word	25504
	.word	53466
	.word	5500
	.word	0
	.word	0
	.word	0
	.word	24208
	.word	33149
	.word	5470
	.word	0
	.word	0
	.word	0
	.word	5268
	.word	45375
	.word	5440
	.word	0
	.word	0
	.word	0
	.word	144
	.word	40000
	.word	5409
	.word	0
	.word	0
	.word	0
	.word	56688
	.word	52358
	.word	5376
	.word	0
	.word	0
	.word	0
	.word	25848
	.word	56175
	.word	5345
	.word	0
	.word	0
	.word	0
	.word	57900
	.word	44055
	.word	5315
	.word	0
	.word	0
	.word	0
	.word	24800
	.word	43437
	.word	5283
	.word	0
	.word	0
	.word	0
	.word	17984
	.word	54872
	.word	5249
	.word	0
	.word	0
	.word	0
	.word	25744
	.word	41345
	.word	5223
	.word	0
	.word	0
	.word	0
	.word	7668
	.word	43682
	.word	5191
	.word	0
	.word	0
	.word	0
	.word	47434
	.word	36705
	.word	5161
	.word	0
	.word	0
	.word	0
	.word	20888
	.word	40323
	.word	5129
	.word	0
	.word	0
	.word	0
	.word	3962
	.word	43032
	.word	5099
	.word	0
	.word	0
	.word	0
	.word	50270
	.word	49260
	.word	5068
	.word	0
	.word	0
	.word	0
	.word	20160
	.word	64041
	.word	5032
	.word	0
	.word	0
	.word	0
	.word	25624
	.word	36013
	.word	5004
	.word	0
	.word	0
	.word	0
	.word	48328
	.word	59345
	.word	4975
	.word	0
	.word	0
	.word	0
	.word	51508
	.word	63920
	.word	4943
	.word	0
	.word	0
	.word	0
	.word	27872
	.word	39135
	.word	4913
	.word	0
	.word	0
	.word	0
	.word	13590
	.word	58857
	.word	4882
	.word	0
	.word	0
	.word	0
	.word	50880
	.word	61323
	.word	4847
	.word	0
	.word	0
	.word	0
	.word	44802
	.word	37181
	.word	4820
	.word	0
	.word	0
	.word	0
	.word	53808
	.word	57813
	.word	4789
	.word	0
	.word	0
	.word	0
	.word	64424
	.word	49714
	.word	4757
	.word	0
	.word	0
	.word	0
	.word	31652
	.word	44011
	.word	4727
	.word	0
	.word	0
	.word	0
	.word	28252
	.word	50834
	.word	4696
	.word	0
	.word	0
	.word	0
	.word	30370
	.word	38742
	.word	4665
	.word	0
	.word	0
	.word	0
	.word	57728
	.word	58403
	.word	4628
	.word	0
	.word	0
	.word	0
	.word	35900
	.word	37112
	.word	4603
	.word	0
	.word	0
	.word	0
	.word	40764
	.word	40914
	.word	4572
	.word	0
	.word	0
	.word	0
	.word	21472
	.word	46910
	.word	4541
	.word	0
	.word	0
	.word	0
	.word	17854
	.word	35030
	.word	4510
	.word	0
	.word	0
	.word	0
	.word	4378
	.word	35776
	.word	4479
	.word	0
	.word	0
	.word	0
	.word	57962
	.word	55295
	.word	4448
	.word	0
	.word	0
	.word	0
	.word	64352
	.word	56717
	.word	4415
	.word	0
	.word	0
	.word	0
	.word	37744
	.word	49416
	.word	4384
	.word	0
	.word	0
	.word	0
	.word	38484
	.word	35759
	.word	4355
	.word	0
	.word	0
	.word	0
	.word	55020
	.word	54969
	.word	4324
	.word	0
	.word	0
	.word	0
	.word	9188
	.word	55223
	.word	4292
	.word	0
	.word	0
	.word	0
	.word	6822
	.word	43079
	.word	4262
	.word	0
	.word	0
	.word	0
	.word	48870
	.word	40943
	.word	4231
	.word	0
	.word	0
	.word	0
	.word	9936
	.word	42731
	.word	4198
	.word	0
	.word	0
	.word	0
	.word	23430
	.word	43136
	.word	4169
	.word	0
	.word	0
	.word	0
	.word	4700
	.word	55665
	.word	4137
	.word	0
	.word	0
	.word	0
	.word	8056
	.word	40216
	.word	4106
	.word	0
	.word	0
	.word	0
	.word	3716
	.word	45403
	.word	4075
	.word	0
	.word	0
	.word	0
	.word	53440
	.word	49488
	.word	4044
	.word	0
	.word	0
	.word	0
	.word	41776
	.word	50188
	.word	4013
	.word	0
	.word	0
	.word	0
	.word	20994
	.word	64556
	.word	3983
	.word	0
	.word	0
	.word	0
	.word	16252
	.word	60661
	.word	3951
	.word	0
	.word	0
	.word	0
	.word	61252
	.word	65021
	.word	3920
	.word	0
	.word	0
	.word	0
	.word	16236
	.word	43803
	.word	3889
	.word	0
	.word	0
	.word	0
	.word	63064
	.word	35308
	.word	3857
	.word	0
	.word	0
	.word	0
	.word	49096
	.word	39848
	.word	3828
	.word	0
	.word	0
	.word	0
	.word	15680
	.word	48673
	.word	3797
	.word	0
	.word	0
	.word	0
	.word	48068
	.word	50957
	.word	3766
	.word	0
	.word	0
	.word	0
	.word	20824
	.word	56086
	.word	3734
	.word	0
	.word	0
	.word	0
	.word	46504
	.word	43224
	.word	3704
	.word	0
	.word	0
	.word	0
	.word	52428
	.word	46094
	.word	3672
	.word	0
	.word	0
	.word	0
	.word	17548
	.word	52066
	.word	3642
	.word	0
	.word	0
	.word	0
	.word	61738
	.word	35565
	.word	3611
	.word	0
	.word	0
	.word	0
	.word	31184
	.word	50588
	.word	3579
	.word	0
	.word	0
	.word	0
	.word	1716
	.word	52681
	.word	3549
	.word	0
	.word	0
	.word	0
	.word	44656
	.word	43385
	.word	3518
	.word	0
	.word	0
	.word	0
	.word	12668
	.word	43259
	.word	3486
	.word	0
	.word	0
	.word	0
	.word	24544
	.word	35408
	.word	3453
	.word	0
	.word	0
	.word	0
	.word	28854
	.word	65018
	.word	3425
	.word	0
	.word	0
	.word	0
	.word	5696
	.word	40391
	.word	3393
	.word	0
	.word	0
	.word	0
	.word	39580
	.word	56400
	.word	3363
	.word	0
	.word	0
	.word	0
	.word	20428
	.word	39579
	.word	3332
	.word	0
	.word	0
	.word	0
	.word	32328
	.word	36727
	.word	3301
	.word	0
	.word	0
	.word	0
	.word	34020
	.word	54457
	.word	3270
	.word	0
	.word	0
	.word	0
	.word	34016
	.word	48400
	.word	3238
	.word	0
	.word	0
	.word	0
	.word	6922
	.word	51417
	.word	3208
	.word	0
	.word	0
	.word	0
	.word	27208
	.word	64641
	.word	3176
	.word	0
	.word	0
	.word	0
	.word	1802
	.word	48886
	.word	3146
	.word	0
	.word	0
	.word	0
	.word	35440
	.word	61590
	.word	3115
	.word	0
	.word	0
	.word	0
	.word	60610
	.word	51604
	.word	3084
	.word	0
	.word	0
	.word	0
	.word	5440
	.word	38199
	.word	3050
	.word	0
	.word	0
	.word	0
	.word	6914
	.word	43867
	.word	3022
	.word	0
	.word	0
	.word	0
	.word	24000
	.word	45256
	.word	2989
	.word	0
	.word	0
	.word	0
	.word	51496
	.word	57396
	.word	2959
	.word	0
	.word	0
	.word	0
	.word	11538
	.word	46256
	.word	2929
	.word	0
	.word	0
	.word	0
	.word	36802
	.word	48020
	.word	2898
	.word	0
	.word	0
	.word	0
	.word	57910
	.word	57903
	.word	2867
	.word	0
	.word	0
	.word	0
	.word	47484
	.word	48798
	.word	2835
	.word	0
	.word	0
	.word	0
	.word	57766
	.word	57709
	.word	2805
	.word	0
	.word	0
	.word	0
	.word	54064
	.word	47856
	.word	2774
	.word	0
	.word	0
	.word	0
	.word	49340
	.word	48080
	.word	2743
	.word	0
	.word	0
	.word	0
	.word	36454
	.word	56731
	.word	2712
	.word	0
	.word	0
	.word	0
	.word	51548
	.word	63385
	.word	2681
	.word	0
	.word	0
	.word	0
	.word	56000
	.word	48716
	.word	2645
	.word	0
	.word	0
	.word	0
	.word	44992
	.word	50040
	.word	2615
	.word	0
	.word	0
	.word	0
	.word	43136
	.word	58177
	.word	2585
	.word	0
	.word	0
	.word	0
	.word	49730
	.word	33270
	.word	2557
	.word	0
	.word	0
	.word	0
	.word	29808
	.word	51063
	.word	2526
	.word	0
	.word	0
	.word	0
	.word	25276
	.word	46724
	.word	2494
	.word	0
	.word	0
	.word	0
	.word	17324
	.word	35928
	.word	2463
	.word	0
	.word	0
	.word	0
	.word	52284
	.word	63916
	.word	2433
	.word	0
	.word	0
	.word	0
	.word	5414
	.word	46704
	.word	2402
	.word	0
	.word	0
	.word	0
	.word	51710
	.word	57168
	.word	2371
	.word	0
	.word	0
	.word	0
	.word	27366
	.word	49253
	.word	2340
	.word	0
	.word	0
	.word	0
	.word	45332
	.word	53033
	.word	2309
	.word	0
	.word	0
	.word	0
	.word	54152
	.word	37418
	.word	2276
	.word	0
	.word	0
	.word	0
	.word	53076
	.word	47398
	.word	2247
	.word	0
	.word	0
	.word	0
	.word	14374
	.word	59477
	.word	2216
	.word	0
	.word	0
	.word	0
	.word	59336
	.word	33435
	.word	2184
	.word	0
	.word	0
	.word	0
	.word	21612
	.word	43267
	.word	2154
	.word	0
	.word	0
	.word	0
	.word	34664
	.word	39372
	.word	2121
	.word	0
	.word	0
	.word	0
	.word	172
	.word	62761
	.word	2091
	.word	0
	.word	0
	.word	0
	.word	9816
	.word	40715
	.word	2060
	.word	0
	.word	0
	.word	0
	.word	65116
	.word	40481
	.word	2030
	.word	0
	.word	0
	.word	0
	.word	28066
	.word	39184
	.word	1999
	.word	0
	.word	0
	.word	0
	.word	37408
	.word	63923
	.word	1968
	.word	0
	.word	0
	.word	0
	.word	15760
	.word	42305
	.word	1937
	.word	0
	.word	0
	.word	0
	.word	28236
	.word	59340
	.word	1905
	.word	0
	.word	0
	.word	0
	.word	43258
	.word	59402
	.word	1875
	.word	0
	.word	0
	.word	0
	.word	19988
	.word	50087
	.word	1844
	.word	0
	.word	0
	.word	0
	.word	63456
	.word	47833
	.word	1810
	.word	0
	.word	0
	.word	0
	.word	65184
	.word	61426
	.word	1781
	.word	0
	.word	0
	.word	0
	.word	52982
	.word	48456
	.word	1751
	.word	0
	.word	0
	.word	0
	.word	30020
	.word	62809
	.word	1719
	.word	0
	.word	0
	.word	0
	.word	9096
	.word	63061
	.word	1688
	.word	0
	.word	0
	.word	0
	.word	59648
	.word	44374
	.word	1654
	.word	0
	.word	0
	.word	0
	.word	11456
	.word	33847
	.word	1625
	.word	0
	.word	0
	.word	0
	.word	12392
	.word	50500
	.word	1595
	.word	0
	.word	0
	.word	0
	.word	56432
	.word	59196
	.word	1563
	.word	0
	.word	0
	.word	0
	.word	61008
	.word	40265
	.word	1532
	.word	0
	.word	0
	.word	0
	.word	37842
	.word	33270
	.word	1503
	.word	0
	.word	0
	.word	0
	.word	37916
	.word	44543
	.word	1471
	.word	0
	.word	0
	.word	0
	.word	11490
	.word	36421
	.word	1441
	.word	0
	.word	0
	.word	0
	.word	19040
	.word	38397
	.word	1409
	.word	0
	.word	0
	.word	0
	.word	31224
	.word	47162
	.word	1379
	.word	0
	.word	0
	.word	0
	.word	52056
	.word	41461
	.word	1347
	.word	0
	.word	0
	.word	0
	.word	10810
	.word	56374
	.word	1317
	.word	0
	.word	0
	.word	0
	.word	5358
	.word	35086
	.word	1286
	.word	0
	.word	0
	.word	0
	.word	36640
	.word	50226
	.word	1251
	.word	0
	.word	0
	.word	0
	.word	33856
	.word	45597
	.word	1222
	.word	0
	.word	0
	.word	0
	.word	21552
	.word	63128
	.word	1191
	.word	0
	.word	0
	.word	0
	.word	1198
	.word	35616
	.word	1162
	.word	0
	.word	0
	.word	0
	.word	1232
	.word	59506
	.word	1131
	.word	0
	.word	0
	.word	0
	.word	51086
	.word	34963
	.word	1100
	.word	0
	.word	0
	.word	0
	.word	3960
	.word	39061
	.word	1067
	.word	0
	.word	0
	.word	0
	.word	4564
	.word	57134
	.word	1037
	.word	0
	.word	0
	.word	0
	.word	59468
	.word	35285
	.word	1007
	.word	0
	.word	0
	.word	0
	.word	63422
	.word	35431
	.word	976
	.word	0
	.word	0
	.word	0
	.word	38352
	.word	51462
	.word	945
	.word	0
	.word	0
	.word	0
	.word	25806
	.word	55660
	.word	914
	.word	0
	.word	0
	.word	0
	.word	38842
	.word	41327
	.word	883
	.word	0
	.word	0
	.word	0
	.word	17980
	.word	50458
	.word	852
	.word	0
	.word	0
	.word	0
	.word	61194
	.word	59710
	.word	821
	.word	0
	.word	0
	.word	0
	.word	21098
	.word	42086
	.word	790
	.word	0
	.word	0
	.word	0
	.word	16704
	.word	43341
	.word	757
	.word	0
	.word	0
	.word	0
	.word	46316
	.word	52840
	.word	728
	.word	0
	.word	0
	.word	0
	.word	20386
	.word	33936
	.word	697
	.word	0
	.word	0
	.word	0
	.word	20064
	.word	51864
	.word	664
	.word	0
	.word	0
	.word	0
	.word	2268
	.word	57500
	.word	634
	.word	0
	.word	0
	.word	0
	.word	11152
	.word	51171
	.word	604
	.word	0
	.word	0
	.word	0
	.word	23164
	.word	63727
	.word	572
	.word	0
	.word	0
	.word	0
	.word	20514
	.word	40280
	.word	542
	.word	0
	.word	0
	.word	0
	.word	21818
	.word	57922
	.word	511
	.word	0
	.word	0
	.word	0
	.word	32366
	.word	46413
	.word	480
	.word	0
	.word	0
	.word	0
	.word	53972
	.word	43148
	.word	449
	.word	0
	.word	0
	.word	0
	.word	30134
	.word	65133
	.word	418
	.word	0
	.word	0
	.word	0
	.word	15282
	.word	61516
	.word	387
	.word	0
	.word	0
	.word	0
	.word	49872
	.word	49222
	.word	355
	.word	0
	.word	0
	.word	0
	.word	9484
	.word	63958
	.word	325
	.word	0
	.word	0
	.word	0
	.word	47028
	.word	35341
	.word	294
	.word	0
	.word	0
	.word	0
	.word	6770
	.word	58613
	.word	263
	.word	0
	.word	0
	.word	0
	.word	33372
	.word	43448
	.word	232
	.word	0
	.word	0
	.word	0
	.word	27792
	.word	51629
	.word	198
	.word	0
	.word	0
	.word	0
	.word	19712
	.word	53691
	.word	170
	.word	0
	.word	0
	.word	0
	.word	42144
	.word	60929
	.word	135
	.word	0
	.word	0
	.word	0
	.word	35240
	.word	48799
	.word	107
	.word	0
	.word	0
	.word	0
	.word	910
	.word	51212
	.word	77
	.word	0
	.word	0
	.word	0
	.word	65062
	.word	33668
	.word	46
	.word	0
	.word	0
	.word	0
	.word	52624
	.word	51799
	.word	14
	.word	0
	.type	__4onpi_31l,@object
	.size	__4onpi_31l,6444
	.data
	.section .note.GNU-stack, ""
# End
