/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_1_t<float, float> g_log10f_intel_data[] = {
  { // Entry 0
    -0x1.fe8bfdffff13dd47512c048f491f9b43p3,
    0x1.000022p-53
  },
  { // Entry 1
    -0x1.815170ed4e086e755171000a21e4418ap2,
    0x1.0000a0p-20
  },
  { // Entry 2
    -0x1.fe8beafff5736c97130c9ced1f57d1a3p3,
    0x1.000180p-53
  },
  { // Entry 3
    -0x1.343e0effe0b2cf5c4261140f67bbb9dbp-2,
    0x1.0001d0p-1
  },
  { // Entry 4
    0x1.bc41b9006f9ea191f8d77992988148e8p-11,
    0x1.007ffep0
  },
  { // Entry 5
    0x1.286d48f2328d1c51bb42649f1e36f51cp-10,
    0x1.00aadcp0
  },
  { // Entry 6
    0x1.3c3724fff9a66a1fc88c62753a01a093p-10,
    0x1.00b648p0
  },
  { // Entry 7
    0x1.b41066a765c47c650e3f2b65383836c5p-10,
    0x1.00fb80p0
  },
  { // Entry 8
    0x1.b4ede8ab7383b8e1ac6403842ab125e1p-10,
    0x1.00fcp0
  },
  { // Entry 9
    0x1.b606409a66ace2644d565b3bbe495b4bp-10,
    0x1.00fca2p0
  },
  { // Entry 10
    0x1.361702fff27220603ff5a74b9a7278a1p-2,
    0x1.010fp1
  },
  { // Entry 11
    0x1.30ecd6fe9803b26443d0a8c84cf88f49p-9,
    0x1.0160p0
  },
  { // Entry 12
    0x1.ad1561043e238a54f2968308b5b84a0ap-9,
    0x1.01efdep0
  },
  { // Entry 13
    0x1.add67b049b9eccb589d59f2e94044d4cp-9,
    0x1.01f0bep0
  },
  { // Entry 14
    0x1.b4181727e525aa3c9fe9bb81a1ea32f2p-9,
    0x1.01f8p0
  },
  { // Entry 15
    0x1.ba90af0300546714c91e69807716244bp-9,
    0x1.01ff82p0
  },
  { // Entry 16
    0x1.bf75c6fdd387cfc33e178c7140ff4a43p-9,
    0x1.020530p0
  },
  { // Entry 17
    0x1.c160fcfb3f11263df6c5479a7fc1f96ep-9,
    0x1.02076ap0
  },
  { // Entry 18
    0x1.c3b396fb7cc17548094cdeed806812d7p-9,
    0x1.020a1cp0
  },
  { // Entry 19
    0x1.041e5efff8637a181cab5a487e534f1cp5,
    0x1.0220p108
  },
  { // Entry 20
    0x1.deaf41009dde64cb85f68d09d2edf173p-9,
    0x1.02296ep0
  },
  { // Entry 21
    0x1.ecf47efdaeb10f5ade28ff93f4f44527p-9,
    0x1.023ap0
  },
  { // Entry 22
    0x1.f514f89756d667a2094b9aa6f5425a94p-8,
    0x1.048cp0
  },
  { // Entry 23
    -0x1.31add3ffcf191eb75b949d0c4b25562ep0,
    0x1.06p-4
  },
  { // Entry 24
    0x1.5d5eb8fffce13ef5613f5c26350b3ef3p-7,
    0x1.065cd2p0
  },
  { // Entry 25
    0x1.b02afb003def304a513c84d809f21238p-7,
    0x1.07e4bcp0
  },
  { // Entry 26
    0x1.e8296b002bba062b42b25642380152e2p-7,
    0x1.08ef12p0
  },
  { // Entry 27
    0x1.e9c5e90021ec01c297e475abe4ba42p-7,
    0x1.08f6c0p0
  },
  { // Entry 28
    -0x1.7d2b50ffff0186373287a99f0cecd28ep0,
    0x1.09bcp-5
  },
  { // Entry 29
    0x1.3a62cbffff2834d75a70360f6b9d64cfp0,
    0x1.0e83a0p4
  },
  { // Entry 30
    -0x1.7aa2bc000221055273bfa7fee62d0379p0,
    0x1.0fdcp-5
  },
  { // Entry 31
    0x1.d5bbd4fffd35c403bb0a652e9334f1e4p0,
    0x1.1180p6
  },
  { // Entry 32
    0x1.ef425287c21feec9c54e178d894354edp-6,
    0x1.1274p0
  },
  { // Entry 33
    -0x1.29297dffff901bb8ac5190eca10186b9p0,
    0x1.1adcp-4
  },
  { // Entry 34
    0x1.817dc8fccbc0fb5087e88f554f1908fdp-5,
    0x1.1d4cp0
  },
  { // Entry 35
    0x1.96aaacfefcf3bb8dcf3d8c94eb1423cap-5,
    0x1.1fp0
  },
  { // Entry 36
    0x1.a2d9334a67417635918aaf61a00994f0p-5,
    0x1.1ffcp0
  },
  { // Entry 37
    0x1.e32d32fa5c9d38509a7ba3e2bfb93574p-5,
    0x1.253d24p0
  },
  { // Entry 38
    0x1.55811effbe311325be81852b0556032cp-1,
    0x1.294a50p2
  },
  { // Entry 39
    -0x1.d7dae0fffee85f639c44d1f94b88a9aap-3,
    0x1.2d363ap-1
  },
  { // Entry 40
    -0x1.9ba71b0001bcb89106e975a5735cc54cp1,
    0x1.3ecf84p-11
  },
  { // Entry 41
    0x1.p0,
    0x1.40p3
  },
  { // Entry 42
    0x1.879ecefffff999362de3e56a2a6ed238p2,
    0x1.412668p20
  },
  { // Entry 43
    0x1.c10343057f36be857e8738b6dfecd5dep-4,
    0x1.498152p0
  },
  { // Entry 44
    0x1.f237b389b8afaac4cac40f2695df7209p-4,
    0x1.52bf2ap0
  },
  { // Entry 45
    -0x1.e0e8f9e4b17e517c0a47404130e68838p-2,
    0x1.5b43e2p-2
  },
  { // Entry 46
    0x1.bce8b0000212bd563ade9f93343779fbp-2,
    0x1.5c17p1
  },
  { // Entry 47
    -0x1.d30fa3d9517968762410807be9c7cb7ep-2,
    0x1.663fe0p-2
  },
  { // Entry 48
    0x1.ca3f98fffffea806640e073c5b17da75p-2,
    0x1.66b06ap1
  },
  { // Entry 49
    -0x1.81bbccfffeb10074d0f87e9e6ab68f3fp-1,
    0x1.695dp-3
  },
  { // Entry 50
    -0x1.3442891155fedc1531e5c4a593f0e2f0p-3,
    0x1.6a095cp-1
  },
  { // Entry 51
    0x1.f28489002d32f29f766276e96f7f21aap4,
    0x1.6aaaaap103
  },
  { // Entry 52
    -0x1.7d9722fffffee06829536561f0f13e07p-1,
    0x1.7028e2p-3
  },
  { // Entry 53
    0x1.e39e45d51ccc5ba793598e2a5b79a0dfp-2,
    0x1.7bbf06p1
  },
  { // Entry 54
    -0x1.ffbfcbff9b381c31b8783059f0acf062p-4,
    0x1.7ffffep-1
  },
  { // Entry 55
    -0x1.ffbfc2bbc780375837c4b0b84f38a14ap-4,
    0x1.80p-1
  },
  { // Entry 56
    -0x1.b40dd238181b3a9e0aacd04028af4a80p-2,
    0x1.801e82p-2
  },
  { // Entry 57
    -0x1.f9043300033a2fda0c9e8b664d0dfae2p-4,
    0x1.8174c4p-1
  },
  { // Entry 58
    -0x1.530ccb00030817c37d1894f62c055194p0,
    0x1.8421p-5
  },
  { // Entry 59
    -0x1.e2278820b34cd516815ccd9af00ec36cp-4,
    0x1.867124p-1
  },
  { // Entry 60
    -0x1.db11ed766abf432dc3c1bb4167a6eb47p-4,
    0x1.88p-1
  },
  { // Entry 61
    0x1.eb76a4317f935066a9dd258d69495f3bp-3,
    0x1.bcd946p0
  },
  { // Entry 62
    -0x1.e5a7d2fffbde5faba9ad1dafa9f8e25ep-1,
    0x1.cd1eb6p-4
  },
  { // Entry 63
    -0x1.e3e2e8000003707015334e8f6d4e1baep-1,
    0x1.d0cdb4p-4
  },
  { // Entry 64
    -0x1.46b528fff19f0db93b31ce66c94d4faap-1,
    0x1.d739cep-3
  },
  { // Entry 65
    -0x1.ffd158bd0b2827904af6cec4c6e1bbe4p-6,
    0x1.dc7710p-1
  },
  { // Entry 66
    0x1.c00806bb584a81d2425a4c449277a3c0p-1,
    0x1.dffffep2
  },
  { // Entry 67
    -0x1.a0ed34fffc666da4d52ec02aeafec305p-6,
    0x1.e2dc9ap-1
  },
  { // Entry 68
    0x1.e61002ffffc2d1e0983851bf24c9ce23p4,
    0x1.e339a2p100
  },
  { // Entry 69
    -0x1.3a6ae8fffd0faf4aca1345a2b412cb11p-6,
    0x1.e9de50p-1
  },
  { // Entry 70
    -0x1.9775a6e35532e99d0cf2384ab86d5473p-7,
    0x1.f18c60p-1
  },
  { // Entry 71
    -0x1.81f977002634432665d65d78d2968a65p2,
    0x1.f40e5ep-21
  },
  { // Entry 72
    -0x1.f62251ffffff968db3edbd69bcf5cfdcp1,
    0x1.f4e26ap-14
  },
  { // Entry 73
    -0x1.14f03effe1727a0c4e49b2a6bad88689p-7,
    0x1.f621f6p-1
  },
  { // Entry 74
    -0x1.f7c3f8ffbdab13a6cac3e1e31df4ebbfp-8,
    0x1.f7047cp-1
  },
  { // Entry 75
    -0x1.f63efaafb8883e9793490850e59689c5p-8,
    0x1.f70b5cp-1
  },
  { // Entry 76
    -0x1.f37d18ffb9ef3b0fef577217ed18e097p-8,
    0x1.f717d6p-1
  },
  { // Entry 77
    -0x1.def364ad9e50296b41e69bbd93d4b89dp-8,
    0x1.f774cep-1
  },
  { // Entry 78
    -0x1.d980a30635055b8d9b54edd672c858a3p-10,
    0x1.fddffep-1
  },
  { // Entry 79
    -0x1.be7cd6ffc9f63979c62763b7424b91b8p-10,
    0x1.fdfef8p-1
  },
  { // Entry 80
    -0x1.a0d0f2971f8c3359f07a6bb4fccab210p-10,
    0x1.fe21p-1
  },
  { // Entry 81
    -0x1.bd2a7f88f7e22e1fbeda7c34e78c5fbfp-11,
    0x1.fefffep-1
  },
  { // Entry 82
    -0x1.ad17eafff3e585f32e96d0e7c6897eaep-11,
    0x1.ff093ap-1
  },
  { // Entry 83
    -0x1.e1b20eab03fb3a4a3c1ca58716aa04d8p2,
    0x1.ff1ffep-26
  },
  { // Entry 84
    -0x1.bd42c8df31e3d447244cc720bd67faadp-12,
    0x1.ff7fe8p-1
  },
  { // Entry 85
    -0x1.bdb1f6cd42c7c46d6967bb003016e45bp-13,
    0x1.ffbfe0p-1
  },
  { // Entry 86
    -0x1.ca749c8706de8e46ee3cf5bf9a96ab1bp-14,
    0x1.ffdf04p-1
  },
  { // Entry 87
    -0x1.c600bcbce645991d16979edbbc0c311fp-14,
    0x1.ffdf56p-1
  },
  { // Entry 88
    -0x1.bd34cc84be200f8cb449c26c3f6763d1p-14,
    0x1.ffdff8p-1
  },
  { // Entry 89
    -0x1.bce164dc339f92c17cc22cb9a07458d6p-14,
    0x1.ffdffep-1
  },
  { // Entry 90
    -0x1.3443d0ffc8b4e8b31ed055e579024a80p-1,
    0x1.fff9fep-3
  },
  { // Entry 91
    -0x1.72de800001549031af6ca96747c1126fp4,
    0x1.fffc7ep-78
  },
  { // Entry 92
    0x1.344134ff8b51b7a013d2358e0089d30dp5,
    0x1.fffffap127
  },
  { // Entry 93
    -0x1.bcb7b30f2604868dab81d79e1f40443cp-25,
    0x1.fffffcp-1
  },
  { // Entry 94
    -0x1.3441360959c2bf17a59af37357663f09p-3,
    0x1.6a09e6p-1
  },
  { // Entry 95
    -0x1.8e271d6ab5d7ee84106f48e33b8cb8e0p-4,
    0x1.995256p-1
  },
  { // Entry 96
    -0x1.9762ba2f4a2198a2ce8974450be1661fp-5,
    0x1.c89ac6p-1
  },
  { // Entry 97
    -0x1.c694764682002f79a74b22bb7570477ep-8,
    0x1.f7e336p-1
  },
  { // Entry 98
    0x1.064661197381c71f1a9f9ac21e313749p-5,
    0x1.1395d2p0
  },
  { // Entry 99
    0x1.158bedc46861d0d27c114033f3db9a96p-4,
    0x1.2b3a0ap0
  },
  { // Entry 100
    0x1.9cd10befe72cc8a8ecfeacd70aed874ap-4,
    0x1.42de42p0
  },
  { // Entry 101
    0x1.0d42f94d71eab1a45a4e19f5a1d78fcbp-3,
    0x1.5a827ap0
  },
  { // Entry 102
    0x1.47f707c940c69c0e2b81a883c7fcf3e2p-3,
    0x1.7226b2p0
  },
  { // Entry 103
    0x1.7f08567d056a15ac18992a2573074fc1p-3,
    0x1.89caeap0
  },
  { // Entry 104
    0x1.b2e37e3ec1bd60c78ec0b821ea37604dp-3,
    0x1.a16f22p0
  },
  { // Entry 105
    0x1.e3e3215b7afa3355ef4ed63c72685ff3p-3,
    0x1.b9135ap0
  },
  { // Entry 106
    0x1.0929d68063288eaf1594278eb7b2fc8ep-2,
    0x1.d0b792p0
  },
  { // Entry 107
    0x1.1f3b15ea121ed378638c6e76b1a3108fp-2,
    0x1.e85bcap0
  },
  { // Entry 108
    0x1.34413509f79fef311f12b35816f922f0p-2,
    0x1.p1
  },
  { // Entry 109
    -0x1.3441360959c2bf17a59af37357663f09p-3,
    0x1.6a09e6p-1
  },
  { // Entry 110
    -0x1.edc7b7d1726b9d3a32996762d45e780ap-4,
    0x1.83e608p-1
  },
  { // Entry 111
    -0x1.7af97b7bce8afc77122afb0375a2da53p-4,
    0x1.9dc22ap-1
  },
  { // Entry 112
    -0x1.0f219957375a31be41be4c43a6916104p-4,
    0x1.b79e4cp-1
  },
  { // Entry 113
    -0x1.52e86324d08348db62a1b30a19674a5cp-5,
    0x1.d17a6ep-1
  },
  { // Entry 114
    -0x1.2519f3a5667aea40e1f962a1f5d85c21p-6,
    0x1.eb5690p-1
  },
  { // Entry 115
    0x1.1f80654567c5aa07e1d9578dfde75b1fp-8,
    0x1.02995ap0
  },
  { // Entry 116
    0x1.a30a884b48ced10372c3c1f79d81055bp-6,
    0x1.0f876cp0
  },
  { // Entry 117
    0x1.7706deccbe15df9c9101690cc9b736b0p-5,
    0x1.1c757ep0
  },
  { // Entry 118
    0x1.0a965f582ad2d2cc3962364e72fabf4bp-4,
    0x1.296390p0
  },
  { // Entry 119
    0x1.564ba4450402b6d51b22231ee30056ecp-4,
    0x1.3651a2p0
  },
  { // Entry 120
    0x1.9ee99d1f81cea5262e8e5fa8308a4f10p-4,
    0x1.433fb4p0
  },
  { // Entry 121
    0x1.e4ae6049c4561ba2e5b54e4aef7ec1f7p-4,
    0x1.502dc6p0
  },
  { // Entry 122
    0x1.13e87df00be5c8e58f5f6baa00a8e9a8p-3,
    0x1.5d1bd8p0
  },
  { // Entry 123
    0x1.3441340a957d1f4a988a733cd68c06d7p-3,
    0x1.6a09e6p0
  },
  { // Entry 124
    -0x1.ffbfc2bbc780375837c4b0b84f38a14ap-4,
    0x1.80p-1
  },
  { // Entry 125
    -0x1.5634641a3fd51681f12d3df90719aed0p-4,
    0x1.a66666p-1
  },
  { // Entry 126
    -0x1.76d86fdd61d0265fd8416f7297bd494fp-5,
    0x1.ccccccp-1
  },
  { // Entry 127
    -0x1.684c1a332d5dc3307d73c7ba25168d0fp-7,
    0x1.f33332p-1
  },
  { // Entry 128
    0x1.5b2a4774a2de2143d8ff5f649a50863bp-6,
    0x1.0cccccp0
  },
  { // Entry 129
    0x1.a30a9d609efe9c281982d7df7ae69259p-5,
    0x1.20p0
  },
  { // Entry 130
    0x1.445392859c560c3c9ed56125e21ba584p-4,
    0x1.333334p0
  },
  { // Entry 131
    0x1.b02b7b4804d6e3346e6f30fb0ed80ed8p-4,
    0x1.466668p0
  },
  { // Entry 132
    0x1.0aec747738c557211b21410621b26f8fp-3,
    0x1.59999cp0
  },
  { // Entry 133
    0x1.3b03516d50b3544158f589c768f946e6p-3,
    0x1.6cccd0p0
  },
  { // Entry 134
    0x1.68a288b60b7fc2b622430e540655f53bp-3,
    0x1.80p0
  },
  { // Entry 135
    0.0,
    0x1.p0
  },
  { // Entry 136
    0x1.e1a5e2df92e9e5bcc08d3839a3e54697p4,
    0x1.p100
  },
  { // Entry 137
    0x1.e24f6e426a8bf8a9e67a7799f8b17451p4,
    0x1.19999ap100
  },
  { // Entry 138
    0x1.e2ea367218863bc8fd2c0d9ac9c7623cp4,
    0x1.333334p100
  },
  { // Entry 139
    0x1.e3789929b904e81bc6f0e5158f365203p4,
    0x1.4ccccep100
  },
  { // Entry 140
    0x1.e3fc6d41682d18d8c703d601ddc1fa20p4,
    0x1.666668p100
  },
  { // Entry 141
    0x1.e47727fa42d490cc96bad253a3656436p4,
    0x1.800002p100
  },
  { // Entry 142
    0x1.e4e9f63a9eb204cd2dcd94b7ceca28a7p4,
    0x1.99999cp100
  },
  { // Entry 143
    0x1.e555ce20504ed691954bc10e175867a8p4,
    0x1.b33336p100
  },
  { // Entry 144
    0x1.e5bb7b8b3d22f0a25afb3f6c6877e417p4,
    0x1.ccccd0p100
  },
  { // Entry 145
    0x1.e61ba942b928956af0bafc1ad04f0b20p4,
    0x1.e6666ap100
  },
  { // Entry 146
    0x1.e676e7b3bac865798509830704412b23p4,
    0x1.p101
  },
  { // Entry 147
    -0x1.bcb7bf382c6fb3df0029e1e6c04e5b04p-22,
    0x1.ffffe0p-1
  },
  { // Entry 148
    -0x1.15f2d18a6400ab03be90bfceaa5447fbp-23,
    0x1.fffff6p-1
  },
  { // Entry 149
    0x1.4d89c115357d535c8f9533338e6883eap-23,
    0x1.000006p0
  },
  { // Entry 150
    0x1.bcb7a36cb15a8cec0c39b0a7cf2d7858p-22,
    0x1.000010p0
  },
  { // Entry 151
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 152
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 153
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 154
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 155
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 156
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 157
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 158
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 159
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 160
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 161
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 162
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 163
    0x1.344135067e308acf8abe721a7991fdb7p5,
    0x1.fffffep127
  },
  { // Entry 164
    -0x1.66d3e7bd9a402c6f2e2bc4c48abe02abp5,
    0x1.p-149
  },
  { // Entry 165
    -0x1.34413af333ae8c86c135ab5278494452p-3,
    0x1.6a09e4p-1
  },
  { // Entry 166
    -0x1.3441360959c2bf17a59af37357663f09p-3,
    0x1.6a09e6p-1
  },
  { // Entry 167
    -0x1.3441311f7fdde48753477d6b1af5d93dp-3,
    0x1.6a09e8p-1
  },
  { // Entry 168
    0x1.34412f20bb9151db7cefbb5db5a9018ep-3,
    0x1.6a09e4p0
  },
  { // Entry 169
    0x1.3441340a957d1f4a988a733cd68c06d7p-3,
    0x1.6a09e6p0
  },
  { // Entry 170
    0x1.344138f46f61f9daeadde94512fc6ca3p-3,
    0x1.6a09e8p0
  },
  { // Entry 171
    -0x1.344136c6af521ffb49335226ca8bbf4ap-2,
    0x1.fffffep-2
  },
  { // Entry 172
    -0x1.34413509f79fef311f12b35816f922f0p-2,
    0x1.p-1
  },
  { // Entry 173
    -0x1.344131908840c3c3db4f515285b11c22p-2,
    0x1.000002p-1
  },
  { // Entry 174
    -0x1.ffbfcbff9b381c31b8783059f0acf062p-4,
    0x1.7ffffep-1
  },
  { // Entry 175
    -0x1.ffbfc2bbc780375837c4b0b84f38a14ap-4,
    0x1.80p-1
  },
  { // Entry 176
    -0x1.ffbfb977f3d4acee4eb0b360dbc6ec48p-4,
    0x1.800002p-1
  },
  { // Entry 177
    0x1.68a2841421a3d04961e94e83359bcdafp-3,
    0x1.7ffffep0
  },
  { // Entry 178
    0x1.68a288b60b7fc2b622430e540655f53bp-3,
    0x1.80p0
  },
  { // Entry 179
    0x1.68a28d57f55587eb16cd0cffc00ecfbcp-3,
    0x1.800002p0
  },
  { // Entry 180
    0x1.28132fbb336f7bcb34b70b00867dc9d5p-10,
    0x1.00aaa8p0
  },
  { // Entry 181
    0x1.2816a6db3131b6eda414e69eae447c9dp-10,
    0x1.00aaaap0
  },
  { // Entry 182
    0x1.281a1dfb280a4dd9abcda3a702e5258dp-10,
    0x1.00aaacp0
  },
  { // Entry 183
    0x1.3441342b9bc6d6cc0a0263f0bd2fd4c3p-1,
    0x1.fffffep1
  },
  { // Entry 184
    0x1.34413509f79fef311f12b35816f922f0p-1,
    0x1.p2
  },
  { // Entry 185
    0x1.344136c6af4f84e7c0f4645adf9d2657p-1,
    0x1.000002p2
  },
  { // Entry 186
    0x1.3441334d3fedbe66f4f2148963668696p-2,
    0x1.fffffep0
  },
  { // Entry 187
    0x1.34413509f79fef311f12b35816f922f0p-2,
    0x1.p1
  },
  { // Entry 188
    0x1.3441388366ff1a9e62d6155da84129bep-2,
    0x1.000002p1
  },
  { // Entry 189
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 190
    0.0,
    0x1.p0
  },
  { // Entry 191
    0x1.bcb7af95b6a1e1b102c8a40366dc2f73p-25,
    0x1.000002p0
  },
  { // Entry 192
    -0x1.344136c6af521ffb49335226ca8bbf4ap-2,
    0x1.fffffep-2
  },
  { // Entry 193
    -0x1.34413509f79fef311f12b35816f922f0p-2,
    0x1.p-1
  },
  { // Entry 194
    -0x1.344131908840c3c3db4f515285b11c22p-2,
    0x1.000002p-1
  },
  { // Entry 195
    -0x1.344135e853790796342302bf70c2711dp-1,
    0x1.fffffep-3
  },
  { // Entry 196
    -0x1.34413509f79fef311f12b35816f922f0p-1,
    0x1.p-2
  },
  { // Entry 197
    -0x1.3441334d3ff0597a7d3102554e551f89p-1,
    0x1.000002p-2
  },
  { // Entry 198
    -0x1.ce61d06d4f48ff2ec3ac5c6b7c3f0295p-1,
    0x1.fffffep-4
  },
  { // Entry 199
    -0x1.ce61cf8ef36fe6c9ae9c0d042275b468p-1,
    0x1.p-3
  },
  { // Entry 200
    -0x1.ce61cdd23bc051130cba5c0159d1b101p-1,
    0x1.000002p-3
  },
  { // Entry 201
    -0x1.34413579258c7b63a99adb0bc3ddca06p0,
    0x1.fffffep-5
  },
  { // Entry 202
    -0x1.34413509f79fef311f12b35816f922f0p0,
    0x1.p-4
  },
  { // Entry 203
    -0x1.3441342b9bc82455ce21dad6b2a7213cp0,
    0x1.000002p-4
  },
  { // Entry 204
    -0x1.815182bba374772ff15f87e1c99c12c2p0,
    0x1.fffffep-6
  },
  { // Entry 205
    -0x1.8151824c7587eafd66d7602e1cb76bacp0,
    0x1.p-5
  },
  { // Entry 206
    -0x1.8151816e19b0202215e687acb86569f8p0,
    0x1.000002p-5
  },
  { // Entry 207
    -0x1.ce61cffe215c72fc392434b7cf5a5b7ep0,
    0x1.fffffep-7
  },
  { // Entry 208
    -0x1.ce61cf8ef36fe6c9ae9c0d042275b468p0,
    0x1.p-6
  },
  { // Entry 209
    -0x1.ce61ceb097981bee5dab3482be23b2b5p0,
    0x1.000002p-6
  },
  { // Entry 210
    -0x1.0db90ea04fa23764407470c6ea8c521dp1,
    0x1.fffffep-8
  },
  { // Entry 211
    -0x1.0db90e68b8abf14afb305ced1419fe92p1,
    0x1.p-7
  },
  { // Entry 212
    -0x1.0db90df98ac00bdd52b7f0ac61f0fdb8p1,
    0x1.000002p-7
  },
  { // Entry 213
    -0x1.344135418e96354a6456c731ed6b767bp1,
    0x1.fffffep-9
  },
  { // Entry 214
    -0x1.34413509f79fef311f12b35816f922f0p1,
    0x1.p-8
  },
  { // Entry 215
    -0x1.3441349ac9b409c3769a471764d02216p1,
    0x1.000002p-8
  },
  { // Entry 216
    -0x1.5ac95be2cd8a333088391d9cf04a9ad9p1,
    0x1.fffffep-10
  },
  { // Entry 217
    -0x1.5ac95bab3693ed1742f509c319d8474ep1,
    0x1.p-9
  },
  { // Entry 218
    -0x1.5ac95b3c08a807a99a7c9d8267af4674p1,
    0x1.000002p-9
  },
  { // Entry 219
    -0x1.815182840c7e3116ac1b7407f329bf37p1,
    0x1.fffffep-11
  },
  { // Entry 220
    -0x1.8151824c7587eafd66d7602e1cb76bacp1,
    0x1.p-10
  },
  { // Entry 221
    -0x1.815181dd479c058fbe5ef3ed6a8e6ad2p1,
    0x1.000002p-10
  },
  { // Entry 222
    -0x1.f4e9f667c95a2ac917c27748fbc72c51p1,
    0x1.fffffep-14
  },
  { // Entry 223
    -0x1.f4e9f6303263e4afd27e636f2554d8c6p1,
    0x1.p-13
  },
  { // Entry 224
    -0x1.f4e9f5c10477ff422a05f72e732bd7ecp1,
    0x1.000002p-13
  },
  { // Entry 225
    -0x1.f4e9f667c95a2ac917c27748fbc72c51p1,
    0x1.fffffep-14
  },
  { // Entry 226
    -0x1.f4e9f6303263e4afd27e636f2554d8c6p1,
    0x1.p-13
  },
  { // Entry 227
    -0x1.f4e9f5c10477ff422a05f72e732bd7ecp1,
    0x1.000002p-13
  },
  { // Entry 228
    -0x1.ce61d06d4f48ff2ec3ac5c6b7c3f0295p-1,
    0x1.fffffep-4
  },
  { // Entry 229
    -0x1.ce61cf8ef36fe6c9ae9c0d042275b468p-1,
    0x1.p-3
  },
  { // Entry 230
    -0x1.ce61cdd23bc051130cba5c0159d1b101p-1,
    0x1.000002p-3
  },
  { // Entry 231
    -0x1.db11fd5867f8ff1cca049f4cb4fd8694p-5,
    0x1.bffffep-1
  },
  { // Entry 232
    -0x1.db11ed766abf432dc3c1bb4167a6eb47p-5,
    0x1.c0p-1
  },
  { // Entry 233
    -0x1.db11dd946d97ae16f51ada8f25bd4cc1p-5,
    0x1.c00002p-1
  },
  { // Entry 234
    -0x1.34413579258c7b63a99adb0bc3ddca06p0,
    0x1.fffffep-5
  },
  { // Entry 235
    -0x1.34413509f79fef311f12b35816f922f0p0,
    0x1.p-4
  },
  { // Entry 236
    -0x1.3441342b9bc82455ce21dad6b2a7213cp0,
    0x1.000002p-4
  },
  { // Entry 237
    -0x1.cb391a7364ac9eed883817f1ffc2150cp-6,
    0x1.dffffep-1
  },
  { // Entry 238
    -0x1.cb38fccd8bfdb696b29463658b991237p-6,
    0x1.e0p-1
  },
  { // Entry 239
    -0x1.cb38df27b36e6e15dbf9aa6e26e0527bp-6,
    0x1.e00002p-1
  },
  { // Entry 240
    -0x1.815182bba374772ff15f87e1c99c12c2p0,
    0x1.fffffep-6
  },
  { // Entry 241
    -0x1.8151824c7587eafd66d7602e1cb76bacp0,
    0x1.p-5
  },
  { // Entry 242
    -0x1.8151816e19b0202215e687acb86569f8p0,
    0x1.000002p-5
  },
  { // Entry 243
    -0x1.c3d0bcd98b3edf45205cfdbb6aed1917p-7,
    0x1.effffep-1
  },
  { // Entry 244
    -0x1.c3d0837784c409cbf85d4dd61d426e1bp-7,
    0x1.f0p-1
  },
  { // Entry 245
    -0x1.c3d04a157e84703859e1417a8c326212p-7,
    0x1.f00002p-1
  },
  { // Entry 246
    -0x1.ce61cffe215c72fc392434b7cf5a5b7ep0,
    0x1.fffffep-7
  },
  { // Entry 247
    -0x1.ce61cf8ef36fe6c9ae9c0d042275b468p0,
    0x1.p-6
  },
  { // Entry 248
    -0x1.ce61ceb097981bee5dab3482be23b2b5p0,
    0x1.000002p-6
  },
  { // Entry 249
    -0x1.c03af1a0115fb694dfc7e5305e350297p-8,
    0x1.f7fffep-1
  },
  { // Entry 250
    -0x1.c03a80ae5e05382d51f71b0f6602c76ap-8,
    0x1.f8p-1
  },
  { // Entry 251
    -0x1.c03a0fbcab1d766b7c26660812478675p-8,
    0x1.f80002p-1
  },
  { // Entry 252
    -0x1.0db90ea04fa23764407470c6ea8c521dp1,
    0x1.fffffep-8
  },
  { // Entry 253
    -0x1.0db90e68b8abf14afb305ced1419fe92p1,
    0x1.p-7
  },
  { // Entry 254
    -0x1.0db90df98ac00bdd52b7f0ac61f0fdb8p1,
    0x1.000002p-7
  },
  { // Entry 255
    -0x1.be779d93c637ed8142930d32c760672cp-9,
    0x1.fbfffep-1
  },
  { // Entry 256
    -0x1.be76bd77b4fc30d6cb5e729fc0bd5fa5p-9,
    0x1.fcp-1
  },
  { // Entry 257
    -0x1.be75dd5ba4a253fcbfcde28906782f81p-9,
    0x1.fc0002p-1
  },
  { // Entry 258
    -0x1.344135418e96354a6456c731ed6b767bp1,
    0x1.fffffep-9
  },
  { // Entry 259
    -0x1.34413509f79fef311f12b35816f922f0p1,
    0x1.p-8
  },
  { // Entry 260
    -0x1.3441349ac9b409c3769a471764d02216p1,
    0x1.000002p-8
  },
  { // Entry 261
    -0x1.bd98604e0225c5f5bcfcaf2d317a9cb8p-10,
    0x1.fdfffep-1
  },
  { // Entry 262
    -0x1.bd96a1d7d9cbc28d1ed88eb987048038p-10,
    0x1.fep-1
  },
  { // Entry 263
    -0x1.bd94e361b331f5825874683d16a4fa02p-10,
    0x1.fe0002p-1
  },
  { // Entry 264
    -0x1.5ac95be2cd8a333088391d9cf04a9ad9p1,
    0x1.fffffep-10
  },
  { // Entry 265
    -0x1.5ac95bab3693ed1742f509c319d8474ep1,
    0x1.p-9
  },
  { // Entry 266
    -0x1.5ac95b3c08a807a99a7c9d8267af4674p1,
    0x1.000002p-9
  },
  { // Entry 267
    -0x1.bd2a7f88f7e22e1fbeda7c34e78c5fbfp-11,
    0x1.fefffep-1
  },
  { // Entry 268
    -0x1.bd27045bfd024b0eb5a690199f7d311fp-11,
    0x1.ffp-1
  },
  { // Entry 269
    -0x1.bd23892f059f536c854c6b13c5a3b7bfp-11,
    0x1.ff0002p-1
  },
  { // Entry 270
    -0x1.815182840c7e3116ac1b7407f329bf37p1,
    0x1.fffffep-11
  },
  { // Entry 271
    -0x1.8151824c7587eafd66d7602e1cb76bacp1,
    0x1.p-10
  },
  { // Entry 272
    -0x1.815181dd479c058fbe5ef3ed6a8e6ad2p1,
    0x1.000002p-10
  },
  { // Entry 273
    -0x1.bcf6462a1921118a3b66f92fb7c60797p-12,
    0x1.ff7ffep-1
  },
  { // Entry 274
    -0x1.bcef518e29611a506bc6531e97655414p-12,
    0x1.ff80p-1
  },
  { // Entry 275
    -0x1.bce85cf240977c99419983a95dfa8d28p-12,
    0x1.ff8002p-1
  },
  { // Entry 276
    -0x1.f4e9f667c95a2ac917c27748fbc72c51p1,
    0x1.fffffep-14
  },
  { // Entry 277
    -0x1.f4e9f6303263e4afd27e636f2554d8c6p1,
    0x1.p-13
  },
  { // Entry 278
    -0x1.f4e9f5c10477ff422a05f72e732bd7ecp1,
    0x1.000002p-13
  },
  { // Entry 279
    -0x1.bcf63d094f7a45ef4f9d2bcde45ded2fp-15,
    0x1.ffeffep-1
  },
  { // Entry 280
    -0x1.bcbea45643c7c4b46503e30e59b7dd28p-15,
    0x1.fff0p-1
  },
  { // Entry 281
    -0x1.bc870ba36fafb33cddcf17f055436437p-15,
    0x1.fff002p-1
  },
  { // Entry 282
    HUGE_VALF,
    HUGE_VALF
  },
  { // Entry 283
    0x1.344135067e308acf8abe721a7991fdb7p5,
    0x1.fffffep127
  },
  { // Entry 284
    0x1.3441350304c122f48700992168f1c477p5,
    0x1.fffffcp127
  },
  { // Entry 285
    0x1.fd14dc015a2443dc8d1c9a7a4ead7c44p-2,
    0x1.921fb6p1
  },
  { // Entry 286
    0x1.91a74deec508a956dc13ce446f68b2a7p-3,
    0x1.921fb6p0
  },
  { // Entry 287
    0x1.bcb7af95b6a1e1b102c8a40366dc2f73p-25,
    0x1.000002p0
  },
  { // Entry 288
    0.0,
    0x1.p0
  },
  { // Entry 289
    -0x1.bcb7b230ca2a209eceb3929c5a02ff59p-26,
    0x1.fffffep-1
  },
  { // Entry 290
    -0x1.adb6384a546e6a16c42330d77d132671p-4,
    0x1.921fb6p-1
  },
  { // Entry 291
    -0x1.2f70302edce2b11d800ee1c6ab7aae56p5,
    0x1.000002p-126
  },
  { // Entry 292
    -0x1.2f703035cfc16f745a96688ab69d3e64p5,
    0x1.p-126
  },
  { // Entry 293
    -0x1.2f70303cc2a03bb0f2a882c164a49cddp5,
    0x1.fffffcp-127
  },
  { // Entry 294
    -0x1.2f703043b57f15d3487cc76186a378f6p5,
    0x1.fffff8p-127
  },
  { // Entry 295
    -0x1.646b65538650ec90cbed9f5dda901065p5,
    0x1.p-148
  },
  { // Entry 296
    -0x1.66d3e7bd9a402c6f2e2bc4c48abe02abp5,
    0x1.p-149
  },
  { // Entry 297
    -HUGE_VALF,
    0.0f
  },
  { // Entry 298
    -HUGE_VALF,
    -0.0f
  },
  { // Entry 299
    0x1.p0,
    0x1.40p3
  },
  { // Entry 300
    0x1.p1,
    0x1.90p6
  },
  { // Entry 301
    0x1.80p1,
    0x1.f4p9
  }
};
