#
# Copyright (C) 2011 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

ifeq ($(PREBUILT_MODULES),)
ifeq ($(LOCAL_MODULE),)
$(error PREBUILT_MODULES must be specified; LOCAL_PATH=$(LOCAL_PATH))
endif
PREBUILT_MODULES := $(LOCAL_MODULE)
endif

ifeq ($(PREBUILT_PROJECT),)
$(error PREBUILT_PROJECT must be specified; LOCAL_PATH=$(LOCAL_PATH))
endif

ifndef prebuilt_create_once
prebuilt_create_once := true

PREBUILT_OUT_DIR := $(OUT_DIR)/prebuilt

define convert_installed_to_relative
  $(if $(strip $(TARGET_OUT_$(strip $(2)))), \
    $(subst $(TARGET_OUT_$(strip $(2)))/,,$(1)) \
   , \
    $(subst $(PRODUCT_OUT)/,,$(1)) \
  )
endef

define transfer_content
  $(info prebuilt transfer_content: $(1) => $(2))
  $(hide) $(ACP) -fp $(1) $(2)
endef

define _write_metadata
  $(eval data := $(strip $(1)))
  $(if $(data),\
    $(shell echo $(data) > $(2)) \
  )
endef

#
# translate ABS module data into a prebuilt bundle.
# $(1): pathway to the binary base
# $(2): pathway to the headers base
# $(3): module to translate.
#
define install_prebuilt
  $(eval prebuilt_out := $(1)/$(TARGET_BOARD_PLATFORM)/$(3))
  $(eval prebuilt_headers_out := $(2)/$(TARGET_BOARD_PLATFORM)/$(PREBUILT-HEADERS-TO-$(3)))
  $(shell mkdir -p $(prebuilt_out))
  $(if $(word 1,$(PREBUILT-HEADERS-$(3))),
    $(shell mkdir -p $(prebuilt_headers_out))
  )
  $(info creating prebuilt: $(3))
  $(call _write_metadata,$(ALL_MODULES.$(3).CLASS),$(prebuilt_out)/class)
  $(call _write_metadata,$(ALL_MODULES.$(3).TAGS),$(prebuilt_out)/tags)
  $(call _write_metadata,$(ALL_MODULES.$(3).REQUIRED),$(prebuilt_out)/required)
  $(eval files = $(call module-installed-files,$(3)))
  $(if $(word 2,$(files)), \
    $(error installing $(3), multiple files encountered- we cannot handle that) \
  )

  $(eval suf := $(suffix $(files)))
  $(call _write_metadata,$(suf),$(prebuilt_out)/suffix)
  $(foreach x,$(files),\
    $(call transfer_content,$(x),$(prebuilt_out)/payload$(suf)) \
  )
  $(foreach x,$(PREBUILT-HEADERS-$(3)),\
    $(call transfer_content,$(PREBUILT-HEADERS-FROM-$(3))/$(x),$(prebuilt_headers_out)) \
  )
  $(info Headers list for $(3) from $(PREBUILT-HEADERS-FROM-$(3)): $(PREBUILT-HEADERS-$(3)))
endef

#
# create a project android.mk
# $(1): path to the Android.mk to create for this project
#
define install_prebuilt_project
  $(shell mkdir -p $(dir $(1)))
  $(shell echo # autogenerated template for prebuilts > $(1))
  $(shell echo 'ifneq ($$(TARGET_BOARD_PLATFORM),)' >> $(1))
  $(shell echo LOCAL_PATH := $$\(call my-dir\)/$$\(TARGET_BOARD_PLATFORM\) >> $(1))
  $(shell echo include $$\(BUILD_PREBUILT_BUNDLE\) >> $(1))
  $(shell echo endif >> $(1))
endef

#
# create a module bundle
# $(1): directory to create the prebuilt projects bundles in.
# $(2): directory to create the prebuilt headers bundles in.
# $(3): project/grouping for the module bundling.
# $(4): module to translate
#
define prebuilt_bundle_create_boilerplate
  $(eval PREBUILT-HEADERS-FROM-$(4) := $(LOCAL_PATH))
  $(eval PREBUILT-HEADERS-TO-$(4) := $(LOCAL_COPY_HEADERS_TO))
  $(eval PREBUILT-HEADERS-$(4) := $(LOCAL_COPY_HEADERS))
  $(eval .PHONY: PREBUILT-$(4))
  $(eval PREBUILT-$(4): $(1)/Android.mk $(4) ; $$(call install_prebuilt,$(1),$(2),$(4)))
  $(eval PREBUILT-PROJECT-$(3): PREBUILT-$(4))
endef
endif

prebuilt_base := $(PREBUILT_OUT_DIR)/$(PREBUILT_PROJECT)

prebuilt_bin := $(prebuilt_base)/proprietary
ifneq ($(PREBUILT_INSTALL_DIR),)
prebuilt_bin := $(prebuilt_base)/$(PREBUILT_INSTALL_DIR)
endif

prebuilt_hdr := $(prebuilt_base)/include
ifneq ($(PREBUILT_INSTALL_HEADERS_DIR),)
prebuilt_hdr := $(prebuilt_base)/$(PREBUILT_INSTALL_HEADERS_DIR)
endif

$(prebuilt_bin)/Android.mk:
	$(call install_prebuilt_project,$@)

.PHONY: PREBUILT-PROJECT-$(PREBUILT_PROJECT)

PREBUILT-PROJECT-$(PREBUILT_PROJECT): $(prebuilt_bin)/Android.mk

$(foreach x,$(PREBUILT_MODULES), \
  $(eval $(call prebuilt_bundle_create_boilerplate,$(prebuilt_bin),$(prebuilt_hdr),$(PREBUILT_PROJECT),$(x))) \
)

prebuilt_base :=
prebuilt_bin :=
prebuilt_hdr :=
PREBUILT_MODULES :=
PREBUILT_PROJECT :=
PREBUILT_INSTALL_DIR :=
