/*
 This Java source file was generated by test-to-java.xsl
 and is a derived work from the source document.
 The source document contained the following notice:



 Copyright (c) 2001 World Wide Web Consortium, 
 (Massachusetts Institute of Technology, Institut National de
 Recherche en Informatique et en Automatique, Keio University).  All 
 Rights Reserved.  This program is distributed under the W3C's Software
 Intellectual Property License.  This program is distributed in the 
 hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  

 See W3C License http://www.w3.org/Consortium/Legal/ for more details.


 */

package tests.org.w3c.dom;

import dalvik.annotation.TestTargets;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargetClass;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;

import javax.xml.parsers.DocumentBuilder;

/**
 * The method setNamedItemNS adds a node using its namespaceURI and localName.
 * If a node with that namespace URI and that local name is already present in
 * this map, it is replaced by the new one.
 * 
 * Retreive the first element whose localName is address and namespaceURI
 * http://www.nist.gov", and put its attributes into a named node map. Create a
 * new attribute node and add it to this map. Verify if the attr node was
 * successfully added by checking the nodeName of the retreived atttribute.
 * 
 * @author IBM
 * @author Neil Delima
 * @see <a
 *      href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-getNamedItemNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-getNamedItemNS</a>
 */
@TestTargetClass(NamedNodeMap.class) 
public final class NamedNodeMapSetNamedItemNS extends DOMTestCase {

    DOMDocumentBuilderFactory factory;

    DocumentBuilder builder;

    protected void setUp() throws Exception {
        super.setUp();
        try {
            // Changed to configuration #2. This test case just doesn't make
            // sense without a namespace-aware parser. It actually fails even
            // on the JDK in that case.
            factory = new DOMDocumentBuilderFactory(DOMDocumentBuilderFactory
                    .getConfiguration2());
            builder = factory.getBuilder();
        } catch (Exception e) {
            fail("Unexpected exception" + e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        factory = null;
        builder = null;
        super.tearDown();
    }

    /**
     * Runs the test case.
     * 
     * @throws Throwable
     *             Any uncaught exception causes test to fail
     */
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Doesn't verify DOMException.",
        method = "setNamedItemNS",
        args = {org.w3c.dom.Node.class}
    )
    public void testSetNamedItemNS1() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        Node element;
        Attr attribute;

        Attr newAttr1;
        NodeList elementList;
        String attrName;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("http://www.nist.gov",
                "address");
        element = elementList.item(0);
        attributes = element.getAttributes();
        newAttr1 = doc.createAttributeNS("http://www.w3.org/DOM/L1", "streets");
        ((Element) /* Node */element).setAttributeNodeNS(newAttr1);
        attribute = (Attr) attributes.getNamedItemNS(
                "http://www.w3.org/DOM/L1", "streets");
        attrName = attribute.getNodeName();
        assertEquals("namednodemapsetnameditemns01", "streets", attrName);
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Doesn't verify DOMException.",
        method = "setNamedItemNS",
        args = {org.w3c.dom.Node.class}
    )
    public void testSetNamedItemNS2() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        Element element;
        Attr attribute;
        Attr attribute1;

        String attrName;
        doc = (Document) load("staffNS", builder);
        element = doc.createElementNS("http://www.w3.org/DOM/Test", "root");
        attribute1 = doc
                .createAttributeNS("http://www.w3.org/DOM/L1", "L1:att");
        attributes = element.getAttributes();
        attributes.setNamedItemNS(attribute1);
        attribute = (Attr) attributes.getNamedItemNS(
                "http://www.w3.org/DOM/L1", "att");
        attrName = attribute.getNodeName();
        assertEquals("namednodemapsetnameditemns02", "L1:att", attrName);
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that setNamedItemNS throws DOMException with WRONG_DOCUMENT_ERR code.",
        method = "setNamedItemNS",
        args = {org.w3c.dom.Node.class}
    )
    public void testSetNamedItemNS3() throws Throwable {

        Document doc;
        Document docAlt;
        NamedNodeMap attributes;
        NamedNodeMap attributesAlt;
        NodeList elementList;
        NodeList elementListAlt;
        Element element;
        Element elementAlt;
        Attr attr;

        String nullNS = null;

        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("*", "address");
        element = (Element) elementList.item(1);
        attributes = element.getAttributes();
        docAlt = (Document) load("staffNS", builder);
        elementListAlt = docAlt.getElementsByTagNameNS("*", "address");
        elementAlt = (Element) elementListAlt.item(1);
        attributesAlt = elementAlt.getAttributes();
        attr = (Attr) attributesAlt.getNamedItemNS(nullNS, "street");
        attributesAlt.removeNamedItemNS(nullNS, "street");

        {
            boolean success = false;
            try {
                attributes.setNamedItemNS(attr);
            } catch (DOMException ex) {
                success = (ex.code == DOMException.WRONG_DOCUMENT_ERR);
            }
            assertTrue("throw_WRONG_DOCUMENT_ERR", success);
        }
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that setNamedItemNS throws DOMException with WRONG_DOCUMENT_ERR code.",
        method = "setNamedItemNS",
        args = {org.w3c.dom.Node.class}
    )
    public void testSetNamedItemNS4() throws Throwable {
        Document doc;
        DOMImplementation domImpl;
        Document docAlt; 
        DocumentType docType = null;

        NamedNodeMap attributes;
        NodeList elementList;
        Element element;
        Attr attrAlt;

        String nullNS = null;

        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("*", "address");
        element = (Element) elementList.item(1);
        attributes = element.getAttributes();
        domImpl = doc.getImplementation();
        docAlt = domImpl.createDocument(nullNS, "newDoc", docType);
        attrAlt = docAlt.createAttributeNS(nullNS, "street");

        {
            boolean success = false;
            try {
                attributes.setNamedItemNS(attrAlt);
            } catch (DOMException ex) {
                success = (ex.code == DOMException.WRONG_DOCUMENT_ERR);
            }
            assertTrue("throw_WRONG_DOCUMENT_ERR", success);
        }
    }

// Assumes validation.
//    public void testSetNamedItemNS5() throws Throwable {
//        Document doc;
//        DocumentType docType;
//        NamedNodeMap entities;
//        NamedNodeMap notations;
//        Entity entity;
//        Notation notation;
//
//        doc = (Document) load("staffNS", builder);
//        docType = doc.getDoctype();
//        entities = docType.getEntities();
//        assertNotNull("entitiesNotNull", entities);
//        notations = docType.getNotations();
//        assertNotNull("notationsNotNull", notations);
//        entity = (Entity) entities.getNamedItem("ent1");
//        notation = (Notation) notations.getNamedItem("notation1");
//
//        {
//            boolean success = false;
//            try {
//                entities.setNamedItemNS(entity);
//            } catch (DOMException ex) {
//                success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
//            }
//            assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR_entities", success);
//        }
//
//        {
//            boolean success = false;
//            try {
//                notations.setNamedItemNS(notation);
//            } catch (DOMException ex) {
//                success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
//            }
//            assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR_notations", success);
//        }
//    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that setNamedItemNS throws DOMException with INUSE_ATTRIBUTE_ERR code.",
        method = "setNamedItemNS",
        args = {org.w3c.dom.Node.class}
    )
    public void testSetNamedItemNS6() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        NodeList elementList;
        Element element;
        Attr attr;

        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("*", "address");
        element = (Element) elementList.item(0);
        attributes = element.getAttributes();
        attr = (Attr) attributes.getNamedItemNS("http://www.usa.com",
                "domestic");
        element = (Element) elementList.item(1);
        attributes = element.getAttributes();

        {
            boolean success = false;
            try {
                attributes.setNamedItemNS(attr);
            } catch (DOMException ex) {
                success = (ex.code == DOMException.INUSE_ATTRIBUTE_ERR);
            }
            assertTrue("namednodemapsetnameditemns06", success);
        }
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that setNamedItemNS throws DOMException with INUSE_ATTRIBUTE_ERR code.",
        method = "setNamedItemNS",
        args = {org.w3c.dom.Node.class}
    )
    public void testSetNamedItemNS7() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        NodeList elementList;
        Element element;
        Attr attr;

        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("*", "address");
        element = (Element) elementList.item(0);
        attributes = element.getAttributes();
        attr = (Attr) attributes.getNamedItemNS("http://www.usa.com",
                "domestic");
        element = (Element) elementList.item(1);
        attributes = element.getAttributes();

        {
            boolean success = false;
            try {
                attributes.setNamedItemNS(attr);
            } catch (DOMException ex) {
                success = (ex.code == DOMException.INUSE_ATTRIBUTE_ERR);
            }
            assertTrue("namednodemapsetnameditemns07", success);
        }
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that setNamedItemNS throws DOMException with INUSE_ATTRIBUTE_ERR code.",
        method = "setNamedItemNS",
        args = {org.w3c.dom.Node.class}
    )
    public void testSetNamedItemNS8() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        NodeList elementList;
        Element element;
        Attr attr;

        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("*", "address");
        element = (Element) elementList.item(0);
        attributes = element.getAttributes();
        attr = (Attr) attributes.getNamedItemNS("http://www.usa.com",
                "domestic");
        element = (Element) elementList.item(1);
        attributes = element.getAttributes();

        {
            boolean success = false;
            try {
                attributes.setNamedItemNS(attr);
            } catch (DOMException ex) {
                success = (ex.code == DOMException.INUSE_ATTRIBUTE_ERR);
            }
            assertTrue("namednodemapsetnameditemns08", success);
        }
    }

// Assumes validation.
//    public void testSetNamedItemNS9() throws Throwable {
//        Document doc;
//        DocumentType docType;
//        NamedNodeMap entities;
//        NamedNodeMap notations;
//        Attr attr;
//        doc = (Document) load("staffNS", builder);
//        docType = doc.getDoctype();
//        entities = docType.getEntities();
//        notations = docType.getNotations();
//        attr = doc.createAttributeNS("http://www.w3.org/DOM/Test", "test");
//
//        {
//            boolean success = false;
//            try {
//                entities.setNamedItemNS(attr);
//            } catch (DOMException ex) {
//                success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
//            }
//            assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR_entities", success);
//        }
//
//        {
//            boolean success = false;
//            try {
//                notations.setNamedItemNS(attr);
//            } catch (DOMException ex) {
//                success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
//            }
//            assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR_notations", success);
//        }
//    }

// Assumes validation.
//    public void testSetNamedItemNS10() throws Throwable {
//        Document doc;
//        DocumentType docType;
//        NamedNodeMap entities;
//        NamedNodeMap attributes;
//        Entity entity;
//
//        Element element;
//        NodeList elementList;
//
//        doc = (Document) load("staffNS", builder);
//        docType = doc.getDoctype();
//        entities = docType.getEntities();
//        assertNotNull("entitiesNotNull", entities);
//        entity = (Entity) entities.getNamedItem("ent1");
//        elementList = doc.getElementsByTagNameNS("http://www.nist.gov",
//                "address");
//        element = (Element) elementList.item(0);
//        attributes = element.getAttributes();
//
//        {
//            boolean success = false;
//            try {
//                attributes.setNamedItemNS(entity);
//            } catch (DOMException ex) {
//                success = (ex.code == DOMException.HIERARCHY_REQUEST_ERR);
//            }
//            assertTrue("throw_HIERARCHY_REQUEST_ERR", success);
//        }
//    }

// Assumes validation.
//    public void testSetNamedItemNS11() throws Throwable {
//        Document doc;
//        DocumentType docType;
//        NamedNodeMap notations;
//        NamedNodeMap attributes;
//        Notation notation;
//        Element element;
//        NodeList elementList;
//
//        doc = (Document) load("staffNS", builder);
//        docType = doc.getDoctype();
//        notations = docType.getNotations();
//        assertNotNull("notationsNotNull", notations);
//        notation = (Notation) notations.getNamedItem("notation1");
//        elementList = doc.getElementsByTagNameNS("http://www.nist.gov",
//                "address");
//        element = (Element) elementList.item(0);
//        attributes = element.getAttributes();
//
//        {
//            boolean success = false;
//            try {
//                attributes.setNamedItemNS(notation);
//            } catch (DOMException ex) {
//                success = (ex.code == DOMException.HIERARCHY_REQUEST_ERR);
//            }
//            assertTrue("throw_HIERARCHY_REQUEST_ERR", success);
//        }
//    }
}
