/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ** UNDER CONSTRUCTION **

/*
 * Declaration of register map data structure and related functions.
 */
#ifndef _DALVIK_REGISTERMAP
#define _DALVIK_REGISTERMAP

/*
 * Format enumeration for RegisterMap data area.
 */
typedef enum RegisterMapFormat {
    kFormatUnknown = 0,
    kFormatCompact8,        /* compact layout, 8-bit addresses */
    kFormatCompact16,       /* compact layout, 16-bit addresses */
    // TODO: compressed stream
} RegisterMapFormat;

/*
 * This is a single variable-size structure.  It may be allocated on the
 * heap or mapped out of a (post-dexopt) DEX file.
 */
struct RegisterMap {
    /* header */
    u1      format;         /* enum RegisterMapFormat */
    u1      regWidth;       /* bytes per register line, 1+ */
    u2      numEntries;     /* number of entries */

    /* data starts here; no alignment guarantees made */
    u1      data[1];
};

/*
 * Generate the register map for a previously-verified method.
 *
 * Returns a pointer to a newly-allocated RegisterMap.
 */
//RegisterMap* dvmGenerateRegisterMap(const Method* meth);

/*
 * Various bits of data generated by the verifier, wrapped up in a package
 * for ease of use by the register map generator.
 */
typedef struct VerifierData {
    /*
     * The method we're working on.
     */
    const Method* method;

    /*
     * Number of instructions in the method.
     */
    int         insnsSize;

    /*
     * Number of registers we track for each instruction.  This is equal
     * to the method's declared "registersSize".  (Does not include the
     * pending return value.)
     */
    int         insnRegCount;

    /*
     * Instruction widths and flags, one entry per code unit.
     */
    InsnFlags*  insnFlags;

    /*
     * Array of SRegType arrays, one entry per code unit.  We only need
     * entries for code units that hold the start of an "interesting"
     * instruction.  For register map generation, we're only interested
     * in GC points.
     */
    RegType**   addrRegs;
} VerifierData;

/*
 * Generate the register map for a method that has just been verified
 * (i.e. we're doing this as part of verification).
 *
 * Returns a pointer to a newly-allocated RegisterMap, or NULL on failure.
 */
RegisterMap* dvmGenerateRegisterMapV(VerifierData* vdata);

#endif /*_DALVIK_REGISTERMAP*/
