/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.Context;
import android.text.TextUtils;
import com.google.analytics.tracking.android.AnalyticsThread;
import com.google.analytics.tracking.android.AppFieldsDefaultProvider;
import com.google.analytics.tracking.android.ClientIdDefaultProvider;
import com.google.analytics.tracking.android.GAServiceProxy;
import com.google.analytics.tracking.android.GAUsage;
import com.google.analytics.tracking.android.GoogleAnalytics;
import com.google.analytics.tracking.android.HitBuilder;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.MapBuilder;
import com.google.analytics.tracking.android.ServiceProxy;
import com.google.analytics.tracking.android.Utils;
import com.google.android.gms.analytics.internal.Command;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

class GAThread
extends Thread
implements AnalyticsThread {
    private static final String CLIENT_VERSION = "ma3.0.2";
    private static final int MAX_SAMPLE_RATE = 100;
    private static final int SAMPLE_RATE_MULTIPLIER = 100;
    private static final int SAMPLE_RATE_MODULO = 10000;
    static final String API_VERSION = "1";
    private final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();
    private volatile boolean mDisabled = false;
    private volatile boolean mClosed = false;
    private volatile List<Command> mCommands;
    private volatile String mInstallCampaign;
    private volatile String mClientId;
    private static GAThread sInstance;
    private volatile ServiceProxy mServiceProxy;
    private final Context mContext;

    static GAThread getInstance(Context ctx) {
        if (sInstance == null) {
            sInstance = new GAThread(ctx);
        }
        return sInstance;
    }

    private GAThread(Context ctx) {
        super("GAThread");
        this.mContext = ctx != null ? ctx.getApplicationContext() : ctx;
        this.start();
    }

    @VisibleForTesting
    GAThread(Context ctx, ServiceProxy proxy) {
        super("GAThread");
        this.mContext = ctx != null ? ctx.getApplicationContext() : ctx;
        this.mServiceProxy = proxy;
        this.start();
    }

    @VisibleForTesting
    protected void init() {
        this.mServiceProxy.createService();
        this.mCommands = new ArrayList<Command>();
        this.mCommands.add(new Command("appendVersion", "&_v".substring(1), CLIENT_VERSION));
        this.mCommands.add(new Command("appendQueueTime", "&qt".substring(1), null));
        this.mCommands.add(new Command("appendCacheBuster", "&z".substring(1), null));
    }

    @Override
    public void sendHit(Map<String, String> hit) {
        final HashMap<String, String> hitCopy = new HashMap<String, String>(hit);
        String hitTime = hit.get("&ht");
        if (hitTime != null) {
            try {
                long ht = Long.valueOf(hitTime);
            }
            catch (NumberFormatException nfe) {
                hitTime = null;
            }
        }
        if (hitTime == null) {
            long currentTimeMs = System.currentTimeMillis();
            hitCopy.put("&ht", Long.toString(currentTimeMs));
        }
        this.queueToThread(new Runnable(){

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hitCopy.get("&cid")))) {
                    hitCopy.put("&cid", GAThread.this.mClientId);
                }
                if (GoogleAnalytics.getInstance(GAThread.this.mContext).getAppOptOut() || GAThread.this.isSampledOut(hitCopy)) {
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)GAThread.this.mInstallCampaign)) {
                    GAUsage.getInstance().setDisableUsage(true);
                    hitCopy.putAll(new MapBuilder().setCampaignParamsFromUrl(GAThread.this.mInstallCampaign).build());
                    GAUsage.getInstance().setDisableUsage(false);
                    GAThread.this.mInstallCampaign = null;
                }
                GAThread.this.fillAppParameters(hitCopy);
                Map<String, String> wireFormatParams = HitBuilder.generateHitParams(hitCopy);
                GAThread.this.mServiceProxy.putHit(wireFormatParams, Long.valueOf((String)hitCopy.get("&ht")), GAThread.this.getUrlScheme(hitCopy), GAThread.this.mCommands);
            }
        });
    }

    private String getUrlScheme(Map<String, String> hit) {
        if (hit.containsKey("useSecure")) {
            return Utils.safeParseBoolean(hit.get("useSecure"), true) ? "https:" : "http:";
        }
        return "https:";
    }

    private boolean isSampledOut(Map<String, String> hit) {
        if (hit.get("&sf") == null) {
            return false;
        }
        double sampleRate = Utils.safeParseDouble(hit.get("&sf"), 100.0);
        if (sampleRate >= 100.0) {
            return false;
        }
        String clientId = hit.get("&cid");
        if ((double)(GAThread.hashClientIdForSampling(clientId) % 10000) >= sampleRate * 100.0) {
            String hitType = hit.get("&t") == null ? "unknown" : hit.get("&t");
            Log.v(String.format("%s hit sampled out", hitType));
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static int hashClientIdForSampling(String clientId) {
        int hashVal = 1;
        int lefMost7 = 0;
        if (!TextUtils.isEmpty((CharSequence)clientId)) {
            hashVal = 0;
            for (int charPos = clientId.length() - 1; charPos >= 0; --charPos) {
                char curChar = clientId.charAt(charPos);
                lefMost7 = (hashVal = (hashVal << 6 & 0xFFFFFFF) + curChar + (curChar << 14)) & 0xFE00000;
                hashVal = lefMost7 != 0 ? hashVal ^ lefMost7 >> 21 : hashVal;
            }
        }
        return hashVal;
    }

    private void fillAppParameters(Map<String, String> hit) {
        AppFieldsDefaultProvider appFieldsProvider = AppFieldsDefaultProvider.getProvider();
        Utils.putIfAbsent(hit, "&an", appFieldsProvider.getValue("&an"));
        Utils.putIfAbsent(hit, "&av", appFieldsProvider.getValue("&av"));
        Utils.putIfAbsent(hit, "&aid", appFieldsProvider.getValue("&aid"));
        Utils.putIfAbsent(hit, "&aiid", appFieldsProvider.getValue("&aiid"));
        hit.put("&v", API_VERSION);
    }

    @Override
    public void dispatch() {
        this.queueToThread(new Runnable(){

            @Override
            public void run() {
                GAThread.this.mServiceProxy.dispatch();
            }
        });
    }

    @Override
    public void clearHits() {
        this.queueToThread(new Runnable(){

            @Override
            public void run() {
                GAThread.this.mServiceProxy.clearHits();
            }
        });
    }

    @Override
    public void setForceLocalDispatch() {
        this.queueToThread(new Runnable(){

            @Override
            public void run() {
                GAThread.this.mServiceProxy.setForceLocalDispatch();
            }
        });
    }

    @VisibleForTesting
    void queueToThread(Runnable r) {
        this.queue.add(r);
    }

    @VisibleForTesting
    static String getAndClearCampaign(Context context) {
        try {
            FileInputStream input = context.openFileInput("gaInstallData");
            byte[] inputBytes = new byte[8192];
            int readLen = input.read(inputBytes, 0, 8192);
            if (input.available() > 0) {
                Log.e("Too much campaign data, ignoring it.");
                input.close();
                context.deleteFile("gaInstallData");
                return null;
            }
            input.close();
            context.deleteFile("gaInstallData");
            if (readLen <= 0) {
                Log.w("Campaign file is empty.");
                return null;
            }
            String campaignString = new String(inputBytes, 0, readLen);
            Log.i("Campaign found: " + campaignString);
            return campaignString;
        }
        catch (FileNotFoundException e) {
            Log.i("No campaign data found.");
            return null;
        }
        catch (IOException e) {
            Log.e("Error reading campaign data.");
            context.deleteFile("gaInstallData");
            return null;
        }
    }

    private String printStackTrace(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        t.printStackTrace(stream);
        stream.flush();
        return new String(baos.toByteArray());
    }

    @Override
    public void run() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            Log.w("sleep interrupted in GAThread initialize");
        }
        try {
            if (this.mServiceProxy == null) {
                this.mServiceProxy = new GAServiceProxy(this.mContext, this);
            }
            this.init();
            this.mClientId = ClientIdDefaultProvider.getProvider().getValue("&cid");
            this.mInstallCampaign = GAThread.getAndClearCampaign(this.mContext);
        }
        catch (Throwable t) {
            Log.e("Error initializing the GAThread: " + this.printStackTrace(t));
            Log.e("Google Analytics will not start up.");
            this.mDisabled = true;
        }
        while (!this.mClosed) {
            try {
                try {
                    Runnable r = this.queue.take();
                    if (this.mDisabled) continue;
                    r.run();
                }
                catch (InterruptedException e) {
                    Log.i(e.toString());
                }
            }
            catch (Throwable t) {
                Log.e("Error on GAThread: " + this.printStackTrace(t));
                Log.e("Google Analytics is shutting down.");
                this.mDisabled = true;
            }
        }
    }

    @Override
    public LinkedBlockingQueue<Runnable> getQueue() {
        return this.queue;
    }

    @Override
    public Thread getThread() {
        return this;
    }

    @VisibleForTesting
    void close() {
        this.mClosed = true;
        this.interrupt();
    }

    @VisibleForTesting
    boolean isDisabled() {
        return this.mDisabled;
    }
}

