/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.analytics.containertag.proto.Debug;
import com.google.analytics.midtier.proto.containertag.TypeSystem;
import com.google.tagmanager.DebugMacroEvaluationInfoBuilder;
import com.google.tagmanager.Log;
import com.google.tagmanager.MacroEvaluationInfoBuilder;
import com.google.tagmanager.ValueBuilder;
import com.google.tagmanager.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.tagmanager.protobuf.nano.MessageNano;

class DebugValueBuilder
implements ValueBuilder {
    private TypeSystem.Value value;

    public DebugValueBuilder(TypeSystem.Value value) {
        this.value = value;
    }

    private void validateType(int expected, int actual, String message) {
        if (expected != actual) {
            throw new TypeMismatchException(message, actual);
        }
    }

    public static TypeSystem.Value copyImmutableValue(TypeSystem.Value value) {
        TypeSystem.Value result = new TypeSystem.Value();
        try {
            MessageNano.mergeFrom(result, MessageNano.toByteArray(value));
        }
        catch (InvalidProtocolBufferNanoException e) {
            Log.e("Failed to copy runtime value into debug value");
        }
        return result;
    }

    @Override
    public ValueBuilder getListItem(int index) {
        this.validateType(2, this.value.type, "add new list item");
        DebugValueBuilder listItemBuilder = new DebugValueBuilder(this.value.listItem[index]);
        return listItemBuilder;
    }

    @Override
    public ValueBuilder getMapKey(int index) {
        this.validateType(3, this.value.type, "add new map key");
        DebugValueBuilder mapKeyValueBuilder = new DebugValueBuilder(this.value.mapKey[index]);
        return mapKeyValueBuilder;
    }

    @Override
    public ValueBuilder getMapValue(int index) {
        this.validateType(3, this.value.type, "add new map value");
        DebugValueBuilder mapValueBuilder = new DebugValueBuilder(this.value.mapValue[index]);
        return mapValueBuilder;
    }

    @Override
    public ValueBuilder getTemplateToken(int index) {
        this.validateType(7, this.value.type, "add template token");
        DebugValueBuilder tokenValueBuilder = new DebugValueBuilder(this.value.templateToken[index]);
        return tokenValueBuilder;
    }

    @Override
    public MacroEvaluationInfoBuilder createValueMacroEvaluationInfoExtension() {
        this.validateType(4, this.value.type, "set macro evaluation extension");
        Debug.MacroEvaluationInfo info = new Debug.MacroEvaluationInfo();
        this.value.setExtension(Debug.MacroEvaluationInfo.macro, info);
        DebugMacroEvaluationInfoBuilder macroEvaluationExtension = new DebugMacroEvaluationInfoBuilder(info);
        return macroEvaluationExtension;
    }

    private static class TypeMismatchException
    extends IllegalStateException {
        public TypeMismatchException(String operation, int t) {
            super("Attempted operation: " + operation + " on object of type: " + t);
        }
    }
}

