/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import android.net.Uri;
import com.google.tagmanager.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

class PreviewManager {
    static final String BASE_DEBUG_QUERY = "&gtm_debug=x";
    static final String CTFE_URL_PATH_PREFIX = "/r?";
    private static final String CONTAINER_BASE_PATTERN = "^tagmanager.c.\\S+:\\/\\/preview\\/p\\?id=\\S+&";
    private static final String CONTAINER_PREVIEW_URL_PATTERN = "^tagmanager.c.\\S+:\\/\\/preview\\/p\\?id=\\S+&gtm_auth=\\S+&gtm_preview=\\d+(&gtm_debug=x)?$";
    private static final String CONTAINER_PREVIEW_EXIT_URL_PATTERN = "^tagmanager.c.\\S+:\\/\\/preview\\/p\\?id=\\S+&gtm_preview=$";
    private static final String CONTAINER_DEBUG_STRING_PATTERN = ".*?&gtm_debug=x$";
    private static PreviewManager sInstance;
    private volatile PreviewMode mPreviewMode;
    private volatile String mContainerId;
    private volatile String mCTFEUrlPath;
    private volatile String mCTFEUrlQuery;

    PreviewManager() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PreviewManager getInstance() {
        Class<PreviewManager> clazz = PreviewManager.class;
        synchronized (PreviewManager.class) {
            if (sInstance == null) {
                sInstance = new PreviewManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    synchronized boolean setPreviewData(Uri data) {
        String uriStr = null;
        try {
            uriStr = URLDecoder.decode(data.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        if (uriStr.matches(CONTAINER_PREVIEW_URL_PATTERN)) {
            Log.v("Container preview url: " + uriStr);
            this.mPreviewMode = uriStr.matches(CONTAINER_DEBUG_STRING_PATTERN) ? PreviewMode.CONTAINER_DEBUG : PreviewMode.CONTAINER;
        } else {
            if (uriStr.matches(CONTAINER_PREVIEW_EXIT_URL_PATTERN)) {
                if (this.getContainerId(data.getQuery()).equals(this.mContainerId)) {
                    Log.v("Exit preview mode for container: " + this.mContainerId);
                    this.mPreviewMode = PreviewMode.NONE;
                    this.mCTFEUrlPath = null;
                    return true;
                }
                return false;
            }
            Log.w("Invalid preview uri: " + uriStr);
            return false;
        }
        this.mCTFEUrlQuery = this.getQueryWithoutDebugParameter(data);
        if (this.mPreviewMode == PreviewMode.CONTAINER || this.mPreviewMode == PreviewMode.CONTAINER_DEBUG) {
            this.mCTFEUrlPath = CTFE_URL_PATH_PREFIX + this.mCTFEUrlQuery;
        }
        this.mContainerId = this.getContainerId(this.mCTFEUrlQuery);
        return true;
    }

    private String getQueryWithoutDebugParameter(Uri data) {
        return data.getQuery().replace(BASE_DEBUG_QUERY, "");
    }

    PreviewMode getPreviewMode() {
        return this.mPreviewMode;
    }

    String getCTFEUrlPath() {
        return this.mCTFEUrlPath;
    }

    String getContainerId() {
        return this.mContainerId;
    }

    String getCTFEUrlDebugQuery() {
        return this.mCTFEUrlQuery;
    }

    void clear() {
        this.mPreviewMode = PreviewMode.NONE;
        this.mCTFEUrlPath = null;
        this.mContainerId = null;
        this.mCTFEUrlQuery = null;
    }

    private String getContainerId(String query) {
        String[] params = query.split("&");
        return params[0].split("=")[1];
    }

    static enum PreviewMode {
        NONE,
        CONTAINER,
        CONTAINER_DEBUG;

    }
}

