/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.analytics.containertag.common.FunctionType;
import com.google.analytics.containertag.common.Key;
import com.google.analytics.midtier.proto.containertag.TypeSystem;
import com.google.tagmanager.FunctionCallImplementation;
import com.google.tagmanager.TypedNumber;
import com.google.tagmanager.Types;
import java.util.Map;

class RandomMacro
extends FunctionCallImplementation {
    private static final String ID = FunctionType.RANDOM.toString();
    private static final String MIN = Key.MIN.toString();
    private static final String MAX = Key.MAX.toString();

    public static String getFunctionId() {
        return ID;
    }

    public RandomMacro() {
        super(ID, new String[0]);
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public TypeSystem.Value evaluate(Map<String, TypeSystem.Value> parameters) {
        double min = 0.0;
        double max = 2.147483647E9;
        TypeSystem.Value minParameter = parameters.get(MIN);
        TypeSystem.Value maxParameter = parameters.get(MAX);
        if (minParameter != null && minParameter != Types.getDefaultValue() && maxParameter != null && maxParameter != Types.getDefaultValue()) {
            double maxDouble;
            double minDouble;
            TypedNumber minValue = Types.valueToNumber(minParameter);
            TypedNumber maxValue = Types.valueToNumber(maxParameter);
            if (minValue != Types.getDefaultNumber() && maxValue != Types.getDefaultNumber() && (minDouble = minValue.doubleValue()) <= (maxDouble = maxValue.doubleValue())) {
                min = minDouble;
                max = maxDouble;
            }
        }
        return Types.objectToValue(Math.round(Math.random() * (max - min) + min));
    }
}

