/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager.protobuf.nano;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public class Extension<T> {
    public final int fieldNumber;
    public boolean isRepeatedField;
    public Class<T> fieldType;
    public Class<T> listType;

    private Extension(int fieldNumber, TypeLiteral<T> type) {
        this.fieldNumber = fieldNumber;
        this.isRepeatedField = ((TypeLiteral)type).isList();
        this.fieldType = ((TypeLiteral)type).getTargetClass();
        this.listType = this.isRepeatedField ? ((TypeLiteral)type).getListType() : null;
    }

    public static <T> Extension<T> create(int fieldNumber, TypeLiteral<T> type) {
        return new Extension<T>(fieldNumber, type);
    }

    public static <T> Extension<List<T>> createRepeated(int fieldNumber, TypeLiteral<List<T>> type) {
        return new Extension<List<T>>(fieldNumber, type);
    }

    public static abstract class TypeLiteral<T> {
        private final Type type;

        protected TypeLiteral() {
            Type superclass = this.getClass().getGenericSuperclass();
            if (superclass instanceof Class) {
                throw new RuntimeException("Missing type parameter");
            }
            this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        }

        private boolean isList() {
            return this.type instanceof ParameterizedType;
        }

        private Class<T> getListType() {
            return (Class)((ParameterizedType)this.type).getRawType();
        }

        private Class<T> getTargetClass() {
            if (this.isList()) {
                return (Class)((ParameterizedType)this.type).getActualTypeArguments()[0];
            }
            return (Class)this.type;
        }
    }
}

