; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=x86-64 -mattr=+sse4.1 | FileCheck %s --check-prefixes=CHECK,GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=slm -mattr=-sse4.2 | FileCheck %s --check-prefixes=CHECK,SLM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=sandybridge -mattr=-sse4.2 | FileCheck %s --check-prefixes=CHECK,SANDY-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=sandybridge -mattr=-avx2   | FileCheck %s --check-prefixes=CHECK,SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=ivybridge -mattr=-sse4.2 | FileCheck %s --check-prefixes=CHECK,SANDY-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=ivybridge -mattr=-avx2   | FileCheck %s --check-prefixes=CHECK,SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=haswell -mattr=-sse4.2 | FileCheck %s --check-prefixes=CHECK,HASWELL-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=haswell -mattr=-avx2   | FileCheck %s --check-prefixes=CHECK,HASWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=broadwell -mattr=-sse4.2 | FileCheck %s --check-prefixes=CHECK,BROADWELL-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=broadwell -mattr=-avx2   | FileCheck %s --check-prefixes=CHECK,BROADWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skylake -mattr=-sse4.2 | FileCheck %s --check-prefixes=CHECK,SKYLAKE-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skylake -mattr=-avx2   | FileCheck %s --check-prefixes=CHECK,SKYLAKE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skx -mattr=-sse4.2 | FileCheck %s --check-prefixes=CHECK,SKX-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skx -mattr=-avx2   | FileCheck %s --check-prefixes=CHECK,SKX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=btver2 -mattr=-sse4.2 | FileCheck %s --check-prefixes=CHECK,BTVER2-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=btver2 -mattr=-avx2   | FileCheck %s --check-prefixes=CHECK,BTVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=znver1 -mattr=-sse4.2 | FileCheck %s --check-prefixes=CHECK,ZNVER1-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=znver1 -mattr=-avx2   | FileCheck %s --check-prefixes=CHECK,ZNVER1

define <2 x double> @test_blendpd(<2 x double> %a0, <2 x double> %a1, <2 x double> *%a2) {
; GENERIC-LABEL: test_blendpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.50]
; GENERIC-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_blendpd:
; SLM:       # %bb.0:
; SLM-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:1.00]
; SLM-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_blendpd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.50]
; SANDY-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_blendpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.50]
; SANDY-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_blendpd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.33]
; HASWELL-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [7:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_blendpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.33]
; HASWELL-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_blendpd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.33]
; BROADWELL-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [6:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_blendpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.33]
; BROADWELL-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_blendpd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_blendpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.33]
; SKYLAKE-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_blendpd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.33]
; SKX-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [4:0.33]
; SKX-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_blendpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.33]
; SKX-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [4:0.33]
; SKX-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_blendpd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.50]
; BTVER2-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_blendpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.50]
; BTVER2-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_blendpd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.50]
; ZNVER1-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    blendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_blendpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],xmm1[1] sched: [1:0.50]
; ZNVER1-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vblendpd {{.*#+}} xmm0 = xmm0[0],mem[1] sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <2 x double> %a0, <2 x double> %a1, <2 x i32> <i32 0, i32 3>
  %2 = load <2 x double>, <2 x double> *%a2, align 16
  %3 = fadd <2 x double> %a1, %1
  %4 = shufflevector <2 x double> %3, <2 x double> %2, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %4
}

define <4 x float> @test_blendps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_blendps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.50]
; GENERIC-NEXT:    blendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [7:0.50]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_blendps:
; SLM:       # %bb.0:
; SLM-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:1.00]
; SLM-NEXT:    blendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [4:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_blendps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.50]
; SANDY-SSE-NEXT:    blendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [7:0.50]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_blendps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.50]
; SANDY-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [7:0.50]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_blendps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.33]
; HASWELL-SSE-NEXT:    blendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [7:0.50]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_blendps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.33]
; HASWELL-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [7:0.50]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_blendps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.33]
; BROADWELL-SSE-NEXT:    blendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [6:0.50]
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_blendps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.33]
; BROADWELL-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [6:0.50]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_blendps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    blendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_blendps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.33]
; SKYLAKE-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [7:0.50]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_blendps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.33]
; SKX-SSE-NEXT:    blendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [7:0.50]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_blendps:
; SKX:       # %bb.0:
; SKX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.33]
; SKX-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [7:0.50]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_blendps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.50]
; BTVER2-SSE-NEXT:    blendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [6:1.00]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_blendps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.50]
; BTVER2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [6:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_blendps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.50]
; ZNVER1-SSE-NEXT:    blendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [8:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_blendps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2],xmm0[3] sched: [1:0.50]
; ZNVER1-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],mem[1],xmm1[2,3] sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 0, i32 5, i32 6, i32 3>
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = shufflevector <4 x float> %a1, <4 x float> %2, <4 x i32> <i32 0, i32 5, i32 2, i32 3>
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}

define <2 x double> @test_blendvpd(<2 x double> %a0, <2 x double> %a1, <2 x double> %a2, <2 x double> *%a3) {
; GENERIC-LABEL: test_blendvpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movapd %xmm0, %xmm3 # sched: [1:1.00]
; GENERIC-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    blendvpd %xmm0, %xmm1, %xmm3 # sched: [2:1.00]
; GENERIC-NEXT:    blendvpd %xmm0, (%rdi), %xmm3 # sched: [8:1.00]
; GENERIC-NEXT:    movapd %xmm3, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_blendvpd:
; SLM:       # %bb.0:
; SLM-NEXT:    movapd %xmm0, %xmm3 # sched: [1:0.50]
; SLM-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    blendvpd %xmm0, %xmm1, %xmm3 # sched: [1:1.00]
; SLM-NEXT:    blendvpd %xmm0, (%rdi), %xmm3 # sched: [4:1.00]
; SLM-NEXT:    movapd %xmm3, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_blendvpd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movapd %xmm0, %xmm3 # sched: [1:1.00]
; SANDY-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; SANDY-SSE-NEXT:    blendvpd %xmm0, %xmm1, %xmm3 # sched: [2:1.00]
; SANDY-SSE-NEXT:    blendvpd %xmm0, (%rdi), %xmm3 # sched: [8:1.00]
; SANDY-SSE-NEXT:    movapd %xmm3, %xmm0 # sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_blendvpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; SANDY-NEXT:    vblendvpd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_blendvpd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movapd %xmm0, %xmm3 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    blendvpd %xmm0, %xmm1, %xmm3 # sched: [2:2.00]
; HASWELL-SSE-NEXT:    blendvpd %xmm0, (%rdi), %xmm3 # sched: [8:2.00]
; HASWELL-SSE-NEXT:    movapd %xmm3, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_blendvpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:2.00]
; HASWELL-NEXT:    vblendvpd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_blendvpd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movapd %xmm0, %xmm3 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    blendvpd %xmm0, %xmm1, %xmm3 # sched: [2:2.00]
; BROADWELL-SSE-NEXT:    blendvpd %xmm0, (%rdi), %xmm3 # sched: [7:2.00]
; BROADWELL-SSE-NEXT:    movapd %xmm3, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_blendvpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:2.00]
; BROADWELL-NEXT:    vblendvpd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_blendvpd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movapd %xmm0, %xmm3 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    blendvpd %xmm0, %xmm1, %xmm3 # sched: [2:0.67]
; SKYLAKE-SSE-NEXT:    blendvpd %xmm0, (%rdi), %xmm3 # sched: [8:0.67]
; SKYLAKE-SSE-NEXT:    movapd %xmm3, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_blendvpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:0.67]
; SKYLAKE-NEXT:    vblendvpd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_blendvpd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movapd %xmm0, %xmm3 # sched: [1:0.33]
; SKX-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    blendvpd %xmm0, %xmm1, %xmm3 # sched: [2:0.67]
; SKX-SSE-NEXT:    blendvpd %xmm0, (%rdi), %xmm3 # sched: [8:0.67]
; SKX-SSE-NEXT:    movapd %xmm3, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_blendvpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:0.67]
; SKX-NEXT:    vblendvpd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_blendvpd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movapd %xmm0, %xmm3 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    blendvpd %xmm0, %xmm1, %xmm3 # sched: [2:2.00]
; BTVER2-SSE-NEXT:    blendvpd %xmm0, (%rdi), %xmm3 # sched: [7:2.00]
; BTVER2-SSE-NEXT:    movapd %xmm3, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_blendvpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:2.00]
; BTVER2-NEXT:    vblendvpd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_blendvpd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movapd %xmm0, %xmm3 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    blendvpd %xmm0, %xmm1, %xmm3 # sched: [1:0.50]
; ZNVER1-SSE-NEXT:    blendvpd %xmm0, (%rdi), %xmm3 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    movapd %xmm3, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_blendvpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; ZNVER1-NEXT:    vblendvpd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <2 x double> @llvm.x86.sse41.blendvpd(<2 x double> %a0, <2 x double> %a1, <2 x double> %a2)
  %2 = load <2 x double>, <2 x double> *%a3, align 16
  %3 = call <2 x double> @llvm.x86.sse41.blendvpd(<2 x double> %1, <2 x double> %2, <2 x double> %a2)
  ret <2 x double> %3
}
declare <2 x double> @llvm.x86.sse41.blendvpd(<2 x double>, <2 x double>, <2 x double>) nounwind readnone

define <4 x float> @test_blendvps(<4 x float> %a0, <4 x float> %a1, <4 x float> %a2, <4 x float> *%a3) {
; GENERIC-LABEL: test_blendvps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movaps %xmm0, %xmm3 # sched: [1:1.00]
; GENERIC-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    blendvps %xmm0, %xmm1, %xmm3 # sched: [2:1.00]
; GENERIC-NEXT:    blendvps %xmm0, (%rdi), %xmm3 # sched: [8:1.00]
; GENERIC-NEXT:    movaps %xmm3, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_blendvps:
; SLM:       # %bb.0:
; SLM-NEXT:    movaps %xmm0, %xmm3 # sched: [1:0.50]
; SLM-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    blendvps %xmm0, %xmm1, %xmm3 # sched: [1:1.00]
; SLM-NEXT:    blendvps %xmm0, (%rdi), %xmm3 # sched: [4:1.00]
; SLM-NEXT:    movaps %xmm3, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_blendvps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movaps %xmm0, %xmm3 # sched: [1:1.00]
; SANDY-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; SANDY-SSE-NEXT:    blendvps %xmm0, %xmm1, %xmm3 # sched: [2:1.00]
; SANDY-SSE-NEXT:    blendvps %xmm0, (%rdi), %xmm3 # sched: [8:1.00]
; SANDY-SSE-NEXT:    movaps %xmm3, %xmm0 # sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_blendvps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; SANDY-NEXT:    vblendvps %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_blendvps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movaps %xmm0, %xmm3 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    blendvps %xmm0, %xmm1, %xmm3 # sched: [2:2.00]
; HASWELL-SSE-NEXT:    blendvps %xmm0, (%rdi), %xmm3 # sched: [8:2.00]
; HASWELL-SSE-NEXT:    movaps %xmm3, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_blendvps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:2.00]
; HASWELL-NEXT:    vblendvps %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_blendvps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movaps %xmm0, %xmm3 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    blendvps %xmm0, %xmm1, %xmm3 # sched: [2:2.00]
; BROADWELL-SSE-NEXT:    blendvps %xmm0, (%rdi), %xmm3 # sched: [7:2.00]
; BROADWELL-SSE-NEXT:    movaps %xmm3, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_blendvps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:2.00]
; BROADWELL-NEXT:    vblendvps %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_blendvps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movaps %xmm0, %xmm3 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    blendvps %xmm0, %xmm1, %xmm3 # sched: [2:0.67]
; SKYLAKE-SSE-NEXT:    blendvps %xmm0, (%rdi), %xmm3 # sched: [8:0.67]
; SKYLAKE-SSE-NEXT:    movaps %xmm3, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_blendvps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:0.67]
; SKYLAKE-NEXT:    vblendvps %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_blendvps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movaps %xmm0, %xmm3 # sched: [1:0.33]
; SKX-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    blendvps %xmm0, %xmm1, %xmm3 # sched: [2:0.67]
; SKX-SSE-NEXT:    blendvps %xmm0, (%rdi), %xmm3 # sched: [8:0.67]
; SKX-SSE-NEXT:    movaps %xmm3, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_blendvps:
; SKX:       # %bb.0:
; SKX-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:0.67]
; SKX-NEXT:    vblendvps %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_blendvps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movaps %xmm0, %xmm3 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    blendvps %xmm0, %xmm1, %xmm3 # sched: [2:2.00]
; BTVER2-SSE-NEXT:    blendvps %xmm0, (%rdi), %xmm3 # sched: [7:2.00]
; BTVER2-SSE-NEXT:    movaps %xmm3, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_blendvps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:2.00]
; BTVER2-NEXT:    vblendvps %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_blendvps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movaps %xmm0, %xmm3 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    blendvps %xmm0, %xmm1, %xmm3 # sched: [1:0.50]
; ZNVER1-SSE-NEXT:    blendvps %xmm0, (%rdi), %xmm3 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    movaps %xmm3, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_blendvps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; ZNVER1-NEXT:    vblendvps %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse41.blendvps(<4 x float> %a0, <4 x float> %a1, <4 x float> %a2)
  %2 = load <4 x float>, <4 x float> *%a3
  %3 = call <4 x float> @llvm.x86.sse41.blendvps(<4 x float> %1, <4 x float> %2, <4 x float> %a2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse41.blendvps(<4 x float>, <4 x float>, <4 x float>) nounwind readnone

define <2 x double> @test_dppd(<2 x double> %a0, <2 x double> %a1, <2 x double> *%a2) {
; GENERIC-LABEL: test_dppd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    dppd $7, %xmm1, %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    dppd $7, (%rdi), %xmm0 # sched: [15:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_dppd:
; SLM:       # %bb.0:
; SLM-NEXT:    dppd $7, %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    dppd $7, (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_dppd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    dppd $7, %xmm1, %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    dppd $7, (%rdi), %xmm0 # sched: [15:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_dppd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vdppd $7, %xmm1, %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    vdppd $7, (%rdi), %xmm0, %xmm0 # sched: [15:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_dppd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    dppd $7, %xmm1, %xmm0 # sched: [9:1.00]
; HASWELL-SSE-NEXT:    dppd $7, (%rdi), %xmm0 # sched: [15:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_dppd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vdppd $7, %xmm1, %xmm0, %xmm0 # sched: [9:1.00]
; HASWELL-NEXT:    vdppd $7, (%rdi), %xmm0, %xmm0 # sched: [15:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_dppd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    dppd $7, %xmm1, %xmm0 # sched: [9:1.00]
; BROADWELL-SSE-NEXT:    dppd $7, (%rdi), %xmm0 # sched: [14:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_dppd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vdppd $7, %xmm1, %xmm0, %xmm0 # sched: [9:1.00]
; BROADWELL-NEXT:    vdppd $7, (%rdi), %xmm0, %xmm0 # sched: [14:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_dppd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    dppd $7, %xmm1, %xmm0 # sched: [9:1.00]
; SKYLAKE-SSE-NEXT:    dppd $7, (%rdi), %xmm0 # sched: [15:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_dppd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vdppd $7, %xmm1, %xmm0, %xmm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    vdppd $7, (%rdi), %xmm0, %xmm0 # sched: [15:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_dppd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    dppd $7, %xmm1, %xmm0 # sched: [9:1.00]
; SKX-SSE-NEXT:    dppd $7, (%rdi), %xmm0 # sched: [15:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_dppd:
; SKX:       # %bb.0:
; SKX-NEXT:    vdppd $7, %xmm1, %xmm0, %xmm0 # sched: [9:1.00]
; SKX-NEXT:    vdppd $7, (%rdi), %xmm0, %xmm0 # sched: [15:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_dppd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    dppd $7, %xmm1, %xmm0 # sched: [9:3.00]
; BTVER2-SSE-NEXT:    dppd $7, (%rdi), %xmm0 # sched: [14:3.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_dppd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vdppd $7, %xmm1, %xmm0, %xmm0 # sched: [9:3.00]
; BTVER2-NEXT:    vdppd $7, (%rdi), %xmm0, %xmm0 # sched: [14:3.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_dppd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    dppd $7, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    dppd $7, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_dppd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vdppd $7, %xmm1, %xmm0, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    vdppd $7, (%rdi), %xmm0, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <2 x double> @llvm.x86.sse41.dppd(<2 x double> %a0, <2 x double> %a1, i8 7)
  %2 = load <2 x double>, <2 x double> *%a2, align 16
  %3 = call <2 x double> @llvm.x86.sse41.dppd(<2 x double> %1, <2 x double> %2, i8 7)
  ret <2 x double> %3
}
declare <2 x double> @llvm.x86.sse41.dppd(<2 x double>, <2 x double>, i8) nounwind readnone

define <4 x float> @test_dpps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_dpps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    dpps $7, %xmm1, %xmm0 # sched: [12:2.00]
; GENERIC-NEXT:    dpps $7, (%rdi), %xmm0 # sched: [18:2.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_dpps:
; SLM:       # %bb.0:
; SLM-NEXT:    dpps $7, %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    dpps $7, (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_dpps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    dpps $7, %xmm1, %xmm0 # sched: [12:2.00]
; SANDY-SSE-NEXT:    dpps $7, (%rdi), %xmm0 # sched: [18:2.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_dpps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vdpps $7, %xmm1, %xmm0, %xmm0 # sched: [12:2.00]
; SANDY-NEXT:    vdpps $7, (%rdi), %xmm0, %xmm0 # sched: [18:2.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_dpps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    dpps $7, %xmm1, %xmm0 # sched: [14:2.00]
; HASWELL-SSE-NEXT:    dpps $7, (%rdi), %xmm0 # sched: [20:2.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_dpps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vdpps $7, %xmm1, %xmm0, %xmm0 # sched: [14:2.00]
; HASWELL-NEXT:    vdpps $7, (%rdi), %xmm0, %xmm0 # sched: [20:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_dpps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    dpps $7, %xmm1, %xmm0 # sched: [14:2.00]
; BROADWELL-SSE-NEXT:    dpps $7, (%rdi), %xmm0 # sched: [19:2.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_dpps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vdpps $7, %xmm1, %xmm0, %xmm0 # sched: [14:2.00]
; BROADWELL-NEXT:    vdpps $7, (%rdi), %xmm0, %xmm0 # sched: [19:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_dpps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    dpps $7, %xmm1, %xmm0 # sched: [13:1.50]
; SKYLAKE-SSE-NEXT:    dpps $7, (%rdi), %xmm0 # sched: [19:1.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_dpps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vdpps $7, %xmm1, %xmm0, %xmm0 # sched: [13:1.50]
; SKYLAKE-NEXT:    vdpps $7, (%rdi), %xmm0, %xmm0 # sched: [19:1.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_dpps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    dpps $7, %xmm1, %xmm0 # sched: [13:1.33]
; SKX-SSE-NEXT:    dpps $7, (%rdi), %xmm0 # sched: [19:1.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_dpps:
; SKX:       # %bb.0:
; SKX-NEXT:    vdpps $7, %xmm1, %xmm0, %xmm0 # sched: [13:1.33]
; SKX-NEXT:    vdpps $7, (%rdi), %xmm0, %xmm0 # sched: [19:1.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_dpps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    dpps $7, %xmm1, %xmm0 # sched: [11:3.00]
; BTVER2-SSE-NEXT:    dpps $7, (%rdi), %xmm0 # sched: [16:3.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_dpps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vdpps $7, %xmm1, %xmm0, %xmm0 # sched: [11:3.00]
; BTVER2-NEXT:    vdpps $7, (%rdi), %xmm0, %xmm0 # sched: [16:3.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_dpps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    dpps $7, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    dpps $7, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_dpps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vdpps $7, %xmm1, %xmm0, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    vdpps $7, (%rdi), %xmm0, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse41.dpps(<4 x float> %a0, <4 x float> %a1, i8 7)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse41.dpps(<4 x float> %1, <4 x float> %2, i8 7)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse41.dpps(<4 x float>, <4 x float>, i8) nounwind readnone

define i32 @test_extractps(<4 x float> %a0, i32 *%a1) {
; GENERIC-LABEL: test_extractps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    extractps $3, %xmm0, %eax # sched: [3:1.00]
; GENERIC-NEXT:    extractps $1, %xmm0, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_extractps:
; SLM:       # %bb.0:
; SLM-NEXT:    extractps $3, %xmm0, %eax # sched: [1:1.00]
; SLM-NEXT:    extractps $1, %xmm0, (%rdi) # sched: [4:2.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_extractps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    extractps $3, %xmm0, %eax # sched: [3:1.00]
; SANDY-SSE-NEXT:    extractps $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_extractps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vextractps $3, %xmm0, %eax # sched: [3:1.00]
; SANDY-NEXT:    vextractps $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_extractps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    extractps $3, %xmm0, %eax # sched: [2:1.00]
; HASWELL-SSE-NEXT:    extractps $1, %xmm0, (%rdi) # sched: [2:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_extractps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vextractps $3, %xmm0, %eax # sched: [2:1.00]
; HASWELL-NEXT:    vextractps $1, %xmm0, (%rdi) # sched: [2:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_extractps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    extractps $3, %xmm0, %eax # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    extractps $1, %xmm0, (%rdi) # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_extractps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vextractps $3, %xmm0, %eax # sched: [2:1.00]
; BROADWELL-NEXT:    vextractps $1, %xmm0, (%rdi) # sched: [2:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_extractps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    extractps $3, %xmm0, %eax # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    extractps $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_extractps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vextractps $3, %xmm0, %eax # sched: [3:1.00]
; SKYLAKE-NEXT:    vextractps $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_extractps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    extractps $3, %xmm0, %eax # sched: [3:1.00]
; SKX-SSE-NEXT:    extractps $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_extractps:
; SKX:       # %bb.0:
; SKX-NEXT:    vextractps $3, %xmm0, %eax # sched: [3:1.00]
; SKX-NEXT:    vextractps $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_extractps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    extractps $3, %xmm0, %eax # sched: [3:1.00]
; BTVER2-SSE-NEXT:    extractps $1, %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_extractps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vextractps $3, %xmm0, %eax # sched: [3:1.00]
; BTVER2-NEXT:    vextractps $1, %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_extractps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    extractps $3, %xmm0, %eax # sched: [2:2.00]
; ZNVER1-SSE-NEXT:    extractps $1, %xmm0, (%rdi) # sched: [5:2.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_extractps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vextractps $3, %xmm0, %eax # sched: [2:2.00]
; ZNVER1-NEXT:    vextractps $1, %xmm0, (%rdi) # sched: [5:2.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = extractelement <4 x float> %a0, i32 3
  %2 = extractelement <4 x float> %a0, i32 1
  %3 = bitcast float %1 to i32
  %4 = bitcast float %2 to i32
  store i32 %4, i32 *%a1
  ret i32 %3
}

define <4 x float> @test_insertps(<4 x float> %a0, <4 x float> %a1, float *%a2) {
; GENERIC-LABEL: test_insertps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    insertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; GENERIC-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_insertps:
; SLM:       # %bb.0:
; SLM-NEXT:    insertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; SLM-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_insertps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    insertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; SANDY-SSE-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [7:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_insertps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; SANDY-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_insertps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    insertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; HASWELL-SSE-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [7:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_insertps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; HASWELL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_insertps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    insertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; BROADWELL-SSE-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [6:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_insertps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; BROADWELL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [6:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_insertps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    insertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [7:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_insertps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; SKYLAKE-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [7:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_insertps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    insertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; SKX-SSE-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [7:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_insertps:
; SKX:       # %bb.0:
; SKX-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:1.00]
; SKX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [7:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_insertps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    insertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:0.50]
; BTVER2-SSE-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_insertps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:0.50]
; BTVER2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_insertps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    insertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:0.50]
; ZNVER1-SSE-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_insertps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3] sched: [1:0.50]
; ZNVER1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0] sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse41.insertps(<4 x float> %a0, <4 x float> %a1, i8 17)
  %2 = load float, float *%a2
  %3 = insertelement <4 x float> %1, float %2, i32 3
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse41.insertps(<4 x float>, <4 x float>, i8) nounwind readnone

define <2 x i64> @test_movntdqa(i8* %a0) {
; GENERIC-LABEL: test_movntdqa:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movntdqa (%rdi), %xmm0 # sched: [6:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_movntdqa:
; SLM:       # %bb.0:
; SLM-NEXT:    movntdqa (%rdi), %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_movntdqa:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movntdqa (%rdi), %xmm0 # sched: [6:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movntdqa:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovntdqa (%rdi), %xmm0 # sched: [6:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_movntdqa:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movntdqa (%rdi), %xmm0 # sched: [6:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_movntdqa:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovntdqa (%rdi), %xmm0 # sched: [6:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_movntdqa:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movntdqa (%rdi), %xmm0 # sched: [5:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movntdqa:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovntdqa (%rdi), %xmm0 # sched: [5:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_movntdqa:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movntdqa (%rdi), %xmm0 # sched: [6:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movntdqa:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovntdqa (%rdi), %xmm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_movntdqa:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movntdqa (%rdi), %xmm0 # sched: [6:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movntdqa:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovntdqa (%rdi), %xmm0 # sched: [6:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_movntdqa:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movntdqa (%rdi), %xmm0 # sched: [5:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_movntdqa:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovntdqa (%rdi), %xmm0 # sched: [5:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_movntdqa:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movntdqa (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_movntdqa:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovntdqa (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <2 x i64> @llvm.x86.sse41.movntdqa(i8* %a0)
  ret <2 x i64> %1
}
declare <2 x i64> @llvm.x86.sse41.movntdqa(i8*) nounwind readnone

define <8 x i16> @test_mpsadbw(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> *%a2) {
; GENERIC-LABEL: test_mpsadbw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    mpsadbw $7, %xmm1, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    mpsadbw $7, (%rdi), %xmm0 # sched: [13:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_mpsadbw:
; SLM:       # %bb.0:
; SLM-NEXT:    mpsadbw $7, %xmm1, %xmm0 # sched: [7:1.00]
; SLM-NEXT:    mpsadbw $7, (%rdi), %xmm0 # sched: [10:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_mpsadbw:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    mpsadbw $7, %xmm1, %xmm0 # sched: [7:1.00]
; SANDY-SSE-NEXT:    mpsadbw $7, (%rdi), %xmm0 # sched: [13:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_mpsadbw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmpsadbw $7, %xmm1, %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    vmpsadbw $7, (%rdi), %xmm0, %xmm0 # sched: [13:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_mpsadbw:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    mpsadbw $7, %xmm1, %xmm0 # sched: [7:2.00]
; HASWELL-SSE-NEXT:    mpsadbw $7, (%rdi), %xmm0 # sched: [13:2.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_mpsadbw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmpsadbw $7, %xmm1, %xmm0, %xmm0 # sched: [7:2.00]
; HASWELL-NEXT:    vmpsadbw $7, (%rdi), %xmm0, %xmm0 # sched: [13:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_mpsadbw:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    mpsadbw $7, %xmm1, %xmm0 # sched: [7:2.00]
; BROADWELL-SSE-NEXT:    mpsadbw $7, (%rdi), %xmm0 # sched: [12:2.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_mpsadbw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmpsadbw $7, %xmm1, %xmm0, %xmm0 # sched: [7:2.00]
; BROADWELL-NEXT:    vmpsadbw $7, (%rdi), %xmm0, %xmm0 # sched: [12:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_mpsadbw:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    mpsadbw $7, %xmm1, %xmm0 # sched: [4:2.00]
; SKYLAKE-SSE-NEXT:    mpsadbw $7, (%rdi), %xmm0 # sched: [10:2.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_mpsadbw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmpsadbw $7, %xmm1, %xmm0, %xmm0 # sched: [4:2.00]
; SKYLAKE-NEXT:    vmpsadbw $7, (%rdi), %xmm0, %xmm0 # sched: [10:2.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_mpsadbw:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    mpsadbw $7, %xmm1, %xmm0 # sched: [4:2.00]
; SKX-SSE-NEXT:    mpsadbw $7, (%rdi), %xmm0 # sched: [10:2.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_mpsadbw:
; SKX:       # %bb.0:
; SKX-NEXT:    vmpsadbw $7, %xmm1, %xmm0, %xmm0 # sched: [4:2.00]
; SKX-NEXT:    vmpsadbw $7, (%rdi), %xmm0, %xmm0 # sched: [10:2.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_mpsadbw:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    mpsadbw $7, %xmm1, %xmm0 # sched: [3:2.00]
; BTVER2-SSE-NEXT:    mpsadbw $7, (%rdi), %xmm0 # sched: [8:2.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_mpsadbw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmpsadbw $7, %xmm1, %xmm0, %xmm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmpsadbw $7, (%rdi), %xmm0, %xmm0 # sched: [8:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_mpsadbw:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    mpsadbw $7, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    mpsadbw $7, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_mpsadbw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmpsadbw $7, %xmm1, %xmm0, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    vmpsadbw $7, (%rdi), %xmm0, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x i16> @llvm.x86.sse41.mpsadbw(<16 x i8> %a0, <16 x i8> %a1, i8 7)
  %2 = bitcast <8 x i16> %1 to <16 x i8>
  %3 = load <16 x i8>, <16 x i8> *%a2, align 16
  %4 = call <8 x i16> @llvm.x86.sse41.mpsadbw(<16 x i8> %2, <16 x i8> %3, i8 7)
  ret <8 x i16> %4
}
declare <8 x i16> @llvm.x86.sse41.mpsadbw(<16 x i8>, <16 x i8>, i8) nounwind readnone

define <8 x i16> @test_packusdw(<4 x i32> %a0, <4 x i32> %a1, <4 x i32> *%a2) {
; GENERIC-LABEL: test_packusdw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    packusdw %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    packusdw (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_packusdw:
; SLM:       # %bb.0:
; SLM-NEXT:    packusdw %xmm1, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    packusdw (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_packusdw:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    packusdw %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    packusdw (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_packusdw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpackusdw (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_packusdw:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    packusdw %xmm1, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    packusdw (%rdi), %xmm0 # sched: [7:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_packusdw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vpackusdw (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_packusdw:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    packusdw %xmm1, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    packusdw (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_packusdw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vpackusdw (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_packusdw:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    packusdw %xmm1, %xmm0 # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    packusdw (%rdi), %xmm0 # sched: [7:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_packusdw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vpackusdw (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_packusdw:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    packusdw %xmm1, %xmm0 # sched: [1:1.00]
; SKX-SSE-NEXT:    packusdw (%rdi), %xmm0 # sched: [7:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_packusdw:
; SKX:       # %bb.0:
; SKX-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SKX-NEXT:    vpackusdw (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_packusdw:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    packusdw %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    packusdw (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_packusdw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpackusdw (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_packusdw:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    packusdw %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    packusdw (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_packusdw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpackusdw (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x i16> @llvm.x86.sse41.packusdw(<4 x i32> %a0, <4 x i32> %a1)
  %2 = bitcast <8 x i16> %1 to <4 x i32>
  %3 = load <4 x i32>, <4 x i32> *%a2, align 16
  %4 = call <8 x i16> @llvm.x86.sse41.packusdw(<4 x i32> %2, <4 x i32> %3)
  ret <8 x i16> %4
}
declare <8 x i16> @llvm.x86.sse41.packusdw(<4 x i32>, <4 x i32>) nounwind readnone

define <16 x i8> @test_pblendvb(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> %a2, <16 x i8> *%a3) {
; GENERIC-LABEL: test_pblendvb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movdqa %xmm0, %xmm3 # sched: [1:0.33]
; GENERIC-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    pblendvb %xmm0, %xmm1, %xmm3 # sched: [2:1.00]
; GENERIC-NEXT:    pblendvb %xmm0, (%rdi), %xmm3 # sched: [8:1.00]
; GENERIC-NEXT:    movdqa %xmm3, %xmm0 # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pblendvb:
; SLM:       # %bb.0:
; SLM-NEXT:    movdqa %xmm0, %xmm3 # sched: [1:0.50]
; SLM-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pblendvb %xmm0, %xmm1, %xmm3 # sched: [1:1.00]
; SLM-NEXT:    pblendvb %xmm0, (%rdi), %xmm3 # sched: [4:1.00]
; SLM-NEXT:    movdqa %xmm3, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pblendvb:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movdqa %xmm0, %xmm3 # sched: [1:0.33]
; SANDY-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; SANDY-SSE-NEXT:    pblendvb %xmm0, %xmm1, %xmm3 # sched: [2:1.00]
; SANDY-SSE-NEXT:    pblendvb %xmm0, (%rdi), %xmm3 # sched: [8:1.00]
; SANDY-SSE-NEXT:    movdqa %xmm3, %xmm0 # sched: [1:0.33]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pblendvb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; SANDY-NEXT:    vpblendvb %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pblendvb:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movdqa %xmm0, %xmm3 # sched: [1:0.33]
; HASWELL-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    pblendvb %xmm0, %xmm1, %xmm3 # sched: [2:2.00]
; HASWELL-SSE-NEXT:    pblendvb %xmm0, (%rdi), %xmm3 # sched: [8:2.00]
; HASWELL-SSE-NEXT:    movdqa %xmm3, %xmm0 # sched: [1:0.33]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pblendvb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:2.00]
; HASWELL-NEXT:    vpblendvb %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pblendvb:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movdqa %xmm0, %xmm3 # sched: [1:0.33]
; BROADWELL-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pblendvb %xmm0, %xmm1, %xmm3 # sched: [2:2.00]
; BROADWELL-SSE-NEXT:    pblendvb %xmm0, (%rdi), %xmm3 # sched: [7:2.00]
; BROADWELL-SSE-NEXT:    movdqa %xmm3, %xmm0 # sched: [1:0.33]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pblendvb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:2.00]
; BROADWELL-NEXT:    vpblendvb %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pblendvb:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movdqa %xmm0, %xmm3 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    pblendvb %xmm0, %xmm1, %xmm3 # sched: [2:0.67]
; SKYLAKE-SSE-NEXT:    pblendvb %xmm0, (%rdi), %xmm3 # sched: [8:0.67]
; SKYLAKE-SSE-NEXT:    movdqa %xmm3, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pblendvb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:0.67]
; SKYLAKE-NEXT:    vpblendvb %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pblendvb:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movdqa %xmm0, %xmm3 # sched: [1:0.33]
; SKX-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    pblendvb %xmm0, %xmm1, %xmm3 # sched: [2:0.67]
; SKX-SSE-NEXT:    pblendvb %xmm0, (%rdi), %xmm3 # sched: [8:0.67]
; SKX-SSE-NEXT:    movdqa %xmm3, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pblendvb:
; SKX:       # %bb.0:
; SKX-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:0.67]
; SKX-NEXT:    vpblendvb %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pblendvb:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movdqa %xmm0, %xmm3 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pblendvb %xmm0, %xmm1, %xmm3 # sched: [2:2.00]
; BTVER2-SSE-NEXT:    pblendvb %xmm0, (%rdi), %xmm3 # sched: [7:2.00]
; BTVER2-SSE-NEXT:    movdqa %xmm3, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pblendvb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:2.00]
; BTVER2-NEXT:    vpblendvb %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pblendvb:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movdqa %xmm0, %xmm3 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    movaps %xmm2, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pblendvb %xmm0, %xmm1, %xmm3 # sched: [1:1.00]
; ZNVER1-SSE-NEXT:    pblendvb %xmm0, (%rdi), %xmm3 # sched: [8:1.00]
; ZNVER1-SSE-NEXT:    movdqa %xmm3, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pblendvb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; ZNVER1-NEXT:    vpblendvb %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <16 x i8> @llvm.x86.sse41.pblendvb(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> %a2)
  %2 = load <16 x i8>, <16 x i8> *%a3, align 16
  %3 = call <16 x i8> @llvm.x86.sse41.pblendvb(<16 x i8> %1, <16 x i8> %2, <16 x i8> %a2)
  ret <16 x i8> %3
}
declare <16 x i8> @llvm.x86.sse41.pblendvb(<16 x i8>, <16 x i8>, <16 x i8>) nounwind readnone

define <8 x i16> @test_pblendw(<8 x i16> %a0, <8 x i16> %a1, <8 x i16> *%a2) {
; GENERIC-LABEL: test_pblendw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:0.50]
; GENERIC-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [7:0.50]
; GENERIC-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pblendw:
; SLM:       # %bb.0:
; SLM-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:1.00]
; SLM-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [4:1.00]
; SLM-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pblendw:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:0.50]
; SANDY-SSE-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [7:0.50]
; SANDY-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pblendw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:0.50]
; SANDY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [7:0.50]
; SANDY-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pblendw:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:1.00]
; HASWELL-SSE-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [7:1.00]
; HASWELL-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pblendw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:1.00]
; HASWELL-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [7:1.00]
; HASWELL-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pblendw:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pblendw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:1.00]
; BROADWELL-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [6:1.00]
; BROADWELL-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pblendw:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [7:1.00]
; SKYLAKE-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pblendw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:1.00]
; SKYLAKE-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [7:1.00]
; SKYLAKE-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pblendw:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:1.00]
; SKX-SSE-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [7:1.00]
; SKX-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pblendw:
; SKX:       # %bb.0:
; SKX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:1.00]
; SKX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [7:1.00]
; SKX-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pblendw:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:0.50]
; BTVER2-SSE-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pblendw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:0.50]
; BTVER2-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [6:1.00]
; BTVER2-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pblendw:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:0.33]
; ZNVER1-SSE-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pblendw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7] sched: [1:0.33]
; ZNVER1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6],mem[7] sched: [8:0.50]
; ZNVER1-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x i16> %a0, <8 x i16> %a1, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %2 = load <8 x i16>, <8 x i16> *%a2, align 16
  %3 = shufflevector <8 x i16> %a1, <8 x i16> %2, <8 x i32> <i32 0, i32 1, i32 10, i32 11, i32 4, i32 5, i32 6, i32 15>
  %4 = add <8 x i16> %1, %3
  ret <8 x i16> %4
}

define <2 x i64> @test_pcmpeqq(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_pcmpeqq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pcmpeqq %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    pcmpeqq (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pcmpeqq:
; SLM:       # %bb.0:
; SLM-NEXT:    pcmpeqq %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pcmpeqq (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pcmpeqq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pcmpeqq %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pcmpeqq (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pcmpeqq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpcmpeqq (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pcmpeqq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pcmpeqq %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    pcmpeqq (%rdi), %xmm0 # sched: [7:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pcmpeqq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    vpcmpeqq (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pcmpeqq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pcmpeqq %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    pcmpeqq (%rdi), %xmm0 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpeqq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    vpcmpeqq (%rdi), %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pcmpeqq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pcmpeqq %xmm1, %xmm0 # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    pcmpeqq (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpeqq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    vpcmpeqq (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pcmpeqq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pcmpeqq %xmm1, %xmm0 # sched: [1:0.50]
; SKX-SSE-NEXT:    pcmpeqq (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpeqq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKX-NEXT:    vpcmpeqq (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pcmpeqq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pcmpeqq %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pcmpeqq (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pcmpeqq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpcmpeqq (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pcmpeqq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pcmpeqq %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pcmpeqq (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pcmpeqq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpcmpeqq (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = icmp eq <2 x i64> %a0, %a1
  %2 = sext <2 x i1> %1 to <2 x i64>
  %3 = load <2 x i64>, <2 x i64>*%a2, align 16
  %4 = icmp eq <2 x i64> %2, %3
  %5 = sext <2 x i1> %4 to <2 x i64>
  ret <2 x i64> %5
}

define i32 @test_pextrb(<16 x i8> %a0, i8 *%a1) {
; GENERIC-LABEL: test_pextrb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pextrb $3, %xmm0, %eax # sched: [3:1.00]
; GENERIC-NEXT:    pextrb $1, %xmm0, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pextrb:
; SLM:       # %bb.0:
; SLM-NEXT:    pextrb $3, %xmm0, %eax # sched: [1:1.00]
; SLM-NEXT:    pextrb $1, %xmm0, (%rdi) # sched: [4:2.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pextrb:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pextrb $3, %xmm0, %eax # sched: [3:1.00]
; SANDY-SSE-NEXT:    pextrb $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pextrb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpextrb $3, %xmm0, %eax # sched: [3:1.00]
; SANDY-NEXT:    vpextrb $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pextrb:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pextrb $3, %xmm0, %eax # sched: [2:1.00]
; HASWELL-SSE-NEXT:    pextrb $1, %xmm0, (%rdi) # sched: [2:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pextrb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpextrb $3, %xmm0, %eax # sched: [2:1.00]
; HASWELL-NEXT:    vpextrb $1, %xmm0, (%rdi) # sched: [2:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pextrb:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pextrb $3, %xmm0, %eax # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    pextrb $1, %xmm0, (%rdi) # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pextrb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpextrb $3, %xmm0, %eax # sched: [2:1.00]
; BROADWELL-NEXT:    vpextrb $1, %xmm0, (%rdi) # sched: [2:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pextrb:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pextrb $3, %xmm0, %eax # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    pextrb $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pextrb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpextrb $3, %xmm0, %eax # sched: [3:1.00]
; SKYLAKE-NEXT:    vpextrb $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pextrb:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pextrb $3, %xmm0, %eax # sched: [3:1.00]
; SKX-SSE-NEXT:    pextrb $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pextrb:
; SKX:       # %bb.0:
; SKX-NEXT:    vpextrb $3, %xmm0, %eax # sched: [3:1.00]
; SKX-NEXT:    vpextrb $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pextrb:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pextrb $3, %xmm0, %eax # sched: [3:1.00]
; BTVER2-SSE-NEXT:    pextrb $1, %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pextrb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpextrb $3, %xmm0, %eax # sched: [3:1.00]
; BTVER2-NEXT:    vpextrb $1, %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pextrb:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pextrb $3, %xmm0, %eax # sched: [2:2.00]
; ZNVER1-SSE-NEXT:    pextrb $1, %xmm0, (%rdi) # sched: [5:3.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pextrb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpextrb $3, %xmm0, %eax # sched: [2:2.00]
; ZNVER1-NEXT:    vpextrb $1, %xmm0, (%rdi) # sched: [5:3.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = extractelement <16 x i8> %a0, i32 3
  %2 = extractelement <16 x i8> %a0, i32 1
  store i8 %2, i8 *%a1
  %3 = zext i8 %1 to i32
  ret i32 %3
}

define i32 @test_pextrd(<4 x i32> %a0, i32 *%a1) {
; GENERIC-LABEL: test_pextrd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    paddd %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    pextrd $3, %xmm0, %eax # sched: [3:1.00]
; GENERIC-NEXT:    pextrd $1, %xmm0, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pextrd:
; SLM:       # %bb.0:
; SLM-NEXT:    paddd %xmm0, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pextrd $3, %xmm0, %eax # sched: [1:1.00]
; SLM-NEXT:    pextrd $1, %xmm0, (%rdi) # sched: [4:2.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pextrd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    paddd %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pextrd $3, %xmm0, %eax # sched: [3:1.00]
; SANDY-SSE-NEXT:    pextrd $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pextrd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpaddd %xmm0, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpextrd $3, %xmm0, %eax # sched: [3:1.00]
; SANDY-NEXT:    vpextrd $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pextrd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    paddd %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    pextrd $3, %xmm0, %eax # sched: [2:1.00]
; HASWELL-SSE-NEXT:    pextrd $1, %xmm0, (%rdi) # sched: [2:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pextrd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpaddd %xmm0, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    vpextrd $3, %xmm0, %eax # sched: [2:1.00]
; HASWELL-NEXT:    vpextrd $1, %xmm0, (%rdi) # sched: [2:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pextrd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    paddd %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    pextrd $3, %xmm0, %eax # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    pextrd $1, %xmm0, (%rdi) # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pextrd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpaddd %xmm0, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    vpextrd $3, %xmm0, %eax # sched: [2:1.00]
; BROADWELL-NEXT:    vpextrd $1, %xmm0, (%rdi) # sched: [2:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pextrd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    paddd %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    pextrd $3, %xmm0, %eax # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    pextrd $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pextrd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpaddd %xmm0, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vpextrd $3, %xmm0, %eax # sched: [3:1.00]
; SKYLAKE-NEXT:    vpextrd $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pextrd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    paddd %xmm0, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    pextrd $3, %xmm0, %eax # sched: [3:1.00]
; SKX-SSE-NEXT:    pextrd $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pextrd:
; SKX:       # %bb.0:
; SKX-NEXT:    vpaddd %xmm0, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    vpextrd $3, %xmm0, %eax # sched: [3:1.00]
; SKX-NEXT:    vpextrd $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pextrd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    paddd %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pextrd $3, %xmm0, %eax # sched: [3:1.00]
; BTVER2-SSE-NEXT:    pextrd $1, %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pextrd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpaddd %xmm0, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpextrd $3, %xmm0, %eax # sched: [3:1.00]
; BTVER2-NEXT:    vpextrd $1, %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pextrd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    paddd %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pextrd $3, %xmm0, %eax # sched: [2:2.00]
; ZNVER1-SSE-NEXT:    pextrd $1, %xmm0, (%rdi) # sched: [5:3.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pextrd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpaddd %xmm0, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpextrd $3, %xmm0, %eax # sched: [2:2.00]
; ZNVER1-NEXT:    vpextrd $1, %xmm0, (%rdi) # sched: [5:3.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = add <4 x i32> %a0, %a0
  %2 = extractelement <4 x i32> %1, i32 3
  %3 = extractelement <4 x i32> %1, i32 1
  store i32 %3, i32 *%a1
  ret i32 %2
}

define i64 @test_pextrq(<2 x i64> %a0, <2 x i64> %a1, i64 *%a2) {
; GENERIC-LABEL: test_pextrq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pextrq $1, %xmm0, %rax # sched: [3:1.00]
; GENERIC-NEXT:    pextrq $1, %xmm0, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pextrq:
; SLM:       # %bb.0:
; SLM-NEXT:    pextrq $1, %xmm0, %rax # sched: [1:1.00]
; SLM-NEXT:    pextrq $1, %xmm0, (%rdi) # sched: [4:2.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pextrq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pextrq $1, %xmm0, %rax # sched: [3:1.00]
; SANDY-SSE-NEXT:    pextrq $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pextrq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpextrq $1, %xmm0, %rax # sched: [3:1.00]
; SANDY-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pextrq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pextrq $1, %xmm0, %rax # sched: [2:1.00]
; HASWELL-SSE-NEXT:    pextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pextrq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpextrq $1, %xmm0, %rax # sched: [2:1.00]
; HASWELL-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pextrq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pextrq $1, %xmm0, %rax # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    pextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pextrq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpextrq $1, %xmm0, %rax # sched: [2:1.00]
; BROADWELL-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pextrq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pextrq $1, %xmm0, %rax # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    pextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pextrq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpextrq $1, %xmm0, %rax # sched: [3:1.00]
; SKYLAKE-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pextrq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pextrq $1, %xmm0, %rax # sched: [3:1.00]
; SKX-SSE-NEXT:    pextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pextrq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpextrq $1, %xmm0, %rax # sched: [3:1.00]
; SKX-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pextrq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pextrq $1, %xmm0, %rax # sched: [3:1.00]
; BTVER2-SSE-NEXT:    pextrq $1, %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pextrq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpextrq $1, %xmm0, %rax # sched: [3:1.00]
; BTVER2-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pextrq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pextrq $1, %xmm0, %rax # sched: [2:2.00]
; ZNVER1-SSE-NEXT:    pextrq $1, %xmm0, (%rdi) # sched: [5:3.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pextrq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpextrq $1, %xmm0, %rax # sched: [2:2.00]
; ZNVER1-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [5:3.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = extractelement <2 x i64> %a0, i32 1
  %2 = extractelement <2 x i64> %a0, i32 1
  store i64 %2, i64 *%a2
  ret i64 %1
}

define i32 @test_pextrw(<8 x i16> %a0, i16 *%a1) {
; GENERIC-LABEL: test_pextrw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pextrw $3, %xmm0, %eax # sched: [3:1.00]
; GENERIC-NEXT:    pextrw $1, %xmm0, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pextrw:
; SLM:       # %bb.0:
; SLM-NEXT:    pextrw $3, %xmm0, %eax # sched: [1:1.00]
; SLM-NEXT:    pextrw $1, %xmm0, (%rdi) # sched: [4:2.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pextrw:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pextrw $3, %xmm0, %eax # sched: [3:1.00]
; SANDY-SSE-NEXT:    pextrw $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pextrw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpextrw $3, %xmm0, %eax # sched: [3:1.00]
; SANDY-NEXT:    vpextrw $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pextrw:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pextrw $3, %xmm0, %eax # sched: [2:1.00]
; HASWELL-SSE-NEXT:    pextrw $1, %xmm0, (%rdi) # sched: [2:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pextrw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpextrw $3, %xmm0, %eax # sched: [2:1.00]
; HASWELL-NEXT:    vpextrw $1, %xmm0, (%rdi) # sched: [2:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pextrw:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pextrw $3, %xmm0, %eax # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    pextrw $1, %xmm0, (%rdi) # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pextrw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpextrw $3, %xmm0, %eax # sched: [2:1.00]
; BROADWELL-NEXT:    vpextrw $1, %xmm0, (%rdi) # sched: [2:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pextrw:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pextrw $3, %xmm0, %eax # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    pextrw $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pextrw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpextrw $3, %xmm0, %eax # sched: [3:1.00]
; SKYLAKE-NEXT:    vpextrw $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pextrw:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pextrw $3, %xmm0, %eax # sched: [3:1.00]
; SKX-SSE-NEXT:    pextrw $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pextrw:
; SKX:       # %bb.0:
; SKX-NEXT:    vpextrw $3, %xmm0, %eax # sched: [3:1.00]
; SKX-NEXT:    vpextrw $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pextrw:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pextrw $3, %xmm0, %eax # sched: [3:1.00]
; BTVER2-SSE-NEXT:    pextrw $1, %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pextrw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpextrw $3, %xmm0, %eax # sched: [3:1.00]
; BTVER2-NEXT:    vpextrw $1, %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pextrw:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pextrw $3, %xmm0, %eax # sched: [2:2.00]
; ZNVER1-SSE-NEXT:    pextrw $1, %xmm0, (%rdi) # sched: [5:3.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pextrw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpextrw $3, %xmm0, %eax # sched: [2:2.00]
; ZNVER1-NEXT:    vpextrw $1, %xmm0, (%rdi) # sched: [5:3.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = extractelement <8 x i16> %a0, i32 3
  %2 = extractelement <8 x i16> %a0, i32 1
  store i16 %2, i16 *%a1
  %3 = zext i16 %1 to i32
  ret i32 %3
}

define <8 x i16> @test_phminposuw(<8 x i16> *%a0) {
; GENERIC-LABEL: test_phminposuw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    phminposuw (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    phminposuw %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_phminposuw:
; SLM:       # %bb.0:
; SLM-NEXT:    phminposuw (%rdi), %xmm0 # sched: [7:1.00]
; SLM-NEXT:    phminposuw %xmm0, %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_phminposuw:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    phminposuw (%rdi), %xmm0 # sched: [11:1.00]
; SANDY-SSE-NEXT:    phminposuw %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_phminposuw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vphminposuw (%rdi), %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    vphminposuw %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_phminposuw:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    phminposuw (%rdi), %xmm0 # sched: [11:1.00]
; HASWELL-SSE-NEXT:    phminposuw %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_phminposuw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vphminposuw (%rdi), %xmm0 # sched: [11:1.00]
; HASWELL-NEXT:    vphminposuw %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_phminposuw:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    phminposuw (%rdi), %xmm0 # sched: [10:1.00]
; BROADWELL-SSE-NEXT:    phminposuw %xmm0, %xmm0 # sched: [5:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_phminposuw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vphminposuw (%rdi), %xmm0 # sched: [10:1.00]
; BROADWELL-NEXT:    vphminposuw %xmm0, %xmm0 # sched: [5:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_phminposuw:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    phminposuw (%rdi), %xmm0 # sched: [10:0.50]
; SKYLAKE-SSE-NEXT:    phminposuw %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_phminposuw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vphminposuw (%rdi), %xmm0 # sched: [10:0.50]
; SKYLAKE-NEXT:    vphminposuw %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_phminposuw:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    phminposuw (%rdi), %xmm0 # sched: [10:0.50]
; SKX-SSE-NEXT:    phminposuw %xmm0, %xmm0 # sched: [4:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_phminposuw:
; SKX:       # %bb.0:
; SKX-NEXT:    vphminposuw (%rdi), %xmm0 # sched: [10:0.50]
; SKX-NEXT:    vphminposuw %xmm0, %xmm0 # sched: [4:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_phminposuw:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    phminposuw (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    phminposuw %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_phminposuw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vphminposuw (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    vphminposuw %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_phminposuw:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    phminposuw (%rdi), %xmm0 # sched: [11:1.00]
; ZNVER1-SSE-NEXT:    phminposuw %xmm0, %xmm0 # sched: [4:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_phminposuw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vphminposuw (%rdi), %xmm0 # sched: [11:1.00]
; ZNVER1-NEXT:    vphminposuw %xmm0, %xmm0 # sched: [4:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load <8 x i16>, <8 x i16> *%a0, align 16
  %2 = call <8 x i16> @llvm.x86.sse41.phminposuw(<8 x i16> %1)
  %3 = call <8 x i16> @llvm.x86.sse41.phminposuw(<8 x i16> %2)
  ret <8 x i16> %3
}
declare <8 x i16> @llvm.x86.sse41.phminposuw(<8 x i16>) nounwind readnone

define <16 x i8> @test_pinsrb(<16 x i8> %a0, i8 %a1, i8 *%a2) {
; GENERIC-LABEL: test_pinsrb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pinsrb $1, %edi, %xmm0 # sched: [2:1.00]
; GENERIC-NEXT:    pinsrb $3, (%rsi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pinsrb:
; SLM:       # %bb.0:
; SLM-NEXT:    pinsrb $1, %edi, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    pinsrb $3, (%rsi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pinsrb:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pinsrb $1, %edi, %xmm0 # sched: [2:1.00]
; SANDY-SSE-NEXT:    pinsrb $3, (%rsi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pinsrb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpinsrb $1, %edi, %xmm0, %xmm0 # sched: [2:1.00]
; SANDY-NEXT:    vpinsrb $3, (%rsi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pinsrb:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pinsrb $1, %edi, %xmm0 # sched: [2:2.00]
; HASWELL-SSE-NEXT:    pinsrb $3, (%rsi), %xmm0 # sched: [6:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pinsrb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpinsrb $1, %edi, %xmm0, %xmm0 # sched: [2:2.00]
; HASWELL-NEXT:    vpinsrb $3, (%rsi), %xmm0, %xmm0 # sched: [6:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pinsrb:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pinsrb $1, %edi, %xmm0 # sched: [2:2.00]
; BROADWELL-SSE-NEXT:    pinsrb $3, (%rsi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pinsrb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpinsrb $1, %edi, %xmm0, %xmm0 # sched: [2:2.00]
; BROADWELL-NEXT:    vpinsrb $3, (%rsi), %xmm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pinsrb:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pinsrb $1, %edi, %xmm0 # sched: [2:2.00]
; SKYLAKE-SSE-NEXT:    pinsrb $3, (%rsi), %xmm0 # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pinsrb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpinsrb $1, %edi, %xmm0, %xmm0 # sched: [2:2.00]
; SKYLAKE-NEXT:    vpinsrb $3, (%rsi), %xmm0, %xmm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pinsrb:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pinsrb $1, %edi, %xmm0 # sched: [2:2.00]
; SKX-SSE-NEXT:    pinsrb $3, (%rsi), %xmm0 # sched: [6:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pinsrb:
; SKX:       # %bb.0:
; SKX-NEXT:    vpinsrb $1, %edi, %xmm0, %xmm0 # sched: [2:2.00]
; SKX-NEXT:    vpinsrb $3, (%rsi), %xmm0, %xmm0 # sched: [6:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pinsrb:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pinsrb $1, %edi, %xmm0 # sched: [7:0.50]
; BTVER2-SSE-NEXT:    pinsrb $3, (%rsi), %xmm0 # sched: [4:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pinsrb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpinsrb $1, %edi, %xmm0, %xmm0 # sched: [7:0.50]
; BTVER2-NEXT:    vpinsrb $3, (%rsi), %xmm0, %xmm0 # sched: [4:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pinsrb:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pinsrb $1, %edi, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pinsrb $3, (%rsi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pinsrb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpinsrb $1, %edi, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpinsrb $3, (%rsi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = insertelement <16 x i8> %a0, i8 %a1, i32 1
  %2 = load i8, i8 *%a2
  %3 = insertelement <16 x i8> %1, i8 %2, i32 3
  ret <16 x i8> %3
}

define <4 x i32> @test_pinsrd(<4 x i32> %a0, i32 %a1, i32 *%a2) {
; GENERIC-LABEL: test_pinsrd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pinsrd $1, %edi, %xmm0 # sched: [2:1.00]
; GENERIC-NEXT:    pinsrd $3, (%rsi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pinsrd:
; SLM:       # %bb.0:
; SLM-NEXT:    pinsrd $1, %edi, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    pinsrd $3, (%rsi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pinsrd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pinsrd $1, %edi, %xmm0 # sched: [2:1.00]
; SANDY-SSE-NEXT:    pinsrd $3, (%rsi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pinsrd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpinsrd $1, %edi, %xmm0, %xmm0 # sched: [2:1.00]
; SANDY-NEXT:    vpinsrd $3, (%rsi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pinsrd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pinsrd $1, %edi, %xmm0 # sched: [2:2.00]
; HASWELL-SSE-NEXT:    pinsrd $3, (%rsi), %xmm0 # sched: [6:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pinsrd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpinsrd $1, %edi, %xmm0, %xmm0 # sched: [2:2.00]
; HASWELL-NEXT:    vpinsrd $3, (%rsi), %xmm0, %xmm0 # sched: [6:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pinsrd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pinsrd $1, %edi, %xmm0 # sched: [2:2.00]
; BROADWELL-SSE-NEXT:    pinsrd $3, (%rsi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pinsrd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpinsrd $1, %edi, %xmm0, %xmm0 # sched: [2:2.00]
; BROADWELL-NEXT:    vpinsrd $3, (%rsi), %xmm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pinsrd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pinsrd $1, %edi, %xmm0 # sched: [2:2.00]
; SKYLAKE-SSE-NEXT:    pinsrd $3, (%rsi), %xmm0 # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pinsrd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpinsrd $1, %edi, %xmm0, %xmm0 # sched: [2:2.00]
; SKYLAKE-NEXT:    vpinsrd $3, (%rsi), %xmm0, %xmm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pinsrd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pinsrd $1, %edi, %xmm0 # sched: [2:2.00]
; SKX-SSE-NEXT:    pinsrd $3, (%rsi), %xmm0 # sched: [6:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pinsrd:
; SKX:       # %bb.0:
; SKX-NEXT:    vpinsrd $1, %edi, %xmm0, %xmm0 # sched: [2:2.00]
; SKX-NEXT:    vpinsrd $3, (%rsi), %xmm0, %xmm0 # sched: [6:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pinsrd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pinsrd $1, %edi, %xmm0 # sched: [7:0.50]
; BTVER2-SSE-NEXT:    pinsrd $3, (%rsi), %xmm0 # sched: [4:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pinsrd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpinsrd $1, %edi, %xmm0, %xmm0 # sched: [7:0.50]
; BTVER2-NEXT:    vpinsrd $3, (%rsi), %xmm0, %xmm0 # sched: [4:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pinsrd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pinsrd $1, %edi, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pinsrd $3, (%rsi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pinsrd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpinsrd $1, %edi, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpinsrd $3, (%rsi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = insertelement <4 x i32> %a0, i32 %a1, i32 1
  %2 = load i32, i32 *%a2
  %3 = insertelement <4 x i32> %1, i32 %2, i32 3
  ret <4 x i32> %3
}

define <2 x i64> @test_pinsrq(<2 x i64> %a0, <2 x i64> %a1, i64 %a2, i64 *%a3) {
; GENERIC-LABEL: test_pinsrq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pinsrq $1, %rdi, %xmm0 # sched: [2:1.00]
; GENERIC-NEXT:    pinsrq $1, (%rsi), %xmm1 # sched: [7:0.50]
; GENERIC-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pinsrq:
; SLM:       # %bb.0:
; SLM-NEXT:    pinsrq $1, (%rsi), %xmm1 # sched: [4:1.00]
; SLM-NEXT:    pinsrq $1, %rdi, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pinsrq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pinsrq $1, %rdi, %xmm0 # sched: [2:1.00]
; SANDY-SSE-NEXT:    pinsrq $1, (%rsi), %xmm1 # sched: [7:0.50]
; SANDY-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pinsrq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpinsrq $1, %rdi, %xmm0, %xmm0 # sched: [2:1.00]
; SANDY-NEXT:    vpinsrq $1, (%rsi), %xmm1, %xmm1 # sched: [7:0.50]
; SANDY-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pinsrq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pinsrq $1, %rdi, %xmm0 # sched: [2:2.00]
; HASWELL-SSE-NEXT:    pinsrq $1, (%rsi), %xmm1 # sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pinsrq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpinsrq $1, %rdi, %xmm0, %xmm0 # sched: [2:2.00]
; HASWELL-NEXT:    vpinsrq $1, (%rsi), %xmm1, %xmm1 # sched: [6:1.00]
; HASWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pinsrq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pinsrq $1, %rdi, %xmm0 # sched: [2:2.00]
; BROADWELL-SSE-NEXT:    pinsrq $1, (%rsi), %xmm1 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pinsrq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpinsrq $1, %rdi, %xmm0, %xmm0 # sched: [2:2.00]
; BROADWELL-NEXT:    vpinsrq $1, (%rsi), %xmm1, %xmm1 # sched: [6:1.00]
; BROADWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pinsrq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pinsrq $1, %rdi, %xmm0 # sched: [2:2.00]
; SKYLAKE-SSE-NEXT:    pinsrq $1, (%rsi), %xmm1 # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pinsrq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpinsrq $1, %rdi, %xmm0, %xmm0 # sched: [2:2.00]
; SKYLAKE-NEXT:    vpinsrq $1, (%rsi), %xmm1, %xmm1 # sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pinsrq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pinsrq $1, %rdi, %xmm0 # sched: [2:2.00]
; SKX-SSE-NEXT:    pinsrq $1, (%rsi), %xmm1 # sched: [6:1.00]
; SKX-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pinsrq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpinsrq $1, %rdi, %xmm0, %xmm0 # sched: [2:2.00]
; SKX-NEXT:    vpinsrq $1, (%rsi), %xmm1, %xmm1 # sched: [6:1.00]
; SKX-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pinsrq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pinsrq $1, %rdi, %xmm0 # sched: [7:0.50]
; BTVER2-SSE-NEXT:    pinsrq $1, (%rsi), %xmm1 # sched: [4:1.00]
; BTVER2-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pinsrq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpinsrq $1, %rdi, %xmm0, %xmm0 # sched: [7:0.50]
; BTVER2-NEXT:    vpinsrq $1, (%rsi), %xmm1, %xmm1 # sched: [4:1.00]
; BTVER2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pinsrq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pinsrq $1, (%rsi), %xmm1 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    pinsrq $1, %rdi, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pinsrq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpinsrq $1, (%rsi), %xmm1, %xmm1 # sched: [8:0.50]
; ZNVER1-NEXT:    vpinsrq $1, %rdi, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = insertelement <2 x i64> %a0, i64 %a2, i32 1
  %2 = load i64, i64 *%a3
  %3 = insertelement <2 x i64> %a1, i64 %2, i32 1
  %4 = add <2 x i64> %1, %3
  ret <2 x i64> %4
}

define <16 x i8> @test_pmaxsb(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> *%a2) {
; GENERIC-LABEL: test_pmaxsb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmaxsb %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    pmaxsb (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmaxsb:
; SLM:       # %bb.0:
; SLM-NEXT:    pmaxsb %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pmaxsb (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmaxsb:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmaxsb %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pmaxsb (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmaxsb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpmaxsb (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmaxsb:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmaxsb %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    pmaxsb (%rdi), %xmm0 # sched: [7:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmaxsb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    vpmaxsb (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmaxsb:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmaxsb %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    pmaxsb (%rdi), %xmm0 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmaxsb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    vpmaxsb (%rdi), %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmaxsb:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmaxsb %xmm1, %xmm0 # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    pmaxsb (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmaxsb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    vpmaxsb (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmaxsb:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmaxsb %xmm1, %xmm0 # sched: [1:0.50]
; SKX-SSE-NEXT:    pmaxsb (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmaxsb:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKX-NEXT:    vpmaxsb (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmaxsb:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmaxsb %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmaxsb (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmaxsb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpmaxsb (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmaxsb:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmaxsb %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmaxsb (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmaxsb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpmaxsb (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <16 x i8> @llvm.x86.sse41.pmaxsb(<16 x i8> %a0, <16 x i8> %a1)
  %2 = load <16 x i8>, <16 x i8> *%a2, align 16
  %3 = call <16 x i8> @llvm.x86.sse41.pmaxsb(<16 x i8> %1, <16 x i8> %2)
  ret <16 x i8> %3
}
declare <16 x i8> @llvm.x86.sse41.pmaxsb(<16 x i8>, <16 x i8>) nounwind readnone

define <4 x i32> @test_pmaxsd(<4 x i32> %a0, <4 x i32> %a1, <4 x i32> *%a2) {
; GENERIC-LABEL: test_pmaxsd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmaxsd %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    pmaxsd (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmaxsd:
; SLM:       # %bb.0:
; SLM-NEXT:    pmaxsd %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pmaxsd (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmaxsd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmaxsd %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pmaxsd (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmaxsd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpmaxsd (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmaxsd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmaxsd %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    pmaxsd (%rdi), %xmm0 # sched: [7:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmaxsd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    vpmaxsd (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmaxsd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmaxsd %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    pmaxsd (%rdi), %xmm0 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmaxsd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    vpmaxsd (%rdi), %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmaxsd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmaxsd %xmm1, %xmm0 # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    pmaxsd (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmaxsd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    vpmaxsd (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmaxsd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmaxsd %xmm1, %xmm0 # sched: [1:0.50]
; SKX-SSE-NEXT:    pmaxsd (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmaxsd:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKX-NEXT:    vpmaxsd (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmaxsd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmaxsd %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmaxsd (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmaxsd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpmaxsd (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmaxsd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmaxsd %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmaxsd (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmaxsd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpmaxsd (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x i32> @llvm.x86.sse41.pmaxsd(<4 x i32> %a0, <4 x i32> %a1)
  %2 = load <4 x i32>, <4 x i32> *%a2, align 16
  %3 = call <4 x i32> @llvm.x86.sse41.pmaxsd(<4 x i32> %1, <4 x i32> %2)
  ret <4 x i32> %3
}
declare <4 x i32> @llvm.x86.sse41.pmaxsd(<4 x i32>, <4 x i32>) nounwind readnone

define <4 x i32> @test_pmaxud(<4 x i32> %a0, <4 x i32> %a1, <4 x i32> *%a2) {
; GENERIC-LABEL: test_pmaxud:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmaxud %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    pmaxud (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmaxud:
; SLM:       # %bb.0:
; SLM-NEXT:    pmaxud %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pmaxud (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmaxud:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmaxud %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pmaxud (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmaxud:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpmaxud (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmaxud:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmaxud %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    pmaxud (%rdi), %xmm0 # sched: [7:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmaxud:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    vpmaxud (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmaxud:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmaxud %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    pmaxud (%rdi), %xmm0 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmaxud:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    vpmaxud (%rdi), %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmaxud:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmaxud %xmm1, %xmm0 # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    pmaxud (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmaxud:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    vpmaxud (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmaxud:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmaxud %xmm1, %xmm0 # sched: [1:0.50]
; SKX-SSE-NEXT:    pmaxud (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmaxud:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKX-NEXT:    vpmaxud (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmaxud:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmaxud %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmaxud (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmaxud:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpmaxud (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmaxud:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmaxud %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmaxud (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmaxud:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpmaxud (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x i32> @llvm.x86.sse41.pmaxud(<4 x i32> %a0, <4 x i32> %a1)
  %2 = load <4 x i32>, <4 x i32> *%a2, align 16
  %3 = call <4 x i32> @llvm.x86.sse41.pmaxud(<4 x i32> %1, <4 x i32> %2)
  ret <4 x i32> %3
}
declare <4 x i32> @llvm.x86.sse41.pmaxud(<4 x i32>, <4 x i32>) nounwind readnone

define <8 x i16> @test_pmaxuw(<8 x i16> %a0, <8 x i16> %a1, <8 x i16> *%a2) {
; GENERIC-LABEL: test_pmaxuw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmaxuw %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    pmaxuw (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmaxuw:
; SLM:       # %bb.0:
; SLM-NEXT:    pmaxuw %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pmaxuw (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmaxuw:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmaxuw %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pmaxuw (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmaxuw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpmaxuw (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmaxuw:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmaxuw %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    pmaxuw (%rdi), %xmm0 # sched: [7:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmaxuw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    vpmaxuw (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmaxuw:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmaxuw %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    pmaxuw (%rdi), %xmm0 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmaxuw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    vpmaxuw (%rdi), %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmaxuw:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmaxuw %xmm1, %xmm0 # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    pmaxuw (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmaxuw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    vpmaxuw (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmaxuw:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmaxuw %xmm1, %xmm0 # sched: [1:0.50]
; SKX-SSE-NEXT:    pmaxuw (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmaxuw:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKX-NEXT:    vpmaxuw (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmaxuw:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmaxuw %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmaxuw (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmaxuw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpmaxuw (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmaxuw:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmaxuw %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmaxuw (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmaxuw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpmaxuw (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x i16> @llvm.x86.sse41.pmaxuw(<8 x i16> %a0, <8 x i16> %a1)
  %2 = load <8 x i16>, <8 x i16> *%a2, align 16
  %3 = call <8 x i16> @llvm.x86.sse41.pmaxuw(<8 x i16> %1, <8 x i16> %2)
  ret <8 x i16> %3
}
declare <8 x i16> @llvm.x86.sse41.pmaxuw(<8 x i16>, <8 x i16>) nounwind readnone

define <16 x i8> @test_pminsb(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> *%a2) {
; GENERIC-LABEL: test_pminsb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pminsb %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    pminsb (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pminsb:
; SLM:       # %bb.0:
; SLM-NEXT:    pminsb %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pminsb (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pminsb:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pminsb %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pminsb (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pminsb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpminsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpminsb (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pminsb:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pminsb %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    pminsb (%rdi), %xmm0 # sched: [7:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pminsb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpminsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    vpminsb (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pminsb:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pminsb %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    pminsb (%rdi), %xmm0 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pminsb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpminsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    vpminsb (%rdi), %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pminsb:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pminsb %xmm1, %xmm0 # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    pminsb (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pminsb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpminsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    vpminsb (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pminsb:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pminsb %xmm1, %xmm0 # sched: [1:0.50]
; SKX-SSE-NEXT:    pminsb (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pminsb:
; SKX:       # %bb.0:
; SKX-NEXT:    vpminsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKX-NEXT:    vpminsb (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pminsb:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pminsb %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pminsb (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pminsb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpminsb %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpminsb (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pminsb:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pminsb %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pminsb (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pminsb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpminsb %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpminsb (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <16 x i8> @llvm.x86.sse41.pminsb(<16 x i8> %a0, <16 x i8> %a1)
  %2 = load <16 x i8>, <16 x i8> *%a2, align 16
  %3 = call <16 x i8> @llvm.x86.sse41.pminsb(<16 x i8> %1, <16 x i8> %2)
  ret <16 x i8> %3
}
declare <16 x i8> @llvm.x86.sse41.pminsb(<16 x i8>, <16 x i8>) nounwind readnone

define <4 x i32> @test_pminsd(<4 x i32> %a0, <4 x i32> %a1, <4 x i32> *%a2) {
; GENERIC-LABEL: test_pminsd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pminsd %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    pminsd (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pminsd:
; SLM:       # %bb.0:
; SLM-NEXT:    pminsd %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pminsd (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pminsd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pminsd %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pminsd (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pminsd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpminsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpminsd (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pminsd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pminsd %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    pminsd (%rdi), %xmm0 # sched: [7:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pminsd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpminsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    vpminsd (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pminsd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pminsd %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    pminsd (%rdi), %xmm0 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pminsd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpminsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    vpminsd (%rdi), %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pminsd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pminsd %xmm1, %xmm0 # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    pminsd (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pminsd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpminsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    vpminsd (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pminsd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pminsd %xmm1, %xmm0 # sched: [1:0.50]
; SKX-SSE-NEXT:    pminsd (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pminsd:
; SKX:       # %bb.0:
; SKX-NEXT:    vpminsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKX-NEXT:    vpminsd (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pminsd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pminsd %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pminsd (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pminsd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpminsd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpminsd (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pminsd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pminsd %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pminsd (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pminsd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpminsd %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpminsd (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x i32> @llvm.x86.sse41.pminsd(<4 x i32> %a0, <4 x i32> %a1)
  %2 = load <4 x i32>, <4 x i32> *%a2, align 16
  %3 = call <4 x i32> @llvm.x86.sse41.pminsd(<4 x i32> %1, <4 x i32> %2)
  ret <4 x i32> %3
}
declare <4 x i32> @llvm.x86.sse41.pminsd(<4 x i32>, <4 x i32>) nounwind readnone

define <4 x i32> @test_pminud(<4 x i32> %a0, <4 x i32> %a1, <4 x i32> *%a2) {
; GENERIC-LABEL: test_pminud:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pminud %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    pminud (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pminud:
; SLM:       # %bb.0:
; SLM-NEXT:    pminud %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pminud (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pminud:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pminud %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pminud (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pminud:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpminud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpminud (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pminud:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pminud %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    pminud (%rdi), %xmm0 # sched: [7:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pminud:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpminud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    vpminud (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pminud:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pminud %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    pminud (%rdi), %xmm0 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pminud:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpminud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    vpminud (%rdi), %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pminud:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pminud %xmm1, %xmm0 # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    pminud (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pminud:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpminud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    vpminud (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pminud:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pminud %xmm1, %xmm0 # sched: [1:0.50]
; SKX-SSE-NEXT:    pminud (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pminud:
; SKX:       # %bb.0:
; SKX-NEXT:    vpminud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKX-NEXT:    vpminud (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pminud:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pminud %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pminud (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pminud:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpminud %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpminud (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pminud:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pminud %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pminud (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pminud:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpminud %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpminud (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x i32> @llvm.x86.sse41.pminud(<4 x i32> %a0, <4 x i32> %a1)
  %2 = load <4 x i32>, <4 x i32> *%a2, align 16
  %3 = call <4 x i32> @llvm.x86.sse41.pminud(<4 x i32> %1, <4 x i32> %2)
  ret <4 x i32> %3
}
declare <4 x i32> @llvm.x86.sse41.pminud(<4 x i32>, <4 x i32>) nounwind readnone

define <8 x i16> @test_pminuw(<8 x i16> %a0, <8 x i16> %a1, <8 x i16> *%a2) {
; GENERIC-LABEL: test_pminuw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pminuw %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    pminuw (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pminuw:
; SLM:       # %bb.0:
; SLM-NEXT:    pminuw %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pminuw (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pminuw:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pminuw %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pminuw (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pminuw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpminuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpminuw (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pminuw:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pminuw %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    pminuw (%rdi), %xmm0 # sched: [7:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pminuw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpminuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    vpminuw (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pminuw:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pminuw %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    pminuw (%rdi), %xmm0 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pminuw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpminuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    vpminuw (%rdi), %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pminuw:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pminuw %xmm1, %xmm0 # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    pminuw (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pminuw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpminuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    vpminuw (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pminuw:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pminuw %xmm1, %xmm0 # sched: [1:0.50]
; SKX-SSE-NEXT:    pminuw (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pminuw:
; SKX:       # %bb.0:
; SKX-NEXT:    vpminuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SKX-NEXT:    vpminuw (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pminuw:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pminuw %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pminuw (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pminuw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpminuw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpminuw (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pminuw:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pminuw %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pminuw (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pminuw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpminuw %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpminuw (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x i16> @llvm.x86.sse41.pminuw(<8 x i16> %a0, <8 x i16> %a1)
  %2 = load <8 x i16>, <8 x i16> *%a2, align 16
  %3 = call <8 x i16> @llvm.x86.sse41.pminuw(<8 x i16> %1, <8 x i16> %2)
  ret <8 x i16> %3
}
declare <8 x i16> @llvm.x86.sse41.pminuw(<8 x i16>, <8 x i16>) nounwind readnone

define <8 x i16> @test_pmovsxbw(<16 x i8> %a0, <8 x i8> *%a1) {
; GENERIC-LABEL: test_pmovsxbw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovsxbw %xmm0, %xmm1 # sched: [1:0.50]
; GENERIC-NEXT:    pmovsxbw (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovsxbw:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovsxbw (%rdi), %xmm1 # sched: [4:1.00]
; SLM-NEXT:    pmovsxbw %xmm0, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    paddw %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovsxbw:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovsxbw %xmm0, %xmm1 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovsxbw (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovsxbw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovsxbw %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpmovsxbw (%rdi), %xmm1 # sched: [7:0.50]
; SANDY-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovsxbw:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovsxbw %xmm0, %xmm1 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovsxbw (%rdi), %xmm0 # sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovsxbw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovsxbw %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vpmovsxbw (%rdi), %xmm1 # sched: [6:1.00]
; HASWELL-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovsxbw:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovsxbw %xmm0, %xmm1 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovsxbw (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovsxbw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovsxbw %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vpmovsxbw (%rdi), %xmm1 # sched: [6:1.00]
; BROADWELL-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovsxbw:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovsxbw %xmm0, %xmm1 # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovsxbw (%rdi), %xmm0 # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovsxbw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovsxbw %xmm0, %xmm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovsxbw (%rdi), %xmm1 # sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovsxbw:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovsxbw %xmm0, %xmm1 # sched: [1:1.00]
; SKX-SSE-NEXT:    pmovsxbw (%rdi), %xmm0 # sched: [6:1.00]
; SKX-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovsxbw:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsxbw %xmm0, %xmm0 # sched: [1:1.00]
; SKX-NEXT:    vpmovsxbw (%rdi), %xmm1 # sched: [6:1.00]
; SKX-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovsxbw:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovsxbw %xmm0, %xmm1 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovsxbw (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovsxbw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovsxbw (%rdi), %xmm1 # sched: [6:1.00]
; BTVER2-NEXT:    vpmovsxbw %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovsxbw:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovsxbw %xmm0, %xmm1 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovsxbw (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovsxbw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovsxbw (%rdi), %xmm1 # sched: [8:0.50]
; ZNVER1-NEXT:    vpmovsxbw %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = sext <8 x i8> %1 to <8 x i16>
  %3 = load <8 x i8>, <8 x i8>* %a1, align 1
  %4 = sext <8 x i8> %3 to <8 x i16>
  %5 = add <8 x i16> %2, %4
  ret <8 x i16> %5
}

define <4 x i32> @test_pmovsxbd(<16 x i8> %a0, <4 x i8> *%a1) {
; GENERIC-LABEL: test_pmovsxbd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovsxbd %xmm0, %xmm1 # sched: [1:0.50]
; GENERIC-NEXT:    pmovsxbd (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovsxbd:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovsxbd (%rdi), %xmm1 # sched: [4:1.00]
; SLM-NEXT:    pmovsxbd %xmm0, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    paddd %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovsxbd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovsxbd %xmm0, %xmm1 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovsxbd (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovsxbd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovsxbd %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpmovsxbd (%rdi), %xmm1 # sched: [7:0.50]
; SANDY-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovsxbd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovsxbd %xmm0, %xmm1 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovsxbd (%rdi), %xmm0 # sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovsxbd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovsxbd %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vpmovsxbd (%rdi), %xmm1 # sched: [6:1.00]
; HASWELL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovsxbd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovsxbd %xmm0, %xmm1 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovsxbd (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovsxbd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovsxbd %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vpmovsxbd (%rdi), %xmm1 # sched: [6:1.00]
; BROADWELL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovsxbd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovsxbd %xmm0, %xmm1 # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovsxbd (%rdi), %xmm0 # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovsxbd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovsxbd %xmm0, %xmm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovsxbd (%rdi), %xmm1 # sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovsxbd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovsxbd %xmm0, %xmm1 # sched: [1:1.00]
; SKX-SSE-NEXT:    pmovsxbd (%rdi), %xmm0 # sched: [6:1.00]
; SKX-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovsxbd:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsxbd %xmm0, %xmm0 # sched: [1:1.00]
; SKX-NEXT:    vpmovsxbd (%rdi), %xmm1 # sched: [6:1.00]
; SKX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovsxbd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovsxbd %xmm0, %xmm1 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovsxbd (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovsxbd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovsxbd (%rdi), %xmm1 # sched: [6:1.00]
; BTVER2-NEXT:    vpmovsxbd %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovsxbd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovsxbd %xmm0, %xmm1 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovsxbd (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovsxbd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovsxbd (%rdi), %xmm1 # sched: [8:0.50]
; ZNVER1-NEXT:    vpmovsxbd %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = sext <4 x i8> %1 to <4 x i32>
  %3 = load <4 x i8>, <4 x i8>* %a1, align 1
  %4 = sext <4 x i8> %3 to <4 x i32>
  %5 = add <4 x i32> %2, %4
  ret <4 x i32> %5
}

define <2 x i64> @test_pmovsxbq(<16 x i8> %a0, <2 x i8> *%a1) {
; GENERIC-LABEL: test_pmovsxbq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovsxbq %xmm0, %xmm1 # sched: [1:0.50]
; GENERIC-NEXT:    pmovsxbq (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovsxbq:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovsxbq (%rdi), %xmm1 # sched: [4:1.00]
; SLM-NEXT:    pmovsxbq %xmm0, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    paddq %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovsxbq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovsxbq %xmm0, %xmm1 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovsxbq (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovsxbq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovsxbq %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpmovsxbq (%rdi), %xmm1 # sched: [7:0.50]
; SANDY-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovsxbq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovsxbq %xmm0, %xmm1 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovsxbq (%rdi), %xmm0 # sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovsxbq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovsxbq %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vpmovsxbq (%rdi), %xmm1 # sched: [6:1.00]
; HASWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovsxbq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovsxbq %xmm0, %xmm1 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovsxbq (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovsxbq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovsxbq %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vpmovsxbq (%rdi), %xmm1 # sched: [6:1.00]
; BROADWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovsxbq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovsxbq %xmm0, %xmm1 # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovsxbq (%rdi), %xmm0 # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovsxbq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovsxbq %xmm0, %xmm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovsxbq (%rdi), %xmm1 # sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovsxbq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovsxbq %xmm0, %xmm1 # sched: [1:1.00]
; SKX-SSE-NEXT:    pmovsxbq (%rdi), %xmm0 # sched: [6:1.00]
; SKX-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovsxbq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsxbq %xmm0, %xmm0 # sched: [1:1.00]
; SKX-NEXT:    vpmovsxbq (%rdi), %xmm1 # sched: [6:1.00]
; SKX-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovsxbq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovsxbq %xmm0, %xmm1 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovsxbq (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovsxbq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovsxbq (%rdi), %xmm1 # sched: [6:1.00]
; BTVER2-NEXT:    vpmovsxbq %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovsxbq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovsxbq %xmm0, %xmm1 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovsxbq (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovsxbq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovsxbq (%rdi), %xmm1 # sched: [8:0.50]
; ZNVER1-NEXT:    vpmovsxbq %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <2 x i32> <i32 0, i32 1>
  %2 = sext <2 x i8> %1 to <2 x i64>
  %3 = load <2 x i8>, <2 x i8>* %a1, align 1
  %4 = sext <2 x i8> %3 to <2 x i64>
  %5 = add <2 x i64> %2, %4
  ret <2 x i64> %5
}

define <2 x i64> @test_pmovsxdq(<4 x i32> %a0, <2 x i32> *%a1) {
; GENERIC-LABEL: test_pmovsxdq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovsxdq %xmm0, %xmm1 # sched: [1:0.50]
; GENERIC-NEXT:    pmovsxdq (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovsxdq:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovsxdq (%rdi), %xmm1 # sched: [4:1.00]
; SLM-NEXT:    pmovsxdq %xmm0, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    paddq %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovsxdq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovsxdq %xmm0, %xmm1 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovsxdq (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovsxdq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovsxdq %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpmovsxdq (%rdi), %xmm1 # sched: [7:0.50]
; SANDY-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovsxdq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovsxdq %xmm0, %xmm1 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovsxdq (%rdi), %xmm0 # sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovsxdq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovsxdq %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vpmovsxdq (%rdi), %xmm1 # sched: [6:1.00]
; HASWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovsxdq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovsxdq %xmm0, %xmm1 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovsxdq (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovsxdq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovsxdq %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vpmovsxdq (%rdi), %xmm1 # sched: [6:1.00]
; BROADWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovsxdq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovsxdq %xmm0, %xmm1 # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovsxdq (%rdi), %xmm0 # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovsxdq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovsxdq %xmm0, %xmm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovsxdq (%rdi), %xmm1 # sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovsxdq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovsxdq %xmm0, %xmm1 # sched: [1:1.00]
; SKX-SSE-NEXT:    pmovsxdq (%rdi), %xmm0 # sched: [6:1.00]
; SKX-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovsxdq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsxdq %xmm0, %xmm0 # sched: [1:1.00]
; SKX-NEXT:    vpmovsxdq (%rdi), %xmm1 # sched: [6:1.00]
; SKX-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovsxdq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovsxdq %xmm0, %xmm1 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovsxdq (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovsxdq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovsxdq (%rdi), %xmm1 # sched: [6:1.00]
; BTVER2-NEXT:    vpmovsxdq %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovsxdq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovsxdq %xmm0, %xmm1 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovsxdq (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovsxdq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovsxdq (%rdi), %xmm1 # sched: [8:0.50]
; ZNVER1-NEXT:    vpmovsxdq %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x i32> %a0, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %2 = sext <2 x i32> %1 to <2 x i64>
  %3 = load <2 x i32>, <2 x i32>* %a1, align 1
  %4 = sext <2 x i32> %3 to <2 x i64>
  %5 = add <2 x i64> %2, %4
  ret <2 x i64> %5
}

define <4 x i32> @test_pmovsxwd(<8 x i16> %a0, <4 x i16> *%a1) {
; GENERIC-LABEL: test_pmovsxwd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovsxwd %xmm0, %xmm1 # sched: [1:0.50]
; GENERIC-NEXT:    pmovsxwd (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovsxwd:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovsxwd (%rdi), %xmm1 # sched: [4:1.00]
; SLM-NEXT:    pmovsxwd %xmm0, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    paddd %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovsxwd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovsxwd %xmm0, %xmm1 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovsxwd (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovsxwd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovsxwd %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpmovsxwd (%rdi), %xmm1 # sched: [7:0.50]
; SANDY-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovsxwd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovsxwd %xmm0, %xmm1 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovsxwd (%rdi), %xmm0 # sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovsxwd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovsxwd %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vpmovsxwd (%rdi), %xmm1 # sched: [6:1.00]
; HASWELL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovsxwd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovsxwd %xmm0, %xmm1 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovsxwd (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovsxwd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovsxwd %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vpmovsxwd (%rdi), %xmm1 # sched: [6:1.00]
; BROADWELL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovsxwd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovsxwd %xmm0, %xmm1 # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovsxwd (%rdi), %xmm0 # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovsxwd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovsxwd %xmm0, %xmm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovsxwd (%rdi), %xmm1 # sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovsxwd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovsxwd %xmm0, %xmm1 # sched: [1:1.00]
; SKX-SSE-NEXT:    pmovsxwd (%rdi), %xmm0 # sched: [6:1.00]
; SKX-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovsxwd:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsxwd %xmm0, %xmm0 # sched: [1:1.00]
; SKX-NEXT:    vpmovsxwd (%rdi), %xmm1 # sched: [6:1.00]
; SKX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovsxwd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovsxwd %xmm0, %xmm1 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovsxwd (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovsxwd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovsxwd (%rdi), %xmm1 # sched: [6:1.00]
; BTVER2-NEXT:    vpmovsxwd %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovsxwd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovsxwd %xmm0, %xmm1 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovsxwd (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovsxwd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovsxwd (%rdi), %xmm1 # sched: [8:0.50]
; ZNVER1-NEXT:    vpmovsxwd %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x i16> %a0, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = sext <4 x i16> %1 to <4 x i32>
  %3 = load <4 x i16>, <4 x i16>* %a1, align 1
  %4 = sext <4 x i16> %3 to <4 x i32>
  %5 = add <4 x i32> %2, %4
  ret <4 x i32> %5
}

define <2 x i64> @test_pmovsxwq(<8 x i16> %a0, <2 x i16> *%a1) {
; GENERIC-LABEL: test_pmovsxwq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovsxwq %xmm0, %xmm1 # sched: [1:0.50]
; GENERIC-NEXT:    pmovsxwq (%rdi), %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovsxwq:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovsxwq (%rdi), %xmm1 # sched: [4:1.00]
; SLM-NEXT:    pmovsxwq %xmm0, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    paddq %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovsxwq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovsxwq %xmm0, %xmm1 # sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovsxwq (%rdi), %xmm0 # sched: [7:0.50]
; SANDY-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovsxwq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovsxwq %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    vpmovsxwq (%rdi), %xmm1 # sched: [7:0.50]
; SANDY-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovsxwq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovsxwq %xmm0, %xmm1 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovsxwq (%rdi), %xmm0 # sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovsxwq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovsxwq %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vpmovsxwq (%rdi), %xmm1 # sched: [6:1.00]
; HASWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovsxwq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovsxwq %xmm0, %xmm1 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovsxwq (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovsxwq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovsxwq %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vpmovsxwq (%rdi), %xmm1 # sched: [6:1.00]
; BROADWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovsxwq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovsxwq %xmm0, %xmm1 # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovsxwq (%rdi), %xmm0 # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovsxwq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovsxwq %xmm0, %xmm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovsxwq (%rdi), %xmm1 # sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovsxwq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovsxwq %xmm0, %xmm1 # sched: [1:1.00]
; SKX-SSE-NEXT:    pmovsxwq (%rdi), %xmm0 # sched: [6:1.00]
; SKX-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovsxwq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsxwq %xmm0, %xmm0 # sched: [1:1.00]
; SKX-NEXT:    vpmovsxwq (%rdi), %xmm1 # sched: [6:1.00]
; SKX-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovsxwq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovsxwq %xmm0, %xmm1 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovsxwq (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovsxwq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovsxwq (%rdi), %xmm1 # sched: [6:1.00]
; BTVER2-NEXT:    vpmovsxwq %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovsxwq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovsxwq %xmm0, %xmm1 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovsxwq (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovsxwq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovsxwq (%rdi), %xmm1 # sched: [8:0.50]
; ZNVER1-NEXT:    vpmovsxwq %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x i16> %a0, <8 x i16> undef, <2 x i32> <i32 0, i32 1>
  %2 = sext <2 x i16> %1 to <2 x i64>
  %3 = load <2 x i16>, <2 x i16>* %a1, align 1
  %4 = sext <2 x i16> %3 to <2 x i64>
  %5 = add <2 x i64> %2, %4
  ret <2 x i64> %5
}

define <8 x i16> @test_pmovzxbw(<16 x i8> %a0, <8 x i8> *%a1) {
; GENERIC-LABEL: test_pmovzxbw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovzxbw {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:0.50]
; GENERIC-NEXT:    pmovzxbw {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [7:0.50]
; GENERIC-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovzxbw:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovzxbw {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [4:1.00]
; SLM-NEXT:    pmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:1.00]
; SLM-NEXT:    paddw %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovzxbw:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovzxbw {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovzxbw {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [7:0.50]
; SANDY-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovzxbw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:0.50]
; SANDY-NEXT:    vpmovzxbw {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [7:0.50]
; SANDY-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovzxbw:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovzxbw {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovzxbw {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovzxbw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:1.00]
; HASWELL-NEXT:    vpmovzxbw {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [6:1.00]
; HASWELL-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovzxbw:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovzxbw {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovzxbw {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovzxbw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:1.00]
; BROADWELL-NEXT:    vpmovzxbw {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [6:1.00]
; BROADWELL-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovzxbw:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovzxbw {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovzxbw {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovzxbw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovzxbw {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovzxbw:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovzxbw {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:1.00]
; SKX-SSE-NEXT:    pmovzxbw {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [6:1.00]
; SKX-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovzxbw:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:1.00]
; SKX-NEXT:    vpmovzxbw {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [6:1.00]
; SKX-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovzxbw:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovzxbw {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovzxbw {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovzxbw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovzxbw {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [6:1.00]
; BTVER2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:0.50]
; BTVER2-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovzxbw:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovzxbw {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovzxbw {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddw %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovzxbw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovzxbw {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero sched: [8:0.50]
; ZNVER1-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero sched: [1:0.25]
; ZNVER1-NEXT:    vpaddw %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = zext <8 x i8> %1 to <8 x i16>
  %3 = load <8 x i8>, <8 x i8>* %a1, align 1
  %4 = zext <8 x i8> %3 to <8 x i16>
  %5 = add <8 x i16> %2, %4
  ret <8 x i16> %5
}

define <4 x i32> @test_pmovzxbd(<16 x i8> %a0, <4 x i8> *%a1) {
; GENERIC-LABEL: test_pmovzxbd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:0.50]
; GENERIC-NEXT:    pmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [7:0.50]
; GENERIC-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovzxbd:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovzxbd {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [4:1.00]
; SLM-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:1.00]
; SLM-NEXT:    paddd %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovzxbd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [7:0.50]
; SANDY-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovzxbd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:0.50]
; SANDY-NEXT:    vpmovzxbd {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [7:0.50]
; SANDY-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovzxbd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovzxbd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:1.00]
; HASWELL-NEXT:    vpmovzxbd {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [6:1.00]
; HASWELL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovzxbd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovzxbd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:1.00]
; BROADWELL-NEXT:    vpmovzxbd {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [6:1.00]
; BROADWELL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovzxbd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovzxbd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovzxbd {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovzxbd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:1.00]
; SKX-SSE-NEXT:    pmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [6:1.00]
; SKX-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovzxbd:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:1.00]
; SKX-NEXT:    vpmovzxbd {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [6:1.00]
; SKX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovzxbd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovzxbd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovzxbd {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [6:1.00]
; BTVER2-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:0.50]
; BTVER2-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovzxbd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovzxbd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero sched: [8:0.50]
; ZNVER1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero sched: [1:0.25]
; ZNVER1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = zext <4 x i8> %1 to <4 x i32>
  %3 = load <4 x i8>, <4 x i8>* %a1, align 1
  %4 = zext <4 x i8> %3 to <4 x i32>
  %5 = add <4 x i32> %2, %4
  ret <4 x i32> %5
}

define <2 x i64> @test_pmovzxbq(<16 x i8> %a0, <2 x i8> *%a1) {
; GENERIC-LABEL: test_pmovzxbq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovzxbq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:0.50]
; GENERIC-NEXT:    pmovzxbq {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [7:0.50]
; GENERIC-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovzxbq:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovzxbq {{.*#+}} xmm1 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [4:1.00]
; SLM-NEXT:    pmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:1.00]
; SLM-NEXT:    paddq %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovzxbq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovzxbq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovzxbq {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [7:0.50]
; SANDY-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovzxbq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:0.50]
; SANDY-NEXT:    vpmovzxbq {{.*#+}} xmm1 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [7:0.50]
; SANDY-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovzxbq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovzxbq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovzxbq {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovzxbq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:1.00]
; HASWELL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [6:1.00]
; HASWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovzxbq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovzxbq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovzxbq {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovzxbq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:1.00]
; BROADWELL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [6:1.00]
; BROADWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovzxbq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovzxbq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovzxbq {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovzxbq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovzxbq {{.*#+}} xmm1 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovzxbq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovzxbq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:1.00]
; SKX-SSE-NEXT:    pmovzxbq {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [6:1.00]
; SKX-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovzxbq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:1.00]
; SKX-NEXT:    vpmovzxbq {{.*#+}} xmm1 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [6:1.00]
; SKX-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovzxbq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovzxbq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovzxbq {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovzxbq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovzxbq {{.*#+}} xmm1 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [6:1.00]
; BTVER2-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:0.50]
; BTVER2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovzxbq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovzxbq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovzxbq {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovzxbq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero sched: [8:0.50]
; ZNVER1-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero sched: [1:0.25]
; ZNVER1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <2 x i32> <i32 0, i32 1>
  %2 = zext <2 x i8> %1 to <2 x i64>
  %3 = load <2 x i8>, <2 x i8>* %a1, align 1
  %4 = zext <2 x i8> %3 to <2 x i64>
  %5 = add <2 x i64> %2, %4
  ret <2 x i64> %5
}

define <2 x i64> @test_pmovzxdq(<4 x i32> %a0, <2 x i32> *%a1) {
; GENERIC-LABEL: test_pmovzxdq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero sched: [1:0.50]
; GENERIC-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero sched: [7:0.50]
; GENERIC-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovzxdq:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero sched: [4:1.00]
; SLM-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero sched: [1:1.00]
; SLM-NEXT:    paddq %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovzxdq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero sched: [7:0.50]
; SANDY-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovzxdq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero sched: [1:0.50]
; SANDY-NEXT:    vpmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero sched: [7:0.50]
; SANDY-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovzxdq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovzxdq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero sched: [1:1.00]
; HASWELL-NEXT:    vpmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero sched: [6:1.00]
; HASWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovzxdq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovzxdq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero sched: [1:1.00]
; BROADWELL-NEXT:    vpmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero sched: [6:1.00]
; BROADWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovzxdq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovzxdq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovzxdq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero sched: [1:1.00]
; SKX-SSE-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero sched: [6:1.00]
; SKX-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovzxdq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero sched: [1:1.00]
; SKX-NEXT:    vpmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero sched: [6:1.00]
; SKX-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovzxdq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovzxdq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero sched: [6:1.00]
; BTVER2-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero sched: [1:0.50]
; BTVER2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovzxdq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovzxdq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero sched: [8:0.50]
; ZNVER1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero sched: [1:0.25]
; ZNVER1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x i32> %a0, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %2 = zext <2 x i32> %1 to <2 x i64>
  %3 = load <2 x i32>, <2 x i32>* %a1, align 1
  %4 = zext <2 x i32> %3 to <2 x i64>
  %5 = add <2 x i64> %2, %4
  ret <2 x i64> %5
}

define <4 x i32> @test_pmovzxwd(<8 x i16> %a0, <4 x i16> *%a1) {
; GENERIC-LABEL: test_pmovzxwd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:0.50]
; GENERIC-NEXT:    pmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [7:0.50]
; GENERIC-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovzxwd:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovzxwd {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [4:1.00]
; SLM-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:1.00]
; SLM-NEXT:    paddd %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovzxwd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [7:0.50]
; SANDY-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovzxwd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:0.50]
; SANDY-NEXT:    vpmovzxwd {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [7:0.50]
; SANDY-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovzxwd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovzxwd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:1.00]
; HASWELL-NEXT:    vpmovzxwd {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [6:1.00]
; HASWELL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovzxwd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovzxwd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:1.00]
; BROADWELL-NEXT:    vpmovzxwd {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [6:1.00]
; BROADWELL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovzxwd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovzxwd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovzxwd {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovzxwd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:1.00]
; SKX-SSE-NEXT:    pmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [6:1.00]
; SKX-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovzxwd:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:1.00]
; SKX-NEXT:    vpmovzxwd {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [6:1.00]
; SKX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovzxwd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovzxwd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovzxwd {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [6:1.00]
; BTVER2-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:0.50]
; BTVER2-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovzxwd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddd %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovzxwd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovzxwd {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero sched: [8:0.50]
; ZNVER1-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero sched: [1:0.25]
; ZNVER1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x i16> %a0, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = zext <4 x i16> %1 to <4 x i32>
  %3 = load <4 x i16>, <4 x i16>* %a1, align 1
  %4 = zext <4 x i16> %3 to <4 x i32>
  %5 = add <4 x i32> %2, %4
  ret <4 x i32> %5
}

define <2 x i64> @test_pmovzxwq(<8 x i16> %a0, <2 x i16> *%a1) {
; GENERIC-LABEL: test_pmovzxwq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovzxwq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:0.50]
; GENERIC-NEXT:    pmovzxwq {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [7:0.50]
; GENERIC-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmovzxwq:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovzxwq {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [4:1.00]
; SLM-NEXT:    pmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:1.00]
; SLM-NEXT:    paddq %xmm0, %xmm1 # sched: [1:0.50]
; SLM-NEXT:    movdqa %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmovzxwq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmovzxwq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:0.50]
; SANDY-SSE-NEXT:    pmovzxwq {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [7:0.50]
; SANDY-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmovzxwq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:0.50]
; SANDY-NEXT:    vpmovzxwq {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [7:0.50]
; SANDY-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmovzxwq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmovzxwq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:1.00]
; HASWELL-SSE-NEXT:    pmovzxwq {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [6:1.00]
; HASWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmovzxwq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:1.00]
; HASWELL-NEXT:    vpmovzxwq {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [6:1.00]
; HASWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmovzxwq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmovzxwq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:1.00]
; BROADWELL-SSE-NEXT:    pmovzxwq {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [6:1.00]
; BROADWELL-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovzxwq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:1.00]
; BROADWELL-NEXT:    vpmovzxwq {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [6:1.00]
; BROADWELL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmovzxwq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmovzxwq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    pmovzxwq {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovzxwq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:1.00]
; SKYLAKE-NEXT:    vpmovzxwq {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [6:1.00]
; SKYLAKE-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmovzxwq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmovzxwq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:1.00]
; SKX-SSE-NEXT:    pmovzxwq {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [6:1.00]
; SKX-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovzxwq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:1.00]
; SKX-NEXT:    vpmovzxwq {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [6:1.00]
; SKX-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmovzxwq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmovzxwq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:0.50]
; BTVER2-SSE-NEXT:    pmovzxwq {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [6:1.00]
; BTVER2-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmovzxwq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmovzxwq {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [6:1.00]
; BTVER2-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:0.50]
; BTVER2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmovzxwq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmovzxwq {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pmovzxwq {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [8:0.50]
; ZNVER1-SSE-NEXT:    paddq %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmovzxwq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero sched: [8:0.50]
; ZNVER1-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero sched: [1:0.25]
; ZNVER1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x i16> %a0, <8 x i16> undef, <2 x i32> <i32 0, i32 1>
  %2 = zext <2 x i16> %1 to <2 x i64>
  %3 = load <2 x i16>, <2 x i16>* %a1, align 1
  %4 = zext <2 x i16> %3 to <2 x i64>
  %5 = add <2 x i64> %2, %4
  ret <2 x i64> %5
}

define <2 x i64> @test_pmuldq(<4 x i32> %a0, <4 x i32> %a1, <4 x i32> *%a2) {
; GENERIC-LABEL: test_pmuldq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmuldq %xmm1, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    pmuldq (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmuldq:
; SLM:       # %bb.0:
; SLM-NEXT:    pmuldq %xmm1, %xmm0 # sched: [4:1.00]
; SLM-NEXT:    pmuldq (%rdi), %xmm0 # sched: [7:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmuldq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmuldq %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-SSE-NEXT:    pmuldq (%rdi), %xmm0 # sched: [11:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmuldq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmuldq %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vpmuldq (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmuldq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmuldq %xmm1, %xmm0 # sched: [5:1.00]
; HASWELL-SSE-NEXT:    pmuldq (%rdi), %xmm0 # sched: [11:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmuldq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmuldq %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    vpmuldq (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmuldq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmuldq %xmm1, %xmm0 # sched: [5:1.00]
; BROADWELL-SSE-NEXT:    pmuldq (%rdi), %xmm0 # sched: [10:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmuldq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmuldq %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; BROADWELL-NEXT:    vpmuldq (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmuldq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmuldq %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    pmuldq (%rdi), %xmm0 # sched: [10:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmuldq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmuldq %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vpmuldq (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmuldq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmuldq %xmm1, %xmm0 # sched: [4:0.33]
; SKX-SSE-NEXT:    pmuldq (%rdi), %xmm0 # sched: [10:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmuldq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmuldq %xmm1, %xmm0, %xmm0 # sched: [4:0.33]
; SKX-NEXT:    vpmuldq (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmuldq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmuldq %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    pmuldq (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmuldq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmuldq %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vpmuldq (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmuldq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmuldq %xmm1, %xmm0 # sched: [4:1.00]
; ZNVER1-SSE-NEXT:    pmuldq (%rdi), %xmm0 # sched: [11:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmuldq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmuldq %xmm1, %xmm0, %xmm0 # sched: [4:1.00]
; ZNVER1-NEXT:    vpmuldq (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <2 x i64> @llvm.x86.sse41.pmuldq(<4 x i32> %a0, <4 x i32> %a1)
  %2 = bitcast <2 x i64> %1 to <4 x i32>
  %3 = load <4 x i32>, <4 x i32> *%a2, align 16
  %4 = call <2 x i64> @llvm.x86.sse41.pmuldq(<4 x i32> %2, <4 x i32> %3)
  ret <2 x i64> %4
}
declare <2 x i64> @llvm.x86.sse41.pmuldq(<4 x i32>, <4 x i32>) nounwind readnone

define <4 x i32> @test_pmulld(<4 x i32> %a0, <4 x i32> %a1, <4 x i32> *%a2) {
; GENERIC-LABEL: test_pmulld:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmulld %xmm1, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    pmulld (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pmulld:
; SLM:       # %bb.0:
; SLM-NEXT:    pmulld %xmm1, %xmm0 # sched: [4:1.00]
; SLM-NEXT:    pmulld (%rdi), %xmm0 # sched: [7:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pmulld:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pmulld %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-SSE-NEXT:    pmulld (%rdi), %xmm0 # sched: [11:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pmulld:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpmulld %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vpmulld (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pmulld:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pmulld %xmm1, %xmm0 # sched: [10:2.00]
; HASWELL-SSE-NEXT:    pmulld (%rdi), %xmm0 # sched: [16:2.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pmulld:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpmulld %xmm1, %xmm0, %xmm0 # sched: [10:2.00]
; HASWELL-NEXT:    vpmulld (%rdi), %xmm0, %xmm0 # sched: [16:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pmulld:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pmulld %xmm1, %xmm0 # sched: [10:2.00]
; BROADWELL-SSE-NEXT:    pmulld (%rdi), %xmm0 # sched: [15:2.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmulld:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpmulld %xmm1, %xmm0, %xmm0 # sched: [10:2.00]
; BROADWELL-NEXT:    vpmulld (%rdi), %xmm0, %xmm0 # sched: [15:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pmulld:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pmulld %xmm1, %xmm0 # sched: [10:1.00]
; SKYLAKE-SSE-NEXT:    pmulld (%rdi), %xmm0 # sched: [16:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmulld:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpmulld %xmm1, %xmm0, %xmm0 # sched: [10:1.00]
; SKYLAKE-NEXT:    vpmulld (%rdi), %xmm0, %xmm0 # sched: [16:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pmulld:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pmulld %xmm1, %xmm0 # sched: [10:0.67]
; SKX-SSE-NEXT:    pmulld (%rdi), %xmm0 # sched: [16:0.67]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmulld:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmulld %xmm1, %xmm0, %xmm0 # sched: [10:0.67]
; SKX-NEXT:    vpmulld (%rdi), %xmm0, %xmm0 # sched: [16:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pmulld:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pmulld %xmm1, %xmm0 # sched: [4:2.00]
; BTVER2-SSE-NEXT:    pmulld (%rdi), %xmm0 # sched: [9:2.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pmulld:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpmulld %xmm1, %xmm0, %xmm0 # sched: [4:2.00]
; BTVER2-NEXT:    vpmulld (%rdi), %xmm0, %xmm0 # sched: [9:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pmulld:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pmulld %xmm1, %xmm0 # sched: [4:1.00]
; ZNVER1-SSE-NEXT:    pmulld (%rdi), %xmm0 # sched: [11:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pmulld:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpmulld %xmm1, %xmm0, %xmm0 # sched: [4:1.00]
; ZNVER1-NEXT:    vpmulld (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = mul <4 x i32> %a0, %a1
  %2 = load <4 x i32>, <4 x i32> *%a2, align 16
  %3 = mul <4 x i32> %1, %2
  ret <4 x i32> %3
}

define i32 @test_ptest(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_ptest:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    ptest %xmm1, %xmm0 # sched: [2:1.00]
; GENERIC-NEXT:    setb %al # sched: [1:0.50]
; GENERIC-NEXT:    ptest (%rdi), %xmm0 # sched: [8:1.00]
; GENERIC-NEXT:    setb %cl # sched: [1:0.50]
; GENERIC-NEXT:    andb %al, %cl # sched: [1:0.33]
; GENERIC-NEXT:    movzbl %cl, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_ptest:
; SLM:       # %bb.0:
; SLM-NEXT:    ptest %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    setb %al # sched: [1:0.50]
; SLM-NEXT:    ptest (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    setb %cl # sched: [1:0.50]
; SLM-NEXT:    andb %al, %cl # sched: [1:0.50]
; SLM-NEXT:    movzbl %cl, %eax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_ptest:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    ptest %xmm1, %xmm0 # sched: [2:1.00]
; SANDY-SSE-NEXT:    setb %al # sched: [1:0.50]
; SANDY-SSE-NEXT:    ptest (%rdi), %xmm0 # sched: [8:1.00]
; SANDY-SSE-NEXT:    setb %cl # sched: [1:0.50]
; SANDY-SSE-NEXT:    andb %al, %cl # sched: [1:0.33]
; SANDY-SSE-NEXT:    movzbl %cl, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_ptest:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vptest %xmm1, %xmm0 # sched: [2:1.00]
; SANDY-NEXT:    setb %al # sched: [1:0.50]
; SANDY-NEXT:    vptest (%rdi), %xmm0 # sched: [8:1.00]
; SANDY-NEXT:    setb %cl # sched: [1:0.50]
; SANDY-NEXT:    andb %al, %cl # sched: [1:0.33]
; SANDY-NEXT:    movzbl %cl, %eax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_ptest:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    ptest %xmm1, %xmm0 # sched: [2:1.00]
; HASWELL-SSE-NEXT:    setb %al # sched: [1:0.50]
; HASWELL-SSE-NEXT:    ptest (%rdi), %xmm0 # sched: [8:1.00]
; HASWELL-SSE-NEXT:    setb %cl # sched: [1:0.50]
; HASWELL-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; HASWELL-SSE-NEXT:    movzbl %cl, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_ptest:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vptest %xmm1, %xmm0 # sched: [2:1.00]
; HASWELL-NEXT:    setb %al # sched: [1:0.50]
; HASWELL-NEXT:    vptest (%rdi), %xmm0 # sched: [8:1.00]
; HASWELL-NEXT:    setb %cl # sched: [1:0.50]
; HASWELL-NEXT:    andb %al, %cl # sched: [1:0.25]
; HASWELL-NEXT:    movzbl %cl, %eax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_ptest:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    ptest %xmm1, %xmm0 # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    setb %al # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    ptest (%rdi), %xmm0 # sched: [7:1.00]
; BROADWELL-SSE-NEXT:    setb %cl # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    movzbl %cl, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_ptest:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vptest %xmm1, %xmm0 # sched: [2:1.00]
; BROADWELL-NEXT:    setb %al # sched: [1:0.50]
; BROADWELL-NEXT:    vptest (%rdi), %xmm0 # sched: [7:1.00]
; BROADWELL-NEXT:    setb %cl # sched: [1:0.50]
; BROADWELL-NEXT:    andb %al, %cl # sched: [1:0.25]
; BROADWELL-NEXT:    movzbl %cl, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_ptest:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    ptest %xmm1, %xmm0 # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    setb %al # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    ptest (%rdi), %xmm0 # sched: [9:1.00]
; SKYLAKE-SSE-NEXT:    setb %cl # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    movzbl %cl, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_ptest:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vptest %xmm1, %xmm0 # sched: [3:1.00]
; SKYLAKE-NEXT:    setb %al # sched: [1:0.50]
; SKYLAKE-NEXT:    vptest (%rdi), %xmm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    setb %cl # sched: [1:0.50]
; SKYLAKE-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKYLAKE-NEXT:    movzbl %cl, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_ptest:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    ptest %xmm1, %xmm0 # sched: [3:1.00]
; SKX-SSE-NEXT:    setb %al # sched: [1:0.50]
; SKX-SSE-NEXT:    ptest (%rdi), %xmm0 # sched: [9:1.00]
; SKX-SSE-NEXT:    setb %cl # sched: [1:0.50]
; SKX-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKX-SSE-NEXT:    movzbl %cl, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_ptest:
; SKX:       # %bb.0:
; SKX-NEXT:    vptest %xmm1, %xmm0 # sched: [3:1.00]
; SKX-NEXT:    setb %al # sched: [1:0.50]
; SKX-NEXT:    vptest (%rdi), %xmm0 # sched: [9:1.00]
; SKX-NEXT:    setb %cl # sched: [1:0.50]
; SKX-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKX-NEXT:    movzbl %cl, %eax # sched: [1:0.25]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_ptest:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    ptest %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    setb %al # sched: [1:0.50]
; BTVER2-SSE-NEXT:    ptest (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-SSE-NEXT:    setb %cl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    andb %al, %cl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    movzbl %cl, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_ptest:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vptest %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    setb %al # sched: [1:0.50]
; BTVER2-NEXT:    vptest (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    setb %cl # sched: [1:0.50]
; BTVER2-NEXT:    andb %al, %cl # sched: [1:0.50]
; BTVER2-NEXT:    movzbl %cl, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_ptest:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    ptest %xmm1, %xmm0 # sched: [1:1.00]
; ZNVER1-SSE-NEXT:    setb %al # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    ptest (%rdi), %xmm0 # sched: [8:1.00]
; ZNVER1-SSE-NEXT:    setb %cl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    movzbl %cl, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_ptest:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vptest %xmm1, %xmm0 # sched: [1:1.00]
; ZNVER1-NEXT:    setb %al # sched: [1:0.25]
; ZNVER1-NEXT:    vptest (%rdi), %xmm0 # sched: [8:1.00]
; ZNVER1-NEXT:    setb %cl # sched: [1:0.25]
; ZNVER1-NEXT:    andb %al, %cl # sched: [1:0.25]
; ZNVER1-NEXT:    movzbl %cl, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.sse41.ptestc(<2 x i64> %a0, <2 x i64> %a1)
  %2 = load <2 x i64>, <2 x i64> *%a2, align 16
  %3 = call i32 @llvm.x86.sse41.ptestc(<2 x i64> %a0, <2 x i64> %2)
  %4 = and i32 %1, %3
  ret i32 %4
}
declare i32 @llvm.x86.sse41.ptestc(<2 x i64>, <2 x i64>) nounwind readnone

define <2 x double> @test_roundpd(<2 x double> %a0, <2 x double> *%a1) {
; GENERIC-LABEL: test_roundpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    roundpd $7, %xmm0, %xmm1 # sched: [3:1.00]
; GENERIC-NEXT:    roundpd $7, (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_roundpd:
; SLM:       # %bb.0:
; SLM-NEXT:    roundpd $7, (%rdi), %xmm1 # sched: [6:1.00]
; SLM-NEXT:    roundpd $7, %xmm0, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addpd %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    movapd %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_roundpd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    roundpd $7, %xmm0, %xmm1 # sched: [3:1.00]
; SANDY-SSE-NEXT:    roundpd $7, (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_roundpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vroundpd $7, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vroundpd $7, (%rdi), %xmm1 # sched: [9:1.00]
; SANDY-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_roundpd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    roundpd $7, %xmm0, %xmm1 # sched: [6:0.50]
; HASWELL-SSE-NEXT:    roundpd $7, (%rdi), %xmm0 # sched: [12:2.00]
; HASWELL-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_roundpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vroundpd $7, %xmm0, %xmm0 # sched: [6:0.50]
; HASWELL-NEXT:    vroundpd $7, (%rdi), %xmm1 # sched: [12:2.00]
; HASWELL-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_roundpd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    roundpd $7, (%rdi), %xmm1 # sched: [11:2.00]
; BROADWELL-SSE-NEXT:    roundpd $7, %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    addpd %xmm0, %xmm1 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    movapd %xmm1, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_roundpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vroundpd $7, (%rdi), %xmm1 # sched: [11:2.00]
; BROADWELL-NEXT:    vroundpd $7, %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_roundpd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    roundpd $7, %xmm0, %xmm1 # sched: [8:1.00]
; SKYLAKE-SSE-NEXT:    roundpd $7, (%rdi), %xmm0 # sched: [14:1.00]
; SKYLAKE-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_roundpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vroundpd $7, %xmm0, %xmm0 # sched: [8:1.00]
; SKYLAKE-NEXT:    vroundpd $7, (%rdi), %xmm1 # sched: [14:1.00]
; SKYLAKE-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_roundpd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    roundpd $7, %xmm0, %xmm1 # sched: [8:0.67]
; SKX-SSE-NEXT:    roundpd $7, (%rdi), %xmm0 # sched: [14:0.67]
; SKX-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [4:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_roundpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vroundpd $7, %xmm0, %xmm0 # sched: [8:0.67]
; SKX-NEXT:    vroundpd $7, (%rdi), %xmm1 # sched: [14:0.67]
; SKX-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [4:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_roundpd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    roundpd $7, %xmm0, %xmm1 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    roundpd $7, (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_roundpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vroundpd $7, (%rdi), %xmm1 # sched: [8:1.00]
; BTVER2-NEXT:    vroundpd $7, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_roundpd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    roundpd $7, %xmm0, %xmm1 # sched: [4:1.00]
; ZNVER1-SSE-NEXT:    roundpd $7, (%rdi), %xmm0 # sched: [11:1.00]
; ZNVER1-SSE-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_roundpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vroundpd $7, (%rdi), %xmm1 # sched: [11:1.00]
; ZNVER1-NEXT:    vroundpd $7, %xmm0, %xmm0 # sched: [4:1.00]
; ZNVER1-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <2 x double> @llvm.x86.sse41.round.pd(<2 x double> %a0, i32 7)
  %2 = load <2 x double>, <2 x double> *%a1, align 16
  %3 = call <2 x double> @llvm.x86.sse41.round.pd(<2 x double> %2, i32 7)
  %4 = fadd <2 x double> %1, %3
  ret <2 x double> %4
}
declare <2 x double> @llvm.x86.sse41.round.pd(<2 x double>, i32) nounwind readnone

define <4 x float> @test_roundps(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_roundps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    roundps $7, %xmm0, %xmm1 # sched: [3:1.00]
; GENERIC-NEXT:    roundps $7, (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_roundps:
; SLM:       # %bb.0:
; SLM-NEXT:    roundps $7, (%rdi), %xmm1 # sched: [6:1.00]
; SLM-NEXT:    roundps $7, %xmm0, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    movaps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_roundps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    roundps $7, %xmm0, %xmm1 # sched: [3:1.00]
; SANDY-SSE-NEXT:    roundps $7, (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_roundps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vroundps $7, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vroundps $7, (%rdi), %xmm1 # sched: [9:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_roundps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    roundps $7, %xmm0, %xmm1 # sched: [6:0.50]
; HASWELL-SSE-NEXT:    roundps $7, (%rdi), %xmm0 # sched: [12:2.00]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_roundps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vroundps $7, %xmm0, %xmm0 # sched: [6:0.50]
; HASWELL-NEXT:    vroundps $7, (%rdi), %xmm1 # sched: [12:2.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_roundps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    roundps $7, (%rdi), %xmm1 # sched: [11:2.00]
; BROADWELL-SSE-NEXT:    roundps $7, %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    movaps %xmm1, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_roundps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vroundps $7, (%rdi), %xmm1 # sched: [11:2.00]
; BROADWELL-NEXT:    vroundps $7, %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_roundps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    roundps $7, %xmm0, %xmm1 # sched: [8:1.00]
; SKYLAKE-SSE-NEXT:    roundps $7, (%rdi), %xmm0 # sched: [14:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_roundps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vroundps $7, %xmm0, %xmm0 # sched: [8:1.00]
; SKYLAKE-NEXT:    vroundps $7, (%rdi), %xmm1 # sched: [14:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_roundps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    roundps $7, %xmm0, %xmm1 # sched: [8:0.67]
; SKX-SSE-NEXT:    roundps $7, (%rdi), %xmm0 # sched: [14:0.67]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_roundps:
; SKX:       # %bb.0:
; SKX-NEXT:    vroundps $7, %xmm0, %xmm0 # sched: [8:0.67]
; SKX-NEXT:    vroundps $7, (%rdi), %xmm1 # sched: [14:0.67]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_roundps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    roundps $7, %xmm0, %xmm1 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    roundps $7, (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_roundps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vroundps $7, (%rdi), %xmm1 # sched: [8:1.00]
; BTVER2-NEXT:    vroundps $7, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_roundps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    roundps $7, %xmm0, %xmm1 # sched: [4:1.00]
; ZNVER1-SSE-NEXT:    roundps $7, (%rdi), %xmm0 # sched: [11:1.00]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_roundps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vroundps $7, (%rdi), %xmm1 # sched: [11:1.00]
; ZNVER1-NEXT:    vroundps $7, %xmm0, %xmm0 # sched: [4:1.00]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse41.round.ps(<4 x float> %a0, i32 7)
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = call <4 x float> @llvm.x86.sse41.round.ps(<4 x float> %2, i32 7)
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
declare <4 x float> @llvm.x86.sse41.round.ps(<4 x float>, i32) nounwind readnone

define <2 x double> @test_roundsd(<2 x double> %a0, <2 x double> %a1, <2 x double> *%a2) {
; GENERIC-LABEL: test_roundsd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movapd %xmm0, %xmm2 # sched: [1:1.00]
; GENERIC-NEXT:    roundsd $7, %xmm1, %xmm2 # sched: [3:1.00]
; GENERIC-NEXT:    roundsd $7, (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    addpd %xmm2, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_roundsd:
; SLM:       # %bb.0:
; SLM-NEXT:    movapd %xmm0, %xmm2 # sched: [1:0.50]
; SLM-NEXT:    roundsd $7, (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    roundsd $7, %xmm1, %xmm2 # sched: [3:1.00]
; SLM-NEXT:    addpd %xmm2, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_roundsd:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movapd %xmm0, %xmm2 # sched: [1:1.00]
; SANDY-SSE-NEXT:    roundsd $7, %xmm1, %xmm2 # sched: [3:1.00]
; SANDY-SSE-NEXT:    roundsd $7, (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    addpd %xmm2, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_roundsd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vroundsd $7, %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; SANDY-NEXT:    vroundsd $7, (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_roundsd:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movapd %xmm0, %xmm2 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    roundsd $7, %xmm1, %xmm2 # sched: [6:0.50]
; HASWELL-SSE-NEXT:    roundsd $7, (%rdi), %xmm0 # sched: [12:2.00]
; HASWELL-SSE-NEXT:    addpd %xmm2, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_roundsd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vroundsd $7, %xmm1, %xmm0, %xmm1 # sched: [6:0.50]
; HASWELL-NEXT:    vroundsd $7, (%rdi), %xmm0, %xmm0 # sched: [12:2.00]
; HASWELL-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_roundsd:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movapd %xmm0, %xmm2 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    roundsd $7, (%rdi), %xmm0 # sched: [11:2.00]
; BROADWELL-SSE-NEXT:    roundsd $7, %xmm1, %xmm2 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    addpd %xmm2, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_roundsd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vroundsd $7, (%rdi), %xmm0, %xmm2 # sched: [11:2.00]
; BROADWELL-NEXT:    vroundsd $7, %xmm1, %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    vaddpd %xmm2, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_roundsd:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movapd %xmm0, %xmm2 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    roundsd $7, %xmm1, %xmm2 # sched: [8:1.00]
; SKYLAKE-SSE-NEXT:    roundsd $7, (%rdi), %xmm0 # sched: [14:1.00]
; SKYLAKE-SSE-NEXT:    addpd %xmm2, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_roundsd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vroundsd $7, %xmm1, %xmm0, %xmm1 # sched: [8:1.00]
; SKYLAKE-NEXT:    vroundsd $7, (%rdi), %xmm0, %xmm0 # sched: [14:1.00]
; SKYLAKE-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_roundsd:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movapd %xmm0, %xmm2 # sched: [1:0.33]
; SKX-SSE-NEXT:    roundsd $7, %xmm1, %xmm2 # sched: [8:0.67]
; SKX-SSE-NEXT:    roundsd $7, (%rdi), %xmm0 # sched: [14:0.67]
; SKX-SSE-NEXT:    addpd %xmm2, %xmm0 # sched: [4:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_roundsd:
; SKX:       # %bb.0:
; SKX-NEXT:    vroundsd $7, %xmm1, %xmm0, %xmm1 # sched: [8:0.67]
; SKX-NEXT:    vroundsd $7, (%rdi), %xmm0, %xmm0 # sched: [14:0.67]
; SKX-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [4:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_roundsd:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movapd %xmm0, %xmm2 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    roundsd $7, (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-SSE-NEXT:    roundsd $7, %xmm1, %xmm2 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    addpd %xmm2, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_roundsd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vroundsd $7, %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; BTVER2-NEXT:    vroundsd $7, (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_roundsd:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movapd %xmm0, %xmm2 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    roundsd $7, (%rdi), %xmm0 # sched: [11:1.00]
; ZNVER1-SSE-NEXT:    roundsd $7, %xmm1, %xmm2 # sched: [4:1.00]
; ZNVER1-SSE-NEXT:    addpd %xmm2, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_roundsd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vroundsd $7, %xmm1, %xmm0, %xmm1 # sched: [4:1.00]
; ZNVER1-NEXT:    vroundsd $7, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; ZNVER1-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <2 x double> @llvm.x86.sse41.round.sd(<2 x double> %a0, <2 x double> %a1, i32 7)
  %2 = load <2 x double>, <2 x double>* %a2, align 16
  %3 = call <2 x double> @llvm.x86.sse41.round.sd(<2 x double> %a0, <2 x double> %2, i32 7)
  %4 = fadd <2 x double> %1, %3
  ret <2 x double> %4
}
declare <2 x double> @llvm.x86.sse41.round.sd(<2 x double>, <2 x double>, i32) nounwind readnone

define <4 x float> @test_roundss(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_roundss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movaps %xmm0, %xmm2 # sched: [1:1.00]
; GENERIC-NEXT:    roundss $7, %xmm1, %xmm2 # sched: [3:1.00]
; GENERIC-NEXT:    roundss $7, (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    addps %xmm2, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_roundss:
; SLM:       # %bb.0:
; SLM-NEXT:    movaps %xmm0, %xmm2 # sched: [1:0.50]
; SLM-NEXT:    roundss $7, (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    roundss $7, %xmm1, %xmm2 # sched: [3:1.00]
; SLM-NEXT:    addps %xmm2, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_roundss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movaps %xmm0, %xmm2 # sched: [1:1.00]
; SANDY-SSE-NEXT:    roundss $7, %xmm1, %xmm2 # sched: [3:1.00]
; SANDY-SSE-NEXT:    roundss $7, (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    addps %xmm2, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_roundss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vroundss $7, %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; SANDY-NEXT:    vroundss $7, (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_roundss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movaps %xmm0, %xmm2 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    roundss $7, %xmm1, %xmm2 # sched: [6:0.50]
; HASWELL-SSE-NEXT:    roundss $7, (%rdi), %xmm0 # sched: [12:2.00]
; HASWELL-SSE-NEXT:    addps %xmm2, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_roundss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vroundss $7, %xmm1, %xmm0, %xmm1 # sched: [6:0.50]
; HASWELL-NEXT:    vroundss $7, (%rdi), %xmm0, %xmm0 # sched: [12:2.00]
; HASWELL-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_roundss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movaps %xmm0, %xmm2 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    roundss $7, (%rdi), %xmm0 # sched: [11:2.00]
; BROADWELL-SSE-NEXT:    roundss $7, %xmm1, %xmm2 # sched: [6:0.50]
; BROADWELL-SSE-NEXT:    addps %xmm2, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_roundss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vroundss $7, (%rdi), %xmm0, %xmm2 # sched: [11:2.00]
; BROADWELL-NEXT:    vroundss $7, %xmm1, %xmm0, %xmm0 # sched: [6:0.50]
; BROADWELL-NEXT:    vaddps %xmm2, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_roundss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movaps %xmm0, %xmm2 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    roundss $7, %xmm1, %xmm2 # sched: [8:1.00]
; SKYLAKE-SSE-NEXT:    roundss $7, (%rdi), %xmm0 # sched: [14:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm2, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_roundss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vroundss $7, %xmm1, %xmm0, %xmm1 # sched: [8:1.00]
; SKYLAKE-NEXT:    vroundss $7, (%rdi), %xmm0, %xmm0 # sched: [14:1.00]
; SKYLAKE-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_roundss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movaps %xmm0, %xmm2 # sched: [1:0.33]
; SKX-SSE-NEXT:    roundss $7, %xmm1, %xmm2 # sched: [8:0.67]
; SKX-SSE-NEXT:    roundss $7, (%rdi), %xmm0 # sched: [14:0.67]
; SKX-SSE-NEXT:    addps %xmm2, %xmm0 # sched: [4:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_roundss:
; SKX:       # %bb.0:
; SKX-NEXT:    vroundss $7, %xmm1, %xmm0, %xmm1 # sched: [8:0.67]
; SKX-NEXT:    vroundss $7, (%rdi), %xmm0, %xmm0 # sched: [14:0.67]
; SKX-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [4:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_roundss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movaps %xmm0, %xmm2 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    roundss $7, (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-SSE-NEXT:    roundss $7, %xmm1, %xmm2 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    addps %xmm2, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_roundss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vroundss $7, %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; BTVER2-NEXT:    vroundss $7, (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_roundss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movaps %xmm0, %xmm2 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    roundss $7, (%rdi), %xmm0 # sched: [11:1.00]
; ZNVER1-SSE-NEXT:    roundss $7, %xmm1, %xmm2 # sched: [4:1.00]
; ZNVER1-SSE-NEXT:    addps %xmm2, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_roundss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vroundss $7, %xmm1, %xmm0, %xmm1 # sched: [4:1.00]
; ZNVER1-NEXT:    vroundss $7, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; ZNVER1-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse41.round.ss(<4 x float> %a0, <4 x float> %a1, i32 7)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse41.round.ss(<4 x float> %a0, <4 x float> %2, i32 7)
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
declare <4 x float> @llvm.x86.sse41.round.ss(<4 x float>, <4 x float>, i32) nounwind readnone
