; NOTE: Assertions have been autogenerated by update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefix=AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw | FileCheck %s --check-prefix=AVX512BW

@a = global [1024 x i8] zeroinitializer, align 16
@b = global [1024 x i8] zeroinitializer, align 16

define i32 @sad_16i8() nounwind {
; SSE2-LABEL: sad_16i8:
; SSE2:       # BB#0: # %entry
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    movq $-1024, %rax # imm = 0xFC00
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    .p2align 4, 0x90
; SSE2-NEXT:  .LBB0_1: # %vector.body
; SSE2-NEXT:    # =>This Inner Loop Header: Depth=1
; SSE2-NEXT:    movdqu a+1024(%rax), %xmm2
; SSE2-NEXT:    movdqu b+1024(%rax), %xmm3
; SSE2-NEXT:    psadbw %xmm2, %xmm3
; SSE2-NEXT:    paddd %xmm3, %xmm1
; SSE2-NEXT:    addq $4, %rax
; SSE2-NEXT:    jne .LBB0_1
; SSE2-NEXT:  # BB#2: # %middle.block
; SSE2-NEXT:    paddd %xmm0, %xmm1
; SSE2-NEXT:    paddd %xmm0, %xmm0
; SSE2-NEXT:    paddd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; SSE2-NEXT:    paddd %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,2,3]
; SSE2-NEXT:    paddd %xmm1, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    retq
;
; AVX2-LABEL: sad_16i8:
; AVX2:       # BB#0: # %entry
; AVX2-NEXT:    vpxor %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX2-NEXT:    vpxor %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    .p2align 4, 0x90
; AVX2-NEXT:  .LBB0_1: # %vector.body
; AVX2-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX2-NEXT:    vmovdqu a+1024(%rax), %xmm2
; AVX2-NEXT:    vpsadbw b+1024(%rax), %xmm2, %xmm2
; AVX2-NEXT:    vpaddd %xmm1, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    addq $4, %rax
; AVX2-NEXT:    jne .LBB0_1
; AVX2-NEXT:  # BB#2: # %middle.block
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vphaddd %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sad_16i8:
; AVX512F:       # BB#0: # %entry
; AVX512F-NEXT:    vpxord %zmm0, %zmm0, %zmm0
; AVX512F-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX512F-NEXT:    .p2align 4, 0x90
; AVX512F-NEXT:  .LBB0_1: # %vector.body
; AVX512F-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX512F-NEXT:    vmovdqu a+1024(%rax), %xmm1
; AVX512F-NEXT:    vpsadbw b+1024(%rax), %xmm1, %xmm1
; AVX512F-NEXT:    vpaddd %xmm0, %xmm1, %xmm1
; AVX512F-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm0
; AVX512F-NEXT:    addq $4, %rax
; AVX512F-NEXT:    jne .LBB0_1
; AVX512F-NEXT:  # BB#2: # %middle.block
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,0,1]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[2,3,0,1,0,1,0,1]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[2,3,2,3,6,7,6,7,10,11,10,11,14,15,14,15]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[1,1,2,3,5,5,6,7,9,9,10,11,13,13,14,15]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: sad_16i8:
; AVX512BW:       # BB#0: # %entry
; AVX512BW-NEXT:    vpxord %zmm0, %zmm0, %zmm0
; AVX512BW-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX512BW-NEXT:    .p2align 4, 0x90
; AVX512BW-NEXT:  .LBB0_1: # %vector.body
; AVX512BW-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX512BW-NEXT:    vmovdqu a+1024(%rax), %xmm1
; AVX512BW-NEXT:    vpsadbw b+1024(%rax), %xmm1, %xmm1
; AVX512BW-NEXT:    vpaddd %xmm0, %xmm1, %xmm1
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    addq $4, %rax
; AVX512BW-NEXT:    jne .LBB0_1
; AVX512BW-NEXT:  # BB#2: # %middle.block
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,0,1]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[2,3,0,1,0,1,0,1]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[2,3,2,3,6,7,6,7,10,11,10,11,14,15,14,15]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[1,1,2,3,5,5,6,7,9,9,10,11,13,13,14,15]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovd %xmm0, %eax
; AVX512BW-NEXT:    retq
entry:
  br label %vector.body

vector.body:
  %index = phi i64 [ 0, %entry ], [ %index.next, %vector.body ]
  %vec.phi = phi <16 x i32> [ zeroinitializer, %entry ], [ %10, %vector.body ]
  %0 = getelementptr inbounds [1024 x i8], [1024 x i8]* @a, i64 0, i64 %index
  %1 = bitcast i8* %0 to <16 x i8>*
  %wide.load = load <16 x i8>, <16 x i8>* %1, align 4
  %2 = zext <16 x i8> %wide.load to <16 x i32>
  %3 = getelementptr inbounds [1024 x i8], [1024 x i8]* @b, i64 0, i64 %index
  %4 = bitcast i8* %3 to <16 x i8>*
  %wide.load1 = load <16 x i8>, <16 x i8>* %4, align 4
  %5 = zext <16 x i8> %wide.load1 to <16 x i32>
  %6 = sub nsw <16 x i32> %2, %5
  %7 = icmp sgt <16 x i32> %6, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %8 = sub nsw <16 x i32> zeroinitializer, %6
  %9 = select <16 x i1> %7, <16 x i32> %6, <16 x i32> %8
  %10 = add nsw <16 x i32> %9, %vec.phi
  %index.next = add i64 %index, 4
  %11 = icmp eq i64 %index.next, 1024
  br i1 %11, label %middle.block, label %vector.body

middle.block:
  %.lcssa = phi <16 x i32> [ %10, %vector.body ]
  %rdx.shuf = shufflevector <16 x i32> %.lcssa, <16 x i32> undef, <16 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx = add <16 x i32> %.lcssa, %rdx.shuf
  %rdx.shuf2 = shufflevector <16 x i32> %bin.rdx, <16 x i32> undef, <16 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx2 = add <16 x i32> %bin.rdx, %rdx.shuf2
  %rdx.shuf3 = shufflevector <16 x i32> %bin.rdx2, <16 x i32> undef, <16 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx3 = add <16 x i32> %bin.rdx2, %rdx.shuf3
  %rdx.shuf4 = shufflevector <16 x i32> %bin.rdx3, <16 x i32> undef, <16 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx4 = add <16 x i32> %bin.rdx3, %rdx.shuf4
  %12 = extractelement <16 x i32> %bin.rdx4, i32 0
  ret i32 %12
}

define i32 @sad_32i8() nounwind {
; SSE2-LABEL: sad_32i8:
; SSE2:       # BB#0: # %entry
; SSE2-NEXT:    pxor %xmm12, %xmm12
; SSE2-NEXT:    movq $-1024, %rax # imm = 0xFC00
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm13, %xmm13
; SSE2-NEXT:    pxor %xmm15, %xmm15
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm14, %xmm14
; SSE2-NEXT:    .p2align 4, 0x90
; SSE2-NEXT:  .LBB1_1: # %vector.body
; SSE2-NEXT:    # =>This Inner Loop Header: Depth=1
; SSE2-NEXT:    movdqa %xmm5, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm2, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm0, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm1, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa a+1040(%rax), %xmm0
; SSE2-NEXT:    movdqa a+1024(%rax), %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm1[2,3,0,1]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm12[0],xmm8[1],xmm12[1],xmm8[2],xmm12[2],xmm8[3],xmm12[3],xmm8[4],xmm12[4],xmm8[5],xmm12[5],xmm8[6],xmm12[6],xmm8[7],xmm12[7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[2,3,0,1]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm12[0],xmm7[1],xmm12[1],xmm7[2],xmm12[2],xmm7[3],xmm12[3],xmm7[4],xmm12[4],xmm7[5],xmm12[5],xmm7[6],xmm12[6],xmm7[7],xmm12[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm12[0],xmm1[1],xmm12[1],xmm1[2],xmm12[2],xmm1[3],xmm12[3],xmm1[4],xmm12[4],xmm1[5],xmm12[5],xmm1[6],xmm12[6],xmm1[7],xmm12[7]
; SSE2-NEXT:    movdqa %xmm1, %xmm6
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm12[4],xmm1[5],xmm12[5],xmm1[6],xmm12[6],xmm1[7],xmm12[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm12[0],xmm0[1],xmm12[1],xmm0[2],xmm12[2],xmm0[3],xmm12[3],xmm0[4],xmm12[4],xmm0[5],xmm12[5],xmm0[6],xmm12[6],xmm0[7],xmm12[7]
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm12[0],xmm2[1],xmm12[1],xmm2[2],xmm12[2],xmm2[3],xmm12[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm12[4],xmm0[5],xmm12[5],xmm0[6],xmm12[6],xmm0[7],xmm12[7]
; SSE2-NEXT:    movdqa b+1040(%rax), %xmm3
; SSE2-NEXT:    movdqa b+1024(%rax), %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm3[2,3,0,1]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm12[0],xmm3[1],xmm12[1],xmm3[2],xmm12[2],xmm3[3],xmm12[3],xmm3[4],xmm12[4],xmm3[5],xmm12[5],xmm3[6],xmm12[6],xmm3[7],xmm12[7]
; SSE2-NEXT:    movdqa %xmm3, %xmm10
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm12[4],xmm3[5],xmm12[5],xmm3[6],xmm12[6],xmm3[7],xmm12[7]
; SSE2-NEXT:    psubd %xmm3, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm11 = xmm5[2,3,0,1]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm12[0],xmm5[1],xmm12[1],xmm5[2],xmm12[2],xmm5[3],xmm12[3],xmm5[4],xmm12[4],xmm5[5],xmm12[5],xmm5[6],xmm12[6],xmm5[7],xmm12[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm12[0],xmm10[1],xmm12[1],xmm10[2],xmm12[2],xmm10[3],xmm12[3]
; SSE2-NEXT:    psubd %xmm10, %xmm2
; SSE2-NEXT:    movdqa %xmm5, %xmm3
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm12[4],xmm5[5],xmm12[5],xmm5[6],xmm12[6],xmm5[7],xmm12[7]
; SSE2-NEXT:    psubd %xmm5, %xmm1
; SSE2-NEXT:    movdqa %xmm7, %xmm5
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm12[4],xmm7[5],xmm12[5],xmm7[6],xmm12[6],xmm7[7],xmm12[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm12[0],xmm6[1],xmm12[1],xmm6[2],xmm12[2],xmm6[3],xmm12[3]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm9 = xmm9[0],xmm12[0],xmm9[1],xmm12[1],xmm9[2],xmm12[2],xmm9[3],xmm12[3],xmm9[4],xmm12[4],xmm9[5],xmm12[5],xmm9[6],xmm12[6],xmm9[7],xmm12[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm12[0],xmm3[1],xmm12[1],xmm3[2],xmm12[2],xmm3[3],xmm12[3]
; SSE2-NEXT:    psubd %xmm3, %xmm6
; SSE2-NEXT:    movdqa %xmm4, %xmm10
; SSE2-NEXT:    movdqa %xmm9, %xmm4
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4],xmm12[4],xmm9[5],xmm12[5],xmm9[6],xmm12[6],xmm9[7],xmm12[7]
; SSE2-NEXT:    psubd %xmm9, %xmm7
; SSE2-NEXT:    movdqa %xmm8, %xmm3
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4],xmm12[4],xmm8[5],xmm12[5],xmm8[6],xmm12[6],xmm8[7],xmm12[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm12[0],xmm5[1],xmm12[1],xmm5[2],xmm12[2],xmm5[3],xmm12[3]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3],xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm12[0],xmm4[1],xmm12[1],xmm4[2],xmm12[2],xmm4[3],xmm12[3]
; SSE2-NEXT:    psubd %xmm4, %xmm5
; SSE2-NEXT:    movdqa %xmm11, %xmm4
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm11 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; SSE2-NEXT:    psubd %xmm11, %xmm8
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm12[0],xmm3[1],xmm12[1],xmm3[2],xmm12[2],xmm3[3],xmm12[3]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm12[0],xmm4[1],xmm12[1],xmm4[2],xmm12[2],xmm4[3],xmm12[3]
; SSE2-NEXT:    psubd %xmm4, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm3
; SSE2-NEXT:    movdqa %xmm8, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm8
; SSE2-NEXT:    pxor %xmm4, %xmm8
; SSE2-NEXT:    movdqa %xmm5, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm5
; SSE2-NEXT:    pxor %xmm4, %xmm5
; SSE2-NEXT:    movdqa %xmm7, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm7
; SSE2-NEXT:    pxor %xmm4, %xmm7
; SSE2-NEXT:    movdqa %xmm6, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm6
; SSE2-NEXT:    pxor %xmm4, %xmm6
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm0
; SSE2-NEXT:    pxor %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm10, %xmm4
; SSE2-NEXT:    paddd %xmm0, %xmm15
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm2, %xmm13
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm2 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm1, %xmm2
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm1 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm6, %xmm4
; SSE2-NEXT:    paddd %xmm7, %xmm14
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm6 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm5, %xmm6
; SSE2-NEXT:    movdqa %xmm6, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm5 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm8, %xmm1
; SSE2-NEXT:    paddd %xmm3, %xmm0
; SSE2-NEXT:    addq $4, %rax
; SSE2-NEXT:    jne .LBB1_1
; SSE2-NEXT:  # BB#2: # %middle.block
; SSE2-NEXT:    paddd %xmm15, %xmm2
; SSE2-NEXT:    paddd %xmm14, %xmm1
; SSE2-NEXT:    paddd %xmm13, %xmm4
; SSE2-NEXT:    paddd %xmm5, %xmm0
; SSE2-NEXT:    paddd %xmm4, %xmm0
; SSE2-NEXT:    paddd %xmm2, %xmm1
; SSE2-NEXT:    paddd %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,0,1]
; SSE2-NEXT:    paddd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; SSE2-NEXT:    paddd %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    retq
;
; AVX2-LABEL: sad_32i8:
; AVX2:       # BB#0: # %entry
; AVX2-NEXT:    vpxor %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX2-NEXT:    vpxor %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    .p2align 4, 0x90
; AVX2-NEXT:  .LBB1_1: # %vector.body
; AVX2-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX2-NEXT:    vmovdqa a+1024(%rax), %ymm2
; AVX2-NEXT:    vpsadbw b+1024(%rax), %ymm2, %ymm2
; AVX2-NEXT:    vpaddd %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    addq $4, %rax
; AVX2-NEXT:    jne .LBB1_1
; AVX2-NEXT:  # BB#2: # %middle.block
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vphaddd %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sad_32i8:
; AVX512F:       # BB#0: # %entry
; AVX512F-NEXT:    vpxord %zmm0, %zmm0, %zmm0
; AVX512F-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX512F-NEXT:    vpxord %zmm1, %zmm1, %zmm1
; AVX512F-NEXT:    .p2align 4, 0x90
; AVX512F-NEXT:  .LBB1_1: # %vector.body
; AVX512F-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX512F-NEXT:    vmovdqa a+1024(%rax), %ymm2
; AVX512F-NEXT:    vpsadbw b+1024(%rax), %ymm2, %ymm2
; AVX512F-NEXT:    vpaddd %ymm1, %ymm2, %ymm2
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm1, %zmm1
; AVX512F-NEXT:    addq $4, %rax
; AVX512F-NEXT:    jne .LBB1_1
; AVX512F-NEXT:  # BB#2: # %middle.block
; AVX512F-NEXT:    vpaddd %zmm0, %zmm1, %zmm0
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,0,1]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[2,3,0,1,0,1,0,1]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[2,3,2,3,6,7,6,7,10,11,10,11,14,15,14,15]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[1,1,2,3,5,5,6,7,9,9,10,11,13,13,14,15]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: sad_32i8:
; AVX512BW:       # BB#0: # %entry
; AVX512BW-NEXT:    vpxord %zmm0, %zmm0, %zmm0
; AVX512BW-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX512BW-NEXT:    vpxord %zmm1, %zmm1, %zmm1
; AVX512BW-NEXT:    .p2align 4, 0x90
; AVX512BW-NEXT:  .LBB1_1: # %vector.body
; AVX512BW-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX512BW-NEXT:    vmovdqa a+1024(%rax), %ymm2
; AVX512BW-NEXT:    vpsadbw b+1024(%rax), %ymm2, %ymm2
; AVX512BW-NEXT:    vpaddd %ymm1, %ymm2, %ymm2
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm1, %zmm1
; AVX512BW-NEXT:    addq $4, %rax
; AVX512BW-NEXT:    jne .LBB1_1
; AVX512BW-NEXT:  # BB#2: # %middle.block
; AVX512BW-NEXT:    vpaddd %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,0,1]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[2,3,0,1,0,1,0,1]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[2,3,2,3,6,7,6,7,10,11,10,11,14,15,14,15]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[1,1,2,3,5,5,6,7,9,9,10,11,13,13,14,15]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovd %xmm0, %eax
; AVX512BW-NEXT:    retq
entry:
  br label %vector.body

vector.body:
  %index = phi i64 [ 0, %entry ], [ %index.next, %vector.body ]
  %vec.phi = phi <32 x i32> [ zeroinitializer, %entry ], [ %10, %vector.body ]
  %0 = getelementptr inbounds [1024 x i8], [1024 x i8]* @a, i64 0, i64 %index
  %1 = bitcast i8* %0 to <32 x i8>*
  %wide.load = load <32 x i8>, <32 x i8>* %1, align 32
  %2 = zext <32 x i8> %wide.load to <32 x i32>
  %3 = getelementptr inbounds [1024 x i8], [1024 x i8]* @b, i64 0, i64 %index
  %4 = bitcast i8* %3 to <32 x i8>*
  %wide.load1 = load <32 x i8>, <32 x i8>* %4, align 32
  %5 = zext <32 x i8> %wide.load1 to <32 x i32>
  %6 = sub nsw <32 x i32> %2, %5
  %7 = icmp sgt <32 x i32> %6, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %8 = sub nsw <32 x i32> zeroinitializer, %6
  %9 = select <32 x i1> %7, <32 x i32> %6, <32 x i32> %8
  %10 = add nsw <32 x i32> %9, %vec.phi
  %index.next = add i64 %index, 4
  %11 = icmp eq i64 %index.next, 1024
  br i1 %11, label %middle.block, label %vector.body

middle.block:
  %.lcssa = phi <32 x i32> [ %10, %vector.body ]
  %rdx.shuf = shufflevector <32 x i32> %.lcssa, <32 x i32> undef, <32 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx = add <32 x i32> %.lcssa, %rdx.shuf
  %rdx.shuf2 = shufflevector <32 x i32> %bin.rdx, <32 x i32> undef, <32 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx2 = add <32 x i32> %bin.rdx, %rdx.shuf2
  %rdx.shuf3 = shufflevector <32 x i32> %bin.rdx2, <32 x i32> undef, <32 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx3 = add <32 x i32> %bin.rdx2, %rdx.shuf3
  %rdx.shuf4 = shufflevector <32 x i32> %bin.rdx3, <32 x i32> undef, <32 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx4 = add <32 x i32> %bin.rdx3, %rdx.shuf4
  %rdx.shuf5 = shufflevector <32 x i32> %bin.rdx4, <32 x i32> undef, <32 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx5 = add <32 x i32> %bin.rdx4, %rdx.shuf5
  %12 = extractelement <32 x i32> %bin.rdx5, i32 0
  ret i32 %12
}

define i32 @sad_avx64i8() nounwind {
; SSE2-LABEL: sad_avx64i8:
; SSE2:       # BB#0: # %entry
; SSE2-NEXT:    subq $232, %rsp
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    movq $-1024, %rax # imm = 0xFC00
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    movdqa %xmm0, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    pxor %xmm13, %xmm13
; SSE2-NEXT:    pxor %xmm10, %xmm10
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    movdqa %xmm0, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    pxor %xmm12, %xmm12
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    movdqa %xmm0, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    pxor %xmm11, %xmm11
; SSE2-NEXT:    pxor %xmm15, %xmm15
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    .p2align 4, 0x90
; SSE2-NEXT:  .LBB2_1: # %vector.body
; SSE2-NEXT:    # =>This Inner Loop Header: Depth=1
; SSE2-NEXT:    movdqa %xmm12, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm7, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm15, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm11, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm9, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm3, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm2, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm6, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm1, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm5, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm13, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm10, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa a+1040(%rax), %xmm13
; SSE2-NEXT:    movdqa a+1024(%rax), %xmm1
; SSE2-NEXT:    movdqa a+1056(%rax), %xmm3
; SSE2-NEXT:    movdqa a+1072(%rax), %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,3,0,1]
; SSE2-NEXT:    movdqa %xmm0, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm8[0],xmm3[1],xmm8[1],xmm3[2],xmm8[2],xmm3[3],xmm8[3],xmm3[4],xmm8[4],xmm3[5],xmm8[5],xmm3[6],xmm8[6],xmm3[7],xmm8[7]
; SSE2-NEXT:    movdqa %xmm3, %xmm12
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,0,1]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3],xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm13[2,3,0,1]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm8[0],xmm10[1],xmm8[1],xmm10[2],xmm8[2],xmm10[3],xmm8[3],xmm10[4],xmm8[4],xmm10[5],xmm8[5],xmm10[6],xmm8[6],xmm10[7],xmm8[7]
; SSE2-NEXT:    movdqa %xmm10, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4],xmm8[4],xmm10[5],xmm8[5],xmm10[6],xmm8[6],xmm10[7],xmm8[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm8[0],xmm3[1],xmm8[1],xmm3[2],xmm8[2],xmm3[3],xmm8[3]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1],xmm1[2],xmm8[2],xmm1[3],xmm8[3],xmm1[4],xmm8[4],xmm1[5],xmm8[5],xmm1[6],xmm8[6],xmm1[7],xmm8[7]
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; SSE2-NEXT:    movdqa %xmm0, %xmm15
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm8[4],xmm1[5],xmm8[5],xmm1[6],xmm8[6],xmm1[7],xmm8[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm13 = xmm13[0],xmm8[0],xmm13[1],xmm8[1],xmm13[2],xmm8[2],xmm13[3],xmm8[3],xmm13[4],xmm8[4],xmm13[5],xmm8[5],xmm13[6],xmm8[6],xmm13[7],xmm8[7]
; SSE2-NEXT:    movdqa %xmm13, %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm13 = xmm13[4],xmm8[4],xmm13[5],xmm8[5],xmm13[6],xmm8[6],xmm13[7],xmm8[7]
; SSE2-NEXT:    movdqa b+1040(%rax), %xmm7
; SSE2-NEXT:    movdqa b+1024(%rax), %xmm11
; SSE2-NEXT:    movdqa b+1056(%rax), %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[2,3,0,1]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3],xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE2-NEXT:    movdqa %xmm7, %xmm4
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE2-NEXT:    psubd %xmm7, %xmm13
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm11[2,3,0,1]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0],xmm8[0],xmm11[1],xmm8[1],xmm11[2],xmm8[2],xmm11[3],xmm8[3],xmm11[4],xmm8[4],xmm11[5],xmm8[5],xmm11[6],xmm8[6],xmm11[7],xmm8[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3]
; SSE2-NEXT:    psubd %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm11, %xmm4
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm11 = xmm11[4],xmm8[4],xmm11[5],xmm8[5],xmm11[6],xmm8[6],xmm11[7],xmm8[7]
; SSE2-NEXT:    psubd %xmm11, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm14 = xmm9[2,3,0,1]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm9 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3],xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3]
; SSE2-NEXT:    psubd %xmm4, %xmm15
; SSE2-NEXT:    movdqa %xmm15, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm9, %xmm4
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm8[0],xmm5[1],xmm8[1],xmm5[2],xmm8[2],xmm5[3],xmm8[3],xmm5[4],xmm8[4],xmm5[5],xmm8[5],xmm5[6],xmm8[6],xmm5[7],xmm8[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; SSE2-NEXT:    psubd %xmm9, %xmm3
; SSE2-NEXT:    movdqa %xmm5, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm8[4],xmm5[5],xmm8[5],xmm5[6],xmm8[6],xmm5[7],xmm8[7]
; SSE2-NEXT:    psubd %xmm5, %xmm10
; SSE2-NEXT:    movdqa %xmm2, %xmm15
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm5 # 16-byte Reload
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm8[0],xmm5[1],xmm8[1],xmm5[2],xmm8[2],xmm5[3],xmm8[3]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3],xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; SSE2-NEXT:    psubd %xmm0, %xmm5
; SSE2-NEXT:    movdqa %xmm5, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm7, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE2-NEXT:    psubd %xmm7, %xmm2
; SSE2-NEXT:    movdqa %xmm2, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[2,3,0,1]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm8[0],xmm6[1],xmm8[1],xmm6[2],xmm8[2],xmm6[3],xmm8[3],xmm6[4],xmm8[4],xmm6[5],xmm8[5],xmm6[6],xmm8[6],xmm6[7],xmm8[7]
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm2 # 16-byte Reload
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3],xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm8[0],xmm15[1],xmm8[1],xmm15[2],xmm8[2],xmm15[3],xmm8[3]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; SSE2-NEXT:    psubd %xmm0, %xmm15
; SSE2-NEXT:    movdqa %xmm2, %xmm11
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm12 = xmm12[4],xmm8[4],xmm12[5],xmm8[5],xmm12[6],xmm8[6],xmm12[7],xmm8[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm14 = xmm14[0],xmm8[0],xmm14[1],xmm8[1],xmm14[2],xmm8[2],xmm14[3],xmm8[3],xmm14[4],xmm8[4],xmm14[5],xmm8[5],xmm14[6],xmm8[6],xmm14[7],xmm8[7]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm8[4],xmm4[5],xmm8[5],xmm4[6],xmm8[6],xmm4[7],xmm8[7]
; SSE2-NEXT:    psubd %xmm4, %xmm12
; SSE2-NEXT:    movdqa %xmm14, %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm14 = xmm14[0],xmm8[0],xmm14[1],xmm8[1],xmm14[2],xmm8[2],xmm14[3],xmm8[3]
; SSE2-NEXT:    psubd %xmm14, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm14
; SSE2-NEXT:    movdqa %xmm6, %xmm9
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm8[0],xmm6[1],xmm8[1],xmm6[2],xmm8[2],xmm6[3],xmm8[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm11 = xmm11[4],xmm8[4],xmm11[5],xmm8[5],xmm11[6],xmm8[6],xmm11[7],xmm8[7]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; SSE2-NEXT:    psubd %xmm0, %xmm11
; SSE2-NEXT:    movdqa b+1072(%rax), %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[2,3,0,1]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3],xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; SSE2-NEXT:    psubd %xmm0, %xmm6
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm8[4],xmm5[5],xmm8[5],xmm5[6],xmm8[6],xmm5[7],xmm8[7]
; SSE2-NEXT:    psubd %xmm5, %xmm9
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3],xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE2-NEXT:    movdqa %xmm7, %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3],xmm4[4],xmm8[4],xmm4[5],xmm8[5],xmm4[6],xmm8[6],xmm4[7],xmm8[7]
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3]
; SSE2-NEXT:    psubd %xmm4, %xmm7
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm8[4],xmm5[5],xmm8[5],xmm5[6],xmm8[6],xmm5[7],xmm8[7]
; SSE2-NEXT:    psubd %xmm5, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm0
; SSE2-NEXT:    pxor %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm7, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm7
; SSE2-NEXT:    pxor %xmm4, %xmm7
; SSE2-NEXT:    movdqa %xmm9, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm9
; SSE2-NEXT:    pxor %xmm4, %xmm9
; SSE2-NEXT:    movdqa %xmm6, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm6
; SSE2-NEXT:    pxor %xmm4, %xmm6
; SSE2-NEXT:    movdqa %xmm6, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm11, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm11
; SSE2-NEXT:    pxor %xmm4, %xmm11
; SSE2-NEXT:    movdqa %xmm14, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm14
; SSE2-NEXT:    pxor %xmm4, %xmm14
; SSE2-NEXT:    movdqa %xmm12, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm12
; SSE2-NEXT:    pxor %xmm4, %xmm12
; SSE2-NEXT:    movdqa %xmm12, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm15, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm15
; SSE2-NEXT:    pxor %xmm4, %xmm15
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm2 # 16-byte Reload
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm2, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm2 # 16-byte Reload
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm2, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm10, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm10
; SSE2-NEXT:    pxor %xmm4, %xmm10
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm3
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm2 # 16-byte Reload
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm2, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm2 # 16-byte Reload
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm13, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm13
; SSE2-NEXT:    pxor %xmm4, %xmm13
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm2 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm13, %xmm2
; SSE2-NEXT:    movdqa %xmm2, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm12 # 16-byte Reload
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm6 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm5, %xmm6
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm4 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm1, %xmm4
; SSE2-NEXT:    movdqa %xmm4, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm2 # 16-byte Reload
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5 # 16-byte Reload
; SSE2-NEXT:    paddd -{{[0-9]+}}(%rsp), %xmm5 # 16-byte Folded Reload
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm4 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm3, %xmm4
; SSE2-NEXT:    movdqa %xmm4, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm3 # 16-byte Reload
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm4 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm10, %xmm4
; SSE2-NEXT:    movdqa %xmm4, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm13 # 16-byte Reload
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm10 # 16-byte Reload
; SSE2-NEXT:    paddd -{{[0-9]+}}(%rsp), %xmm13 # 16-byte Folded Reload
; SSE2-NEXT:    paddd -{{[0-9]+}}(%rsp), %xmm3 # 16-byte Folded Reload
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm15, %xmm1
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm15 # 16-byte Reload
; SSE2-NEXT:    paddd {{[0-9]+}}(%rsp), %xmm12 # 16-byte Folded Reload
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm4 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm14, %xmm4
; SSE2-NEXT:    movdqa %xmm4, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm4 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm11, %xmm4
; SSE2-NEXT:    movdqa %xmm4, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm11 # 16-byte Reload
; SSE2-NEXT:    paddd -{{[0-9]+}}(%rsp), %xmm15 # 16-byte Folded Reload
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm4 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm9, %xmm4
; SSE2-NEXT:    movdqa %xmm4, {{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9 # 16-byte Reload
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm4 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm7, %xmm4
; SSE2-NEXT:    movdqa %xmm4, -{{[0-9]+}}(%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm7 # 16-byte Reload
; SSE2-NEXT:    movdqa (%rsp), %xmm4 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm0, %xmm4
; SSE2-NEXT:    movdqa %xmm4, (%rsp) # 16-byte Spill
; SSE2-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE2-NEXT:    addq $4, %rax
; SSE2-NEXT:    jne .LBB2_1
; SSE2-NEXT:  # BB#2: # %middle.block
; SSE2-NEXT:    paddd -{{[0-9]+}}(%rsp), %xmm1 # 16-byte Folded Reload
; SSE2-NEXT:    paddd %xmm7, %xmm13
; SSE2-NEXT:    paddd -{{[0-9]+}}(%rsp), %xmm5 # 16-byte Folded Reload
; SSE2-NEXT:    paddd %xmm15, %xmm6
; SSE2-NEXT:    paddd %xmm11, %xmm3
; SSE2-NEXT:    paddd %xmm0, %xmm10
; SSE2-NEXT:    paddd %xmm12, %xmm2
; SSE2-NEXT:    movdqa -{{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; SSE2-NEXT:    paddd %xmm9, %xmm0
; SSE2-NEXT:    paddd %xmm2, %xmm0
; SSE2-NEXT:    paddd %xmm3, %xmm10
; SSE2-NEXT:    paddd %xmm5, %xmm6
; SSE2-NEXT:    paddd %xmm1, %xmm13
; SSE2-NEXT:    paddd %xmm6, %xmm13
; SSE2-NEXT:    paddd %xmm0, %xmm10
; SSE2-NEXT:    paddd %xmm13, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm10[2,3,0,1]
; SSE2-NEXT:    paddd %xmm10, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; SSE2-NEXT:    paddd %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    addq $232, %rsp
; SSE2-NEXT:    retq
;
; AVX2-LABEL: sad_avx64i8:
; AVX2:       # BB#0: # %entry
; AVX2-NEXT:    vpxor %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX2-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpxor %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm3, %ymm3, %ymm3
; AVX2-NEXT:    vpxor %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpxor %ymm6, %ymm6, %ymm6
; AVX2-NEXT:    vpxor %ymm5, %ymm5, %ymm5
; AVX2-NEXT:    vpxor %ymm7, %ymm7, %ymm7
; AVX2-NEXT:    .p2align 4, 0x90
; AVX2-NEXT:  .LBB2_1: # %vector.body
; AVX2-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm8 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vmovdqu %ymm8, -{{[0-9]+}}(%rsp) # 32-byte Spill
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm9 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm10 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm11 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm12 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm13 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm14 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm15 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm8 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpsubd %ymm8, %ymm15, %ymm8
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm15 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpsubd %ymm15, %ymm14, %ymm14
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm15 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpsubd %ymm15, %ymm13, %ymm13
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm15 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpsubd %ymm15, %ymm12, %ymm12
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm15 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpsubd %ymm15, %ymm11, %ymm11
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm15 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpsubd %ymm15, %ymm10, %ymm10
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm15 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vpsubd %ymm15, %ymm9, %ymm9
; AVX2-NEXT:    vmovdqu %ymm9, -{{[0-9]+}}(%rsp) # 32-byte Spill
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm15 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vmovdqu -{{[0-9]+}}(%rsp), %ymm9 # 32-byte Reload
; AVX2-NEXT:    vpsubd %ymm15, %ymm9, %ymm15
; AVX2-NEXT:    vpabsd %ymm8, %ymm8
; AVX2-NEXT:    vpaddd %ymm3, %ymm8, %ymm3
; AVX2-NEXT:    vpabsd %ymm14, %ymm8
; AVX2-NEXT:    vpaddd %ymm1, %ymm8, %ymm1
; AVX2-NEXT:    vpabsd %ymm13, %ymm8
; AVX2-NEXT:    vpaddd %ymm2, %ymm8, %ymm2
; AVX2-NEXT:    vpabsd %ymm12, %ymm8
; AVX2-NEXT:    vpaddd %ymm0, %ymm8, %ymm0
; AVX2-NEXT:    vpabsd %ymm11, %ymm8
; AVX2-NEXT:    vpaddd %ymm4, %ymm8, %ymm4
; AVX2-NEXT:    vpabsd %ymm10, %ymm8
; AVX2-NEXT:    vpaddd %ymm6, %ymm8, %ymm6
; AVX2-NEXT:    vpabsd -{{[0-9]+}}(%rsp), %ymm8 # 32-byte Folded Reload
; AVX2-NEXT:    vpaddd %ymm5, %ymm8, %ymm5
; AVX2-NEXT:    vpabsd %ymm15, %ymm8
; AVX2-NEXT:    vpaddd %ymm7, %ymm8, %ymm7
; AVX2-NEXT:    addq $4, %rax
; AVX2-NEXT:    jne .LBB2_1
; AVX2-NEXT:  # BB#2: # %middle.block
; AVX2-NEXT:    vpaddd %ymm6, %ymm2, %ymm2
; AVX2-NEXT:    vpaddd %ymm7, %ymm3, %ymm3
; AVX2-NEXT:    vpaddd %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm2, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vphaddd %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sad_avx64i8:
; AVX512F:       # BB#0: # %entry
; AVX512F-NEXT:    vpxord %zmm0, %zmm0, %zmm0
; AVX512F-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX512F-NEXT:    vpxord %zmm1, %zmm1, %zmm1
; AVX512F-NEXT:    vpxord %zmm2, %zmm2, %zmm2
; AVX512F-NEXT:    vpxord %zmm3, %zmm3, %zmm3
; AVX512F-NEXT:    .p2align 4, 0x90
; AVX512F-NEXT:  .LBB2_1: # %vector.body
; AVX512F-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm4 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero,mem[8],zero,zero,zero,mem[9],zero,zero,zero,mem[10],zero,zero,zero,mem[11],zero,zero,zero,mem[12],zero,zero,zero,mem[13],zero,zero,zero,mem[14],zero,zero,zero,mem[15],zero,zero,zero
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm5 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero,mem[8],zero,zero,zero,mem[9],zero,zero,zero,mem[10],zero,zero,zero,mem[11],zero,zero,zero,mem[12],zero,zero,zero,mem[13],zero,zero,zero,mem[14],zero,zero,zero,mem[15],zero,zero,zero
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm6 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero,mem[8],zero,zero,zero,mem[9],zero,zero,zero,mem[10],zero,zero,zero,mem[11],zero,zero,zero,mem[12],zero,zero,zero,mem[13],zero,zero,zero,mem[14],zero,zero,zero,mem[15],zero,zero,zero
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm7 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero,mem[8],zero,zero,zero,mem[9],zero,zero,zero,mem[10],zero,zero,zero,mem[11],zero,zero,zero,mem[12],zero,zero,zero,mem[13],zero,zero,zero,mem[14],zero,zero,zero,mem[15],zero,zero,zero
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm8 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero,mem[8],zero,zero,zero,mem[9],zero,zero,zero,mem[10],zero,zero,zero,mem[11],zero,zero,zero,mem[12],zero,zero,zero,mem[13],zero,zero,zero,mem[14],zero,zero,zero,mem[15],zero,zero,zero
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm9 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero,mem[8],zero,zero,zero,mem[9],zero,zero,zero,mem[10],zero,zero,zero,mem[11],zero,zero,zero,mem[12],zero,zero,zero,mem[13],zero,zero,zero,mem[14],zero,zero,zero,mem[15],zero,zero,zero
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm10 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero,mem[8],zero,zero,zero,mem[9],zero,zero,zero,mem[10],zero,zero,zero,mem[11],zero,zero,zero,mem[12],zero,zero,zero,mem[13],zero,zero,zero,mem[14],zero,zero,zero,mem[15],zero,zero,zero
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm11 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero,mem[8],zero,zero,zero,mem[9],zero,zero,zero,mem[10],zero,zero,zero,mem[11],zero,zero,zero,mem[12],zero,zero,zero,mem[13],zero,zero,zero,mem[14],zero,zero,zero,mem[15],zero,zero,zero
; AVX512F-NEXT:    vpsubd %zmm11, %zmm7, %zmm7
; AVX512F-NEXT:    vpsubd %zmm10, %zmm6, %zmm6
; AVX512F-NEXT:    vpsubd %zmm9, %zmm5, %zmm5
; AVX512F-NEXT:    vpsubd %zmm8, %zmm4, %zmm4
; AVX512F-NEXT:    vpabsd %zmm4, %zmm4
; AVX512F-NEXT:    vpabsd %zmm5, %zmm5
; AVX512F-NEXT:    vpabsd %zmm6, %zmm6
; AVX512F-NEXT:    vpabsd %zmm7, %zmm7
; AVX512F-NEXT:    vpaddd %zmm3, %zmm7, %zmm3
; AVX512F-NEXT:    vpaddd %zmm2, %zmm6, %zmm2
; AVX512F-NEXT:    vpaddd %zmm1, %zmm5, %zmm1
; AVX512F-NEXT:    vpaddd %zmm0, %zmm4, %zmm0
; AVX512F-NEXT:    addq $4, %rax
; AVX512F-NEXT:    jne .LBB2_1
; AVX512F-NEXT:  # BB#2: # %middle.block
; AVX512F-NEXT:    vpaddd %zmm2, %zmm0, %zmm0
; AVX512F-NEXT:    vpaddd %zmm3, %zmm1, %zmm1
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,0,1]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[2,3,0,1,0,1,0,1]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[2,3,2,3,6,7,6,7,10,11,10,11,14,15,14,15]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[1,1,2,3,5,5,6,7,9,9,10,11,13,13,14,15]
; AVX512F-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: sad_avx64i8:
; AVX512BW:       # BB#0: # %entry
; AVX512BW-NEXT:    vpxord %zmm0, %zmm0, %zmm0
; AVX512BW-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX512BW-NEXT:    vpxord %zmm1, %zmm1, %zmm1
; AVX512BW-NEXT:    .p2align 4, 0x90
; AVX512BW-NEXT:  .LBB2_1: # %vector.body
; AVX512BW-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX512BW-NEXT:    vmovdqu8 a+1024(%rax), %zmm2
; AVX512BW-NEXT:    vpsadbw b+1024(%rax), %zmm2, %zmm2
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm2, %zmm1
; AVX512BW-NEXT:    addq $4, %rax
; AVX512BW-NEXT:    jne .LBB2_1
; AVX512BW-NEXT:  # BB#2: # %middle.block
; AVX512BW-NEXT:    vpaddd %zmm0, %zmm1, %zmm1
; AVX512BW-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddd %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,0,1]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[2,3,0,1,0,1,0,1]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[2,3,2,3,6,7,6,7,10,11,10,11,14,15,14,15]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufd {{.*#+}} zmm1 = zmm0[1,1,2,3,5,5,6,7,9,9,10,11,13,13,14,15]
; AVX512BW-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovd %xmm0, %eax
; AVX512BW-NEXT:    retq
entry:
  br label %vector.body

vector.body:
  %index = phi i64 [ 0, %entry ], [ %index.next, %vector.body ]
  %vec.phi = phi <64 x i32> [ zeroinitializer, %entry ], [ %10, %vector.body ]
  %0 = getelementptr inbounds [1024 x i8], [1024 x i8]* @a, i64 0, i64 %index
  %1 = bitcast i8* %0 to <64 x i8>*
  %wide.load = load <64 x i8>, <64 x i8>* %1, align 64
  %2 = zext <64 x i8> %wide.load to <64 x i32>
  %3 = getelementptr inbounds [1024 x i8], [1024 x i8]* @b, i64 0, i64 %index
  %4 = bitcast i8* %3 to <64 x i8>*
  %wide.load1 = load <64 x i8>, <64 x i8>* %4, align 64
  %5 = zext <64 x i8> %wide.load1 to <64 x i32>
  %6 = sub nsw <64 x i32> %2, %5
  %7 = icmp sgt <64 x i32> %6, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %8 = sub nsw <64 x i32> zeroinitializer, %6
  %9 = select <64 x i1> %7, <64 x i32> %6, <64 x i32> %8
  %10 = add nsw <64 x i32> %9, %vec.phi
  %index.next = add i64 %index, 4
  %11 = icmp eq i64 %index.next, 1024
  br i1 %11, label %middle.block, label %vector.body

middle.block:
  %.lcssa = phi <64 x i32> [ %10, %vector.body ]
  %rdx.shuf = shufflevector <64 x i32> %.lcssa, <64 x i32> undef, <64 x i32> <i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx = add <64 x i32> %.lcssa, %rdx.shuf
  %rdx.shuf2 = shufflevector <64 x i32> %bin.rdx, <64 x i32> undef, <64 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx2 = add <64 x i32> %bin.rdx, %rdx.shuf2
  %rdx.shuf3 = shufflevector <64 x i32> %bin.rdx2, <64 x i32> undef, <64 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx3 = add <64 x i32> %bin.rdx2, %rdx.shuf3
  %rdx.shuf4 = shufflevector <64 x i32> %bin.rdx3, <64 x i32> undef, <64 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx4 = add <64 x i32> %bin.rdx3, %rdx.shuf4
  %rdx.shuf5 = shufflevector <64 x i32> %bin.rdx4, <64 x i32> undef, <64 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx5 = add <64 x i32> %bin.rdx4, %rdx.shuf5
  %rdx.shuf6 = shufflevector <64 x i32> %bin.rdx5, <64 x i32> undef, <64 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %bin.rdx6 = add <64 x i32> %bin.rdx5, %rdx.shuf6
  %12 = extractelement <64 x i32> %bin.rdx6, i32 0
  ret i32 %12
}

define i32 @sad_2i8() nounwind {
; SSE2-LABEL: sad_2i8:
; SSE2:       # BB#0: # %entry
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    movq $-1024, %rax # imm = 0xFC00
; SSE2-NEXT:    movl $65535, %ecx # imm = 0xFFFF
; SSE2-NEXT:    movd %ecx, %xmm1
; SSE2-NEXT:    .p2align 4, 0x90
; SSE2-NEXT:  .LBB3_1: # %vector.body
; SSE2-NEXT:    # =>This Inner Loop Header: Depth=1
; SSE2-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    psadbw %xmm3, %xmm2
; SSE2-NEXT:    paddq %xmm2, %xmm0
; SSE2-NEXT:    addq $4, %rax
; SSE2-NEXT:    jne .LBB3_1
; SSE2-NEXT:  # BB#2: # %middle.block
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; SSE2-NEXT:    paddq %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    retq
;
; AVX2-LABEL: sad_2i8:
; AVX2:       # BB#0: # %entry
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    .p2align 4, 0x90
; AVX2-NEXT:  .LBB3_1: # %vector.body
; AVX2-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX2-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX2-NEXT:    vmovd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm0[1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm0[1,2,3,4,5,6,7]
; AVX2-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpaddq %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    addq $4, %rax
; AVX2-NEXT:    jne .LBB3_1
; AVX2-NEXT:  # BB#2: # %middle.block
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[2,3,0,1]
; AVX2-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sad_2i8:
; AVX512F:       # BB#0: # %entry
; AVX512F-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    .p2align 4, 0x90
; AVX512F-NEXT:  .LBB3_1: # %vector.body
; AVX512F-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX512F-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX512F-NEXT:    vmovd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm0[1,2,3,4,5,6,7]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm0[1,2,3,4,5,6,7]
; AVX512F-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpaddq %xmm1, %xmm2, %xmm1
; AVX512F-NEXT:    addq $4, %rax
; AVX512F-NEXT:    jne .LBB3_1
; AVX512F-NEXT:  # BB#2: # %middle.block
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[2,3,0,1]
; AVX512F-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: sad_2i8:
; AVX512BW:       # BB#0: # %entry
; AVX512BW-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    movq $-1024, %rax # imm = 0xFC00
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    .p2align 4, 0x90
; AVX512BW-NEXT:  .LBB3_1: # %vector.body
; AVX512BW-NEXT:    # =>This Inner Loop Header: Depth=1
; AVX512BW-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX512BW-NEXT:    vmovd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm0[1,2,3,4,5,6,7]
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm0[1,2,3,4,5,6,7]
; AVX512BW-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vpaddq %xmm1, %xmm2, %xmm1
; AVX512BW-NEXT:    addq $4, %rax
; AVX512BW-NEXT:    jne .LBB3_1
; AVX512BW-NEXT:  # BB#2: # %middle.block
; AVX512BW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[2,3,0,1]
; AVX512BW-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX512BW-NEXT:    vmovd %xmm0, %eax
; AVX512BW-NEXT:    retq
entry:
  br label %vector.body

vector.body:
  %index = phi i64 [ 0, %entry ], [ %index.next, %vector.body ]
  %vec.phi = phi <2 x i32> [ zeroinitializer, %entry ], [ %10, %vector.body ]
  %0 = getelementptr inbounds [1024 x i8], [1024 x i8]* @a, i64 0, i64 %index
  %1 = bitcast i8* %0 to <2 x i8>*
  %wide.load = load <2 x i8>, <2 x i8>* %1, align 4
  %2 = zext <2 x i8> %wide.load to <2 x i32>
  %3 = getelementptr inbounds [1024 x i8], [1024 x i8]* @b, i64 0, i64 %index
  %4 = bitcast i8* %3 to <2 x i8>*
  %wide.load1 = load <2 x i8>, <2 x i8>* %4, align 4
  %5 = zext <2 x i8> %wide.load1 to <2 x i32>
  %6 = sub nsw <2 x i32> %2, %5
  %7 = icmp sgt <2 x i32> %6, <i32 -1, i32 -1>
  %8 = sub nsw <2 x i32> zeroinitializer, %6
  %9 = select <2 x i1> %7, <2 x i32> %6, <2 x i32> %8
  %10 = add nsw <2 x i32> %9, %vec.phi
  %index.next = add i64 %index, 4
  %11 = icmp eq i64 %index.next, 1024
  br i1 %11, label %middle.block, label %vector.body

middle.block:
  %.lcssa = phi <2 x i32> [ %10, %vector.body ]
  %rdx.shuf = shufflevector <2 x i32> %.lcssa, <2 x i32> undef, <2 x i32> <i32 1, i32 undef>
  %bin.rdx = add <2 x i32> %.lcssa, %rdx.shuf
  %12 = extractelement <2 x i32> %bin.rdx, i32 0
  ret i32 %12
}

