/* DO NOT EDIT *************************************************
 * THIS FILE AUTOMATICALLY GENERATED BY THE es_generator.py SCRIPT
 * API specification file:   main/APIspec.txt
 * GLES version:             GLES1.1
 * date:                     2009-09-15 11:32:17
 */


#include "GLES/gl.h"
#include "GLES/glext.h"


/* These types are needed for the Mesa veneer, but are not defined in
 * the standard GLES headers.
 */
typedef double GLdouble;
typedef double GLclampd;

/* This type is normally in glext.h, but needed here */
typedef char GLchar;

/* Mesa error handling requires these */
extern void *_mesa_get_current_context(void);
extern void _mesa_error(void *ctx, GLenum error, const char *fmtString, ... );

#include "main/compiler.h"
#include "main/api_exec.h"

#define HAVE_GLES_TYPES
#include "glapi/dispatch.h"

typedef void (*_glapi_proc)(void); /* generic function pointer */


extern void GLAPIENTRY _mesa_GetIntegerv(GLenum, GLint *);
static INLINE unsigned int _get_size(GLenum pname)
{
    /* In case of error, make sure the value returned is 0. */
    GLint value = 0;
    _mesa_GetIntegerv(pname, &value);
    return (unsigned int) value;
}

/*************************************************************
 * Generated functions begin here
 */

extern void GLAPIENTRY _mesa_ActiveTextureARB(GLenum texture);
static void _es_ActiveTexture(GLenum texture)
{
    switch(texture) {
        case GL_TEXTURE0:
        case GL_TEXTURE1:
        case GL_TEXTURE2:
        case GL_TEXTURE3:
        case GL_TEXTURE4:
        case GL_TEXTURE5:
        case GL_TEXTURE6:
        case GL_TEXTURE7:
        case GL_TEXTURE8:
        case GL_TEXTURE9:
        case GL_TEXTURE10:
        case GL_TEXTURE11:
        case GL_TEXTURE12:
        case GL_TEXTURE13:
        case GL_TEXTURE14:
        case GL_TEXTURE15:
        case GL_TEXTURE16:
        case GL_TEXTURE17:
        case GL_TEXTURE18:
        case GL_TEXTURE19:
        case GL_TEXTURE20:
        case GL_TEXTURE21:
        case GL_TEXTURE22:
        case GL_TEXTURE23:
        case GL_TEXTURE24:
        case GL_TEXTURE25:
        case GL_TEXTURE26:
        case GL_TEXTURE27:
        case GL_TEXTURE28:
        case GL_TEXTURE29:
        case GL_TEXTURE30:
        case GL_TEXTURE31:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glActiveTexture(texture=0x%x)", texture);
            return;
    } 

    _mesa_ActiveTextureARB(texture);
}

extern void GLAPIENTRY _mesa_AlphaFunc(GLenum func, GLclampf ref);
static void _es_AlphaFunc(GLenum func, GLclampf ref)
{
    switch(func) {
        case GL_NEVER:
        case GL_LESS:
        case GL_EQUAL:
        case GL_LEQUAL:
        case GL_GREATER:
        case GL_NOTEQUAL:
        case GL_GEQUAL:
        case GL_ALWAYS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glAlphaFunc(func=0x%x)", func);
            return;
    } 

    _mesa_AlphaFunc(func, ref);
}

extern void GLAPIENTRY _mesa_AlphaFunc(GLenum func, GLclampf  ref);
static void _es_AlphaFuncx(GLenum func, GLclampx ref)
{
    GLclampf converted_ref; 

    switch(func) {
        case GL_NEVER:
        case GL_LESS:
        case GL_EQUAL:
        case GL_LEQUAL:
        case GL_GREATER:
        case GL_NOTEQUAL:
        case GL_GEQUAL:
        case GL_ALWAYS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glAlphaFuncx(func=0x%x)", func);
            return;
    } 

    converted_ref = (GLclampf) (ref / 65536.0f); 

    _mesa_AlphaFunc(func, converted_ref);
}

/* Extension OES_fixed_point */
static void _es_AlphaFuncxOES(GLenum func, GLclampx ref)
{
    GLclampf converted_ref; 

    switch(func) {
        case GL_NEVER:
        case GL_LESS:
        case GL_EQUAL:
        case GL_LEQUAL:
        case GL_GREATER:
        case GL_NOTEQUAL:
        case GL_GEQUAL:
        case GL_ALWAYS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glAlphaFuncx(func=0x%x)", func);
            return;
    } 

    converted_ref = (GLclampf) (ref / 65536.0f); 

    _mesa_AlphaFunc(func, converted_ref);
}

extern void GLAPIENTRY _mesa_BindBufferARB(GLenum target, GLuint buffer);
static void _es_BindBuffer(GLenum target, GLuint buffer)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBindBuffer(target=0x%x)", target);
            return;
    } 

    _mesa_BindBufferARB(target, buffer);
}

extern void GLAPIENTRY _mesa_BindFramebufferEXT(GLenum target, GLuint framebuffer);
/* Extension OES_framebuffer_object */
static void _es_BindFramebufferOES(GLenum target, GLuint framebuffer)
{
    switch(target) {
        case GL_FRAMEBUFFER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBindFramebuffer(target=0x%x)", target);
            return;
    } 

    _mesa_BindFramebufferEXT(target, framebuffer);
}

extern void GLAPIENTRY _mesa_BindRenderbufferEXT(GLenum target, GLuint renderbuffer);
/* Extension OES_framebuffer_object */
static void _es_BindRenderbufferOES(GLenum target, GLuint renderbuffer)
{
    switch(target) {
        case GL_RENDERBUFFER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBindRenderbuffer(target=0x%x)", target);
            return;
    } 

    _mesa_BindRenderbufferEXT(target, renderbuffer);
}

extern void GLAPIENTRY _mesa_BindTexture(GLenum target, GLuint texture);
static void _es_BindTexture(GLenum target, GLuint texture)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBindTexture(target=0x%x)", target);
            return;
    } 

    _mesa_BindTexture(target, texture);
}

extern void GLAPIENTRY _mesa_BlendEquation(GLenum mode);
/* Extension OES_blend_subtract */
static void _es_BlendEquationOES(GLenum mode)
{
    switch(mode) {
        case GL_FUNC_ADD_OES:
        case GL_FUNC_SUBTRACT_OES:
        case GL_FUNC_REVERSE_SUBTRACT_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendEquation(mode=0x%x)", mode);
            return;
    } 

    _mesa_BlendEquation(mode);
}

extern void GLAPIENTRY _mesa_BlendEquationSeparateEXT(GLenum modeRGB, GLenum modeAlpha);
/* Extension OES_blend_equation_separate */
static void _es_BlendEquationSeparateOES(GLenum modeRGB, GLenum modeAlpha)
{
    switch(modeRGB) {
        case GL_FUNC_ADD_OES:
        case GL_FUNC_SUBTRACT_OES:
        case GL_FUNC_REVERSE_SUBTRACT_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendEquationSeparate(modeRGB=0x%x)", modeRGB);
            return;
    }
    switch(modeAlpha) {
        case GL_FUNC_ADD_OES:
        case GL_FUNC_SUBTRACT_OES:
        case GL_FUNC_REVERSE_SUBTRACT_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendEquationSeparate(modeAlpha=0x%x)", modeAlpha);
            return;
    } 

    _mesa_BlendEquationSeparateEXT(modeRGB, modeAlpha);
}

extern void GLAPIENTRY _mesa_BlendFunc(GLenum sfactor, GLenum dfactor);
static void _es_BlendFunc(GLenum sfactor, GLenum dfactor)
{
    switch(sfactor) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_SRC_ALPHA_SATURATE:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFunc(sfactor=0x%x)", sfactor);
            return;
    }
    switch(dfactor) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_COLOR:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_ONE_MINUS_DST_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFunc(dfactor=0x%x)", dfactor);
            return;
    } 

    _mesa_BlendFunc(sfactor, dfactor);
}

extern void GLAPIENTRY _mesa_BlendFuncSeparateEXT(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
/* Extension OES_blend_func_separate */
static void _es_BlendFuncSeparateOES(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    switch(srcRGB) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_SRC_ALPHA_SATURATE:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(srcRGB=0x%x)", srcRGB);
            return;
    }
    switch(dstRGB) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(dstRGB=0x%x)", dstRGB);
            return;
    }
    switch(srcAlpha) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_SRC_ALPHA_SATURATE:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(srcAlpha=0x%x)", srcAlpha);
            return;
    }
    switch(dstAlpha) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(dstAlpha=0x%x)", dstAlpha);
            return;
    } 

    _mesa_BlendFuncSeparateEXT(srcRGB, dstRGB, srcAlpha, dstAlpha);
}

extern void GLAPIENTRY _mesa_BufferDataARB(GLenum target, GLsizeiptr size, const GLvoid * data, GLenum usage);
static void _es_BufferData(GLenum target, GLsizeiptr size, const GLvoid * data, GLenum usage)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBufferData(target=0x%x)", target);
            return;
    }
    switch(usage) {
        case GL_STATIC_DRAW:
        case GL_DYNAMIC_DRAW:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBufferData(usage=0x%x)", usage);
            return;
    } 

    _mesa_BufferDataARB(target, size, data, usage);
}

extern void GLAPIENTRY _mesa_BufferSubDataARB(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid * data);
static void _es_BufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid * data)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBufferSubData(target=0x%x)", target);
            return;
    } 

    _mesa_BufferSubDataARB(target, offset, size, data);
}

extern GLenum GLAPIENTRY _mesa_CheckFramebufferStatusEXT(GLenum target);
/* Extension OES_framebuffer_object */
static GLenum _es_CheckFramebufferStatusOES(GLenum target)
{
    switch(target) {
        case GL_FRAMEBUFFER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCheckFramebufferStatus(target=0x%x)", target);
            return (GLenum) 0;
    } 

    return _mesa_CheckFramebufferStatusEXT(target);
}

extern void GLAPIENTRY _mesa_Clear(GLbitfield mask);
static void _es_Clear(GLbitfield mask)
{
    switch(mask) {
        case 0:
        case (GL_COLOR_BUFFER_BIT):
        case (GL_DEPTH_BUFFER_BIT):
        case (GL_STENCIL_BUFFER_BIT):
        case (GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT):
        case (GL_COLOR_BUFFER_BIT|GL_STENCIL_BUFFER_BIT):
        case (GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT):
        case (GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT):
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glClear(mask=0x%x)", mask);
            return;
    } 

    _mesa_Clear(mask);
}

extern void GLAPIENTRY _mesa_ClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
static void _es_ClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
    _mesa_ClearColor(red, green, blue, alpha);
}

extern void GLAPIENTRY _mesa_ClearColor(GLclampf  red, GLclampf  green, GLclampf  blue, GLclampf  alpha);
static void _es_ClearColorx(GLclampx red, GLclampx green, GLclampx blue, GLclampx alpha)
{
    GLclampf converted_red;
    GLclampf converted_green;
    GLclampf converted_blue;
    GLclampf converted_alpha; 

    converted_red = (GLclampf) (red / 65536.0f);
    converted_green = (GLclampf) (green / 65536.0f);
    converted_blue = (GLclampf) (blue / 65536.0f);
    converted_alpha = (GLclampf) (alpha / 65536.0f); 

    _mesa_ClearColor(converted_red, converted_green, converted_blue, converted_alpha);
}

/* Extension OES_fixed_point */
static void _es_ClearColorxOES(GLclampx red, GLclampx green, GLclampx blue, GLclampx alpha)
{
    GLclampf converted_red;
    GLclampf converted_green;
    GLclampf converted_blue;
    GLclampf converted_alpha; 

    converted_red = (GLclampf) (red / 65536.0f);
    converted_green = (GLclampf) (green / 65536.0f);
    converted_blue = (GLclampf) (blue / 65536.0f);
    converted_alpha = (GLclampf) (alpha / 65536.0f); 

    _mesa_ClearColor(converted_red, converted_green, converted_blue, converted_alpha);
}

extern void GLAPIENTRY _mesa_ClearDepth(GLclampd  depth);
static void _es_ClearDepthf(GLclampf depth)
{
    GLclampd converted_depth; 

    converted_depth = (GLclampd) (depth); 

    _mesa_ClearDepth(converted_depth);
}

/* Extension OES_single_precision */
static void _es_ClearDepthfOES(GLclampf depth)
{
    GLclampd converted_depth; 

    converted_depth = (GLclampd) (depth); 

    _mesa_ClearDepth(converted_depth);
}

extern void GLAPIENTRY _mesa_ClearDepth(GLclampd  depth);
static void _es_ClearDepthx(GLclampx depth)
{
    GLclampd converted_depth; 

    converted_depth = (GLclampd) (depth / 65536.0); 

    _mesa_ClearDepth(converted_depth);
}

/* Extension OES_fixed_point */
static void _es_ClearDepthxOES(GLclampx depth)
{
    GLclampd converted_depth; 

    converted_depth = (GLclampd) (depth / 65536.0); 

    _mesa_ClearDepth(converted_depth);
}

extern void GLAPIENTRY _mesa_ClearStencil(GLint s);
static void _es_ClearStencil(GLint s)
{
    _mesa_ClearStencil(s);
}

extern void GLAPIENTRY _mesa_ClientActiveTextureARB(GLenum texture);
static void _es_ClientActiveTexture(GLenum texture)
{
    switch(texture) {
        case GL_TEXTURE0:
        case GL_TEXTURE1:
        case GL_TEXTURE2:
        case GL_TEXTURE3:
        case GL_TEXTURE4:
        case GL_TEXTURE5:
        case GL_TEXTURE6:
        case GL_TEXTURE7:
        case GL_TEXTURE8:
        case GL_TEXTURE9:
        case GL_TEXTURE10:
        case GL_TEXTURE11:
        case GL_TEXTURE12:
        case GL_TEXTURE13:
        case GL_TEXTURE14:
        case GL_TEXTURE15:
        case GL_TEXTURE16:
        case GL_TEXTURE17:
        case GL_TEXTURE18:
        case GL_TEXTURE19:
        case GL_TEXTURE20:
        case GL_TEXTURE21:
        case GL_TEXTURE22:
        case GL_TEXTURE23:
        case GL_TEXTURE24:
        case GL_TEXTURE25:
        case GL_TEXTURE26:
        case GL_TEXTURE27:
        case GL_TEXTURE28:
        case GL_TEXTURE29:
        case GL_TEXTURE30:
        case GL_TEXTURE31:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glClientActiveTexture(texture=0x%x)", texture);
            return;
    } 

    _mesa_ClientActiveTextureARB(texture);
}

extern void GLAPIENTRY _mesa_ClipPlane(GLenum plane, GLdouble const * equation);
static void _es_ClipPlanef(GLenum plane, const GLfloat * equation)
{
    register unsigned int i;
    unsigned int n_equation = 4;
    GLdouble converted_equation[4]; 

    switch(plane) {
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glClipPlanef(plane=0x%x)", plane);
            return;
    } 

    for (i = 0; i < n_equation; i++) {
        converted_equation[i] = (GLdouble) (equation[i]);
    } 

    _mesa_ClipPlane(plane, converted_equation);
}

/* Extension OES_single_precision */
static void _es_ClipPlanefOES(GLenum plane, const GLfloat * equation)
{
    register unsigned int i;
    unsigned int n_equation = 4;
    GLdouble converted_equation[4]; 

    switch(plane) {
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glClipPlanef(plane=0x%x)", plane);
            return;
    } 

    for (i = 0; i < n_equation; i++) {
        converted_equation[i] = (GLdouble) (equation[i]);
    } 

    _mesa_ClipPlane(plane, converted_equation);
}

extern void GLAPIENTRY _mesa_ClipPlane(GLenum plane, GLdouble const * equation);
static void _es_ClipPlanex(GLenum plane, const GLfixed * equation)
{
    register unsigned int i;
    unsigned int n_equation = 4;
    GLdouble converted_equation[4]; 

    switch(plane) {
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glClipPlanex(plane=0x%x)", plane);
            return;
    } 

    for (i = 0; i < n_equation; i++) {
        converted_equation[i] = (GLdouble) (equation[i] / 65536.0);
    } 

    _mesa_ClipPlane(plane, converted_equation);
}

/* Extension OES_fixed_point */
static void _es_ClipPlanexOES(GLenum plane, const GLfixed * equation)
{
    register unsigned int i;
    unsigned int n_equation = 4;
    GLdouble converted_equation[4]; 

    switch(plane) {
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glClipPlanex(plane=0x%x)", plane);
            return;
    } 

    for (i = 0; i < n_equation; i++) {
        converted_equation[i] = (GLdouble) (equation[i] / 65536.0);
    } 

    _mesa_ClipPlane(plane, converted_equation);
}

extern void GLAPIENTRY _vbo_Color4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
static void _es_Color4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    _vbo_Color4f(red, green, blue, alpha);
}

extern void GLAPIENTRY _vbo_Color4f(GLfloat  red, GLfloat  green, GLfloat  blue, GLfloat  alpha);
static void _es_Color4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    GLfloat converted_red;
    GLfloat converted_green;
    GLfloat converted_blue;
    GLfloat converted_alpha; 

    converted_red = (GLfloat) (red / 255.0f);
    converted_green = (GLfloat) (green / 255.0f);
    converted_blue = (GLfloat) (blue / 255.0f);
    converted_alpha = (GLfloat) (alpha / 255.0f); 

    _vbo_Color4f(converted_red, converted_green, converted_blue, converted_alpha);
}

extern void GLAPIENTRY _vbo_Color4f(GLfloat  red, GLfloat  green, GLfloat  blue, GLfloat  alpha);
static void _es_Color4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    GLfloat converted_red;
    GLfloat converted_green;
    GLfloat converted_blue;
    GLfloat converted_alpha; 

    converted_red = (GLfloat) (red / 65536.0f);
    converted_green = (GLfloat) (green / 65536.0f);
    converted_blue = (GLfloat) (blue / 65536.0f);
    converted_alpha = (GLfloat) (alpha / 65536.0f); 

    _vbo_Color4f(converted_red, converted_green, converted_blue, converted_alpha);
}

/* Extension OES_fixed_point */
static void _es_Color4xOES(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    GLfloat converted_red;
    GLfloat converted_green;
    GLfloat converted_blue;
    GLfloat converted_alpha; 

    converted_red = (GLfloat) (red / 65536.0f);
    converted_green = (GLfloat) (green / 65536.0f);
    converted_blue = (GLfloat) (blue / 65536.0f);
    converted_alpha = (GLfloat) (alpha / 65536.0f); 

    _vbo_Color4f(converted_red, converted_green, converted_blue, converted_alpha);
}

extern void GLAPIENTRY _mesa_ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
static void _es_ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
    _mesa_ColorMask(red, green, blue, alpha);
}

extern void GLAPIENTRY _mesa_ColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer);
static void _es_ColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)
{
    switch(size) {
        case 4:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glColorPointer(size=%d)", size);
            return;
    }
    switch(type) {
        case GL_UNSIGNED_BYTE:
        case GL_FIXED:
        case GL_FLOAT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glColorPointer(type=0x%x)", type);
            return;
    } 

    _mesa_ColorPointer(size, type, stride, pointer);
}

/* this function is special and is defined elsewhere */
extern void _es_CompressedTexImage2D(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * data);

extern void GLAPIENTRY _mesa_CompressedTexSubImage2DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * data);
static void _es_CompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * data)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexSubImage2D(target=0x%x)", target);
            return;
    }
    switch(format) {
        case GL_PALETTE4_RGB8_OES:
        case GL_PALETTE4_RGBA8_OES:
        case GL_PALETTE4_R5_G6_B5_OES:
        case GL_PALETTE4_RGBA4_OES:
        case GL_PALETTE4_RGB5_A1_OES:
        case GL_PALETTE8_RGB8_OES:
        case GL_PALETTE8_RGBA8_OES:
        case GL_PALETTE8_R5_G6_B5_OES:
        case GL_PALETTE8_RGBA4_OES:
        case GL_PALETTE8_RGB5_A1_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexSubImage2D(format=0x%x)", format);
            return;
    } 

    _mesa_CompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, imageSize, data);
}

extern void GLAPIENTRY _mesa_CopyTexImage2D(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
static void _es_CopyTexImage2D(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCopyTexImage2D(target=0x%x)", target);
            return;
    }
    switch(internalFormat) {
        case GL_ALPHA:
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
        case GL_RGB:
        case GL_RGBA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glCopyTexImage2D(internalFormat=0x%x)", internalFormat);
            return;
    }
    switch(border) {
        case 0:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glCopyTexImage2D(border=%d)", border);
            return;
    } 

    _mesa_CopyTexImage2D(target, level, internalFormat, x, y, width, height, border);
}

extern void GLAPIENTRY _mesa_CopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
static void _es_CopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCopyTexSubImage2D(target=0x%x)", target);
            return;
    } 

    _mesa_CopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
}

extern void GLAPIENTRY _mesa_CullFace(GLenum mode);
static void _es_CullFace(GLenum mode)
{
    switch(mode) {
        case GL_FRONT:
        case GL_BACK:
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCullFace(mode=0x%x)", mode);
            return;
    } 

    _mesa_CullFace(mode);
}

extern void GLAPIENTRY _mesa_DeleteBuffersARB(GLsizei n, const GLuint * buffer);
static void _es_DeleteBuffers(GLsizei n, const GLuint * buffer)
{
    _mesa_DeleteBuffersARB(n, buffer);
}

extern void GLAPIENTRY _mesa_DeleteFramebuffersEXT(GLsizei n, const GLuint * framebuffers);
/* Extension OES_framebuffer_object */
static void _es_DeleteFramebuffersOES(GLsizei n, const GLuint * framebuffers)
{
    _mesa_DeleteFramebuffersEXT(n, framebuffers);
}

extern void GLAPIENTRY _mesa_DeleteRenderbuffersEXT(GLsizei n, const GLuint * renderbuffers);
/* Extension OES_framebuffer_object */
static void _es_DeleteRenderbuffersOES(GLsizei n, const GLuint * renderbuffers)
{
    _mesa_DeleteRenderbuffersEXT(n, renderbuffers);
}

extern void GLAPIENTRY _mesa_DeleteTextures(GLsizei n, const GLuint * textures);
static void _es_DeleteTextures(GLsizei n, const GLuint * textures)
{
    _mesa_DeleteTextures(n, textures);
}

extern void GLAPIENTRY _mesa_DepthFunc(GLenum func);
static void _es_DepthFunc(GLenum func)
{
    switch(func) {
        case GL_NEVER:
        case GL_LESS:
        case GL_EQUAL:
        case GL_LEQUAL:
        case GL_GREATER:
        case GL_NOTEQUAL:
        case GL_GEQUAL:
        case GL_ALWAYS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDepthFunc(func=0x%x)", func);
            return;
    } 

    _mesa_DepthFunc(func);
}

extern void GLAPIENTRY _mesa_DepthMask(GLboolean flag);
static void _es_DepthMask(GLboolean flag)
{
    _mesa_DepthMask(flag);
}

extern void GLAPIENTRY _mesa_DepthRange(GLclampd  zNear, GLclampd  zFar);
static void _es_DepthRangef(GLclampf zNear, GLclampf zFar)
{
    GLclampd converted_zNear;
    GLclampd converted_zFar; 

    converted_zNear = (GLclampd) (zNear);
    converted_zFar = (GLclampd) (zFar); 

    _mesa_DepthRange(converted_zNear, converted_zFar);
}

/* Extension OES_single_precision */
static void _es_DepthRangefOES(GLclampf zNear, GLclampf zFar)
{
    GLclampd converted_zNear;
    GLclampd converted_zFar; 

    converted_zNear = (GLclampd) (zNear);
    converted_zFar = (GLclampd) (zFar); 

    _mesa_DepthRange(converted_zNear, converted_zFar);
}

extern void GLAPIENTRY _mesa_DepthRange(GLclampd  zNear, GLclampd  zFar);
static void _es_DepthRangex(GLclampx zNear, GLclampx zFar)
{
    GLclampd converted_zNear;
    GLclampd converted_zFar; 

    converted_zNear = (GLclampd) (zNear / 65536.0);
    converted_zFar = (GLclampd) (zFar / 65536.0); 

    _mesa_DepthRange(converted_zNear, converted_zFar);
}

/* Extension OES_fixed_point */
static void _es_DepthRangexOES(GLclampx zNear, GLclampx zFar)
{
    GLclampd converted_zNear;
    GLclampd converted_zFar; 

    converted_zNear = (GLclampd) (zNear / 65536.0);
    converted_zFar = (GLclampd) (zFar / 65536.0); 

    _mesa_DepthRange(converted_zNear, converted_zFar);
}

extern void GLAPIENTRY _mesa_Disable(GLenum cap);
static void _es_Disable(GLenum cap)
{
    switch(cap) {
        case GL_VERTEX_ARRAY:
        case GL_NORMAL_ARRAY:
        case GL_COLOR_ARRAY:
        case GL_TEXTURE_COORD_ARRAY:
        case GL_NORMALIZE:
        case GL_RESCALE_NORMAL:
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
        case GL_FOG:
        case GL_LIGHTING:
        case GL_COLOR_MATERIAL:
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
        case GL_POINT_SMOOTH:
        case GL_LINE_SMOOTH:
        case GL_CULL_FACE:
        case GL_POLYGON_OFFSET_FILL:
        case GL_MULTISAMPLE:
        case GL_SAMPLE_ALPHA_TO_COVERAGE:
        case GL_SAMPLE_ALPHA_TO_ONE:
        case GL_SAMPLE_COVERAGE:
        case GL_TEXTURE_2D:
        case GL_SCISSOR_TEST:
        case GL_ALPHA_TEST:
        case GL_STENCIL_TEST:
        case GL_DEPTH_TEST:
        case GL_BLEND:
        case GL_DITHER:
        case GL_COLOR_LOGIC_OP:
        case GL_MATRIX_INDEX_ARRAY_OES:
        case GL_WEIGHT_ARRAY_OES:
        case GL_POINT_SIZE_ARRAY_OES:
        case GL_POINT_SPRITE_OES:
        case GL_TEXTURE_CUBE_MAP_OES:
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDisable(cap=0x%x)", cap);
            return;
    } 

    _mesa_Disable(cap);
}

extern void GLAPIENTRY _mesa_DisableClientState(GLenum array);
static void _es_DisableClientState(GLenum array)
{
    switch(array) {
        case GL_COLOR_ARRAY:
        case GL_NORMAL_ARRAY:
        case GL_TEXTURE_COORD_ARRAY:
        case GL_VERTEX_ARRAY:
        case GL_MATRIX_INDEX_ARRAY_OES:
        case GL_WEIGHT_ARRAY_OES:
        case GL_POINT_SIZE_ARRAY_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDisableClientState(array=0x%x)", array);
            return;
    } 

    _mesa_DisableClientState(array);
}

extern void GLAPIENTRY _mesa_DrawArrays(GLenum mode, GLint first, GLsizei count);
static void _es_DrawArrays(GLenum mode, GLint first, GLsizei count)
{
    switch(mode) {
        case GL_POINTS:
        case GL_LINE_STRIP:
        case GL_LINE_LOOP:
        case GL_LINES:
        case GL_TRIANGLE_STRIP:
        case GL_TRIANGLE_FAN:
        case GL_TRIANGLES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDrawArrays(mode=0x%x)", mode);
            return;
    } 

    _mesa_DrawArrays(mode, first, count);
}

extern void GLAPIENTRY _mesa_DrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices);
static void _es_DrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices)
{
    switch(mode) {
        case GL_POINTS:
        case GL_LINE_STRIP:
        case GL_LINE_LOOP:
        case GL_LINES:
        case GL_TRIANGLE_STRIP:
        case GL_TRIANGLE_FAN:
        case GL_TRIANGLES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDrawElements(mode=0x%x)", mode);
            return;
    }
    switch(type) {
        case GL_UNSIGNED_BYTE:
        case GL_UNSIGNED_SHORT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDrawElements(type=0x%x)", type);
            return;
    } 

    _mesa_DrawElements(mode, count, type, indices);
}

extern void GLAPIENTRY _mesa_DrawTexf(GLfloat x, GLfloat y, GLfloat z, GLfloat w, GLfloat h);
/* Extension OES_draw_texture */
static void _es_DrawTexfOES(GLfloat x, GLfloat y, GLfloat z, GLfloat w, GLfloat h)
{
    _mesa_DrawTexf(x, y, z, w, h);
}

extern void GLAPIENTRY _mesa_DrawTexfv(const GLfloat * coords);
/* Extension OES_draw_texture */
static void _es_DrawTexfvOES(const GLfloat * coords)
{
    _mesa_DrawTexfv(coords);
}

extern void GLAPIENTRY _mesa_DrawTexi(GLint x, GLint y, GLint z, GLint w, GLint h);
/* Extension OES_draw_texture */
static void _es_DrawTexiOES(GLint x, GLint y, GLint z, GLint w, GLint h)
{
    _mesa_DrawTexi(x, y, z, w, h);
}

extern void GLAPIENTRY _mesa_DrawTexiv(const GLint * coords);
/* Extension OES_draw_texture */
static void _es_DrawTexivOES(const GLint * coords)
{
    _mesa_DrawTexiv(coords);
}

extern void GLAPIENTRY _mesa_DrawTexs(GLshort x, GLshort y, GLshort z, GLshort w, GLshort h);
/* Extension OES_draw_texture */
static void _es_DrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort w, GLshort h)
{
    _mesa_DrawTexs(x, y, z, w, h);
}

extern void GLAPIENTRY _mesa_DrawTexsv(const GLshort * coords);
/* Extension OES_draw_texture */
static void _es_DrawTexsvOES(const GLshort * coords)
{
    _mesa_DrawTexsv(coords);
}

extern void GLAPIENTRY _mesa_DrawTexf(GLfloat  x, GLfloat  y, GLfloat  z, GLfloat  w, GLfloat  h);
/* Extension OES_draw_texture */
static void _es_DrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed w, GLfixed h)
{
    GLfloat converted_x;
    GLfloat converted_y;
    GLfloat converted_z;
    GLfloat converted_w;
    GLfloat converted_h; 

    converted_x = (GLfloat) (x / 65536.0f);
    converted_y = (GLfloat) (y / 65536.0f);
    converted_z = (GLfloat) (z / 65536.0f);
    converted_w = (GLfloat) (w / 65536.0f);
    converted_h = (GLfloat) (h / 65536.0f); 

    _mesa_DrawTexf(converted_x, converted_y, converted_z, converted_w, converted_h);
}

extern void GLAPIENTRY _mesa_DrawTexfv(GLfloat const * coords);
/* Extension OES_draw_texture */
static void _es_DrawTexxvOES(const GLfixed * coords)
{
    register unsigned int i;
    unsigned int n_coords = 5;
    GLfloat converted_coords[5]; 

    for (i = 0; i < n_coords; i++) {
        converted_coords[i] = (GLfloat) (coords[i] / 65536.0f);
    } 

    _mesa_DrawTexfv(converted_coords);
}

extern void GLAPIENTRY _mesa_EGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image);
/* Extension OES_EGL_image */
static void _es_EGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image)
{
    switch(target) {
        case GL_RENDERBUFFER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glEGLImageTargetRenderbufferStorage(target=0x%x)", target);
            return;
    } 

    _mesa_EGLImageTargetRenderbufferStorageOES(target, image);
}

extern void GLAPIENTRY _mesa_EGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image);
/* Extension OES_EGL_image */
static void _es_EGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image)
{
    switch(target) {
        case GL_TEXTURE_2D:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glEGLImageTargetTexture2D(target=0x%x)", target);
            return;
    } 

    _mesa_EGLImageTargetTexture2DOES(target, image);
}

extern void GLAPIENTRY _mesa_Enable(GLenum cap);
static void _es_Enable(GLenum cap)
{
    switch(cap) {
        case GL_VERTEX_ARRAY:
        case GL_NORMAL_ARRAY:
        case GL_COLOR_ARRAY:
        case GL_TEXTURE_COORD_ARRAY:
        case GL_NORMALIZE:
        case GL_RESCALE_NORMAL:
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
        case GL_FOG:
        case GL_LIGHTING:
        case GL_COLOR_MATERIAL:
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
        case GL_POINT_SMOOTH:
        case GL_LINE_SMOOTH:
        case GL_CULL_FACE:
        case GL_POLYGON_OFFSET_FILL:
        case GL_MULTISAMPLE:
        case GL_SAMPLE_ALPHA_TO_COVERAGE:
        case GL_SAMPLE_ALPHA_TO_ONE:
        case GL_SAMPLE_COVERAGE:
        case GL_TEXTURE_2D:
        case GL_SCISSOR_TEST:
        case GL_ALPHA_TEST:
        case GL_STENCIL_TEST:
        case GL_DEPTH_TEST:
        case GL_BLEND:
        case GL_DITHER:
        case GL_COLOR_LOGIC_OP:
        case GL_MATRIX_INDEX_ARRAY_OES:
        case GL_WEIGHT_ARRAY_OES:
        case GL_POINT_SIZE_ARRAY_OES:
        case GL_POINT_SPRITE_OES:
        case GL_TEXTURE_CUBE_MAP_OES:
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glEnable(cap=0x%x)", cap);
            return;
    } 

    _mesa_Enable(cap);
}

extern void GLAPIENTRY _mesa_EnableClientState(GLenum array);
static void _es_EnableClientState(GLenum array)
{
    switch(array) {
        case GL_COLOR_ARRAY:
        case GL_NORMAL_ARRAY:
        case GL_TEXTURE_COORD_ARRAY:
        case GL_VERTEX_ARRAY:
        case GL_MATRIX_INDEX_ARRAY_OES:
        case GL_WEIGHT_ARRAY_OES:
        case GL_POINT_SIZE_ARRAY_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glEnableClientState(array=0x%x)", array);
            return;
    } 

    _mesa_EnableClientState(array);
}

extern void GLAPIENTRY _mesa_Finish();
static void _es_Finish(void)
{
    _mesa_Finish();
}

extern void GLAPIENTRY _mesa_Flush();
static void _es_Flush(void)
{
    _mesa_Flush();
}

extern void GLAPIENTRY _mesa_Fogf(GLenum pname, GLfloat param);
static void _es_Fogf(GLenum pname, GLfloat param)
{
    switch(pname) {
        case GL_FOG_MODE:
            if (param != GL_EXP && param != GL_EXP2 && param != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_FOG_DENSITY:
        case GL_FOG_START:
        case GL_FOG_END:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogf(pname=0x%x)", pname);
            return;
    } 

    _mesa_Fogf(pname, param);
}

extern void GLAPIENTRY _mesa_Fogfv(GLenum pname, const GLfloat * params);
static void _es_Fogfv(GLenum pname, const GLfloat * params)
{
    switch(pname) {
        case GL_FOG_COLOR: /* size 4 */
        case GL_FOG_DENSITY: /* size 1 */
        case GL_FOG_START: /* size 1 */
        case GL_FOG_END: /* size 1 */
            break;
        case GL_FOG_MODE: /* size 1 */
            if (params[0] != GL_EXP && params[0] != GL_EXP2 && params[0] != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogfv(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_Fogfv(pname, params);
}

extern void GLAPIENTRY _mesa_Fogf(GLenum pname, GLfloat  param);
static void _es_Fogx(GLenum pname, GLfixed param)
{
    GLfloat converted_param;
    int convert_param_value = 1; 

    switch(pname) {
        case GL_FOG_MODE:
            if (param != GL_EXP && param != GL_EXP2 && param != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_FOG_DENSITY:
        case GL_FOG_START:
        case GL_FOG_END:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogx(pname=0x%x)", pname);
            return;
    } 

    if (convert_param_value) {
        converted_param = (GLfloat) (param / 65536.0f);
    } else {
        converted_param = (GLfloat) param;
    } 

    _mesa_Fogf(pname, converted_param);
}

/* Extension OES_fixed_point */
static void _es_FogxOES(GLenum pname, GLfixed param)
{
    GLfloat converted_param;
    int convert_param_value = 1; 

    switch(pname) {
        case GL_FOG_MODE:
            if (param != GL_EXP && param != GL_EXP2 && param != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_FOG_DENSITY:
        case GL_FOG_START:
        case GL_FOG_END:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogx(pname=0x%x)", pname);
            return;
    } 

    if (convert_param_value) {
        converted_param = (GLfloat) (param / 65536.0f);
    } else {
        converted_param = (GLfloat) param;
    } 

    _mesa_Fogf(pname, converted_param);
}

extern void GLAPIENTRY _mesa_Fogfv(GLenum pname, GLfloat const * params);
static void _es_Fogxv(GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4];
    int convert_params_value = 1; 

    switch(pname) {
        case GL_FOG_COLOR:
            n_params = 4;
            break;
        case GL_FOG_DENSITY:
        case GL_FOG_START:
        case GL_FOG_END:
            n_params = 1;
            break;
        case GL_FOG_MODE:
            if (params[0] != GL_EXP && params[0] != GL_EXP2 && params[0] != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogxv(pname=0x%x)", pname);
            return;
    } 

    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) (params[i] / 65536.0f);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) params[i];
        }
    } 

    _mesa_Fogfv(pname, converted_params);
}

/* Extension OES_fixed_point */
static void _es_FogxvOES(GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4];
    int convert_params_value = 1; 

    switch(pname) {
        case GL_FOG_COLOR:
            n_params = 4;
            break;
        case GL_FOG_DENSITY:
        case GL_FOG_START:
        case GL_FOG_END:
            n_params = 1;
            break;
        case GL_FOG_MODE:
            if (params[0] != GL_EXP && params[0] != GL_EXP2 && params[0] != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFogxv(pname=0x%x)", pname);
            return;
    } 

    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) (params[i] / 65536.0f);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) params[i];
        }
    } 

    _mesa_Fogfv(pname, converted_params);
}

extern void GLAPIENTRY _mesa_FramebufferRenderbufferEXT(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
/* Extension OES_framebuffer_object */
static void _es_FramebufferRenderbufferOES(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
    switch(target) {
        case GL_FRAMEBUFFER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFramebufferRenderbuffer(target=0x%x)", target);
            return;
    }
    switch(attachment) {
        case GL_COLOR_ATTACHMENT0_OES:
        case GL_DEPTH_ATTACHMENT_OES:
        case GL_STENCIL_ATTACHMENT_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFramebufferRenderbuffer(attachment=0x%x)", attachment);
            return;
    }
    switch(renderbuffertarget) {
        case GL_RENDERBUFFER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFramebufferRenderbuffer(renderbuffertarget=0x%x)", renderbuffertarget);
            return;
    } 

    _mesa_FramebufferRenderbufferEXT(target, attachment, renderbuffertarget, renderbuffer);
}

extern void GLAPIENTRY _mesa_FramebufferTexture2DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
/* Extension OES_framebuffer_object */
static void _es_FramebufferTexture2DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
    switch(target) {
        case GL_FRAMEBUFFER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFramebufferTexture2D(target=0x%x)", target);
            return;
    }
    switch(attachment) {
        case GL_COLOR_ATTACHMENT0_OES:
        case GL_DEPTH_ATTACHMENT_OES:
        case GL_STENCIL_ATTACHMENT_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFramebufferTexture2D(attachment=0x%x)", attachment);
            return;
    }
    switch(textarget) {
        case GL_TEXTURE_2D:
            break;
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFramebufferTexture2D(textarget=0x%x)", textarget);
            return;
    } 

    _mesa_FramebufferTexture2DEXT(target, attachment, textarget, texture, level);
}

extern void GLAPIENTRY _mesa_FrontFace(GLenum mode);
static void _es_FrontFace(GLenum mode)
{
    switch(mode) {
        case GL_CW:
        case GL_CCW:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFrontFace(mode=0x%x)", mode);
            return;
    } 

    _mesa_FrontFace(mode);
}

extern void GLAPIENTRY _mesa_Frustum(GLdouble  left, GLdouble  right, GLdouble  bottom, GLdouble  top, GLdouble  zNear, GLdouble  zFar);
static void _es_Frustumf(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar)
{
    GLdouble converted_left;
    GLdouble converted_right;
    GLdouble converted_bottom;
    GLdouble converted_top;
    GLdouble converted_zNear;
    GLdouble converted_zFar; 

    converted_left = (GLdouble) (left);
    converted_right = (GLdouble) (right);
    converted_bottom = (GLdouble) (bottom);
    converted_top = (GLdouble) (top);
    converted_zNear = (GLdouble) (zNear);
    converted_zFar = (GLdouble) (zFar); 

    _mesa_Frustum(converted_left, converted_right, converted_bottom, converted_top, converted_zNear, converted_zFar);
}

/* Extension OES_single_precision */
static void _es_FrustumfOES(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar)
{
    GLdouble converted_left;
    GLdouble converted_right;
    GLdouble converted_bottom;
    GLdouble converted_top;
    GLdouble converted_zNear;
    GLdouble converted_zFar; 

    converted_left = (GLdouble) (left);
    converted_right = (GLdouble) (right);
    converted_bottom = (GLdouble) (bottom);
    converted_top = (GLdouble) (top);
    converted_zNear = (GLdouble) (zNear);
    converted_zFar = (GLdouble) (zFar); 

    _mesa_Frustum(converted_left, converted_right, converted_bottom, converted_top, converted_zNear, converted_zFar);
}

extern void GLAPIENTRY _mesa_Frustum(GLdouble  left, GLdouble  right, GLdouble  bottom, GLdouble  top, GLdouble  zNear, GLdouble  zFar);
static void _es_Frustumx(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar)
{
    GLdouble converted_left;
    GLdouble converted_right;
    GLdouble converted_bottom;
    GLdouble converted_top;
    GLdouble converted_zNear;
    GLdouble converted_zFar; 

    converted_left = (GLdouble) (left / 65536.0);
    converted_right = (GLdouble) (right / 65536.0);
    converted_bottom = (GLdouble) (bottom / 65536.0);
    converted_top = (GLdouble) (top / 65536.0);
    converted_zNear = (GLdouble) (zNear / 65536.0);
    converted_zFar = (GLdouble) (zFar / 65536.0); 

    _mesa_Frustum(converted_left, converted_right, converted_bottom, converted_top, converted_zNear, converted_zFar);
}

/* Extension OES_fixed_point */
static void _es_FrustumxOES(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar)
{
    GLdouble converted_left;
    GLdouble converted_right;
    GLdouble converted_bottom;
    GLdouble converted_top;
    GLdouble converted_zNear;
    GLdouble converted_zFar; 

    converted_left = (GLdouble) (left / 65536.0);
    converted_right = (GLdouble) (right / 65536.0);
    converted_bottom = (GLdouble) (bottom / 65536.0);
    converted_top = (GLdouble) (top / 65536.0);
    converted_zNear = (GLdouble) (zNear / 65536.0);
    converted_zFar = (GLdouble) (zFar / 65536.0); 

    _mesa_Frustum(converted_left, converted_right, converted_bottom, converted_top, converted_zNear, converted_zFar);
}

extern void GLAPIENTRY _mesa_GenBuffersARB(GLsizei n, GLuint * buffer);
static void _es_GenBuffers(GLsizei n, GLuint * buffer)
{
    _mesa_GenBuffersARB(n, buffer);
}

extern void GLAPIENTRY _mesa_GenFramebuffersEXT(GLsizei n, GLuint * ids);
/* Extension OES_framebuffer_object */
static void _es_GenFramebuffersOES(GLsizei n, GLuint * ids)
{
    _mesa_GenFramebuffersEXT(n, ids);
}

extern void GLAPIENTRY _mesa_GenRenderbuffersEXT(GLsizei n, GLuint * renderbuffers);
/* Extension OES_framebuffer_object */
static void _es_GenRenderbuffersOES(GLsizei n, GLuint * renderbuffers)
{
    _mesa_GenRenderbuffersEXT(n, renderbuffers);
}

extern void GLAPIENTRY _mesa_GenTextures(GLsizei n, GLuint * textures);
static void _es_GenTextures(GLsizei n, GLuint * textures)
{
    _mesa_GenTextures(n, textures);
}

extern void GLAPIENTRY _mesa_GenerateMipmapEXT(GLenum target);
/* Extension OES_framebuffer_object */
static void _es_GenerateMipmapOES(GLenum target)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGenerateMipmap(target=0x%x)", target);
            return;
    } 

    _mesa_GenerateMipmapEXT(target);
}

extern void GLAPIENTRY _mesa_GetBooleanv(GLenum pname, GLboolean * params);
static void _es_GetBooleanv(GLenum pname, GLboolean * params)
{
    _mesa_GetBooleanv(pname, params);
}

extern void GLAPIENTRY _mesa_GetBufferParameterivARB(GLenum target, GLenum pname, GLint * params);
static void _es_GetBufferParameteriv(GLenum target, GLenum pname, GLint * params)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_BUFFER_SIZE:
        case GL_BUFFER_USAGE:
        case GL_BUFFER_ACCESS_OES:
        case GL_BUFFER_MAPPED_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferParameteriv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetBufferParameterivARB(target, pname, params);
}

extern void GLAPIENTRY _mesa_GetBufferPointervARB(GLenum target, GLenum pname, GLvoid ** params);
/* Extension OES_mapbuffer */
static void _es_GetBufferPointervOES(GLenum target, GLenum pname, GLvoid ** params)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferPointerv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_BUFFER_MAP_POINTER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferPointerv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetBufferPointervARB(target, pname, params);
}

extern void GLAPIENTRY _mesa_GetClipPlane(GLenum plane, GLdouble * equation);
static void _es_GetClipPlanef(GLenum plane, GLfloat * equation)
{
    register unsigned int i;
    unsigned int n_equation = 4;
    GLdouble converted_equation[4]; 

    switch(plane) {
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetClipPlanef(plane=0x%x)", plane);
            return;
    } 

    _mesa_GetClipPlane(plane, converted_equation);
    for (i = 0; i < n_equation; i++) {
        equation[i] = (GLfloat) (converted_equation[i]);
    }
}

/* Extension OES_single_precision */
static void _es_GetClipPlanefOES(GLenum plane, GLfloat * equation)
{
    register unsigned int i;
    unsigned int n_equation = 4;
    GLdouble converted_equation[4]; 

    switch(plane) {
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetClipPlanef(plane=0x%x)", plane);
            return;
    } 

    _mesa_GetClipPlane(plane, converted_equation);
    for (i = 0; i < n_equation; i++) {
        equation[i] = (GLfloat) (converted_equation[i]);
    }
}

extern void GLAPIENTRY _mesa_GetClipPlane(GLenum plane, GLdouble * equation);
static void _es_GetClipPlanex(GLenum plane, GLfixed * equation)
{
    register unsigned int i;
    unsigned int n_equation = 4;
    GLdouble converted_equation[4]; 

    switch(plane) {
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetClipPlanex(plane=0x%x)", plane);
            return;
    } 

    _mesa_GetClipPlane(plane, converted_equation);
    for (i = 0; i < n_equation; i++) {
        equation[i] = (GLfixed) (converted_equation[i] * 65536);
    }
}

/* Extension OES_fixed_point */
static void _es_GetClipPlanexOES(GLenum plane, GLfixed * equation)
{
    register unsigned int i;
    unsigned int n_equation = 4;
    GLdouble converted_equation[4]; 

    switch(plane) {
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetClipPlanex(plane=0x%x)", plane);
            return;
    } 

    _mesa_GetClipPlane(plane, converted_equation);
    for (i = 0; i < n_equation; i++) {
        equation[i] = (GLfixed) (converted_equation[i] * 65536);
    }
}

extern GLenum GLAPIENTRY _mesa_GetError();
static GLenum _es_GetError(void)
{
    return _mesa_GetError();
}

extern void GLAPIENTRY _mesa_GetFloatv(GLenum pname, GLfloat * params);
static void _es_GetFixedv(GLenum pname, GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 16;
    GLfloat converted_params[16];
    int convert_params_value = 1; 

    switch(pname) {
        case GL_CLIENT_ACTIVE_TEXTURE:
            n_params = 1;
            break;
        case GL_VERTEX_ARRAY:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_VERTEX_ARRAY_SIZE:
            n_params = 1;
            break;
        case GL_VERTEX_ARRAY_TYPE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_VERTEX_ARRAY_STRIDE:
            n_params = 1;
            break;
        case GL_NORMAL_ARRAY:
        case GL_NORMAL_ARRAY_TYPE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_NORMAL_ARRAY_STRIDE:
            n_params = 1;
            break;
        case GL_COLOR_ARRAY:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_COLOR_ARRAY_SIZE:
            n_params = 1;
            break;
        case GL_COLOR_ARRAY_TYPE:
        case GL_TEXTURE_COORD_ARRAY:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_COORD_ARRAY_SIZE:
            n_params = 1;
            break;
        case GL_TEXTURE_COORD_ARRAY_TYPE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_COORD_ARRAY_STRIDE:
            n_params = 1;
            break;
        case GL_POINT_SIZE_ARRAY_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_POINT_SIZE_ARRAY_STRIDE_OES:
        case GL_ARRAY_BUFFER_BINDING:
        case GL_VERTEX_ARRAY_BUFFER_BINDING:
        case GL_NORMAL_ARRAY_BUFFER_BINDING:
        case GL_COLOR_ARRAY_BUFFER_BINDING:
        case GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING:
        case GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES:
        case GL_ELEMENT_ARRAY_BUFFER_BINDING:
        case GL_MODELVIEW_STACK_DEPTH:
        case GL_PROJECTION_STACK_DEPTH:
        case GL_TEXTURE_STACK_DEPTH:
            n_params = 1;
            break;
        case GL_MATRIX_MODE:
        case GL_NORMALIZE:
        case GL_RESCALE_NORMAL:
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_FOG_DENSITY:
        case GL_FOG_START:
        case GL_FOG_END:
            n_params = 1;
            break;
        case GL_FOG_MODE:
        case GL_FOG:
        case GL_SHADE_MODEL:
        case GL_LIGHTING:
        case GL_COLOR_MATERIAL:
        case GL_LIGHT_MODEL_TWO_SIDE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_POINT_SIZE:
            n_params = 1;
            break;
        case GL_POINT_SMOOTH:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_POINT_SIZE_MIN:
        case GL_POINT_SIZE_MAX:
        case GL_POINT_FADE_THRESHOLD_SIZE:
            n_params = 1;
            break;
        case GL_POINT_SPRITE_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_LINE_WIDTH:
            n_params = 1;
            break;
        case GL_LINE_SMOOTH:
        case GL_CULL_FACE:
        case GL_CULL_FACE_MODE:
        case GL_FRONT_FACE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_POLYGON_OFFSET_FACTOR:
        case GL_POLYGON_OFFSET_UNITS:
            n_params = 1;
            break;
        case GL_POLYGON_OFFSET_FILL:
        case GL_MULTISAMPLE:
        case GL_SAMPLE_ALPHA_TO_COVERAGE:
        case GL_SAMPLE_ALPHA_TO_ONE:
        case GL_SAMPLE_COVERAGE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SAMPLE_COVERAGE_VALUE:
            n_params = 1;
            break;
        case GL_TEXTURE_2D:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_BINDING_2D:
            n_params = 1;
            break;
        case GL_ACTIVE_TEXTURE:
        case GL_SCISSOR_TEST:
        case GL_ALPHA_TEST_FUNC:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_ALPHA_TEST_REF:
            n_params = 1;
            break;
        case GL_STENCIL_TEST:
        case GL_STENCIL_FUNC:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_STENCIL_VALUE_MASK:
        case GL_STENCIL_REF:
            n_params = 1;
            break;
        case GL_STENCIL_FAIL:
        case GL_STENCIL_PASS_DEPTH_FAIL:
        case GL_STENCIL_PASS_DEPTH_PASS:
        case GL_DEPTH_TEST:
        case GL_DEPTH_FUNC:
        case GL_BLEND:
        case GL_BLEND_SRC:
        case GL_BLEND_DST:
        case GL_DITHER:
        case GL_COLOR_LOGIC_OP:
        case GL_LOGIC_OP_MODE:
        case GL_DEPTH_WRITEMASK:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_STENCIL_WRITEMASK:
        case GL_DEPTH_CLEAR_VALUE:
        case GL_STENCIL_CLEAR_VALUE:
        case GL_UNPACK_ALIGNMENT:
        case GL_PACK_ALIGNMENT:
            n_params = 1;
            break;
        case GL_PERSPECTIVE_CORRECTION_HINT:
        case GL_POINT_SMOOTH_HINT:
        case GL_LINE_SMOOTH_HINT:
        case GL_FOG_HINT:
        case GL_GENERATE_MIPMAP_HINT:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_MAX_LIGHTS:
        case GL_MAX_CLIP_PLANES:
        case GL_MAX_MODELVIEW_STACK_DEPTH:
        case GL_MAX_PROJECTION_STACK_DEPTH:
        case GL_MAX_TEXTURE_STACK_DEPTH:
        case GL_SUBPIXEL_BITS:
        case GL_MAX_TEXTURE_SIZE:
        case GL_MAX_TEXTURE_UNITS:
        case GL_SAMPLE_BUFFERS:
        case GL_SAMPLES:
        case GL_NUM_COMPRESSED_TEXTURE_FORMATS:
        case GL_RED_BITS:
        case GL_GREEN_BITS:
        case GL_BLUE_BITS:
        case GL_ALPHA_BITS:
        case GL_DEPTH_BITS:
        case GL_STENCIL_BITS:
            n_params = 1;
            break;
        case GL_MAX_VIEWPORT_DIMS:
        case GL_ALIASED_POINT_SIZE_RANGE:
        case GL_SMOOTH_POINT_SIZE_RANGE:
        case GL_ALIASED_LINE_WIDTH_RANGE:
        case GL_SMOOTH_LINE_WIDTH_RANGE:
        case GL_DEPTH_RANGE:
            n_params = 2;
            break;
        case GL_CURRENT_NORMAL:
        case GL_POINT_DISTANCE_ATTENUATION:
            n_params = 3;
            break;
        case GL_CURRENT_COLOR:
        case GL_CURRENT_TEXTURE_COORDS:
        case GL_SCISSOR_BOX:
        case GL_COLOR_WRITEMASK:
        case GL_COLOR_CLEAR_VALUE:
        case GL_LIGHT_MODEL_AMBIENT:
        case GL_VIEWPORT:
        case GL_FOG_COLOR:
            n_params = 4;
            break;
        case GL_MODELVIEW_MATRIX:
        case GL_PROJECTION_MATRIX:
        case GL_TEXTURE_MATRIX:
            n_params = 16;
            break;
        case GL_COMPRESSED_TEXTURE_FORMATS:
            convert_params_value = 0;
            n_params = _get_size(GL_NUM_COMPRESSED_TEXTURE_FORMATS);
            break;
        case GL_BLEND_SRC_RGB_OES:
        case GL_BLEND_DST_RGB_OES:
        case GL_BLEND_SRC_ALPHA_OES:
        case GL_BLEND_DST_ALPHA_OES:
        case GL_BLEND_EQUATION_RGB_OES:
        case GL_BLEND_EQUATION_ALPHA_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_FRAMEBUFFER_BINDING_OES:
        case GL_RENDERBUFFER_BINDING_OES:
        case GL_MAX_RENDERBUFFER_SIZE_OES:
            n_params = 1;
            break;
        case GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES:
        case GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES:
        case GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES:
            n_params = 16;
            break;
        case GL_MAX_PALETTE_MATRICES_OES:
        case GL_MAX_VERTEX_UNITS_OES:
        case GL_CURRENT_PALETTE_MATRIX_OES:
        case GL_MATRIX_INDEX_ARRAY_SIZE_OES:
            n_params = 1;
            break;
        case GL_MATRIX_INDEX_ARRAY_TYPE_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_MATRIX_INDEX_ARRAY_STRIDE_OES:
        case GL_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES:
        case GL_WEIGHT_ARRAY_SIZE_OES:
            n_params = 1;
            break;
        case GL_WEIGHT_ARRAY_TYPE_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_WEIGHT_ARRAY_STRIDE_OES:
        case GL_WEIGHT_ARRAY_BUFFER_BINDING_OES:
            n_params = 1;
            break;
        case GL_POINT_SIZE_ARRAY_TYPE_OES:
        case GL_IMPLEMENTATION_COLOR_READ_TYPE_OES:
        case GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES:
        case GL_TEXTURE_CUBE_MAP_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_BINDING_CUBE_MAP_OES:
        case GL_MAX_CUBE_MAP_TEXTURE_SIZE_OES:
        case GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT:
            n_params = 1;
            break;
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
        case GL_ALPHA_TEST:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetFixedv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetFloatv(pname, converted_params);
    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            params[i] = (GLint) (converted_params[i] * 65536);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            params[i] = (GLfloat) converted_params[i];
        }
    }
}

/* Extension OES_fixed_point */
static void _es_GetFixedvOES(GLenum pname, GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 16;
    GLfloat converted_params[16];
    int convert_params_value = 1; 

    switch(pname) {
        case GL_CLIENT_ACTIVE_TEXTURE:
            n_params = 1;
            break;
        case GL_VERTEX_ARRAY:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_VERTEX_ARRAY_SIZE:
            n_params = 1;
            break;
        case GL_VERTEX_ARRAY_TYPE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_VERTEX_ARRAY_STRIDE:
            n_params = 1;
            break;
        case GL_NORMAL_ARRAY:
        case GL_NORMAL_ARRAY_TYPE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_NORMAL_ARRAY_STRIDE:
            n_params = 1;
            break;
        case GL_COLOR_ARRAY:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_COLOR_ARRAY_SIZE:
            n_params = 1;
            break;
        case GL_COLOR_ARRAY_TYPE:
        case GL_TEXTURE_COORD_ARRAY:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_COORD_ARRAY_SIZE:
            n_params = 1;
            break;
        case GL_TEXTURE_COORD_ARRAY_TYPE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_COORD_ARRAY_STRIDE:
            n_params = 1;
            break;
        case GL_POINT_SIZE_ARRAY_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_POINT_SIZE_ARRAY_STRIDE_OES:
        case GL_ARRAY_BUFFER_BINDING:
        case GL_VERTEX_ARRAY_BUFFER_BINDING:
        case GL_NORMAL_ARRAY_BUFFER_BINDING:
        case GL_COLOR_ARRAY_BUFFER_BINDING:
        case GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING:
        case GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES:
        case GL_ELEMENT_ARRAY_BUFFER_BINDING:
        case GL_MODELVIEW_STACK_DEPTH:
        case GL_PROJECTION_STACK_DEPTH:
        case GL_TEXTURE_STACK_DEPTH:
            n_params = 1;
            break;
        case GL_MATRIX_MODE:
        case GL_NORMALIZE:
        case GL_RESCALE_NORMAL:
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_FOG_DENSITY:
        case GL_FOG_START:
        case GL_FOG_END:
            n_params = 1;
            break;
        case GL_FOG_MODE:
        case GL_FOG:
        case GL_SHADE_MODEL:
        case GL_LIGHTING:
        case GL_COLOR_MATERIAL:
        case GL_LIGHT_MODEL_TWO_SIDE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_POINT_SIZE:
            n_params = 1;
            break;
        case GL_POINT_SMOOTH:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_POINT_SIZE_MIN:
        case GL_POINT_SIZE_MAX:
        case GL_POINT_FADE_THRESHOLD_SIZE:
            n_params = 1;
            break;
        case GL_POINT_SPRITE_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_LINE_WIDTH:
            n_params = 1;
            break;
        case GL_LINE_SMOOTH:
        case GL_CULL_FACE:
        case GL_CULL_FACE_MODE:
        case GL_FRONT_FACE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_POLYGON_OFFSET_FACTOR:
        case GL_POLYGON_OFFSET_UNITS:
            n_params = 1;
            break;
        case GL_POLYGON_OFFSET_FILL:
        case GL_MULTISAMPLE:
        case GL_SAMPLE_ALPHA_TO_COVERAGE:
        case GL_SAMPLE_ALPHA_TO_ONE:
        case GL_SAMPLE_COVERAGE:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SAMPLE_COVERAGE_VALUE:
            n_params = 1;
            break;
        case GL_TEXTURE_2D:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_BINDING_2D:
            n_params = 1;
            break;
        case GL_ACTIVE_TEXTURE:
        case GL_SCISSOR_TEST:
        case GL_ALPHA_TEST_FUNC:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_ALPHA_TEST_REF:
            n_params = 1;
            break;
        case GL_STENCIL_TEST:
        case GL_STENCIL_FUNC:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_STENCIL_VALUE_MASK:
        case GL_STENCIL_REF:
            n_params = 1;
            break;
        case GL_STENCIL_FAIL:
        case GL_STENCIL_PASS_DEPTH_FAIL:
        case GL_STENCIL_PASS_DEPTH_PASS:
        case GL_DEPTH_TEST:
        case GL_DEPTH_FUNC:
        case GL_BLEND:
        case GL_BLEND_SRC:
        case GL_BLEND_DST:
        case GL_DITHER:
        case GL_COLOR_LOGIC_OP:
        case GL_LOGIC_OP_MODE:
        case GL_DEPTH_WRITEMASK:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_STENCIL_WRITEMASK:
        case GL_DEPTH_CLEAR_VALUE:
        case GL_STENCIL_CLEAR_VALUE:
        case GL_UNPACK_ALIGNMENT:
        case GL_PACK_ALIGNMENT:
            n_params = 1;
            break;
        case GL_PERSPECTIVE_CORRECTION_HINT:
        case GL_POINT_SMOOTH_HINT:
        case GL_LINE_SMOOTH_HINT:
        case GL_FOG_HINT:
        case GL_GENERATE_MIPMAP_HINT:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_MAX_LIGHTS:
        case GL_MAX_CLIP_PLANES:
        case GL_MAX_MODELVIEW_STACK_DEPTH:
        case GL_MAX_PROJECTION_STACK_DEPTH:
        case GL_MAX_TEXTURE_STACK_DEPTH:
        case GL_SUBPIXEL_BITS:
        case GL_MAX_TEXTURE_SIZE:
        case GL_MAX_TEXTURE_UNITS:
        case GL_SAMPLE_BUFFERS:
        case GL_SAMPLES:
        case GL_NUM_COMPRESSED_TEXTURE_FORMATS:
        case GL_RED_BITS:
        case GL_GREEN_BITS:
        case GL_BLUE_BITS:
        case GL_ALPHA_BITS:
        case GL_DEPTH_BITS:
        case GL_STENCIL_BITS:
            n_params = 1;
            break;
        case GL_MAX_VIEWPORT_DIMS:
        case GL_ALIASED_POINT_SIZE_RANGE:
        case GL_SMOOTH_POINT_SIZE_RANGE:
        case GL_ALIASED_LINE_WIDTH_RANGE:
        case GL_SMOOTH_LINE_WIDTH_RANGE:
        case GL_DEPTH_RANGE:
            n_params = 2;
            break;
        case GL_CURRENT_NORMAL:
        case GL_POINT_DISTANCE_ATTENUATION:
            n_params = 3;
            break;
        case GL_CURRENT_COLOR:
        case GL_CURRENT_TEXTURE_COORDS:
        case GL_SCISSOR_BOX:
        case GL_COLOR_WRITEMASK:
        case GL_COLOR_CLEAR_VALUE:
        case GL_LIGHT_MODEL_AMBIENT:
        case GL_VIEWPORT:
        case GL_FOG_COLOR:
            n_params = 4;
            break;
        case GL_MODELVIEW_MATRIX:
        case GL_PROJECTION_MATRIX:
        case GL_TEXTURE_MATRIX:
            n_params = 16;
            break;
        case GL_COMPRESSED_TEXTURE_FORMATS:
            convert_params_value = 0;
            n_params = _get_size(GL_NUM_COMPRESSED_TEXTURE_FORMATS);
            break;
        case GL_BLEND_SRC_RGB_OES:
        case GL_BLEND_DST_RGB_OES:
        case GL_BLEND_SRC_ALPHA_OES:
        case GL_BLEND_DST_ALPHA_OES:
        case GL_BLEND_EQUATION_RGB_OES:
        case GL_BLEND_EQUATION_ALPHA_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_FRAMEBUFFER_BINDING_OES:
        case GL_RENDERBUFFER_BINDING_OES:
        case GL_MAX_RENDERBUFFER_SIZE_OES:
            n_params = 1;
            break;
        case GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES:
        case GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES:
        case GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES:
            n_params = 16;
            break;
        case GL_MAX_PALETTE_MATRICES_OES:
        case GL_MAX_VERTEX_UNITS_OES:
        case GL_CURRENT_PALETTE_MATRIX_OES:
        case GL_MATRIX_INDEX_ARRAY_SIZE_OES:
            n_params = 1;
            break;
        case GL_MATRIX_INDEX_ARRAY_TYPE_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_MATRIX_INDEX_ARRAY_STRIDE_OES:
        case GL_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES:
        case GL_WEIGHT_ARRAY_SIZE_OES:
            n_params = 1;
            break;
        case GL_WEIGHT_ARRAY_TYPE_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_WEIGHT_ARRAY_STRIDE_OES:
        case GL_WEIGHT_ARRAY_BUFFER_BINDING_OES:
            n_params = 1;
            break;
        case GL_POINT_SIZE_ARRAY_TYPE_OES:
        case GL_IMPLEMENTATION_COLOR_READ_TYPE_OES:
        case GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES:
        case GL_TEXTURE_CUBE_MAP_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_BINDING_CUBE_MAP_OES:
        case GL_MAX_CUBE_MAP_TEXTURE_SIZE_OES:
        case GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT:
            n_params = 1;
            break;
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
        case GL_ALPHA_TEST:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetFixedv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetFloatv(pname, converted_params);
    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            params[i] = (GLint) (converted_params[i] * 65536);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            params[i] = (GLfloat) converted_params[i];
        }
    }
}

extern void GLAPIENTRY _mesa_GetFloatv(GLenum pname, GLfloat * params);
static void _es_GetFloatv(GLenum pname, GLfloat * params)
{
    _mesa_GetFloatv(pname, params);
}

extern void GLAPIENTRY _mesa_GetFramebufferAttachmentParameterivEXT(GLenum target, GLenum attachment, GLenum pname, GLint * params);
/* Extension OES_framebuffer_object */
static void _es_GetFramebufferAttachmentParameterivOES(GLenum target, GLenum attachment, GLenum pname, GLint * params)
{
    switch(target) {
        case GL_FRAMEBUFFER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetFramebufferAttachmentParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_OES: /* size 1 */
        case GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES: /* size 1 */
        case GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES: /* size 1 */
        case GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetFramebufferAttachmentParameteriv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetFramebufferAttachmentParameterivEXT(target, attachment, pname, params);
}

extern void GLAPIENTRY _mesa_GetIntegerv(GLenum pname, GLint * params);
static void _es_GetIntegerv(GLenum pname, GLint * params)
{
    _mesa_GetIntegerv(pname, params);
}

extern void GLAPIENTRY _mesa_GetLightfv(GLenum light, GLenum pname, GLfloat * params);
static void _es_GetLightfv(GLenum light, GLenum pname, GLfloat * params)
{
    switch(light) {
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetLightfv(light=0x%x)", light);
            return;
    }
    switch(pname) {
        case GL_AMBIENT:
        case GL_DIFFUSE:
        case GL_SPECULAR:
        case GL_POSITION:
        case GL_SPOT_DIRECTION:
        case GL_SPOT_EXPONENT:
        case GL_SPOT_CUTOFF:
        case GL_CONSTANT_ATTENUATION:
        case GL_LINEAR_ATTENUATION:
        case GL_QUADRATIC_ATTENUATION:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetLightfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetLightfv(light, pname, params);
}

extern void GLAPIENTRY _mesa_GetLightfv(GLenum light, GLenum pname, GLfloat * params);
static void _es_GetLightxv(GLenum light, GLenum pname, GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4]; 

    switch(light) {
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetLightxv(light=0x%x)", light);
            return;
    }
    switch(pname) {
        case GL_AMBIENT:
        case GL_DIFFUSE:
        case GL_SPECULAR:
        case GL_POSITION:
            n_params = 4;
            break;
        case GL_SPOT_DIRECTION:
            n_params = 3;
            break;
        case GL_SPOT_EXPONENT:
        case GL_SPOT_CUTOFF:
        case GL_CONSTANT_ATTENUATION:
        case GL_QUADRATIC_ATTENUATION:
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetLightxv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetLightfv(light, pname, converted_params);
    for (i = 0; i < n_params; i++) {
        params[i] = (GLint) (converted_params[i] * 65536);
    }
}

/* Extension OES_fixed_point */
static void _es_GetLightxvOES(GLenum light, GLenum pname, GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4]; 

    switch(light) {
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetLightxv(light=0x%x)", light);
            return;
    }
    switch(pname) {
        case GL_AMBIENT:
        case GL_DIFFUSE:
        case GL_SPECULAR:
        case GL_POSITION:
            n_params = 4;
            break;
        case GL_SPOT_DIRECTION:
            n_params = 3;
            break;
        case GL_SPOT_EXPONENT:
        case GL_SPOT_CUTOFF:
        case GL_CONSTANT_ATTENUATION:
        case GL_QUADRATIC_ATTENUATION:
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetLightxv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetLightfv(light, pname, converted_params);
    for (i = 0; i < n_params; i++) {
        params[i] = (GLint) (converted_params[i] * 65536);
    }
}

extern void GLAPIENTRY _mesa_GetMaterialfv(GLenum face, GLenum pname, GLfloat * params);
static void _es_GetMaterialfv(GLenum face, GLenum pname, GLfloat * params)
{
    switch(face) {
        case GL_FRONT:
        case GL_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetMaterialfv(face=0x%x)", face);
            return;
    }
    switch(pname) {
        case GL_AMBIENT:
        case GL_DIFFUSE:
        case GL_AMBIENT_AND_DIFFUSE:
        case GL_SPECULAR:
        case GL_EMISSION:
        case GL_SHININESS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetMaterialfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetMaterialfv(face, pname, params);
}

extern void GLAPIENTRY _mesa_GetMaterialfv(GLenum face, GLenum pname, GLfloat * params);
static void _es_GetMaterialxv(GLenum face, GLenum pname, GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4]; 

    switch(face) {
        case GL_FRONT:
        case GL_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetMaterialxv(face=0x%x)", face);
            return;
    }
    switch(pname) {
        case GL_SHININESS:
            n_params = 1;
            break;
        case GL_AMBIENT:
        case GL_DIFFUSE:
        case GL_AMBIENT_AND_DIFFUSE:
        case GL_SPECULAR:
        case GL_EMISSION:
            n_params = 4;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetMaterialxv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetMaterialfv(face, pname, converted_params);
    for (i = 0; i < n_params; i++) {
        params[i] = (GLint) (converted_params[i] * 65536);
    }
}

/* Extension OES_fixed_point */
static void _es_GetMaterialxvOES(GLenum face, GLenum pname, GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4]; 

    switch(face) {
        case GL_FRONT:
        case GL_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetMaterialxv(face=0x%x)", face);
            return;
    }
    switch(pname) {
        case GL_SHININESS:
            n_params = 1;
            break;
        case GL_AMBIENT:
        case GL_DIFFUSE:
        case GL_AMBIENT_AND_DIFFUSE:
        case GL_SPECULAR:
        case GL_EMISSION:
            n_params = 4;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetMaterialxv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetMaterialfv(face, pname, converted_params);
    for (i = 0; i < n_params; i++) {
        params[i] = (GLint) (converted_params[i] * 65536);
    }
}

extern void GLAPIENTRY _mesa_GetPointerv(GLenum pname, GLvoid ** params);
static void _es_GetPointerv(GLenum pname, GLvoid ** params)
{
    switch(pname) {
        case GL_COLOR_ARRAY_POINTER:
        case GL_NORMAL_ARRAY_POINTER:
        case GL_TEXTURE_COORD_ARRAY_POINTER:
        case GL_VERTEX_ARRAY_POINTER:
        case GL_MATRIX_INDEX_ARRAY_POINTER_OES:
        case GL_WEIGHT_ARRAY_POINTER_OES:
        case GL_POINT_SIZE_ARRAY_POINTER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetPointerv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetPointerv(pname, params);
}

extern void GLAPIENTRY _mesa_GetRenderbufferParameterivEXT(GLenum target, GLenum pname, GLint * params);
/* Extension OES_framebuffer_object */
static void _es_GetRenderbufferParameterivOES(GLenum target, GLenum pname, GLint * params)
{
    switch(target) {
        case GL_RENDERBUFFER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetRenderbufferParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_RENDERBUFFER_WIDTH_OES: /* size 1 */
        case GL_RENDERBUFFER_HEIGHT_OES: /* size 1 */
        case GL_RENDERBUFFER_INTERNAL_FORMAT_OES: /* size 1 */
        case GL_RENDERBUFFER_RED_SIZE_OES: /* size 1 */
        case GL_RENDERBUFFER_GREEN_SIZE_OES: /* size 1 */
        case GL_RENDERBUFFER_BLUE_SIZE_OES: /* size 1 */
        case GL_RENDERBUFFER_ALPHA_SIZE_OES: /* size 1 */
        case GL_RENDERBUFFER_DEPTH_SIZE_OES: /* size 1 */
        case GL_RENDERBUFFER_STENCIL_SIZE_OES: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetRenderbufferParameteriv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetRenderbufferParameterivEXT(target, pname, params);
}

/* this function is special and is defined elsewhere */
extern const GLubyte * _es_GetString(GLenum name);

extern void GLAPIENTRY _mesa_GetTexEnvfv(GLenum target, GLenum pname, GLfloat * params);
static void _es_GetTexEnvfv(GLenum target, GLenum pname, GLfloat * params)
{
    switch(target) {
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvfv(target=0x%x)", target);
                return;
            }
            break;
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_TEXTURE_ENV_COLOR && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvfv(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvfv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_ENV_COLOR: /* size 4 */
        case GL_RGB_SCALE: /* size 1 */
        case GL_ALPHA_SCALE: /* size 1 */
            break;
        case GL_TEXTURE_ENV_MODE: /* size 1 */
        case GL_COMBINE_RGB: /* size 1 */
        case GL_COMBINE_ALPHA: /* size 1 */
        case GL_SRC0_RGB: /* size 1 */
        case GL_SRC1_RGB: /* size 1 */
        case GL_SRC2_RGB: /* size 1 */
        case GL_SRC0_ALPHA: /* size 1 */
        case GL_SRC1_ALPHA: /* size 1 */
        case GL_SRC2_ALPHA: /* size 1 */
        case GL_OPERAND0_RGB: /* size 1 */
        case GL_OPERAND1_RGB: /* size 1 */
        case GL_OPERAND2_RGB: /* size 1 */
        case GL_OPERAND0_ALPHA: /* size 1 */
        case GL_OPERAND1_ALPHA: /* size 1 */
        case GL_OPERAND2_ALPHA: /* size 1 */
        case GL_COORD_REPLACE_OES: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexEnvfv(target, pname, params);
}

extern void GLAPIENTRY _mesa_GetTexEnviv(GLenum target, GLenum pname, GLint * params);
static void _es_GetTexEnviv(GLenum target, GLenum pname, GLint * params)
{
    switch(target) {
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnviv(target=0x%x)", target);
                return;
            }
            break;
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnviv(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnviv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_ENV_COLOR: /* size 4 */
        case GL_RGB_SCALE: /* size 1 */
        case GL_ALPHA_SCALE: /* size 1 */
            break;
        case GL_TEXTURE_ENV_MODE: /* size 1 */
        case GL_COMBINE_RGB: /* size 1 */
        case GL_COMBINE_ALPHA: /* size 1 */
        case GL_SRC0_RGB: /* size 1 */
        case GL_SRC1_RGB: /* size 1 */
        case GL_SRC2_RGB: /* size 1 */
        case GL_SRC0_ALPHA: /* size 1 */
        case GL_SRC1_ALPHA: /* size 1 */
        case GL_SRC2_ALPHA: /* size 1 */
        case GL_OPERAND0_RGB: /* size 1 */
        case GL_OPERAND1_RGB: /* size 1 */
        case GL_OPERAND2_RGB: /* size 1 */
        case GL_OPERAND0_ALPHA: /* size 1 */
        case GL_OPERAND1_ALPHA: /* size 1 */
        case GL_OPERAND2_ALPHA: /* size 1 */
        case GL_COORD_REPLACE_OES: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnviv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexEnviv(target, pname, params);
}

extern void GLAPIENTRY _mesa_GetTexEnvfv(GLenum target, GLenum pname, GLfloat * params);
static void _es_GetTexEnvxv(GLenum target, GLenum pname, GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4];
    int convert_params_value = 1; 

    switch(target) {
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvxv(target=0x%x)", target);
                return;
            }
            break;
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_TEXTURE_ENV_COLOR && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvxv(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvxv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_ENV_COLOR:
            n_params = 4;
            break;
        case GL_RGB_SCALE:
        case GL_ALPHA_SCALE:
            n_params = 1;
            break;
        case GL_TEXTURE_ENV_MODE:
        case GL_COMBINE_RGB:
        case GL_COMBINE_ALPHA:
        case GL_SRC0_RGB:
        case GL_SRC1_RGB:
        case GL_SRC2_RGB:
        case GL_SRC0_ALPHA:
        case GL_SRC1_ALPHA:
        case GL_SRC2_ALPHA:
        case GL_OPERAND0_RGB:
        case GL_OPERAND1_RGB:
        case GL_OPERAND2_RGB:
        case GL_OPERAND0_ALPHA:
        case GL_OPERAND1_ALPHA:
        case GL_OPERAND2_ALPHA:
        case GL_COORD_REPLACE_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvxv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexEnvfv(target, pname, converted_params);
    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            params[i] = (GLint) (converted_params[i] * 65536);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            params[i] = (GLfloat) converted_params[i];
        }
    }
}

/* Extension OES_fixed_point */
static void _es_GetTexEnvxvOES(GLenum target, GLenum pname, GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4];
    int convert_params_value = 1; 

    switch(target) {
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvxv(target=0x%x)", target);
                return;
            }
            break;
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_TEXTURE_ENV_COLOR && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvxv(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvxv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_ENV_COLOR:
            n_params = 4;
            break;
        case GL_RGB_SCALE:
        case GL_ALPHA_SCALE:
            n_params = 1;
            break;
        case GL_TEXTURE_ENV_MODE:
        case GL_COMBINE_RGB:
        case GL_COMBINE_ALPHA:
        case GL_SRC0_RGB:
        case GL_SRC1_RGB:
        case GL_SRC2_RGB:
        case GL_SRC0_ALPHA:
        case GL_SRC1_ALPHA:
        case GL_SRC2_ALPHA:
        case GL_OPERAND0_RGB:
        case GL_OPERAND1_RGB:
        case GL_OPERAND2_RGB:
        case GL_OPERAND0_ALPHA:
        case GL_OPERAND1_ALPHA:
        case GL_OPERAND2_ALPHA:
        case GL_COORD_REPLACE_OES:
            convert_params_value = 0;
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexEnvxv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexEnvfv(target, pname, converted_params);
    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            params[i] = (GLint) (converted_params[i] * 65536);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            params[i] = (GLfloat) converted_params[i];
        }
    }
}

extern void GLAPIENTRY _mesa_GetTexGenfv(GLenum coord, GLenum pname, GLfloat * params);
/* Extension OES_texture_cube_map */
static void _es_GetTexGenfvOES(GLenum coord, GLenum pname, GLfloat * params)
{
    switch(coord) {
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexGenfv(coord=0x%x)", coord);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_GEN_MODE_OES: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexGenfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexGenfv(coord, pname, params);
}

extern void GLAPIENTRY _mesa_GetTexGeniv(GLenum coord, GLenum pname, GLint * params);
/* Extension OES_texture_cube_map */
static void _es_GetTexGenivOES(GLenum coord, GLenum pname, GLint * params)
{
    switch(coord) {
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexGeniv(coord=0x%x)", coord);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_GEN_MODE_OES: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexGeniv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexGeniv(coord, pname, params);
}

extern void GLAPIENTRY _mesa_GetTexGenfv(GLenum coord, GLenum pname, GLfloat * params);
/* Extension OES_texture_cube_map */
static void _es_GetTexGenxvOES(GLenum coord, GLenum pname, GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 1;
    GLfloat converted_params[1]; 

    switch(coord) {
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexGenxv(coord=0x%x)", coord);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_GEN_MODE_OES:
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexGenxv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexGenfv(coord, pname, converted_params);
    for (i = 0; i < n_params; i++) {
        params[i] = (GLfloat) converted_params[i];
    }
}

extern void GLAPIENTRY _mesa_GetTexParameterfv(GLenum target, GLenum pname, GLfloat * params);
static void _es_GetTexParameterfv(GLenum target, GLenum pname, GLfloat * params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameterfv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
        case GL_GENERATE_MIPMAP: /* size 1 */
        case GL_TEXTURE_CROP_RECT_OES: /* size 4 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameterfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexParameterfv(target, pname, params);
}

extern void GLAPIENTRY _mesa_GetTexParameteriv(GLenum target, GLenum pname, GLint * params);
static void _es_GetTexParameteriv(GLenum target, GLenum pname, GLint * params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
        case GL_GENERATE_MIPMAP: /* size 1 */
        case GL_TEXTURE_CROP_RECT_OES: /* size 4 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameteriv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexParameteriv(target, pname, params);
}

extern void GLAPIENTRY _mesa_GetTexParameterfv(GLenum target, GLenum pname, GLfloat * params);
static void _es_GetTexParameterxv(GLenum target, GLenum pname, GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 1;
    GLfloat converted_params[1]; 

    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameterxv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
        case GL_TEXTURE_MIN_FILTER:
        case GL_TEXTURE_MAG_FILTER:
        case GL_GENERATE_MIPMAP:
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameterxv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexParameterfv(target, pname, converted_params);
    for (i = 0; i < n_params; i++) {
        params[i] = (GLfloat) converted_params[i];
    }
}

/* Extension OES_fixed_point */
static void _es_GetTexParameterxvOES(GLenum target, GLenum pname, GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 1;
    GLfloat converted_params[1]; 

    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameterxv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
        case GL_TEXTURE_MIN_FILTER:
        case GL_TEXTURE_MAG_FILTER:
        case GL_GENERATE_MIPMAP:
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameterxv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexParameterfv(target, pname, converted_params);
    for (i = 0; i < n_params; i++) {
        params[i] = (GLfloat) converted_params[i];
    }
}

extern void GLAPIENTRY _mesa_Hint(GLenum target, GLenum mode);
static void _es_Hint(GLenum target, GLenum mode)
{
    switch(target) {
        case GL_FOG_HINT:
        case GL_LINE_SMOOTH_HINT:
        case GL_PERSPECTIVE_CORRECTION_HINT:
        case GL_POINT_SMOOTH_HINT:
        case GL_GENERATE_MIPMAP_HINT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glHint(target=0x%x)", target);
            return;
    }
    switch(mode) {
        case GL_FASTEST:
        case GL_NICEST:
        case GL_DONT_CARE:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glHint(mode=0x%x)", mode);
            return;
    } 

    _mesa_Hint(target, mode);
}

extern GLboolean GLAPIENTRY _mesa_IsBufferARB(GLuint buffer);
static GLboolean _es_IsBuffer(GLuint buffer)
{
    return _mesa_IsBufferARB(buffer);
}

extern GLboolean GLAPIENTRY _mesa_IsEnabled(GLenum cap);
static GLboolean _es_IsEnabled(GLenum cap)
{
    switch(cap) {
        case GL_VERTEX_ARRAY:
        case GL_NORMAL_ARRAY:
        case GL_COLOR_ARRAY:
        case GL_TEXTURE_COORD_ARRAY:
        case GL_NORMALIZE:
        case GL_RESCALE_NORMAL:
        case GL_CLIP_PLANE0:
        case GL_CLIP_PLANE1:
        case GL_CLIP_PLANE2:
        case GL_CLIP_PLANE3:
        case GL_CLIP_PLANE4:
        case GL_CLIP_PLANE5:
        case GL_FOG:
        case GL_LIGHTING:
        case GL_COLOR_MATERIAL:
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
        case GL_POINT_SMOOTH:
        case GL_LINE_SMOOTH:
        case GL_CULL_FACE:
        case GL_POLYGON_OFFSET_FILL:
        case GL_MULTISAMPLE:
        case GL_SAMPLE_ALPHA_TO_COVERAGE:
        case GL_SAMPLE_ALPHA_TO_ONE:
        case GL_SAMPLE_COVERAGE:
        case GL_TEXTURE_2D:
        case GL_SCISSOR_TEST:
        case GL_ALPHA_TEST:
        case GL_STENCIL_TEST:
        case GL_DEPTH_TEST:
        case GL_BLEND:
        case GL_DITHER:
        case GL_COLOR_LOGIC_OP:
        case GL_MATRIX_INDEX_ARRAY_OES:
        case GL_WEIGHT_ARRAY_OES:
        case GL_POINT_SIZE_ARRAY_OES:
        case GL_POINT_SPRITE_OES:
        case GL_TEXTURE_CUBE_MAP_OES:
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glIsEnabled(cap=0x%x)", cap);
            return GL_FALSE;
    } 

    return _mesa_IsEnabled(cap);
}

extern GLboolean GLAPIENTRY _mesa_IsFramebufferEXT(GLuint framebuffer);
/* Extension OES_framebuffer_object */
static GLboolean _es_IsFramebufferOES(GLuint framebuffer)
{
    return _mesa_IsFramebufferEXT(framebuffer);
}

extern GLboolean GLAPIENTRY _mesa_IsRenderbufferEXT(GLuint renderbuffer);
/* Extension OES_framebuffer_object */
static GLboolean _es_IsRenderbufferOES(GLuint renderbuffer)
{
    return _mesa_IsRenderbufferEXT(renderbuffer);
}

extern GLboolean GLAPIENTRY _mesa_IsTexture(GLuint texture);
static GLboolean _es_IsTexture(GLuint texture)
{
    return _mesa_IsTexture(texture);
}

extern void GLAPIENTRY _mesa_LightModelf(GLenum pname, GLfloat param);
static void _es_LightModelf(GLenum pname, GLfloat param)
{
    switch(pname) {
        case GL_LIGHT_MODEL_TWO_SIDE:
            if (param != GL_TRUE && param != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightModelf(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightModelf(pname=0x%x)", pname);
            return;
    } 

    _mesa_LightModelf(pname, param);
}

extern void GLAPIENTRY _mesa_LightModelfv(GLenum pname, const GLfloat * params);
static void _es_LightModelfv(GLenum pname, const GLfloat * params)
{
    switch(pname) {
        case GL_LIGHT_MODEL_AMBIENT: /* size 4 */
        case GL_LIGHT_MODEL_TWO_SIDE: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightModelfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_LightModelfv(pname, params);
}

extern void GLAPIENTRY _mesa_LightModelf(GLenum pname, GLfloat  param);
static void _es_LightModelx(GLenum pname, GLfixed param)
{
    GLfloat converted_param; 

    switch(pname) {
        case GL_LIGHT_MODEL_TWO_SIDE:
            if (param != GL_TRUE && param != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightModelx(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightModelx(pname=0x%x)", pname);
            return;
    } 

    converted_param = (GLfloat) param; 

    _mesa_LightModelf(pname, converted_param);
}

/* Extension OES_fixed_point */
static void _es_LightModelxOES(GLenum pname, GLfixed param)
{
    GLfloat converted_param; 

    switch(pname) {
        case GL_LIGHT_MODEL_TWO_SIDE:
            if (param != GL_TRUE && param != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightModelx(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightModelx(pname=0x%x)", pname);
            return;
    } 

    converted_param = (GLfloat) param; 

    _mesa_LightModelf(pname, converted_param);
}

extern void GLAPIENTRY _mesa_LightModelfv(GLenum pname, GLfloat const * params);
static void _es_LightModelxv(GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4];
    int convert_params_value = 1; 

    switch(pname) {
        case GL_LIGHT_MODEL_AMBIENT:
            n_params = 4;
            break;
        case GL_LIGHT_MODEL_TWO_SIDE:
            if (params[0] != GL_TRUE && params[0] != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightModelxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightModelxv(pname=0x%x)", pname);
            return;
    } 

    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) (params[i] / 65536.0f);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) params[i];
        }
    } 

    _mesa_LightModelfv(pname, converted_params);
}

/* Extension OES_fixed_point */
static void _es_LightModelxvOES(GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4];
    int convert_params_value = 1; 

    switch(pname) {
        case GL_LIGHT_MODEL_AMBIENT:
            n_params = 4;
            break;
        case GL_LIGHT_MODEL_TWO_SIDE:
            if (params[0] != GL_TRUE && params[0] != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightModelxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightModelxv(pname=0x%x)", pname);
            return;
    } 

    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) (params[i] / 65536.0f);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) params[i];
        }
    } 

    _mesa_LightModelfv(pname, converted_params);
}

extern void GLAPIENTRY _mesa_Lightf(GLenum light, GLenum pname, GLfloat param);
static void _es_Lightf(GLenum light, GLenum pname, GLfloat param)
{
    switch(light) {
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightf(light=0x%x)", light);
            return;
    }
    switch(pname) {
        case GL_SPOT_EXPONENT:
        case GL_SPOT_CUTOFF:
        case GL_CONSTANT_ATTENUATION:
        case GL_LINEAR_ATTENUATION:
        case GL_QUADRATIC_ATTENUATION:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightf(pname=0x%x)", pname);
            return;
    } 

    _mesa_Lightf(light, pname, param);
}

extern void GLAPIENTRY _mesa_Lightfv(GLenum light, GLenum pname, const GLfloat * params);
static void _es_Lightfv(GLenum light, GLenum pname, const GLfloat * params)
{
    switch(light) {
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightfv(light=0x%x)", light);
            return;
    }
    switch(pname) {
        case GL_AMBIENT: /* size 4 */
        case GL_DIFFUSE: /* size 4 */
        case GL_SPECULAR: /* size 4 */
        case GL_POSITION: /* size 4 */
        case GL_SPOT_DIRECTION: /* size 3 */
        case GL_SPOT_EXPONENT: /* size 1 */
        case GL_SPOT_CUTOFF: /* size 1 */
        case GL_CONSTANT_ATTENUATION: /* size 1 */
        case GL_LINEAR_ATTENUATION: /* size 1 */
        case GL_QUADRATIC_ATTENUATION: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_Lightfv(light, pname, params);
}

extern void GLAPIENTRY _mesa_Lightf(GLenum light, GLenum pname, GLfloat  param);
static void _es_Lightx(GLenum light, GLenum pname, GLfixed param)
{
    GLfloat converted_param; 

    switch(light) {
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightx(light=0x%x)", light);
            return;
    }
    switch(pname) {
        case GL_SPOT_EXPONENT:
        case GL_SPOT_CUTOFF:
        case GL_CONSTANT_ATTENUATION:
        case GL_LINEAR_ATTENUATION:
        case GL_QUADRATIC_ATTENUATION:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightx(pname=0x%x)", pname);
            return;
    } 

    converted_param = (GLfloat) (param / 65536.0f); 

    _mesa_Lightf(light, pname, converted_param);
}

/* Extension OES_fixed_point */
static void _es_LightxOES(GLenum light, GLenum pname, GLfixed param)
{
    GLfloat converted_param; 

    switch(light) {
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightx(light=0x%x)", light);
            return;
    }
    switch(pname) {
        case GL_SPOT_EXPONENT:
        case GL_SPOT_CUTOFF:
        case GL_CONSTANT_ATTENUATION:
        case GL_LINEAR_ATTENUATION:
        case GL_QUADRATIC_ATTENUATION:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightx(pname=0x%x)", pname);
            return;
    } 

    converted_param = (GLfloat) (param / 65536.0f); 

    _mesa_Lightf(light, pname, converted_param);
}

extern void GLAPIENTRY _mesa_Lightfv(GLenum light, GLenum pname, GLfloat const * params);
static void _es_Lightxv(GLenum light, GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4]; 

    switch(light) {
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightxv(light=0x%x)", light);
            return;
    }
    switch(pname) {
        case GL_AMBIENT:
        case GL_DIFFUSE:
        case GL_SPECULAR:
        case GL_POSITION:
            n_params = 4;
            break;
        case GL_SPOT_DIRECTION:
            n_params = 3;
            break;
        case GL_SPOT_EXPONENT:
        case GL_SPOT_CUTOFF:
        case GL_CONSTANT_ATTENUATION:
        case GL_LINEAR_ATTENUATION:
        case GL_QUADRATIC_ATTENUATION:
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightxv(pname=0x%x)", pname);
            return;
    } 

    for (i = 0; i < n_params; i++) {
        converted_params[i] = (GLfloat) (params[i] / 65536.0f);
    } 

    _mesa_Lightfv(light, pname, converted_params);
}

/* Extension OES_fixed_point */
static void _es_LightxvOES(GLenum light, GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4]; 

    switch(light) {
        case GL_LIGHT0:
        case GL_LIGHT1:
        case GL_LIGHT2:
        case GL_LIGHT3:
        case GL_LIGHT4:
        case GL_LIGHT5:
        case GL_LIGHT6:
        case GL_LIGHT7:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightxv(light=0x%x)", light);
            return;
    }
    switch(pname) {
        case GL_AMBIENT:
        case GL_DIFFUSE:
        case GL_SPECULAR:
        case GL_POSITION:
            n_params = 4;
            break;
        case GL_SPOT_DIRECTION:
            n_params = 3;
            break;
        case GL_SPOT_EXPONENT:
        case GL_SPOT_CUTOFF:
        case GL_CONSTANT_ATTENUATION:
        case GL_LINEAR_ATTENUATION:
        case GL_QUADRATIC_ATTENUATION:
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLightxv(pname=0x%x)", pname);
            return;
    } 

    for (i = 0; i < n_params; i++) {
        converted_params[i] = (GLfloat) (params[i] / 65536.0f);
    } 

    _mesa_Lightfv(light, pname, converted_params);
}

extern void GLAPIENTRY _mesa_LineWidth(GLfloat width);
static void _es_LineWidth(GLfloat width)
{
    _mesa_LineWidth(width);
}

extern void GLAPIENTRY _mesa_LineWidth(GLfloat  width);
static void _es_LineWidthx(GLfixed width)
{
    GLfloat converted_width; 

    converted_width = (GLfloat) (width / 65536.0f); 

    _mesa_LineWidth(converted_width);
}

/* Extension OES_fixed_point */
static void _es_LineWidthxOES(GLfixed width)
{
    GLfloat converted_width; 

    converted_width = (GLfloat) (width / 65536.0f); 

    _mesa_LineWidth(converted_width);
}

extern void GLAPIENTRY _mesa_LoadIdentity();
static void _es_LoadIdentity(void)
{
    _mesa_LoadIdentity();
}

extern void GLAPIENTRY _mesa_LoadMatrixf(const GLfloat * m);
static void _es_LoadMatrixf(const GLfloat * m)
{
    _mesa_LoadMatrixf(m);
}

extern void GLAPIENTRY _mesa_LoadMatrixf(GLfloat const * m);
static void _es_LoadMatrixx(const GLfixed * m)
{
    register unsigned int i;
    unsigned int n_m = 16;
    GLfloat converted_m[16]; 

    for (i = 0; i < n_m; i++) {
        converted_m[i] = (GLfloat) (m[i] / 65536.0f);
    } 

    _mesa_LoadMatrixf(converted_m);
}

/* Extension OES_fixed_point */
static void _es_LoadMatrixxOES(const GLfixed * m)
{
    register unsigned int i;
    unsigned int n_m = 16;
    GLfloat converted_m[16]; 

    for (i = 0; i < n_m; i++) {
        converted_m[i] = (GLfloat) (m[i] / 65536.0f);
    } 

    _mesa_LoadMatrixf(converted_m);
}

extern void GLAPIENTRY _mesa_LogicOp(GLenum opcode);
static void _es_LogicOp(GLenum opcode)
{
    switch(opcode) {
        case GL_CLEAR:
        case GL_SET:
        case GL_COPY:
        case GL_COPY_INVERTED:
        case GL_NOOP:
        case GL_INVERT:
        case GL_AND:
        case GL_NAND:
        case GL_OR:
        case GL_NOR:
        case GL_XOR:
        case GL_EQUIV:
        case GL_AND_REVERSE:
        case GL_AND_INVERTED:
        case GL_OR_REVERSE:
        case GL_OR_INVERTED:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glLogicOp(opcode=0x%x)", opcode);
            return;
    } 

    _mesa_LogicOp(opcode);
}

extern void * GLAPIENTRY _mesa_MapBufferARB(GLenum target, GLenum access);
/* Extension OES_mapbuffer */
static void * _es_MapBufferOES(GLenum target, GLenum access)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMapBuffer(target=0x%x)", target);
            return (void *) 0;
    }
    switch(access) {
        case GL_WRITE_ONLY_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMapBuffer(access=0x%x)", access);
            return (void *) 0;
    } 

    return _mesa_MapBufferARB(target, access);
}

extern void GLAPIENTRY _vbo_Materialf(GLenum face, GLenum pname, GLfloat param);
static void _es_Materialf(GLenum face, GLenum pname, GLfloat param)
{
    switch(face) {
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialf(face=0x%x)", face);
            return;
    }
    switch(pname) {
        case GL_SHININESS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialf(pname=0x%x)", pname);
            return;
    } 

    _vbo_Materialf(face, pname, param);
}

extern void GLAPIENTRY _vbo_Materialfv(GLenum face, GLenum pname, const GLfloat * params);
static void _es_Materialfv(GLenum face, GLenum pname, const GLfloat * params)
{
    switch(face) {
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialfv(face=0x%x)", face);
            return;
    }
    switch(pname) {
        case GL_AMBIENT: /* size 4 */
        case GL_DIFFUSE: /* size 4 */
        case GL_AMBIENT_AND_DIFFUSE: /* size 4 */
        case GL_SPECULAR: /* size 4 */
        case GL_EMISSION: /* size 4 */
        case GL_SHININESS: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialfv(pname=0x%x)", pname);
            return;
    } 

    _vbo_Materialfv(face, pname, params);
}

extern void GLAPIENTRY _vbo_Materialf(GLenum face, GLenum pname, GLfloat  param);
static void _es_Materialx(GLenum face, GLenum pname, GLfixed param)
{
    GLfloat converted_param; 

    switch(face) {
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialx(face=0x%x)", face);
            return;
    }
    switch(pname) {
        case GL_SHININESS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialx(pname=0x%x)", pname);
            return;
    } 

    converted_param = (GLfloat) (param / 65536.0f); 

    _vbo_Materialf(face, pname, converted_param);
}

/* Extension OES_fixed_point */
static void _es_MaterialxOES(GLenum face, GLenum pname, GLfixed param)
{
    GLfloat converted_param; 

    switch(face) {
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialx(face=0x%x)", face);
            return;
    }
    switch(pname) {
        case GL_SHININESS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialx(pname=0x%x)", pname);
            return;
    } 

    converted_param = (GLfloat) (param / 65536.0f); 

    _vbo_Materialf(face, pname, converted_param);
}

extern void GLAPIENTRY _vbo_Materialfv(GLenum face, GLenum pname, GLfloat const * params);
static void _es_Materialxv(GLenum face, GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4]; 

    switch(face) {
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialxv(face=0x%x)", face);
            return;
    }
    switch(pname) {
        case GL_AMBIENT:
        case GL_DIFFUSE:
        case GL_AMBIENT_AND_DIFFUSE:
        case GL_SPECULAR:
        case GL_EMISSION:
            n_params = 4;
            break;
        case GL_SHININESS:
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialxv(pname=0x%x)", pname);
            return;
    } 

    for (i = 0; i < n_params; i++) {
        converted_params[i] = (GLfloat) (params[i] / 65536.0f);
    } 

    _vbo_Materialfv(face, pname, converted_params);
}

/* Extension OES_fixed_point */
static void _es_MaterialxvOES(GLenum face, GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4]; 

    switch(face) {
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialxv(face=0x%x)", face);
            return;
    }
    switch(pname) {
        case GL_AMBIENT:
        case GL_DIFFUSE:
        case GL_AMBIENT_AND_DIFFUSE:
        case GL_SPECULAR:
        case GL_EMISSION:
            n_params = 4;
            break;
        case GL_SHININESS:
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMaterialxv(pname=0x%x)", pname);
            return;
    } 

    for (i = 0; i < n_params; i++) {
        converted_params[i] = (GLfloat) (params[i] / 65536.0f);
    } 

    _vbo_Materialfv(face, pname, converted_params);
}

extern void GLAPIENTRY _mesa_MatrixMode(GLenum mode);
static void _es_MatrixMode(GLenum mode)
{
    switch(mode) {
        case GL_MODELVIEW:
        case GL_PROJECTION:
        case GL_TEXTURE:
        case GL_MATRIX_PALETTE_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMatrixMode(mode=0x%x)", mode);
            return;
    } 

    _mesa_MatrixMode(mode);
}

extern void GLAPIENTRY _mesa_MultMatrixf(const GLfloat * m);
static void _es_MultMatrixf(const GLfloat * m)
{
    _mesa_MultMatrixf(m);
}

extern void GLAPIENTRY _mesa_MultMatrixf(GLfloat const * m);
static void _es_MultMatrixx(const GLfixed * m)
{
    register unsigned int i;
    unsigned int n_m = 16;
    GLfloat converted_m[16]; 

    for (i = 0; i < n_m; i++) {
        converted_m[i] = (GLfloat) (m[i] / 65536.0f);
    } 

    _mesa_MultMatrixf(converted_m);
}

/* Extension OES_fixed_point */
static void _es_MultMatrixxOES(const GLfixed * m)
{
    register unsigned int i;
    unsigned int n_m = 16;
    GLfloat converted_m[16]; 

    for (i = 0; i < n_m; i++) {
        converted_m[i] = (GLfloat) (m[i] / 65536.0f);
    } 

    _mesa_MultMatrixf(converted_m);
}

extern void GLAPIENTRY _vbo_MultiTexCoord4f(GLenum texture, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
static void _es_MultiTexCoord4f(GLenum texture, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    switch(texture) {
        case GL_TEXTURE0:
        case GL_TEXTURE1:
        case GL_TEXTURE2:
        case GL_TEXTURE3:
        case GL_TEXTURE4:
        case GL_TEXTURE5:
        case GL_TEXTURE6:
        case GL_TEXTURE7:
        case GL_TEXTURE8:
        case GL_TEXTURE9:
        case GL_TEXTURE10:
        case GL_TEXTURE11:
        case GL_TEXTURE12:
        case GL_TEXTURE13:
        case GL_TEXTURE14:
        case GL_TEXTURE15:
        case GL_TEXTURE16:
        case GL_TEXTURE17:
        case GL_TEXTURE18:
        case GL_TEXTURE19:
        case GL_TEXTURE20:
        case GL_TEXTURE21:
        case GL_TEXTURE22:
        case GL_TEXTURE23:
        case GL_TEXTURE24:
        case GL_TEXTURE25:
        case GL_TEXTURE26:
        case GL_TEXTURE27:
        case GL_TEXTURE28:
        case GL_TEXTURE29:
        case GL_TEXTURE30:
        case GL_TEXTURE31:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMultiTexCoord4f(texture=0x%x)", texture);
            return;
    } 

    _vbo_MultiTexCoord4f(texture, s, t, r, q);
}

extern void GLAPIENTRY _vbo_MultiTexCoord4f(GLenum texture, GLfloat  s, GLfloat  t, GLfloat  r, GLfloat  q);
static void _es_MultiTexCoord4x(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q)
{
    GLfloat converted_s;
    GLfloat converted_t;
    GLfloat converted_r;
    GLfloat converted_q; 

    switch(texture) {
        case GL_TEXTURE0:
        case GL_TEXTURE1:
        case GL_TEXTURE2:
        case GL_TEXTURE3:
        case GL_TEXTURE4:
        case GL_TEXTURE5:
        case GL_TEXTURE6:
        case GL_TEXTURE7:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMultiTexCoord4x(texture=0x%x)", texture);
            return;
    } 

    converted_s = (GLfloat) (s / 65536.0f);
    converted_t = (GLfloat) (t / 65536.0f);
    converted_r = (GLfloat) (r / 65536.0f);
    converted_q = (GLfloat) (q / 65536.0f); 

    _vbo_MultiTexCoord4f(texture, converted_s, converted_t, converted_r, converted_q);
}

/* Extension OES_fixed_point */
static void _es_MultiTexCoord4xOES(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q)
{
    GLfloat converted_s;
    GLfloat converted_t;
    GLfloat converted_r;
    GLfloat converted_q; 

    switch(texture) {
        case GL_TEXTURE0:
        case GL_TEXTURE1:
        case GL_TEXTURE2:
        case GL_TEXTURE3:
        case GL_TEXTURE4:
        case GL_TEXTURE5:
        case GL_TEXTURE6:
        case GL_TEXTURE7:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMultiTexCoord4x(texture=0x%x)", texture);
            return;
    } 

    converted_s = (GLfloat) (s / 65536.0f);
    converted_t = (GLfloat) (t / 65536.0f);
    converted_r = (GLfloat) (r / 65536.0f);
    converted_q = (GLfloat) (q / 65536.0f); 

    _vbo_MultiTexCoord4f(texture, converted_s, converted_t, converted_r, converted_q);
}

extern void GLAPIENTRY _vbo_Normal3f(GLfloat nx, GLfloat ny, GLfloat nz);
static void _es_Normal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
    _vbo_Normal3f(nx, ny, nz);
}

extern void GLAPIENTRY _vbo_Normal3f(GLfloat  nx, GLfloat  ny, GLfloat  nz);
static void _es_Normal3x(GLfixed nx, GLfixed ny, GLfixed nz)
{
    GLfloat converted_nx;
    GLfloat converted_ny;
    GLfloat converted_nz; 

    converted_nx = (GLfloat) (nx / 65536.0f);
    converted_ny = (GLfloat) (ny / 65536.0f);
    converted_nz = (GLfloat) (nz / 65536.0f); 

    _vbo_Normal3f(converted_nx, converted_ny, converted_nz);
}

/* Extension OES_fixed_point */
static void _es_Normal3xOES(GLfixed nx, GLfixed ny, GLfixed nz)
{
    GLfloat converted_nx;
    GLfloat converted_ny;
    GLfloat converted_nz; 

    converted_nx = (GLfloat) (nx / 65536.0f);
    converted_ny = (GLfloat) (ny / 65536.0f);
    converted_nz = (GLfloat) (nz / 65536.0f); 

    _vbo_Normal3f(converted_nx, converted_ny, converted_nz);
}

extern void GLAPIENTRY _mesa_NormalPointer(GLenum type, GLsizei stride, const GLvoid * pointer);
static void _es_NormalPointer(GLenum type, GLsizei stride, const GLvoid * pointer)
{
    switch(type) {
        case GL_BYTE:
        case GL_SHORT:
        case GL_FIXED:
        case GL_FLOAT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glNormalPointer(type=0x%x)", type);
            return;
    } 

    _mesa_NormalPointer(type, stride, pointer);
}

extern void GLAPIENTRY _mesa_Ortho(GLdouble  left, GLdouble  right, GLdouble  bottom, GLdouble  top, GLdouble  zNear, GLdouble  zFar);
static void _es_Orthof(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar)
{
    GLdouble converted_left;
    GLdouble converted_right;
    GLdouble converted_bottom;
    GLdouble converted_top;
    GLdouble converted_zNear;
    GLdouble converted_zFar; 

    converted_left = (GLdouble) (left);
    converted_right = (GLdouble) (right);
    converted_bottom = (GLdouble) (bottom);
    converted_top = (GLdouble) (top);
    converted_zNear = (GLdouble) (zNear);
    converted_zFar = (GLdouble) (zFar); 

    _mesa_Ortho(converted_left, converted_right, converted_bottom, converted_top, converted_zNear, converted_zFar);
}

/* Extension OES_single_precision */
static void _es_OrthofOES(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar)
{
    GLdouble converted_left;
    GLdouble converted_right;
    GLdouble converted_bottom;
    GLdouble converted_top;
    GLdouble converted_zNear;
    GLdouble converted_zFar; 

    converted_left = (GLdouble) (left);
    converted_right = (GLdouble) (right);
    converted_bottom = (GLdouble) (bottom);
    converted_top = (GLdouble) (top);
    converted_zNear = (GLdouble) (zNear);
    converted_zFar = (GLdouble) (zFar); 

    _mesa_Ortho(converted_left, converted_right, converted_bottom, converted_top, converted_zNear, converted_zFar);
}

extern void GLAPIENTRY _mesa_Ortho(GLdouble  left, GLdouble  right, GLdouble  bottom, GLdouble  top, GLdouble  zNear, GLdouble  zFar);
static void _es_Orthox(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar)
{
    GLdouble converted_left;
    GLdouble converted_right;
    GLdouble converted_bottom;
    GLdouble converted_top;
    GLdouble converted_zNear;
    GLdouble converted_zFar; 

    converted_left = (GLdouble) (left / 65536.0);
    converted_right = (GLdouble) (right / 65536.0);
    converted_bottom = (GLdouble) (bottom / 65536.0);
    converted_top = (GLdouble) (top / 65536.0);
    converted_zNear = (GLdouble) (zNear / 65536.0);
    converted_zFar = (GLdouble) (zFar / 65536.0); 

    _mesa_Ortho(converted_left, converted_right, converted_bottom, converted_top, converted_zNear, converted_zFar);
}

/* Extension OES_fixed_point */
static void _es_OrthoxOES(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar)
{
    GLdouble converted_left;
    GLdouble converted_right;
    GLdouble converted_bottom;
    GLdouble converted_top;
    GLdouble converted_zNear;
    GLdouble converted_zFar; 

    converted_left = (GLdouble) (left / 65536.0);
    converted_right = (GLdouble) (right / 65536.0);
    converted_bottom = (GLdouble) (bottom / 65536.0);
    converted_top = (GLdouble) (top / 65536.0);
    converted_zNear = (GLdouble) (zNear / 65536.0);
    converted_zFar = (GLdouble) (zFar / 65536.0); 

    _mesa_Ortho(converted_left, converted_right, converted_bottom, converted_top, converted_zNear, converted_zFar);
}

extern void GLAPIENTRY _mesa_PixelStorei(GLenum pname, GLint param);
static void _es_PixelStorei(GLenum pname, GLint param)
{
    switch(pname) {
        case GL_PACK_ALIGNMENT:
        case GL_UNPACK_ALIGNMENT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glPixelStorei(pname=0x%x)", pname);
            return;
    }
    switch(param) {
        case 1:
        case 2:
        case 4:
        case 8:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glPixelStorei(param=%d)", param);
            return;
    } 

    _mesa_PixelStorei(pname, param);
}

extern void GLAPIENTRY _mesa_PointParameterf(GLenum pname, GLfloat param);
static void _es_PointParameterf(GLenum pname, GLfloat param)
{
    switch(pname) {
        case GL_POINT_SIZE_MIN:
        case GL_POINT_SIZE_MAX:
        case GL_POINT_FADE_THRESHOLD_SIZE:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glPointParameterf(pname=0x%x)", pname);
            return;
    } 

    _mesa_PointParameterf(pname, param);
}

extern void GLAPIENTRY _mesa_PointParameterfv(GLenum pname, const GLfloat * params);
static void _es_PointParameterfv(GLenum pname, const GLfloat * params)
{
    switch(pname) {
        case GL_POINT_SIZE_MIN: /* size 1 */
        case GL_POINT_SIZE_MAX: /* size 1 */
        case GL_POINT_FADE_THRESHOLD_SIZE: /* size 1 */
        case GL_POINT_DISTANCE_ATTENUATION: /* size 3 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glPointParameterfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_PointParameterfv(pname, params);
}

extern void GLAPIENTRY _mesa_PointParameterf(GLenum pname, GLfloat  param);
static void _es_PointParameterx(GLenum pname, GLfixed param)
{
    GLfloat converted_param; 

    switch(pname) {
        case GL_POINT_SIZE_MIN:
        case GL_POINT_SIZE_MAX:
        case GL_POINT_FADE_THRESHOLD_SIZE:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glPointParameterx(pname=0x%x)", pname);
            return;
    } 

    converted_param = (GLfloat) (param / 65536.0f); 

    _mesa_PointParameterf(pname, converted_param);
}

/* Extension OES_fixed_point */
static void _es_PointParameterxOES(GLenum pname, GLfixed param)
{
    GLfloat converted_param; 

    switch(pname) {
        case GL_POINT_SIZE_MIN:
        case GL_POINT_SIZE_MAX:
        case GL_POINT_FADE_THRESHOLD_SIZE:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glPointParameterx(pname=0x%x)", pname);
            return;
    } 

    converted_param = (GLfloat) (param / 65536.0f); 

    _mesa_PointParameterf(pname, converted_param);
}

extern void GLAPIENTRY _mesa_PointParameterfv(GLenum pname, GLfloat const * params);
static void _es_PointParameterxv(GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 3;
    GLfloat converted_params[3]; 

    switch(pname) {
        case GL_POINT_SIZE_MIN:
        case GL_POINT_SIZE_MAX:
        case GL_POINT_FADE_THRESHOLD_SIZE:
            n_params = 1;
            break;
        case GL_POINT_DISTANCE_ATTENUATION:
            n_params = 3;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glPointParameterxv(pname=0x%x)", pname);
            return;
    } 

    for (i = 0; i < n_params; i++) {
        converted_params[i] = (GLfloat) (params[i] / 65536.0f);
    } 

    _mesa_PointParameterfv(pname, converted_params);
}

/* Extension OES_fixed_point */
static void _es_PointParameterxvOES(GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 3;
    GLfloat converted_params[3]; 

    switch(pname) {
        case GL_POINT_SIZE_MIN:
        case GL_POINT_SIZE_MAX:
        case GL_POINT_FADE_THRESHOLD_SIZE:
            n_params = 1;
            break;
        case GL_POINT_DISTANCE_ATTENUATION:
            n_params = 3;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glPointParameterxv(pname=0x%x)", pname);
            return;
    } 

    for (i = 0; i < n_params; i++) {
        converted_params[i] = (GLfloat) (params[i] / 65536.0f);
    } 

    _mesa_PointParameterfv(pname, converted_params);
}

extern void GLAPIENTRY _mesa_PointSize(GLfloat size);
static void _es_PointSize(GLfloat size)
{
    _mesa_PointSize(size);
}

extern void GLAPIENTRY _mesa_PointSizePointer(GLenum type, GLsizei stride, const GLvoid * pointer);
/* Extension OES_point_size_array */
static void _es_PointSizePointerOES(GLenum type, GLsizei stride, const GLvoid * pointer)
{
    switch(type) {
        case GL_FIXED:
        case GL_FLOAT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glPointSizePointer(type=0x%x)", type);
            return;
    } 

    _mesa_PointSizePointer(type, stride, pointer);
}

extern void GLAPIENTRY _mesa_PointSize(GLfloat  size);
static void _es_PointSizex(GLfixed size)
{
    GLfloat converted_size; 

    converted_size = (GLfloat) (size / 65536.0f); 

    _mesa_PointSize(converted_size);
}

/* Extension OES_fixed_point */
static void _es_PointSizexOES(GLfixed size)
{
    GLfloat converted_size; 

    converted_size = (GLfloat) (size / 65536.0f); 

    _mesa_PointSize(converted_size);
}

extern void GLAPIENTRY _mesa_PolygonOffset(GLfloat factor, GLfloat units);
static void _es_PolygonOffset(GLfloat factor, GLfloat units)
{
    _mesa_PolygonOffset(factor, units);
}

extern void GLAPIENTRY _mesa_PolygonOffset(GLfloat  factor, GLfloat  units);
static void _es_PolygonOffsetx(GLfixed factor, GLfixed units)
{
    GLfloat converted_factor;
    GLfloat converted_units; 

    converted_factor = (GLfloat) (factor / 65536.0f);
    converted_units = (GLfloat) (units / 65536.0f); 

    _mesa_PolygonOffset(converted_factor, converted_units);
}

/* Extension OES_fixed_point */
static void _es_PolygonOffsetxOES(GLfixed factor, GLfixed units)
{
    GLfloat converted_factor;
    GLfloat converted_units; 

    converted_factor = (GLfloat) (factor / 65536.0f);
    converted_units = (GLfloat) (units / 65536.0f); 

    _mesa_PolygonOffset(converted_factor, converted_units);
}

extern void GLAPIENTRY _mesa_PopMatrix();
static void _es_PopMatrix(void)
{
    _mesa_PopMatrix();
}

extern void GLAPIENTRY _mesa_PushMatrix();
static void _es_PushMatrix(void)
{
    _mesa_PushMatrix();
}

/* Extension OES_query_matrix */
/* this function is special and is defined elsewhere */
extern GLbitfield _es_QueryMatrixxOES(GLfixed * mantissa, GLint * exponent);

extern void GLAPIENTRY _mesa_ReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid * pixels);
static void _es_ReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid * pixels)
{
    switch(format) {
        case GL_RGBA:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_4_4_4_4 && type != GL_UNSIGNED_SHORT_5_5_5_1) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glReadPixels(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGB:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_5_6_5) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glReadPixels(format=0x%x)", format);
                return;
            }
            break;
        case GL_LUMINANCE_ALPHA:
        case GL_LUMINANCE:
        case GL_ALPHA:
            if (format != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glReadPixels(format=0x%x)", format);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glReadPixels(format=0x%x)", format);
            return;
    } 

    _mesa_ReadPixels(x, y, width, height, format, type, pixels);
}

extern void GLAPIENTRY _mesa_RenderbufferStorageEXT(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height);
/* Extension OES_framebuffer_object */
static void _es_RenderbufferStorageOES(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height)
{
    switch(target) {
        case GL_RENDERBUFFER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glRenderbufferStorage(target=0x%x)", target);
            return;
    }
    switch(internalFormat) {
        case GL_DEPTH_COMPONENT16_OES:
        case GL_RGBA4_OES:
        case GL_RGB5_A1_OES:
        case GL_RGB565_OES:
        case GL_DEPTH_COMPONENT24_OES:
        case GL_DEPTH_COMPONENT32_OES:
        case GL_RGB8_OES:
        case GL_RGBA8_OES:
        case GL_STENCIL_INDEX1_OES:
        case GL_STENCIL_INDEX4_OES:
        case GL_STENCIL_INDEX8_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glRenderbufferStorage(internalFormat=0x%x)", internalFormat);
            return;
    } 

    _mesa_RenderbufferStorageEXT(target, internalFormat, width, height);
}

extern void GLAPIENTRY _mesa_Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
static void _es_Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    _mesa_Rotatef(angle, x, y, z);
}

extern void GLAPIENTRY _mesa_Rotatef(GLfloat  angle, GLfloat  x, GLfloat  y, GLfloat  z);
static void _es_Rotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z)
{
    GLfloat converted_angle;
    GLfloat converted_x;
    GLfloat converted_y;
    GLfloat converted_z; 

    converted_angle = (GLfloat) (angle / 65536.0f);
    converted_x = (GLfloat) (x / 65536.0f);
    converted_y = (GLfloat) (y / 65536.0f);
    converted_z = (GLfloat) (z / 65536.0f); 

    _mesa_Rotatef(converted_angle, converted_x, converted_y, converted_z);
}

/* Extension OES_fixed_point */
static void _es_RotatexOES(GLfixed angle, GLfixed x, GLfixed y, GLfixed z)
{
    GLfloat converted_angle;
    GLfloat converted_x;
    GLfloat converted_y;
    GLfloat converted_z; 

    converted_angle = (GLfloat) (angle / 65536.0f);
    converted_x = (GLfloat) (x / 65536.0f);
    converted_y = (GLfloat) (y / 65536.0f);
    converted_z = (GLfloat) (z / 65536.0f); 

    _mesa_Rotatef(converted_angle, converted_x, converted_y, converted_z);
}

extern void GLAPIENTRY _mesa_SampleCoverageARB(GLclampf value, GLboolean invert);
static void _es_SampleCoverage(GLclampf value, GLboolean invert)
{
    _mesa_SampleCoverageARB(value, invert);
}

extern void GLAPIENTRY _mesa_SampleCoverageARB(GLclampf  value, GLboolean invert);
static void _es_SampleCoveragex(GLclampx value, GLboolean invert)
{
    GLclampf converted_value; 

    converted_value = (GLclampf) (value / 65536.0f); 

    _mesa_SampleCoverageARB(converted_value, invert);
}

/* Extension OES_fixed_point */
static void _es_SampleCoveragexOES(GLclampx value, GLboolean invert)
{
    GLclampf converted_value; 

    converted_value = (GLclampf) (value / 65536.0f); 

    _mesa_SampleCoverageARB(converted_value, invert);
}

extern void GLAPIENTRY _mesa_Scalef(GLfloat x, GLfloat y, GLfloat z);
static void _es_Scalef(GLfloat x, GLfloat y, GLfloat z)
{
    _mesa_Scalef(x, y, z);
}

extern void GLAPIENTRY _mesa_Scalef(GLfloat  x, GLfloat  y, GLfloat  z);
static void _es_Scalex(GLfixed x, GLfixed y, GLfixed z)
{
    GLfloat converted_x;
    GLfloat converted_y;
    GLfloat converted_z; 

    converted_x = (GLfloat) (x / 65536.0f);
    converted_y = (GLfloat) (y / 65536.0f);
    converted_z = (GLfloat) (z / 65536.0f); 

    _mesa_Scalef(converted_x, converted_y, converted_z);
}

/* Extension OES_fixed_point */
static void _es_ScalexOES(GLfixed x, GLfixed y, GLfixed z)
{
    GLfloat converted_x;
    GLfloat converted_y;
    GLfloat converted_z; 

    converted_x = (GLfloat) (x / 65536.0f);
    converted_y = (GLfloat) (y / 65536.0f);
    converted_z = (GLfloat) (z / 65536.0f); 

    _mesa_Scalef(converted_x, converted_y, converted_z);
}

extern void GLAPIENTRY _mesa_Scissor(GLint x, GLint y, GLsizei width, GLsizei height);
static void _es_Scissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    _mesa_Scissor(x, y, width, height);
}

extern void GLAPIENTRY _mesa_ShadeModel(GLenum mode);
static void _es_ShadeModel(GLenum mode)
{
    switch(mode) {
        case GL_FLAT:
        case GL_SMOOTH:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glShadeModel(mode=0x%x)", mode);
            return;
    } 

    _mesa_ShadeModel(mode);
}

extern void GLAPIENTRY _mesa_StencilFunc(GLenum func, GLint ref, GLuint mask);
static void _es_StencilFunc(GLenum func, GLint ref, GLuint mask)
{
    switch(func) {
        case GL_NEVER:
        case GL_LESS:
        case GL_LEQUAL:
        case GL_GREATER:
        case GL_GEQUAL:
        case GL_EQUAL:
        case GL_NOTEQUAL:
        case GL_ALWAYS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilFunc(func=0x%x)", func);
            return;
    } 

    _mesa_StencilFunc(func, ref, mask);
}

extern void GLAPIENTRY _mesa_StencilMask(GLuint mask);
static void _es_StencilMask(GLuint mask)
{
    _mesa_StencilMask(mask);
}

extern void GLAPIENTRY _mesa_StencilOp(GLenum fail, GLenum zfail, GLenum zpass);
static void _es_StencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
    switch(fail) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP_OES:
        case GL_DECR_WRAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOp(fail=0x%x)", fail);
            return;
    }
    switch(zfail) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP_OES:
        case GL_DECR_WRAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOp(zfail=0x%x)", zfail);
            return;
    }
    switch(zpass) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP_OES:
        case GL_DECR_WRAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOp(zpass=0x%x)", zpass);
            return;
    } 

    _mesa_StencilOp(fail, zfail, zpass);
}

extern void GLAPIENTRY _mesa_TexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer);
static void _es_TexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)
{
    switch(size) {
        case 2:
        case 3:
        case 4:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexCoordPointer(size=%d)", size);
            return;
    }
    switch(type) {
        case GL_BYTE:
        case GL_SHORT:
        case GL_FIXED:
        case GL_FLOAT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexCoordPointer(type=0x%x)", type);
            return;
    } 

    _mesa_TexCoordPointer(size, type, stride, pointer);
}

extern void GLAPIENTRY _mesa_TexEnvf(GLenum target, GLenum pname, GLfloat param);
static void _es_TexEnvf(GLenum target, GLenum pname, GLfloat param)
{
    switch(target) {
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(target=0x%x)", target);
                return;
            }
            break;
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_ENV_MODE:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_DECAL && param != GL_BLEND && param != GL_ADD && param != GL_COMBINE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_COMBINE_RGB:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_ADD && param != GL_ADD_SIGNED && param != GL_INTERPOLATE && param != GL_SUBTRACT && param != GL_DOT3_RGB && param != GL_DOT3_RGBA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_COMBINE_ALPHA:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_ADD && param != GL_ADD_SIGNED && param != GL_INTERPOLATE && param != GL_SUBTRACT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_RGB_SCALE:
        case GL_ALPHA_SCALE:
            if (param != 1.0 && param != 2.0 && param != 4.0) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC0_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND0_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC0_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND0_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC1_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND1_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC1_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND1_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC2_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND2_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC2_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND2_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_COORD_REPLACE_OES:
            if (param != GL_TRUE && param != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvf(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexEnvf(target, pname, param);
}

extern void GLAPIENTRY _mesa_TexEnvfv(GLenum target, GLenum pname, const GLfloat * params);
static void _es_TexEnvfv(GLenum target, GLenum pname, const GLfloat * params)
{
    switch(target) {
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(target=0x%x)", target);
                return;
            }
            break;
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_TEXTURE_ENV_COLOR && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_COORD_REPLACE_OES: /* size 1 */
            if (params[0] != GL_TRUE && params[0] != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_ENV_MODE: /* size 1 */
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_DECAL && params[0] != GL_BLEND && params[0] != GL_ADD && params[0] != GL_COMBINE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_COMBINE_RGB: /* size 1 */
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_ADD && params[0] != GL_ADD_SIGNED && params[0] != GL_INTERPOLATE && params[0] != GL_SUBTRACT && params[0] != GL_DOT3_RGB && params[0] != GL_DOT3_RGBA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_COMBINE_ALPHA: /* size 1 */
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_ADD && params[0] != GL_ADD_SIGNED && params[0] != GL_INTERPOLATE && params[0] != GL_SUBTRACT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC0_RGB: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND0_RGB: /* size 1 */
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC0_ALPHA: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND0_ALPHA: /* size 1 */
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC1_RGB: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND1_RGB: /* size 1 */
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC1_ALPHA: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND1_ALPHA: /* size 1 */
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC2_RGB: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND2_RGB: /* size 1 */
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC2_ALPHA: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND2_ALPHA: /* size 1 */
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_RGB_SCALE: /* size 1 */
        case GL_ALPHA_SCALE: /* size 1 */
            if (params[0] != 1.0 && params[0] != 2.0 && params[0] != 4.0) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexEnvfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_ENV_COLOR: /* size 4 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexEnvfv(target, pname, params);
}

extern void GLAPIENTRY _mesa_TexEnvi(GLenum target, GLenum pname, GLint param);
static void _es_TexEnvi(GLenum target, GLenum pname, GLint param)
{
    switch(target) {
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(target=0x%x)", target);
                return;
            }
            break;
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_COORD_REPLACE_OES:
            if (param != GL_TRUE && param != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_ENV_MODE:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_DECAL && param != GL_BLEND && param != GL_ADD && param != GL_COMBINE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_COMBINE_RGB:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_ADD && param != GL_ADD_SIGNED && param != GL_INTERPOLATE && param != GL_SUBTRACT && param != GL_DOT3_RGB && param != GL_DOT3_RGBA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_COMBINE_ALPHA:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_ADD && param != GL_ADD_SIGNED && param != GL_INTERPOLATE && param != GL_SUBTRACT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_RGB_SCALE:
        case GL_ALPHA_SCALE:
            if (param != 1.0 && param != 2.0 && param != 4.0) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC0_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND0_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC0_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND0_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC1_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND1_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC1_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND1_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC2_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND2_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC2_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND2_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvi(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexEnvi(target, pname, param);
}

extern void GLAPIENTRY _mesa_TexEnviv(GLenum target, GLenum pname, const GLint * params);
static void _es_TexEnviv(GLenum target, GLenum pname, const GLint * params)
{
    switch(target) {
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(target=0x%x)", target);
                return;
            }
            break;
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_TEXTURE_ENV_COLOR && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_COORD_REPLACE_OES: /* size 1 */
            if (params[0] != GL_TRUE && params[0] != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_ENV_MODE: /* size 1 */
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_DECAL && params[0] != GL_BLEND && params[0] != GL_ADD && params[0] != GL_COMBINE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_COMBINE_RGB: /* size 1 */
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_ADD && params[0] != GL_ADD_SIGNED && params[0] != GL_INTERPOLATE && params[0] != GL_SUBTRACT && params[0] != GL_DOT3_RGB && params[0] != GL_DOT3_RGBA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_COMBINE_ALPHA: /* size 1 */
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_ADD && params[0] != GL_ADD_SIGNED && params[0] != GL_INTERPOLATE && params[0] != GL_SUBTRACT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC0_RGB: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND0_RGB: /* size 1 */
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC0_ALPHA: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND0_ALPHA: /* size 1 */
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC1_RGB: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND1_RGB: /* size 1 */
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC1_ALPHA: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND1_ALPHA: /* size 1 */
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC2_RGB: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND2_RGB: /* size 1 */
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC2_ALPHA: /* size 1 */
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_OPERAND2_ALPHA: /* size 1 */
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_RGB_SCALE: /* size 1 */
        case GL_ALPHA_SCALE: /* size 1 */
            if (params[0] != 1.0 && params[0] != 2.0 && params[0] != 4.0) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexEnviv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_ENV_COLOR: /* size 4 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnviv(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexEnviv(target, pname, params);
}

extern void GLAPIENTRY _mesa_TexEnvf(GLenum target, GLenum pname, GLfloat  param);
static void _es_TexEnvx(GLenum target, GLenum pname, GLfixed param)
{
    GLfloat converted_param;
    int convert_param_value = 1; 

    switch(target) {
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(target=0x%x)", target);
                return;
            }
            break;
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_COORD_REPLACE_OES:
            if (param != GL_TRUE && param != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_TEXTURE_ENV_MODE:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_DECAL && param != GL_BLEND && param != GL_ADD && param != GL_COMBINE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_COMBINE_RGB:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_ADD && param != GL_ADD_SIGNED && param != GL_INTERPOLATE && param != GL_SUBTRACT && param != GL_DOT3_RGB && param != GL_DOT3_RGBA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_COMBINE_ALPHA:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_ADD && param != GL_ADD_SIGNED && param != GL_INTERPOLATE && param != GL_SUBTRACT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_RGB_SCALE:
        case GL_ALPHA_SCALE:
            if (param != 1.0 && param != 2.0 && param != 4.0) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC0_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND0_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_SRC0_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND0_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_SRC1_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND1_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_SRC1_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND1_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_SRC2_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND2_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_SRC2_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND2_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
            return;
    } 

    if (convert_param_value) {
        converted_param = (GLfloat) (param / 65536.0f);
    } else {
        converted_param = (GLfloat) param;
    } 

    _mesa_TexEnvf(target, pname, converted_param);
}

/* Extension OES_fixed_point */
static void _es_TexEnvxOES(GLenum target, GLenum pname, GLfixed param)
{
    GLfloat converted_param;
    int convert_param_value = 1; 

    switch(target) {
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(target=0x%x)", target);
                return;
            }
            break;
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_COORD_REPLACE_OES:
            if (param != GL_TRUE && param != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_TEXTURE_ENV_MODE:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_DECAL && param != GL_BLEND && param != GL_ADD && param != GL_COMBINE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_COMBINE_RGB:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_ADD && param != GL_ADD_SIGNED && param != GL_INTERPOLATE && param != GL_SUBTRACT && param != GL_DOT3_RGB && param != GL_DOT3_RGBA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_COMBINE_ALPHA:
            if (param != GL_REPLACE && param != GL_MODULATE && param != GL_ADD && param != GL_ADD_SIGNED && param != GL_INTERPOLATE && param != GL_SUBTRACT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_RGB_SCALE:
        case GL_ALPHA_SCALE:
            if (param != 1.0 && param != 2.0 && param != 4.0) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_SRC0_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND0_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_SRC0_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND0_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_SRC1_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND1_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_SRC1_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND1_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_SRC2_RGB:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND2_RGB:
            if (param != GL_SRC_COLOR && param != GL_ONE_MINUS_SRC_COLOR && param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_SRC2_ALPHA:
            if (param != GL_TEXTURE && param != GL_CONSTANT && param != GL_PRIMARY_COLOR && param != GL_PREVIOUS && param != GL_TEXTURE0 && param != GL_TEXTURE1 && param != GL_TEXTURE2 && param != GL_TEXTURE3 && param != GL_TEXTURE4 && param != GL_TEXTURE5 && param != GL_TEXTURE6 && param != GL_TEXTURE7 && param != GL_TEXTURE8 && param != GL_TEXTURE9 && param != GL_TEXTURE10 && param != GL_TEXTURE11 && param != GL_TEXTURE12 && param != GL_TEXTURE13 && param != GL_TEXTURE14 && param != GL_TEXTURE15 && param != GL_TEXTURE16 && param != GL_TEXTURE17 && param != GL_TEXTURE18 && param != GL_TEXTURE19 && param != GL_TEXTURE20 && param != GL_TEXTURE21 && param != GL_TEXTURE22 && param != GL_TEXTURE23 && param != GL_TEXTURE24 && param != GL_TEXTURE25 && param != GL_TEXTURE26 && param != GL_TEXTURE27 && param != GL_TEXTURE28 && param != GL_TEXTURE29 && param != GL_TEXTURE30 && param != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_OPERAND2_ALPHA:
            if (param != GL_SRC_ALPHA && param != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvx(pname=0x%x)", pname);
            return;
    } 

    if (convert_param_value) {
        converted_param = (GLfloat) (param / 65536.0f);
    } else {
        converted_param = (GLfloat) param;
    } 

    _mesa_TexEnvf(target, pname, converted_param);
}

extern void GLAPIENTRY _mesa_TexEnvfv(GLenum target, GLenum pname, GLfloat const * params);
static void _es_TexEnvxv(GLenum target, GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4];
    int convert_params_value = 1; 

    switch(target) {
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(target=0x%x)", target);
                return;
            }
            break;
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_TEXTURE_ENV_COLOR && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_COORD_REPLACE_OES:
            if (params[0] != GL_TRUE && params[0] != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_ENV_MODE:
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_DECAL && params[0] != GL_BLEND && params[0] != GL_ADD && params[0] != GL_COMBINE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_COMBINE_RGB:
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_ADD && params[0] != GL_ADD_SIGNED && params[0] != GL_INTERPOLATE && params[0] != GL_SUBTRACT && params[0] != GL_DOT3_RGB && params[0] != GL_DOT3_RGBA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_COMBINE_ALPHA:
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_ADD && params[0] != GL_ADD_SIGNED && params[0] != GL_INTERPOLATE && params[0] != GL_SUBTRACT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC0_RGB:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND0_RGB:
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC0_ALPHA:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND0_ALPHA:
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC1_RGB:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND1_RGB:
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC1_ALPHA:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND1_ALPHA:
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC2_RGB:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND2_RGB:
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC2_ALPHA:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND2_ALPHA:
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_RGB_SCALE:
        case GL_ALPHA_SCALE:
            if (params[0] != 1.0 && params[0] != 2.0 && params[0] != 4.0) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            n_params = 1;
            break;
        case GL_TEXTURE_ENV_COLOR:
            n_params = 4;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
            return;
    } 

    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) (params[i] / 65536.0f);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) params[i];
        }
    } 

    _mesa_TexEnvfv(target, pname, converted_params);
}

/* Extension OES_fixed_point */
static void _es_TexEnvxvOES(GLenum target, GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4];
    int convert_params_value = 1; 

    switch(target) {
        case GL_POINT_SPRITE_OES:
            if (pname != GL_COORD_REPLACE_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(target=0x%x)", target);
                return;
            }
            break;
        case GL_TEXTURE_ENV:
            if (pname != GL_TEXTURE_ENV_MODE && pname != GL_TEXTURE_ENV_COLOR && pname != GL_COMBINE_RGB && pname != GL_COMBINE_ALPHA && pname != GL_RGB_SCALE && pname != GL_ALPHA_SCALE && pname != GL_SRC0_RGB && pname != GL_OPERAND0_RGB && pname != GL_SRC0_ALPHA && pname != GL_OPERAND0_ALPHA && pname != GL_SRC1_RGB && pname != GL_OPERAND1_RGB && pname != GL_SRC1_ALPHA && pname != GL_OPERAND1_ALPHA && pname != GL_SRC2_RGB && pname != GL_OPERAND2_RGB && pname != GL_SRC2_ALPHA && pname != GL_OPERAND2_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(target=0x%x)", target);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_COORD_REPLACE_OES:
            if (params[0] != GL_TRUE && params[0] != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_ENV_MODE:
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_DECAL && params[0] != GL_BLEND && params[0] != GL_ADD && params[0] != GL_COMBINE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_COMBINE_RGB:
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_ADD && params[0] != GL_ADD_SIGNED && params[0] != GL_INTERPOLATE && params[0] != GL_SUBTRACT && params[0] != GL_DOT3_RGB && params[0] != GL_DOT3_RGBA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_COMBINE_ALPHA:
            if (params[0] != GL_REPLACE && params[0] != GL_MODULATE && params[0] != GL_ADD && params[0] != GL_ADD_SIGNED && params[0] != GL_INTERPOLATE && params[0] != GL_SUBTRACT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC0_RGB:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND0_RGB:
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC0_ALPHA:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND0_ALPHA:
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC1_RGB:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND1_RGB:
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC1_ALPHA:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND1_ALPHA:
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC2_RGB:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND2_RGB:
            if (params[0] != GL_SRC_COLOR && params[0] != GL_ONE_MINUS_SRC_COLOR && params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_SRC2_ALPHA:
            if (params[0] != GL_TEXTURE && params[0] != GL_CONSTANT && params[0] != GL_PRIMARY_COLOR && params[0] != GL_PREVIOUS && params[0] != GL_TEXTURE0 && params[0] != GL_TEXTURE1 && params[0] != GL_TEXTURE2 && params[0] != GL_TEXTURE3 && params[0] != GL_TEXTURE4 && params[0] != GL_TEXTURE5 && params[0] != GL_TEXTURE6 && params[0] != GL_TEXTURE7 && params[0] != GL_TEXTURE8 && params[0] != GL_TEXTURE9 && params[0] != GL_TEXTURE10 && params[0] != GL_TEXTURE11 && params[0] != GL_TEXTURE12 && params[0] != GL_TEXTURE13 && params[0] != GL_TEXTURE14 && params[0] != GL_TEXTURE15 && params[0] != GL_TEXTURE16 && params[0] != GL_TEXTURE17 && params[0] != GL_TEXTURE18 && params[0] != GL_TEXTURE19 && params[0] != GL_TEXTURE20 && params[0] != GL_TEXTURE21 && params[0] != GL_TEXTURE22 && params[0] != GL_TEXTURE23 && params[0] != GL_TEXTURE24 && params[0] != GL_TEXTURE25 && params[0] != GL_TEXTURE26 && params[0] != GL_TEXTURE27 && params[0] != GL_TEXTURE28 && params[0] != GL_TEXTURE29 && params[0] != GL_TEXTURE30 && params[0] != GL_TEXTURE31) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_OPERAND2_ALPHA:
            if (params[0] != GL_SRC_ALPHA && params[0] != GL_ONE_MINUS_SRC_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_RGB_SCALE:
        case GL_ALPHA_SCALE:
            if (params[0] != 1.0 && params[0] != 2.0 && params[0] != 4.0) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexEnvxv(pname=0x%x)", pname);
                return;
            }
            n_params = 1;
            break;
        case GL_TEXTURE_ENV_COLOR:
            n_params = 4;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexEnvxv(pname=0x%x)", pname);
            return;
    } 

    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) (params[i] / 65536.0f);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) params[i];
        }
    } 

    _mesa_TexEnvfv(target, pname, converted_params);
}

extern void GLAPIENTRY _mesa_TexGenf(GLenum coord, GLenum pname, GLfloat param);
/* Extension OES_texture_cube_map */
static void _es_TexGenfOES(GLenum coord, GLenum pname, GLfloat param)
{
    switch(coord) {
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenf(coord=0x%x)", coord);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_GEN_MODE_OES:
            if (param != GL_NORMAL_MAP_OES && param != GL_REFLECTION_MAP_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenf(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenf(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexGenf(coord, pname, param);
}

extern void GLAPIENTRY _mesa_TexGenfv(GLenum coord, GLenum pname, const GLfloat * params);
/* Extension OES_texture_cube_map */
static void _es_TexGenfvOES(GLenum coord, GLenum pname, const GLfloat * params)
{
    switch(coord) {
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenfv(coord=0x%x)", coord);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_GEN_MODE_OES: /* size 1 */
            if (params[0] != GL_NORMAL_MAP_OES && params[0] != GL_REFLECTION_MAP_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenfv(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexGenfv(coord, pname, params);
}

extern void GLAPIENTRY _mesa_TexGeni(GLenum coord, GLenum pname, GLint param);
/* Extension OES_texture_cube_map */
static void _es_TexGeniOES(GLenum coord, GLenum pname, GLint param)
{
    switch(coord) {
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGeni(coord=0x%x)", coord);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_GEN_MODE_OES:
            if (param != GL_NORMAL_MAP_OES && param != GL_REFLECTION_MAP_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGeni(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGeni(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexGeni(coord, pname, param);
}

extern void GLAPIENTRY _mesa_TexGeniv(GLenum coord, GLenum pname, const GLint * params);
/* Extension OES_texture_cube_map */
static void _es_TexGenivOES(GLenum coord, GLenum pname, const GLint * params)
{
    switch(coord) {
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGeniv(coord=0x%x)", coord);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_GEN_MODE_OES: /* size 1 */
            if (params[0] != GL_NORMAL_MAP_OES && params[0] != GL_REFLECTION_MAP_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGeniv(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGeniv(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexGeniv(coord, pname, params);
}

extern void GLAPIENTRY _mesa_TexGenf(GLenum coord, GLenum pname, GLfloat  param);
/* Extension OES_texture_cube_map */
static void _es_TexGenxOES(GLenum coord, GLenum pname, GLfixed param)
{
    GLfloat converted_param; 

    switch(coord) {
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenx(coord=0x%x)", coord);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_GEN_MODE_OES:
            if (param != GL_NORMAL_MAP_OES && param != GL_REFLECTION_MAP_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenx(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenx(pname=0x%x)", pname);
            return;
    } 

    converted_param = (GLfloat) param; 

    _mesa_TexGenf(coord, pname, converted_param);
}

extern void GLAPIENTRY _mesa_TexGenfv(GLenum coord, GLenum pname, GLfloat const * params);
/* Extension OES_texture_cube_map */
static void _es_TexGenxvOES(GLenum coord, GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 1;
    GLfloat converted_params[1]; 

    switch(coord) {
        case GL_TEXTURE_GEN_STR_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenxv(coord=0x%x)", coord);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_GEN_MODE_OES:
            if (params[0] != GL_NORMAL_MAP_OES && params[0] != GL_REFLECTION_MAP_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenxv(pname=0x%x)", pname);
                return;
            }
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexGenxv(pname=0x%x)", pname);
            return;
    } 

    for (i = 0; i < n_params; i++) {
        converted_params[i] = (GLfloat) params[i];
    } 

    _mesa_TexGenfv(coord, pname, converted_params);
}

extern void GLAPIENTRY _mesa_TexImage2D(GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels);
static void _es_TexImage2D(GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage2D(target=0x%x)", target);
            return;
    }
    switch(internalFormat) {
        case GL_ALPHA:
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
        case GL_RGB:
        case GL_RGBA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(internalFormat=%d)", internalFormat);
            return;
    }
    switch(border) {
        case 0:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(border=%d)", border);
            return;
    } 

    _mesa_TexImage2D(target, level, internalFormat, width, height, border, format, type, pixels);
}

extern void GLAPIENTRY _mesa_TexParameterf(GLenum target, GLenum pname, GLfloat param);
static void _es_TexParameterf(GLenum target, GLenum pname, GLfloat param)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
            if (param != GL_CLAMP_TO_EDGE && param != GL_REPEAT && param != GL_MIRRORED_REPEAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR && param != GL_NEAREST_MIPMAP_NEAREST && param != GL_NEAREST_MIPMAP_LINEAR && param != GL_LINEAR_MIPMAP_NEAREST && param != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_GENERATE_MIPMAP:
            if (param != GL_TRUE && param != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexParameterf(target, pname, param);
}

extern void GLAPIENTRY _mesa_TexParameterfv(GLenum target, GLenum pname, const GLfloat * params);
static void _es_TexParameterfv(GLenum target, GLenum pname, const GLfloat * params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
            if (params[0] != GL_CLAMP_TO_EDGE && params[0] != GL_REPEAT && params[0] != GL_MIRRORED_REPEAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR && params[0] != GL_NEAREST_MIPMAP_NEAREST && params[0] != GL_NEAREST_MIPMAP_LINEAR && params[0] != GL_LINEAR_MIPMAP_NEAREST && params[0] != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_GENERATE_MIPMAP: /* size 1 */
            if (params[0] != GL_TRUE && params[0] != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexParameterfv(target, pname, params);
}

extern void GLAPIENTRY _mesa_TexParameteri(GLenum target, GLenum pname, GLint param);
static void _es_TexParameteri(GLenum target, GLenum pname, GLint param)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
            if (param != GL_CLAMP_TO_EDGE && param != GL_REPEAT && param != GL_MIRRORED_REPEAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR && param != GL_NEAREST_MIPMAP_NEAREST && param != GL_NEAREST_MIPMAP_LINEAR && param != GL_LINEAR_MIPMAP_NEAREST && param != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_GENERATE_MIPMAP:
            if (param != GL_TRUE && param != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexParameteri(target, pname, param);
}

extern void GLAPIENTRY _mesa_TexParameteriv(GLenum target, GLenum pname, const GLint * params);
static void _es_TexParameteriv(GLenum target, GLenum pname, const GLint * params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
            if (params[0] != GL_CLAMP_TO_EDGE && params[0] != GL_REPEAT && params[0] != GL_MIRRORED_REPEAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR && params[0] != GL_NEAREST_MIPMAP_NEAREST && params[0] != GL_NEAREST_MIPMAP_LINEAR && params[0] != GL_LINEAR_MIPMAP_NEAREST && params[0] != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_GENERATE_MIPMAP: /* size 1 */
            if (params[0] != GL_TRUE && params[0] != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT: /* size 1 */
        case GL_TEXTURE_CROP_RECT_OES: /* size 4 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexParameteriv(target, pname, params);
}

extern void GLAPIENTRY _mesa_TexParameterf(GLenum target, GLenum pname, GLfloat  param);
static void _es_TexParameterx(GLenum target, GLenum pname, GLfixed param)
{
    GLfloat converted_param;
    int convert_param_value = 1; 

    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
            if (param != GL_CLAMP_TO_EDGE && param != GL_REPEAT && param != GL_MIRRORED_REPEAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_TEXTURE_MIN_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR && param != GL_NEAREST_MIPMAP_NEAREST && param != GL_NEAREST_MIPMAP_LINEAR && param != GL_LINEAR_MIPMAP_NEAREST && param != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_TEXTURE_MAG_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_GENERATE_MIPMAP:
            if (param != GL_TRUE && param != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(pname=0x%x)", pname);
            return;
    } 

    if (convert_param_value) {
        converted_param = (GLfloat) (param / 65536.0f);
    } else {
        converted_param = (GLfloat) param;
    } 

    _mesa_TexParameterf(target, pname, converted_param);
}

/* Extension OES_fixed_point */
static void _es_TexParameterxOES(GLenum target, GLenum pname, GLfixed param)
{
    GLfloat converted_param;
    int convert_param_value = 1; 

    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
            if (param != GL_CLAMP_TO_EDGE && param != GL_REPEAT && param != GL_MIRRORED_REPEAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_TEXTURE_MIN_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR && param != GL_NEAREST_MIPMAP_NEAREST && param != GL_NEAREST_MIPMAP_LINEAR && param != GL_LINEAR_MIPMAP_NEAREST && param != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_TEXTURE_MAG_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_GENERATE_MIPMAP:
            if (param != GL_TRUE && param != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(pname=0x%x)", pname);
                return;
            }
            convert_param_value = 0;
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterx(pname=0x%x)", pname);
            return;
    } 

    if (convert_param_value) {
        converted_param = (GLfloat) (param / 65536.0f);
    } else {
        converted_param = (GLfloat) param;
    } 

    _mesa_TexParameterf(target, pname, converted_param);
}

extern void GLAPIENTRY _mesa_TexParameterfv(GLenum target, GLenum pname, GLfloat const * params);
static void _es_TexParameterxv(GLenum target, GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4];
    int convert_params_value = 1; 

    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
            if (params[0] != GL_CLAMP_TO_EDGE && params[0] != GL_REPEAT && params[0] != GL_MIRRORED_REPEAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_MIN_FILTER:
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR && params[0] != GL_NEAREST_MIPMAP_NEAREST && params[0] != GL_NEAREST_MIPMAP_LINEAR && params[0] != GL_LINEAR_MIPMAP_NEAREST && params[0] != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_MAG_FILTER:
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_GENERATE_MIPMAP:
            if (params[0] != GL_TRUE && params[0] != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_CROP_RECT_OES:
            n_params = 4;
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT:
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(pname=0x%x)", pname);
            return;
    } 

    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) (params[i] / 65536.0f);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) params[i];
        }
    } 

    _mesa_TexParameterfv(target, pname, converted_params);
}

/* Extension OES_fixed_point */
static void _es_TexParameterxvOES(GLenum target, GLenum pname, const GLfixed * params)
{
    register unsigned int i;
    unsigned int n_params = 4;
    GLfloat converted_params[4];
    int convert_params_value = 1; 

    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
            if (params[0] != GL_CLAMP_TO_EDGE && params[0] != GL_REPEAT && params[0] != GL_MIRRORED_REPEAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_MIN_FILTER:
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR && params[0] != GL_NEAREST_MIPMAP_NEAREST && params[0] != GL_NEAREST_MIPMAP_LINEAR && params[0] != GL_LINEAR_MIPMAP_NEAREST && params[0] != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_MAG_FILTER:
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_GENERATE_MIPMAP:
            if (params[0] != GL_TRUE && params[0] != GL_FALSE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(pname=0x%x)", pname);
                return;
            }
            convert_params_value = 0;
            n_params = 1;
            break;
        case GL_TEXTURE_CROP_RECT_OES:
            n_params = 4;
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT:
            n_params = 1;
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterxv(pname=0x%x)", pname);
            return;
    } 

    if (convert_params_value) {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) (params[i] / 65536.0f);
        }
    } else {
        for (i = 0; i < n_params; i++) {
            converted_params[i] = (GLfloat) params[i];
        }
    } 

    _mesa_TexParameterfv(target, pname, converted_params);
}

extern void GLAPIENTRY _mesa_TexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels);
static void _es_TexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexSubImage2D(target=0x%x)", target);
            return;
    }
    switch(format) {
        case GL_ALPHA:
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
            if (type != GL_UNSIGNED_BYTE && type != GL_FLOAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGB:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_5_6_5 && type != GL_FLOAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGBA:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_4_4_4_4 && type != GL_UNSIGNED_SHORT_5_5_5_1 && type != GL_FLOAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexSubImage2D(format=0x%x)", format);
            return;
    } 

    _mesa_TexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

extern void GLAPIENTRY _mesa_Translatef(GLfloat x, GLfloat y, GLfloat z);
static void _es_Translatef(GLfloat x, GLfloat y, GLfloat z)
{
    _mesa_Translatef(x, y, z);
}

extern void GLAPIENTRY _mesa_Translatef(GLfloat  x, GLfloat  y, GLfloat  z);
static void _es_Translatex(GLfixed x, GLfixed y, GLfixed z)
{
    GLfloat converted_x;
    GLfloat converted_y;
    GLfloat converted_z; 

    converted_x = (GLfloat) (x / 65536.0f);
    converted_y = (GLfloat) (y / 65536.0f);
    converted_z = (GLfloat) (z / 65536.0f); 

    _mesa_Translatef(converted_x, converted_y, converted_z);
}

/* Extension OES_fixed_point */
static void _es_TranslatexOES(GLfixed x, GLfixed y, GLfixed z)
{
    GLfloat converted_x;
    GLfloat converted_y;
    GLfloat converted_z; 

    converted_x = (GLfloat) (x / 65536.0f);
    converted_y = (GLfloat) (y / 65536.0f);
    converted_z = (GLfloat) (z / 65536.0f); 

    _mesa_Translatef(converted_x, converted_y, converted_z);
}

extern GLboolean GLAPIENTRY _mesa_UnmapBufferARB(GLenum target);
/* Extension OES_mapbuffer */
static GLboolean _es_UnmapBufferOES(GLenum target)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glUnmapBuffer(target=0x%x)", target);
            return GL_FALSE;
    } 

    return _mesa_UnmapBufferARB(target);
}

extern void GLAPIENTRY _mesa_VertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer);
static void _es_VertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)
{
    switch(size) {
        case 2:
        case 3:
        case 4:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glVertexPointer(size=%d)", size);
            return;
    }
    switch(type) {
        case GL_BYTE:
        case GL_SHORT:
        case GL_FIXED:
        case GL_FLOAT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glVertexPointer(type=0x%x)", type);
            return;
    } 

    _mesa_VertexPointer(size, type, stride, pointer);
}

extern void GLAPIENTRY _mesa_Viewport(GLint x, GLint y, GLsizei width, GLsizei height);
static void _es_Viewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    _mesa_Viewport(x, y, width, height);
}

void
_mesa_init_exec_table(struct _glapi_table *exec)
{
    SET_ActiveTexture(exec, _es_ActiveTexture);
    SET_AlphaFunc(exec, _es_AlphaFunc);
    SET_AlphaFuncx(exec, _es_AlphaFuncx);
    SET_AlphaFuncxOES(exec, _es_AlphaFuncxOES);
    SET_BindBuffer(exec, _es_BindBuffer);
    SET_BindFramebufferOES(exec, _es_BindFramebufferOES);
    SET_BindRenderbufferOES(exec, _es_BindRenderbufferOES);
    SET_BindTexture(exec, _es_BindTexture);
    SET_BlendEquationOES(exec, _es_BlendEquationOES);
    SET_BlendEquationSeparateOES(exec, _es_BlendEquationSeparateOES);
    SET_BlendFunc(exec, _es_BlendFunc);
    SET_BlendFuncSeparateOES(exec, _es_BlendFuncSeparateOES);
    SET_BufferData(exec, _es_BufferData);
    SET_BufferSubData(exec, _es_BufferSubData);
    SET_CheckFramebufferStatusOES(exec, _es_CheckFramebufferStatusOES);
    SET_Clear(exec, _es_Clear);
    SET_ClearColor(exec, _es_ClearColor);
    SET_ClearColorx(exec, _es_ClearColorx);
    SET_ClearColorxOES(exec, _es_ClearColorxOES);
    SET_ClearDepthf(exec, _es_ClearDepthf);
    SET_ClearDepthfOES(exec, _es_ClearDepthfOES);
    SET_ClearDepthx(exec, _es_ClearDepthx);
    SET_ClearDepthxOES(exec, _es_ClearDepthxOES);
    SET_ClearStencil(exec, _es_ClearStencil);
    SET_ClientActiveTexture(exec, _es_ClientActiveTexture);
    SET_ClipPlanef(exec, _es_ClipPlanef);
    SET_ClipPlanefOES(exec, _es_ClipPlanefOES);
    SET_ClipPlanex(exec, _es_ClipPlanex);
    SET_ClipPlanexOES(exec, _es_ClipPlanexOES);
    SET_Color4f(exec, _es_Color4f);
    SET_Color4ub(exec, _es_Color4ub);
    SET_Color4x(exec, _es_Color4x);
    SET_Color4xOES(exec, _es_Color4xOES);
    SET_ColorMask(exec, _es_ColorMask);
    SET_ColorPointer(exec, _es_ColorPointer);
    SET_CompressedTexImage2D(exec, _es_CompressedTexImage2D);
    SET_CompressedTexSubImage2D(exec, _es_CompressedTexSubImage2D);
    SET_CopyTexImage2D(exec, _es_CopyTexImage2D);
    SET_CopyTexSubImage2D(exec, _es_CopyTexSubImage2D);
    SET_CullFace(exec, _es_CullFace);
    SET_DeleteBuffers(exec, _es_DeleteBuffers);
    SET_DeleteFramebuffersOES(exec, _es_DeleteFramebuffersOES);
    SET_DeleteRenderbuffersOES(exec, _es_DeleteRenderbuffersOES);
    SET_DeleteTextures(exec, _es_DeleteTextures);
    SET_DepthFunc(exec, _es_DepthFunc);
    SET_DepthMask(exec, _es_DepthMask);
    SET_DepthRangef(exec, _es_DepthRangef);
    SET_DepthRangefOES(exec, _es_DepthRangefOES);
    SET_DepthRangex(exec, _es_DepthRangex);
    SET_DepthRangexOES(exec, _es_DepthRangexOES);
    SET_Disable(exec, _es_Disable);
    SET_DisableClientState(exec, _es_DisableClientState);
    SET_DrawArrays(exec, _es_DrawArrays);
    SET_DrawElements(exec, _es_DrawElements);
    SET_DrawTexfOES(exec, _es_DrawTexfOES);
    SET_DrawTexfvOES(exec, _es_DrawTexfvOES);
    SET_DrawTexiOES(exec, _es_DrawTexiOES);
    SET_DrawTexivOES(exec, _es_DrawTexivOES);
    SET_DrawTexsOES(exec, _es_DrawTexsOES);
    SET_DrawTexsvOES(exec, _es_DrawTexsvOES);
    SET_DrawTexxOES(exec, _es_DrawTexxOES);
    SET_DrawTexxvOES(exec, _es_DrawTexxvOES);
    SET_EGLImageTargetRenderbufferStorageOES(exec, _es_EGLImageTargetRenderbufferStorageOES);
    SET_EGLImageTargetTexture2DOES(exec, _es_EGLImageTargetTexture2DOES);
    SET_Enable(exec, _es_Enable);
    SET_EnableClientState(exec, _es_EnableClientState);
    SET_Finish(exec, _es_Finish);
    SET_Flush(exec, _es_Flush);
    SET_Fogf(exec, _es_Fogf);
    SET_Fogfv(exec, _es_Fogfv);
    SET_Fogx(exec, _es_Fogx);
    SET_FogxOES(exec, _es_FogxOES);
    SET_Fogxv(exec, _es_Fogxv);
    SET_FogxvOES(exec, _es_FogxvOES);
    SET_FramebufferRenderbufferOES(exec, _es_FramebufferRenderbufferOES);
    SET_FramebufferTexture2DOES(exec, _es_FramebufferTexture2DOES);
    SET_FrontFace(exec, _es_FrontFace);
    SET_Frustumf(exec, _es_Frustumf);
    SET_FrustumfOES(exec, _es_FrustumfOES);
    SET_Frustumx(exec, _es_Frustumx);
    SET_FrustumxOES(exec, _es_FrustumxOES);
    SET_GenBuffers(exec, _es_GenBuffers);
    SET_GenFramebuffersOES(exec, _es_GenFramebuffersOES);
    SET_GenRenderbuffersOES(exec, _es_GenRenderbuffersOES);
    SET_GenTextures(exec, _es_GenTextures);
    SET_GenerateMipmapOES(exec, _es_GenerateMipmapOES);
    SET_GetBooleanv(exec, _es_GetBooleanv);
    SET_GetBufferParameteriv(exec, _es_GetBufferParameteriv);
    SET_GetBufferPointervOES(exec, _es_GetBufferPointervOES);
    SET_GetClipPlanef(exec, _es_GetClipPlanef);
    SET_GetClipPlanefOES(exec, _es_GetClipPlanefOES);
    SET_GetClipPlanex(exec, _es_GetClipPlanex);
    SET_GetClipPlanexOES(exec, _es_GetClipPlanexOES);
    SET_GetError(exec, _es_GetError);
    SET_GetFixedv(exec, _es_GetFixedv);
    SET_GetFixedvOES(exec, _es_GetFixedvOES);
    SET_GetFloatv(exec, _es_GetFloatv);
    SET_GetFramebufferAttachmentParameterivOES(exec, _es_GetFramebufferAttachmentParameterivOES);
    SET_GetIntegerv(exec, _es_GetIntegerv);
    SET_GetLightfv(exec, _es_GetLightfv);
    SET_GetLightxv(exec, _es_GetLightxv);
    SET_GetLightxvOES(exec, _es_GetLightxvOES);
    SET_GetMaterialfv(exec, _es_GetMaterialfv);
    SET_GetMaterialxv(exec, _es_GetMaterialxv);
    SET_GetMaterialxvOES(exec, _es_GetMaterialxvOES);
    SET_GetPointerv(exec, _es_GetPointerv);
    SET_GetRenderbufferParameterivOES(exec, _es_GetRenderbufferParameterivOES);
    SET_GetString(exec, _es_GetString);
    SET_GetTexEnvfv(exec, _es_GetTexEnvfv);
    SET_GetTexEnviv(exec, _es_GetTexEnviv);
    SET_GetTexEnvxv(exec, _es_GetTexEnvxv);
    SET_GetTexEnvxvOES(exec, _es_GetTexEnvxvOES);
    SET_GetTexGenfvOES(exec, _es_GetTexGenfvOES);
    SET_GetTexGenivOES(exec, _es_GetTexGenivOES);
    SET_GetTexGenxvOES(exec, _es_GetTexGenxvOES);
    SET_GetTexParameterfv(exec, _es_GetTexParameterfv);
    SET_GetTexParameteriv(exec, _es_GetTexParameteriv);
    SET_GetTexParameterxv(exec, _es_GetTexParameterxv);
    SET_GetTexParameterxvOES(exec, _es_GetTexParameterxvOES);
    SET_Hint(exec, _es_Hint);
    SET_IsBuffer(exec, _es_IsBuffer);
    SET_IsEnabled(exec, _es_IsEnabled);
    SET_IsFramebufferOES(exec, _es_IsFramebufferOES);
    SET_IsRenderbufferOES(exec, _es_IsRenderbufferOES);
    SET_IsTexture(exec, _es_IsTexture);
    SET_LightModelf(exec, _es_LightModelf);
    SET_LightModelfv(exec, _es_LightModelfv);
    SET_LightModelx(exec, _es_LightModelx);
    SET_LightModelxOES(exec, _es_LightModelxOES);
    SET_LightModelxv(exec, _es_LightModelxv);
    SET_LightModelxvOES(exec, _es_LightModelxvOES);
    SET_Lightf(exec, _es_Lightf);
    SET_Lightfv(exec, _es_Lightfv);
    SET_Lightx(exec, _es_Lightx);
    SET_LightxOES(exec, _es_LightxOES);
    SET_Lightxv(exec, _es_Lightxv);
    SET_LightxvOES(exec, _es_LightxvOES);
    SET_LineWidth(exec, _es_LineWidth);
    SET_LineWidthx(exec, _es_LineWidthx);
    SET_LineWidthxOES(exec, _es_LineWidthxOES);
    SET_LoadIdentity(exec, _es_LoadIdentity);
    SET_LoadMatrixf(exec, _es_LoadMatrixf);
    SET_LoadMatrixx(exec, _es_LoadMatrixx);
    SET_LoadMatrixxOES(exec, _es_LoadMatrixxOES);
    SET_LogicOp(exec, _es_LogicOp);
    SET_MapBufferOES(exec, _es_MapBufferOES);
    SET_Materialf(exec, _es_Materialf);
    SET_Materialfv(exec, _es_Materialfv);
    SET_Materialx(exec, _es_Materialx);
    SET_MaterialxOES(exec, _es_MaterialxOES);
    SET_Materialxv(exec, _es_Materialxv);
    SET_MaterialxvOES(exec, _es_MaterialxvOES);
    SET_MatrixMode(exec, _es_MatrixMode);
    SET_MultMatrixf(exec, _es_MultMatrixf);
    SET_MultMatrixx(exec, _es_MultMatrixx);
    SET_MultMatrixxOES(exec, _es_MultMatrixxOES);
    SET_MultiTexCoord4f(exec, _es_MultiTexCoord4f);
    SET_MultiTexCoord4x(exec, _es_MultiTexCoord4x);
    SET_MultiTexCoord4xOES(exec, _es_MultiTexCoord4xOES);
    SET_Normal3f(exec, _es_Normal3f);
    SET_Normal3x(exec, _es_Normal3x);
    SET_Normal3xOES(exec, _es_Normal3xOES);
    SET_NormalPointer(exec, _es_NormalPointer);
    SET_Orthof(exec, _es_Orthof);
    SET_OrthofOES(exec, _es_OrthofOES);
    SET_Orthox(exec, _es_Orthox);
    SET_OrthoxOES(exec, _es_OrthoxOES);
    SET_PixelStorei(exec, _es_PixelStorei);
    SET_PointParameterf(exec, _es_PointParameterf);
    SET_PointParameterfv(exec, _es_PointParameterfv);
    SET_PointParameterx(exec, _es_PointParameterx);
    SET_PointParameterxOES(exec, _es_PointParameterxOES);
    SET_PointParameterxv(exec, _es_PointParameterxv);
    SET_PointParameterxvOES(exec, _es_PointParameterxvOES);
    SET_PointSize(exec, _es_PointSize);
    SET_PointSizePointerOES(exec, _es_PointSizePointerOES);
    SET_PointSizex(exec, _es_PointSizex);
    SET_PointSizexOES(exec, _es_PointSizexOES);
    SET_PolygonOffset(exec, _es_PolygonOffset);
    SET_PolygonOffsetx(exec, _es_PolygonOffsetx);
    SET_PolygonOffsetxOES(exec, _es_PolygonOffsetxOES);
    SET_PopMatrix(exec, _es_PopMatrix);
    SET_PushMatrix(exec, _es_PushMatrix);
    SET_QueryMatrixxOES(exec, _es_QueryMatrixxOES);
    SET_ReadPixels(exec, _es_ReadPixels);
    SET_RenderbufferStorageOES(exec, _es_RenderbufferStorageOES);
    SET_Rotatef(exec, _es_Rotatef);
    SET_Rotatex(exec, _es_Rotatex);
    SET_RotatexOES(exec, _es_RotatexOES);
    SET_SampleCoverage(exec, _es_SampleCoverage);
    SET_SampleCoveragex(exec, _es_SampleCoveragex);
    SET_SampleCoveragexOES(exec, _es_SampleCoveragexOES);
    SET_Scalef(exec, _es_Scalef);
    SET_Scalex(exec, _es_Scalex);
    SET_ScalexOES(exec, _es_ScalexOES);
    SET_Scissor(exec, _es_Scissor);
    SET_ShadeModel(exec, _es_ShadeModel);
    SET_StencilFunc(exec, _es_StencilFunc);
    SET_StencilMask(exec, _es_StencilMask);
    SET_StencilOp(exec, _es_StencilOp);
    SET_TexCoordPointer(exec, _es_TexCoordPointer);
    SET_TexEnvf(exec, _es_TexEnvf);
    SET_TexEnvfv(exec, _es_TexEnvfv);
    SET_TexEnvi(exec, _es_TexEnvi);
    SET_TexEnviv(exec, _es_TexEnviv);
    SET_TexEnvx(exec, _es_TexEnvx);
    SET_TexEnvxOES(exec, _es_TexEnvxOES);
    SET_TexEnvxv(exec, _es_TexEnvxv);
    SET_TexEnvxvOES(exec, _es_TexEnvxvOES);
    SET_TexGenfOES(exec, _es_TexGenfOES);
    SET_TexGenfvOES(exec, _es_TexGenfvOES);
    SET_TexGeniOES(exec, _es_TexGeniOES);
    SET_TexGenivOES(exec, _es_TexGenivOES);
    SET_TexGenxOES(exec, _es_TexGenxOES);
    SET_TexGenxvOES(exec, _es_TexGenxvOES);
    SET_TexImage2D(exec, _es_TexImage2D);
    SET_TexParameterf(exec, _es_TexParameterf);
    SET_TexParameterfv(exec, _es_TexParameterfv);
    SET_TexParameteri(exec, _es_TexParameteri);
    SET_TexParameteriv(exec, _es_TexParameteriv);
    SET_TexParameterx(exec, _es_TexParameterx);
    SET_TexParameterxOES(exec, _es_TexParameterxOES);
    SET_TexParameterxv(exec, _es_TexParameterxv);
    SET_TexParameterxvOES(exec, _es_TexParameterxvOES);
    SET_TexSubImage2D(exec, _es_TexSubImage2D);
    SET_Translatef(exec, _es_Translatef);
    SET_Translatex(exec, _es_Translatex);
    SET_TranslatexOES(exec, _es_TranslatexOES);
    SET_UnmapBufferOES(exec, _es_UnmapBufferOES);
    SET_VertexPointer(exec, _es_VertexPointer);
    SET_Viewport(exec, _es_Viewport);
}
