/* Generated by re2c 0.13.5 on Thu Jan 28 20:49:22 2010 */
/*
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// Generate js file as follows:
//
// re2c -isc WebCore/inspector/front-end/SourceHTMLTokenizer.re2js \
// | sed 's|^yy\([^:]*\)*\:|case \1:|' \
// | sed 's|[*]cursor[+][+]|this._charAt(cursor++)|' \
// | sed 's|[[*][+][+]cursor|this._charAt(++cursor)|' \
// | sed 's|[*]cursor|this._charAt(cursor)|' \
// | sed 's|yych = \*\([^;]*\)|yych = this._charAt\1|' \
// | sed 's|{ gotoCase = \([^; continue; };]*\)|{ gotoCase = \1; continue; }|' \
// | sed 's|unsigned\ int|var|' \
// | sed 's|var\ yych|case 1: case 1: var yych|'

WebInspector.SourceHTMLTokenizer = function()
{
    WebInspector.SourceTokenizer.call(this);

    this._lexConditions = {
        INITIAL: 0,
        COMMENT: 1,
        DSTRING: 2,
        SSTRING: 3
    };

    this._parseConditions = {
        INITIAL: 0,
        TAG: 1,
        ATTRIBUTE: 2,
        ATTRIBUTE_VALUE: 3,
        SCRIPT: 4,
        SCRIPT_ATTRIBUTE: 5,
        SCRIPT_ATTRIBUTE_VALUE: 6,
        DOCTYPE: 7
    };

    this.case_INITIAL = 1000;
    this.case_COMMENT = 1001;
    this.case_DSTRING = 1002;
    this.case_SSTRING = 1003;

    this.initialCondition = { lexCondition: this._lexConditions.INITIAL, parseCondition: this._parseConditions.INITIAL };
}

WebInspector.SourceHTMLTokenizer.prototype = {
    _isAttribute: function()
    {
        return this._parseCondition === this._parseConditions.ATTRIBUTE || this._parseCondition === this._parseConditions.SCRIPT_ATTRIBUTE;
    },

    _isAttributeValue: function()
    {
        return this._parseCondition === this._parseConditions.ATTRIBUTE_VALUE || this._parseCondition === this._parseConditions.SCRIPT_ATTRIBUTE_VALUE;
    },

    _setAttributeValue: function()
    {
        if (this._parseCondition === this._parseConditions.ATTRIBUTE)
            this._parseCondition = this._parseConditions.ATTRIBUTE_VALUE;
        else if (this._parseCondition === this._parseConditions.SCRIPT_ATTRIBUTE)
            this._parseCondition = this._parseConditions.SCRIPT_ATTRIBUTE_VALUE;
    },

    _setAttribute: function()
    {
        if (this._parseCondition === this._parseConditions.ATTRIBUTE_VALUE)
            this._parseCondition = this._parseConditions.ATTRIBUTE;
        else if (this._parseCondition === this._parseConditions.SCRIPT_ATTRIBUTE_VALUE)
            this._parseCondition = this._parseConditions.SCRIPT_ATTRIBUTE;
    },

    _stringToken: function(cursor, stringEnds)
    {
        if (this._isAttributeValue()) {
            this.tokenType = "html-attr-value";
            if (stringEnds)
                this._setAttribute();
        } else if (this._parseCondition === this._parseConditions.DOCTYPE)
            this.tokenType = "html-doctype";
        else
            this.tokenType = null;
        return cursor;
    },

    nextToken: function(cursor)
    {
        var cursorOnEnter = cursor;
        var gotoCase = 1;
        while (1) {
            switch (gotoCase)
            // Following comment is replaced with generated state machine.
            
        {
            case 1: var yych;
            var yyaccept = 0;
            if (this.getLexCondition() < 2) {
                if (this.getLexCondition() < 1) {
                    { gotoCase = this.case_INITIAL; continue; };
                } else {
                    { gotoCase = this.case_COMMENT; continue; };
                }
            } else {
                if (this.getLexCondition() < 3) {
                    { gotoCase = this.case_DSTRING; continue; };
                } else {
                    { gotoCase = this.case_SSTRING; continue; };
                }
            }
/* *********************************** */
case this.case_COMMENT:

            yych = this._charAt(cursor);
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 4; continue; };
                { gotoCase = 3; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 4; continue; };
                if (yych == '-') { gotoCase = 6; continue; };
                { gotoCase = 3; continue; };
            }
case 2:
            { this.tokenType = "html-comment"; return cursor; }
case 3:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 9; continue; };
case 4:
            ++cursor;
case 5:
            { this.tokenType = null; return cursor; }
case 6:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych != '-') { gotoCase = 5; continue; };
case 7:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '>') { gotoCase = 10; continue; };
case 8:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 9:
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 2; continue; };
                { gotoCase = 8; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 2; continue; };
                if (yych == '-') { gotoCase = 12; continue; };
                { gotoCase = 8; continue; };
            }
case 10:
            ++cursor;
            this.setLexCondition(this._lexConditions.INITIAL);
            { this.tokenType = "html-comment"; return cursor; }
case 12:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '-') { gotoCase = 7; continue; };
            cursor = YYMARKER;
            if (yyaccept <= 0) {
                { gotoCase = 2; continue; };
            } else {
                { gotoCase = 5; continue; };
            }
/* *********************************** */
case this.case_DSTRING:
            yych = this._charAt(cursor);
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 18; continue; };
                { gotoCase = 17; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 18; continue; };
                if (yych == '"') { gotoCase = 20; continue; };
                { gotoCase = 17; continue; };
            }
case 16:
            { return this._stringToken(cursor); }
case 17:
            yych = this._charAt(++cursor);
            { gotoCase = 24; continue; };
case 18:
            ++cursor;
            { this.tokenType = null; return cursor; }
case 20:
            ++cursor;
case 21:
            this.setLexCondition(this._lexConditions.INITIAL);
            { return this._stringToken(cursor, true); }
case 22:
            yych = this._charAt(++cursor);
            { gotoCase = 21; continue; };
case 23:
            ++cursor;
            yych = this._charAt(cursor);
case 24:
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 16; continue; };
                { gotoCase = 23; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 16; continue; };
                if (yych == '"') { gotoCase = 22; continue; };
                { gotoCase = 23; continue; };
            }
/* *********************************** */
case this.case_INITIAL:
            yych = this._charAt(cursor);
            if (yych <= '=') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 29; continue; };
                    if (yych >= '\'') { gotoCase = 30; continue; };
                } else {
                    if (yych <= '9') {
                        if (yych >= '0') { gotoCase = 31; continue; };
                    } else {
                        if (yych <= ';') { gotoCase = 27; continue; };
                        if (yych <= '<') { gotoCase = 33; continue; };
                        { gotoCase = 35; continue; };
                    }
                }
            } else {
                if (yych <= '^') {
                    if (yych <= '>') { gotoCase = 37; continue; };
                    if (yych <= '@') { gotoCase = 27; continue; };
                    if (yych <= 'Z') { gotoCase = 31; continue; };
                } else {
                    if (yych <= '`') {
                        if (yych <= '_') { gotoCase = 31; continue; };
                    } else {
                        if (yych <= 'z') { gotoCase = 31; continue; };
                        if (yych >= 0x80) { gotoCase = 31; continue; };
                    }
                }
            }
case 27:
            ++cursor;
case 28:
            { this.tokenType = null; return cursor; }
case 29:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 82; continue; };
case 30:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 76; continue; };
case 31:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 74; continue; };
case 32:
            {
                    if (this._parseCondition === this._parseConditions.SCRIPT) {
                        this.tokenType = null;
                        return cursor;
                    }

                    if (this._parseCondition === this._parseConditions.TAG) {
                        this.tokenType = "html-tag";
                        this._parseCondition = this._parseConditions.ATTRIBUTE;
                    } else if (this._isAttribute())
                        this.tokenType = "html-attr-name";
                    else if (this._isAttributeValue())
                        this.tokenType = "html-attr-value";
                    else if (this._parseCondition === this._parseConditions.DOCTYPE)
                        this.tokenType = "html-doctype";
                    else
                        this.tokenType = null;
                    return cursor;
                }
case 33:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= '/') {
                if (yych == '!') { gotoCase = 42; continue; };
                if (yych >= '/') { gotoCase = 39; continue; };
            } else {
                if (yych <= 'S') {
                    if (yych >= 'S') { gotoCase = 40; continue; };
                } else {
                    if (yych == 's') { gotoCase = 40; continue; };
                }
            }
case 34:
            {
                    if (this._parseCondition === this._parseConditions.SCRIPT) {
                        this.tokenType = null;
                        return cursor;
                    }

                    this.tokenType = "html-tag";
                    this._parseCondition = this._parseConditions.TAG;
                    return cursor;
                }
case 35:
            ++cursor;
            {
                    if (this._isAttribute()) {
                        this.tokenType = null;
                        this._setAttributeValue();
                    } else if (this._parseCondition === this._parseConditions.DOCTYPE)
                        this.tokenType = "html-doctype";
                    else
                        this.tokenType = null;
                    return cursor;
                }
case 37:
            ++cursor;
            {
                    if (this._parseCondition === this._parseConditions.SCRIPT) {
                        this.tokenType = null;
                        return cursor;
                    }

                    if (this._parseCondition === this._parseConditions.DOCTYPE)
                        this.tokenType = "html-doctype";
                    else
                        this.tokenType = "html-tag";

                    if (this._parseCondition === this._parseConditions.SCRIPT_ATTRIBUTE)
                        this._parseCondition = this._parseConditions.SCRIPT;
                    else
                        this._parseCondition = this._parseConditions.INITIAL;
                    return cursor;
                }
case 39:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == 'S') { gotoCase = 66; continue; };
            if (yych == 's') { gotoCase = 66; continue; };
            { gotoCase = 34; continue; };
case 40:
            yych = this._charAt(++cursor);
            if (yych == 'C') { gotoCase = 60; continue; };
            if (yych == 'c') { gotoCase = 60; continue; };
case 41:
            cursor = YYMARKER;
            if (yyaccept <= 0) {
                { gotoCase = 28; continue; };
            } else {
                { gotoCase = 34; continue; };
            }
case 42:
            yych = this._charAt(++cursor);
            if (yych <= 'C') {
                if (yych != '-') { gotoCase = 41; continue; };
            } else {
                if (yych <= 'D') { gotoCase = 44; continue; };
                if (yych == 'd') { gotoCase = 44; continue; };
                { gotoCase = 41; continue; };
            }
            yych = this._charAt(++cursor);
            if (yych == '-') { gotoCase = 52; continue; };
            { gotoCase = 41; continue; };
case 44:
            yych = this._charAt(++cursor);
            if (yych == 'O') { gotoCase = 45; continue; };
            if (yych != 'o') { gotoCase = 41; continue; };
case 45:
            yych = this._charAt(++cursor);
            if (yych == 'C') { gotoCase = 46; continue; };
            if (yych != 'c') { gotoCase = 41; continue; };
case 46:
            yych = this._charAt(++cursor);
            if (yych == 'T') { gotoCase = 47; continue; };
            if (yych != 't') { gotoCase = 41; continue; };
case 47:
            yych = this._charAt(++cursor);
            if (yych == 'Y') { gotoCase = 48; continue; };
            if (yych != 'y') { gotoCase = 41; continue; };
case 48:
            yych = this._charAt(++cursor);
            if (yych == 'P') { gotoCase = 49; continue; };
            if (yych != 'p') { gotoCase = 41; continue; };
case 49:
            yych = this._charAt(++cursor);
            if (yych == 'E') { gotoCase = 50; continue; };
            if (yych != 'e') { gotoCase = 41; continue; };
case 50:
            ++cursor;
            {
                    this.tokenType = "html-doctype";
                    this._parseCondition = this._parseConditions.DOCTYPE;
                    return cursor;
                }
case 52:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 55; continue; };
                { gotoCase = 52; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 55; continue; };
                if (yych != '-') { gotoCase = 52; continue; };
            }
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '-') { gotoCase = 57; continue; };
            { gotoCase = 41; continue; };
case 55:
            ++cursor;
            this.setLexCondition(this._lexConditions.COMMENT);
            { this.tokenType = "html-comment"; return cursor; }
case 57:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych != '>') { gotoCase = 52; continue; };
            ++cursor;
            { this.tokenType = "html-comment"; return cursor; }
case 60:
            yych = this._charAt(++cursor);
            if (yych == 'R') { gotoCase = 61; continue; };
            if (yych != 'r') { gotoCase = 41; continue; };
case 61:
            yych = this._charAt(++cursor);
            if (yych == 'I') { gotoCase = 62; continue; };
            if (yych != 'i') { gotoCase = 41; continue; };
case 62:
            yych = this._charAt(++cursor);
            if (yych == 'P') { gotoCase = 63; continue; };
            if (yych != 'p') { gotoCase = 41; continue; };
case 63:
            yych = this._charAt(++cursor);
            if (yych == 'T') { gotoCase = 64; continue; };
            if (yych != 't') { gotoCase = 41; continue; };
case 64:
            ++cursor;
            {
                    this.tokenType = "html-tag";
                    this._parseCondition = this._parseConditions.SCRIPT_ATTRIBUTE;
                    return cursor;
                }
case 66:
            yych = this._charAt(++cursor);
            if (yych == 'C') { gotoCase = 67; continue; };
            if (yych != 'c') { gotoCase = 41; continue; };
case 67:
            yych = this._charAt(++cursor);
            if (yych == 'R') { gotoCase = 68; continue; };
            if (yych != 'r') { gotoCase = 41; continue; };
case 68:
            yych = this._charAt(++cursor);
            if (yych == 'I') { gotoCase = 69; continue; };
            if (yych != 'i') { gotoCase = 41; continue; };
case 69:
            yych = this._charAt(++cursor);
            if (yych == 'P') { gotoCase = 70; continue; };
            if (yych != 'p') { gotoCase = 41; continue; };
case 70:
            yych = this._charAt(++cursor);
            if (yych == 'T') { gotoCase = 71; continue; };
            if (yych != 't') { gotoCase = 41; continue; };
case 71:
            ++cursor;
            {
                    this.tokenType = "html-tag";
                    this._parseCondition = this._parseConditions.INITIAL;
                    return cursor;
                }
case 73:
            ++cursor;
            yych = this._charAt(cursor);
case 74:
            if (yych <= '^') {
                if (yych <= '9') {
                    if (yych <= '/') { gotoCase = 32; continue; };
                    { gotoCase = 73; continue; };
                } else {
                    if (yych <= '@') { gotoCase = 32; continue; };
                    if (yych <= 'Z') { gotoCase = 73; continue; };
                    { gotoCase = 32; continue; };
                }
            } else {
                if (yych <= '`') {
                    if (yych <= '_') { gotoCase = 73; continue; };
                    { gotoCase = 32; continue; };
                } else {
                    if (yych <= 'z') { gotoCase = 73; continue; };
                    if (yych <= 0x7F) { gotoCase = 32; continue; };
                    { gotoCase = 73; continue; };
                }
            }
case 75:
            ++cursor;
            yych = this._charAt(cursor);
case 76:
            if (yych <= '\f') {
                if (yych != '\n') { gotoCase = 75; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 77; continue; };
                if (yych == '\'') { gotoCase = 79; continue; };
                { gotoCase = 75; continue; };
            }
case 77:
            ++cursor;
            this.setLexCondition(this._lexConditions.SSTRING);
            { return this._stringToken(cursor); }
case 79:
            ++cursor;
            { return this._stringToken(cursor, true); }
case 81:
            ++cursor;
            yych = this._charAt(cursor);
case 82:
            if (yych <= '\f') {
                if (yych != '\n') { gotoCase = 81; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 83; continue; };
                if (yych == '"') { gotoCase = 79; continue; };
                { gotoCase = 81; continue; };
            }
case 83:
            ++cursor;
            this.setLexCondition(this._lexConditions.DSTRING);
            { return this._stringToken(cursor); }
/* *********************************** */
case this.case_SSTRING:
            yych = this._charAt(cursor);
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 89; continue; };
                { gotoCase = 88; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 89; continue; };
                if (yych == '\'') { gotoCase = 91; continue; };
                { gotoCase = 88; continue; };
            }
case 87:
            { return this._stringToken(cursor); }
case 88:
            yych = this._charAt(++cursor);
            { gotoCase = 95; continue; };
case 89:
            ++cursor;
            { this.tokenType = null; return cursor; }
case 91:
            ++cursor;
case 92:
            this.setLexCondition(this._lexConditions.INITIAL);
            { return this._stringToken(cursor, true); }
case 93:
            yych = this._charAt(++cursor);
            { gotoCase = 92; continue; };
case 94:
            ++cursor;
            yych = this._charAt(cursor);
case 95:
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 87; continue; };
                { gotoCase = 94; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 87; continue; };
                if (yych == '\'') { gotoCase = 93; continue; };
                { gotoCase = 94; continue; };
            }
        }

        }
    }
}

WebInspector.SourceHTMLTokenizer.prototype.__proto__ = WebInspector.SourceTokenizer.prototype;
