/*
 * Copyright (C) 2007-2008 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
/* ----------------------------------------------------------------
 *
 * 
 * File Name:  armVCM4P10_CAVLCTables.c
 * OpenMAX DL: v1.0.2
 * Revision:   12290
 * Date:       Wednesday, April 9, 2008
 * 
 * 
 * 
 * 
 * Optimized CAVLC tables for H.264
 * 
 */
 
#include "omxtypes.h"
#include "armOMX.h"

#include "armVCM4P10_CAVLCTables.h"

/* 4x4 DeZigZag table */

const OMX_U8 armVCM4P10_ZigZag_4x4[16] =
{
    0, 1, 4, 8, 5, 2, 3, 6, 9, 12, 13, 10, 7, 11, 14, 15
};

/* 2x2 DeZigZag table */

const OMX_U8 armVCM4P10_ZigZag_2x2[4] =
{
    0, 1, 2, 3
};


/*
 * Suffix To Level table
 * We increment the suffix length if 
 * ((LevelCode>>1)+1)>(3<<(SuffixLength-1)) && SuffixLength<6
 * (LevelCode>>1)>=(3<<(SuffixLength-1))    && SuffixLength<6
 *  LevelCode    >= 3<<SuffixLength         && SuffixLength<6
 * (LevelCode+2) >= (3<<SuffixLength)+2     && SuffixLength<6
 */
const OMX_S8 armVCM4P10_SuffixToLevel[7] =
{
    (3<<1)+2,       /* SuffixLength=1 */
    (3<<1)+2,       /* SuffixLength=1 */
    (3<<2)+2,       /* SuffixLength=2 */
    (3<<3)+2,       /* SuffixLength=3 */
    (3<<4)+2,       /* SuffixLength=4 */
    (3<<5)+2,       /* SuffixLength=5 */
    -1              /* SuffixLength=6 - never increment */
};

static const OMX_U16 armVCM4P10_CAVLCCoeffTokenTables_0[132] = {
    0x0020, 0x0100, 0x2015, 0x2015, 0x400b, 0x400b, 0x400b, 0x400b,
    0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001,
    0x0028, 0x00f0, 0x00f8, 0x0027, 0x0030, 0x00d8, 0x00e0, 0x00e8,
    0x0038, 0x00a0, 0x00c8, 0x00d0, 0x0040, 0x0068, 0x0090, 0x0098,
    0x0048, 0x0050, 0x0058, 0x0060, 0x27ff, 0x27ff, 0x206b, 0x206b,
    0x0081, 0x0085, 0x0083, 0x0079, 0x0087, 0x007d, 0x007b, 0x0071,
    0x007f, 0x0075, 0x0073, 0x0069, 0x0070, 0x0078, 0x0080, 0x0088,
    0x2077, 0x2077, 0x206d, 0x206d, 0x2063, 0x2063, 0x2061, 0x2061,
    0x206f, 0x206f, 0x2065, 0x2065, 0x205b, 0x205b, 0x2059, 0x2059,
    0x0067, 0x005d, 0x0053, 0x0051, 0x005f, 0x0055, 0x004b, 0x0049,
    0x00a8, 0x00b0, 0x00b8, 0x00c0, 0x2041, 0x2041, 0x204d, 0x204d,
    0x2043, 0x2043, 0x2039, 0x2039, 0x2057, 0x2057, 0x2045, 0x2045,
    0x203b, 0x203b, 0x2031, 0x2031, 0x204f, 0x204f, 0x203d, 0x203d,
    0x2033, 0x2033, 0x2029, 0x2029, 0x0047, 0x0035, 0x002b, 0x0021,
    0x203f, 0x203f, 0x202d, 0x202d, 0x2023, 0x2023, 0x2019, 0x2019,
    0x0037, 0x0025, 0x001b, 0x0011, 0x202f, 0x202f, 0x201d, 0x201d,
    0x0013, 0x0009, 0x201f, 0x201f
};

static const OMX_U16 armVCM4P10_CAVLCCoeffTokenTables_1[128] = {
    0x0020, 0x00e8, 0x00f0, 0x00f8, 0x0027, 0x001f, 0x2015, 0x2015,
    0x400b, 0x400b, 0x400b, 0x400b, 0x4001, 0x4001, 0x4001, 0x4001,
    0x0028, 0x00d0, 0x00d8, 0x00e0, 0x0030, 0x0098, 0x00c0, 0x00c8,
    0x0038, 0x0060, 0x0088, 0x0090, 0x0040, 0x0048, 0x0050, 0x0058,
    0x27ff, 0x27ff, 0x207f, 0x207f, 0x0087, 0x0085, 0x0083, 0x0081,
    0x007b, 0x0079, 0x007d, 0x0073, 0x2075, 0x2075, 0x2071, 0x2071,
    0x0068, 0x0070, 0x0078, 0x0080, 0x2077, 0x2077, 0x206d, 0x206d,
    0x206b, 0x206b, 0x2069, 0x2069, 0x206f, 0x206f, 0x2065, 0x2065,
    0x2063, 0x2063, 0x2061, 0x2061, 0x0059, 0x005d, 0x005b, 0x0051,
    0x0067, 0x0055, 0x0053, 0x0049, 0x00a0, 0x00a8, 0x00b0, 0x00b8,
    0x205f, 0x205f, 0x204d, 0x204d, 0x204b, 0x204b, 0x2041, 0x2041,
    0x2057, 0x2057, 0x2045, 0x2045, 0x2043, 0x2043, 0x2039, 0x2039,
    0x204f, 0x204f, 0x203d, 0x203d, 0x203b, 0x203b, 0x2031, 0x2031,
    0x0029, 0x0035, 0x0033, 0x0021, 0x2047, 0x2047, 0x202d, 0x202d,
    0x202b, 0x202b, 0x2019, 0x2019, 0x003f, 0x0025, 0x0023, 0x0011,
    0x0037, 0x001d, 0x001b, 0x0009, 0x202f, 0x202f, 0x2013, 0x2013
};

static const OMX_U16 armVCM4P10_CAVLCCoeffTokenTables_2[112] = {
    0x0020, 0x0088, 0x00b0, 0x00b8, 0x00c0, 0x00c8, 0x00d0, 0x00d8,
    0x003f, 0x0037, 0x002f, 0x0027, 0x001f, 0x0015, 0x000b, 0x0001,
    0x0028, 0x0050, 0x0078, 0x0080, 0x0030, 0x0038, 0x0040, 0x0048,
    0x07ff, 0x0081, 0x0087, 0x0085, 0x0083, 0x0079, 0x007f, 0x007d,
    0x007b, 0x0071, 0x0077, 0x0075, 0x0073, 0x0069, 0x206b, 0x206b,
    0x0058, 0x0060, 0x0068, 0x0070, 0x2061, 0x2061, 0x206d, 0x206d,
    0x2063, 0x2063, 0x2059, 0x2059, 0x206f, 0x206f, 0x2065, 0x2065,
    0x205b, 0x205b, 0x2051, 0x2051, 0x0067, 0x005d, 0x0053, 0x0049,
    0x005f, 0x0055, 0x004b, 0x0041, 0x0090, 0x0098, 0x00a0, 0x00a8,
    0x2039, 0x2039, 0x2031, 0x2031, 0x204d, 0x204d, 0x2029, 0x2029,
    0x2057, 0x2057, 0x2045, 0x2045, 0x2043, 0x2043, 0x2021, 0x2021,
    0x0019, 0x003d, 0x003b, 0x0011, 0x004f, 0x0035, 0x0033, 0x0009,
    0x202b, 0x202b, 0x202d, 0x202d, 0x2023, 0x2023, 0x2025, 0x2025,
    0x201b, 0x201b, 0x2047, 0x2047, 0x201d, 0x201d, 0x2013, 0x2013
};

static const OMX_U16 armVCM4P10_CAVLCCoeffTokenTables_3[80] = {
    0x0020, 0x0028, 0x0030, 0x0038, 0x0040, 0x0048, 0x0050, 0x0058,
    0x0060, 0x0068, 0x0070, 0x0078, 0x0080, 0x0088, 0x0090, 0x0098,
    0x0009, 0x000b, 0x07ff, 0x0001, 0x0011, 0x0013, 0x0015, 0x07ff,
    0x0019, 0x001b, 0x001d, 0x001f, 0x0021, 0x0023, 0x0025, 0x0027,
    0x0029, 0x002b, 0x002d, 0x002f, 0x0031, 0x0033, 0x0035, 0x0037,
    0x0039, 0x003b, 0x003d, 0x003f, 0x0041, 0x0043, 0x0045, 0x0047,
    0x0049, 0x004b, 0x004d, 0x004f, 0x0051, 0x0053, 0x0055, 0x0057,
    0x0059, 0x005b, 0x005d, 0x005f, 0x0061, 0x0063, 0x0065, 0x0067,
    0x0069, 0x006b, 0x006d, 0x006f, 0x0071, 0x0073, 0x0075, 0x0077,
    0x0079, 0x007b, 0x007d, 0x007f, 0x0081, 0x0083, 0x0085, 0x0087
};

static const OMX_U16 armVCM4P10_CAVLCCoeffTokenTables_4[32] = {
    0x0020, 0x0038, 0x2015, 0x2015, 0x4001, 0x4001, 0x4001, 0x4001,
    0x600b, 0x600b, 0x600b, 0x600b, 0x600b, 0x600b, 0x600b, 0x600b,
    0x0028, 0x0030, 0x0021, 0x0019, 0x2027, 0x2027, 0x0025, 0x0023,
    0x201d, 0x201d, 0x201b, 0x201b, 0x0011, 0x001f, 0x0013, 0x0009
};

const OMX_U16 * armVCM4P10_CAVLCCoeffTokenTables[18] = {
    armVCM4P10_CAVLCCoeffTokenTables_0, /* nC=0 */
    armVCM4P10_CAVLCCoeffTokenTables_0, /* nC=1 */
    armVCM4P10_CAVLCCoeffTokenTables_1, /* nC=2 */
    armVCM4P10_CAVLCCoeffTokenTables_1, /* nC=3 */
    armVCM4P10_CAVLCCoeffTokenTables_2, /* nC=4 */
    armVCM4P10_CAVLCCoeffTokenTables_2, /* nC=5 */
    armVCM4P10_CAVLCCoeffTokenTables_2, /* nC=6 */
    armVCM4P10_CAVLCCoeffTokenTables_2, /* nC=7 */
    armVCM4P10_CAVLCCoeffTokenTables_3, /* nC=8 */
    armVCM4P10_CAVLCCoeffTokenTables_3, /* nC=9 */
    armVCM4P10_CAVLCCoeffTokenTables_3, /* nC=10 */
    armVCM4P10_CAVLCCoeffTokenTables_3, /* nC=11 */
    armVCM4P10_CAVLCCoeffTokenTables_3, /* nC=12 */
    armVCM4P10_CAVLCCoeffTokenTables_3, /* nC=13 */
    armVCM4P10_CAVLCCoeffTokenTables_3, /* nC=14 */
    armVCM4P10_CAVLCCoeffTokenTables_3, /* nC=15 */
    armVCM4P10_CAVLCCoeffTokenTables_3, /* nC=16 */
    armVCM4P10_CAVLCCoeffTokenTables_4  /* nC=-1 */
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_0[40] = {
    0x0020, 0x0048, 0x0009, 0x0007, 0x2005, 0x2005, 0x2003, 0x2003,
    0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001,
    0x0028, 0x0040, 0x0011, 0x000f, 0x0030, 0x0038, 0x0019, 0x0017,
    0x27ff, 0x27ff, 0x201f, 0x201f, 0x201d, 0x201d, 0x201b, 0x201b,
    0x2015, 0x2015, 0x2013, 0x2013, 0x200d, 0x200d, 0x200b, 0x200b
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_1[24] = {
    0x0020, 0x0028, 0x0011, 0x000f, 0x000d, 0x000b, 0x2009, 0x2009,
    0x2007, 0x2007, 0x2005, 0x2005, 0x2003, 0x2003, 0x2001, 0x2001,
    0x001d, 0x001b, 0x0019, 0x0017, 0x2015, 0x2015, 0x2013, 0x2013
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_2[24] = {
    0x0020, 0x0028, 0x0011, 0x000b, 0x0009, 0x0001, 0x200f, 0x200f,
    0x200d, 0x200d, 0x2007, 0x2007, 0x2005, 0x2005, 0x2003, 0x2003,
    0x001b, 0x0017, 0x2019, 0x2019, 0x2015, 0x2015, 0x2013, 0x2013
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_3[24] = {
    0x0020, 0x0028, 0x0013, 0x000f, 0x0007, 0x0005, 0x2011, 0x2011,
    0x200d, 0x200d, 0x200b, 0x200b, 0x2009, 0x2009, 0x2003, 0x2003,
    0x2019, 0x2019, 0x2017, 0x2017, 0x2015, 0x2015, 0x2001, 0x2001
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_4[20] = {
    0x0020, 0x0015, 0x0011, 0x0005, 0x0003, 0x0001, 0x200f, 0x200f,
    0x200d, 0x200d, 0x200b, 0x200b, 0x2009, 0x2009, 0x2007, 0x2007,
    0x2017, 0x2017, 0x2013, 0x2013
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_5[20] = {
    0x0020, 0x0011, 0x2013, 0x2013, 0x200f, 0x200f, 0x200d, 0x200d,
    0x200b, 0x200b, 0x2009, 0x2009, 0x2007, 0x2007, 0x2005, 0x2005,
    0x0015, 0x0001, 0x2003, 0x2003
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_6[20] = {
    0x0020, 0x000f, 0x2011, 0x2011, 0x200d, 0x200d, 0x2009, 0x2009,
    0x2007, 0x2007, 0x2005, 0x2005, 0x400b, 0x400b, 0x400b, 0x400b,
    0x0013, 0x0001, 0x2003, 0x2003
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_7[20] = {
    0x0020, 0x0003, 0x200f, 0x200f, 0x200d, 0x200d, 0x2007, 0x2007,
    0x400b, 0x400b, 0x400b, 0x400b, 0x4009, 0x4009, 0x4009, 0x4009,
    0x0011, 0x0001, 0x2005, 0x2005
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_8[20] = {
    0x0020, 0x0005, 0x200b, 0x200b, 0x400d, 0x400d, 0x400d, 0x400d,
    0x4009, 0x4009, 0x4009, 0x4009, 0x4007, 0x4007, 0x4007, 0x4007,
    0x0003, 0x0001, 0x200f, 0x200f
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_9[20] = {
    0x0020, 0x000d, 0x2005, 0x2005, 0x400b, 0x400b, 0x400b, 0x400b,
    0x4009, 0x4009, 0x4009, 0x4009, 0x4007, 0x4007, 0x4007, 0x4007,
    0x2003, 0x2003, 0x2001, 0x2001
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_10[16] = {
    0x0001, 0x0003, 0x2005, 0x2005, 0x2007, 0x2007, 0x200b, 0x200b,
    0x6009, 0x6009, 0x6009, 0x6009, 0x6009, 0x6009, 0x6009, 0x6009
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_11[16] = {
    0x0001, 0x0003, 0x2009, 0x2009, 0x4005, 0x4005, 0x4005, 0x4005,
    0x6007, 0x6007, 0x6007, 0x6007, 0x6007, 0x6007, 0x6007, 0x6007
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_12[16] = {
    0x2001, 0x2001, 0x2003, 0x2003, 0x4007, 0x4007, 0x4007, 0x4007,
    0x6005, 0x6005, 0x6005, 0x6005, 0x6005, 0x6005, 0x6005, 0x6005
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_13[16] = {
    0x4001, 0x4001, 0x4001, 0x4001, 0x4003, 0x4003, 0x4003, 0x4003,
    0x6005, 0x6005, 0x6005, 0x6005, 0x6005, 0x6005, 0x6005, 0x6005
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeroTables_14[16] = {
    0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001,
    0x6003, 0x6003, 0x6003, 0x6003, 0x6003, 0x6003, 0x6003, 0x6003
};

const OMX_U16 * armVCM4P10_CAVLCTotalZeroTables[15] = {
    armVCM4P10_CAVLCTotalZeroTables_0,
    armVCM4P10_CAVLCTotalZeroTables_1,
    armVCM4P10_CAVLCTotalZeroTables_2,
    armVCM4P10_CAVLCTotalZeroTables_3,
    armVCM4P10_CAVLCTotalZeroTables_4,
    armVCM4P10_CAVLCTotalZeroTables_5,
    armVCM4P10_CAVLCTotalZeroTables_6,
    armVCM4P10_CAVLCTotalZeroTables_7,
    armVCM4P10_CAVLCTotalZeroTables_8,
    armVCM4P10_CAVLCTotalZeroTables_9,
    armVCM4P10_CAVLCTotalZeroTables_10,
    armVCM4P10_CAVLCTotalZeroTables_11,
    armVCM4P10_CAVLCTotalZeroTables_12,
    armVCM4P10_CAVLCTotalZeroTables_13,
    armVCM4P10_CAVLCTotalZeroTables_14
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeros2x2Tables_0[16] = {
    0x2007, 0x2007, 0x2005, 0x2005, 0x4003, 0x4003, 0x4003, 0x4003,
    0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeros2x2Tables_1[16] = {
    0x4005, 0x4005, 0x4005, 0x4005, 0x4003, 0x4003, 0x4003, 0x4003,
    0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001
};

static const OMX_U16 armVCM4P10_CAVLCTotalZeros2x2Tables_2[16] = {
    0x6003, 0x6003, 0x6003, 0x6003, 0x6003, 0x6003, 0x6003, 0x6003,
    0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001, 0x6001
};

const OMX_U16 * armVCM4P10_CAVLCTotalZeros2x2Tables[3] = {
    armVCM4P10_CAVLCTotalZeros2x2Tables_0,
    armVCM4P10_CAVLCTotalZeros2x2Tables_1,
    armVCM4P10_CAVLCTotalZeros2x2Tables_2
};

static const OMX_U16 armVCM4P10_CAVLCRunBeforeTables_0[8] = {
    0x4003, 0x4003, 0x4003, 0x4003, 0x4001, 0x4001, 0x4001, 0x4001
};

static const OMX_U16 armVCM4P10_CAVLCRunBeforeTables_1[8] = {
    0x2005, 0x2005, 0x2003, 0x2003, 0x4001, 0x4001, 0x4001, 0x4001
};

static const OMX_U16 armVCM4P10_CAVLCRunBeforeTables_2[8] = {
    0x2007, 0x2007, 0x2005, 0x2005, 0x2003, 0x2003, 0x2001, 0x2001
};

static const OMX_U16 armVCM4P10_CAVLCRunBeforeTables_3[8] = {
    0x0009, 0x0007, 0x2005, 0x2005, 0x2003, 0x2003, 0x2001, 0x2001
};

static const OMX_U16 armVCM4P10_CAVLCRunBeforeTables_4[8] = {
    0x000b, 0x0009, 0x0007, 0x0005, 0x2003, 0x2003, 0x2001, 0x2001
};

static const OMX_U16 armVCM4P10_CAVLCRunBeforeTables_5[8] = {
    0x0003, 0x0005, 0x0009, 0x0007, 0x000d, 0x000b, 0x2001, 0x2001
};

static const OMX_U16 armVCM4P10_CAVLCRunBeforeTables_6[24] = {
    0x0010, 0x000d, 0x000b, 0x0009, 0x0007, 0x0005, 0x0003, 0x0001,
    0x0018, 0x0011, 0x200f, 0x200f, 0x0020, 0x0015, 0x2013, 0x2013,
    0x0028, 0x0019, 0x2017, 0x2017, 0x07ff, 0x001d, 0x201b, 0x201b
};

/* Tables 7 to 14 are duplicates of table 6 */

const OMX_U16 * armVCM4P10_CAVLCRunBeforeTables[15] = {
    armVCM4P10_CAVLCRunBeforeTables_0,  /* ZerosLeft=1 */
    armVCM4P10_CAVLCRunBeforeTables_1,
    armVCM4P10_CAVLCRunBeforeTables_2,
    armVCM4P10_CAVLCRunBeforeTables_3,
    armVCM4P10_CAVLCRunBeforeTables_4,
    armVCM4P10_CAVLCRunBeforeTables_5,  /* ZerosLeft=6 */
    armVCM4P10_CAVLCRunBeforeTables_6,  /* ZerosLeft=7 */
    armVCM4P10_CAVLCRunBeforeTables_6,  /* ZerosLeft=8 */
    armVCM4P10_CAVLCRunBeforeTables_6,  /* ZerosLeft=9 */
    armVCM4P10_CAVLCRunBeforeTables_6,  /* ZerosLeft=10 */
    armVCM4P10_CAVLCRunBeforeTables_6,  /* ZerosLeft=11 */
    armVCM4P10_CAVLCRunBeforeTables_6,  /* ZerosLeft=12 */
    armVCM4P10_CAVLCRunBeforeTables_6,  /* ZerosLeft=13 */
    armVCM4P10_CAVLCRunBeforeTables_6,  /* ZerosLeft=14 */
    armVCM4P10_CAVLCRunBeforeTables_6   /* ZerosLeft=15 */
};
