/*
 This Java source file was generated by test-to-java.xsl
 and is a derived work from the source document.
 The source document contained the following notice:



 Copyright (c) 2001 World Wide Web Consortium,
 (Massachusetts Institute of Technology, Institut National de
 Recherche en Informatique et en Automatique, Keio University).  All
 Rights Reserved.  This program is distributed under the W3C's Software
 Intellectual Property License.  This program is distributed in the
 hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.

 See W3C License http://www.w3.org/Consortium/Legal/ for more details.


 */

package tests.org.w3c.dom;

import dalvik.annotation.TestTargets;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargetClass;

import org.w3c.dom.Node;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;

import javax.xml.parsers.DocumentBuilder;

/**
 * The "getPrefix()" method for a Node returns the namespace prefix of the node,
 * and for nodes of any type other than ELEMENT_NODE and ATTRIBUTE_NODE and
 * nodes created with a DOM Level 1 method, this is null.
 *
 * Create an new Element with the createElement() method. Invoke the
 * "getPrefix()" method on the newly created element node will cause "null" to
 * be returned.
 *
 * @author NIST
 * @author Mary Brady
 * @see <a
 *      href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSPrefix">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSPrefix</a>
 */
@TestTargetClass(Node.class)
public final class Prefix extends DOMTestCase {

    DOMDocumentBuilderFactory factory;

    DocumentBuilder builder;

    protected void setUp() throws Exception {
        super.setUp();
        try {
            factory = new DOMDocumentBuilderFactory(DOMDocumentBuilderFactory
                    .getConfiguration2());
            builder = factory.getBuilder();
        } catch (Exception e) {
            fail("Unexpected exception" + e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        factory = null;
        builder = null;
        super.tearDown();
    }

    /**
     * Runs the test case.
     *
     * @throws Throwable
     *             Any uncaught exception causes test to fail
     */
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that getPrefix method can return null.",
        method = "getPrefix",
        args = {}
    )
    public void testGetPrefix1() throws Throwable {
        Document doc;
        Node createdNode;
        String prefix;
        doc = (Document) load("staffNS", builder);
        createdNode = doc.createElement("test:employee");
        prefix = createdNode.getPrefix();
        assertNull("throw_Null", prefix);
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies positive functionality of getPrefix method.",
        method = "getPrefix",
        args = {}
    )
    public void testGetPrefix2() throws Throwable {
        Document doc;
        NodeList elementList;
        Node testEmployee;
        Node textNode;
        String prefix;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagName("emp:employeeId");
        testEmployee = elementList.item(0);
        assertNotNull("empEmployeeNotNull", testEmployee);
        textNode = testEmployee.getFirstChild();
        prefix = textNode.getPrefix();
        assertNull("textNodePrefix", prefix);
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies positive functionality of getPrefix method.",
        method = "getPrefix",
        args = {}
    )
    public void testGetPrefix3() throws Throwable {
        Document doc;
        NodeList elementList;
        Node testEmployee;
        String prefix;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagName("emp:employee");
        testEmployee = elementList.item(0);
        assertNotNull("empEmployeeNotNull", testEmployee);
        prefix = testEmployee.getPrefix();
        assertEquals("prefix", "emp", prefix);
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that getPrefix method returns null.",
        method = "getPrefix",
        args = {}
    )
    public void testGetPrefix4() throws Throwable {
        Document doc;
        NodeList elementList;
        Node testEmployee;
        String prefix;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagName("employee");
        testEmployee = elementList.item(0);
        prefix = testEmployee.getPrefix();
        assertNull("throw_Null", prefix);
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that getPrefix method throws DOMException with NAMESPACE_ERR code.",
        method = "getPrefix",
        args = {}
    )
    public void testGetPrefix5() throws Throwable {
        Document doc;
        NodeList elementList;
        Element addrNode;
        Attr addrAttr;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagName("emp:address");
        addrNode = (Element) elementList.item(0);
        assertNotNull("empAddrNotNull", addrNode);
        addrAttr = addrNode.getAttributeNode("emp:domestic");

        {
            boolean success = false;
            try {
                addrAttr.setPrefix("xmlns");
            } catch (DOMException ex) {
                success = (ex.code == DOMException.NAMESPACE_ERR);
            }
            assertTrue("throw_NAMESPACE_ERR", success);
        }
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that getPrefix method throws DOMException with INVALID_CHARACTER_ERR code.",
        method = "getPrefix",
        args = {}
    )
    public void _testGetPrefix6() throws Throwable {
        Document doc;
        NodeList elementList;
        Node employeeNode;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagName("employee");
        employeeNode = elementList.item(0);

        {
            boolean success = false;
            try {
                employeeNode.setPrefix("pre^fix xmlns='http//www.nist.gov'");
            } catch (DOMException ex) {
                success = (ex.code == DOMException.INVALID_CHARACTER_ERR);
            }
            assertTrue("throw_INVALID_CHARACTER_ERR", success);
        }
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that getPrefix method throws DOMException with NAMESPACE_ERR code.",
        method = "getPrefix",
        args = {}
    )
    public void testGetPrefix7() throws Throwable {
        Document doc;
        NodeList elementList;
        Node employeeNode;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagName("employee");
        employeeNode = elementList.item(0);

        {
            boolean success = false;
            try {
                employeeNode.setPrefix("emp::");
            } catch (DOMException ex) {
                success = (ex.code == DOMException.NAMESPACE_ERR);
            }
            assertTrue("throw_NAMESPACE_ERR", success);
        }
    }

// Assumes validation.
//    public void testGetPrefix8() throws Throwable {
//        Document doc;
//        NodeList genderList;
//        Node genderNode;
//        Node entRef;
//        Node entElement;
//
//        int nodeType;
//        doc = (Document) load("staff", builder);
//        genderList = doc.getElementsByTagName("gender");
//        genderNode = genderList.item(2);
//        entRef = genderNode.getFirstChild();
//        nodeType = (int) entRef.getNodeType();
//
//        if (1 == nodeType) {
//            entRef = doc.createEntityReference("ent4");
//            assertNotNull("createdEntRefNotNull", entRef);
//        }
//        entElement = entRef.getFirstChild();
//        assertNotNull("entElement", entElement);
//        doc.createElement("text3");
//
//        {
//            boolean success = false;
//            try {
//                entElement.setPrefix("newPrefix");
//            } catch (DOMException ex) {
//                success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
//            }
//            assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR", success);
//        }
//    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that getPrefix method throws DOMException with NAMESPACE_ERR code.",
        method = "getPrefix",
        args = {}
    )
    public void _testGetPrefix9() throws Throwable {
        Document doc;
        NodeList elementList;
        Element addrNode;
        Attr addrAttr;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagName("address");
        addrNode = (Element) elementList.item(3);
        addrAttr = addrNode.getAttributeNode("xmlns");

        {
            boolean success = false;
            try {
                addrAttr.setPrefix("xxx");
            } catch (DOMException ex) {
                success = (ex.code == DOMException.NAMESPACE_ERR);
            }
            assertTrue("throw_NAMESPACE_ERR", success);
        }
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that getPrefix method throws DOMException with NAMESPACE_ERR code.",
        method = "getPrefix",
        args = {}
    )
    public void testGetPrefix10() throws Throwable {
        Document doc;
        NodeList elementList;
        Node employeeNode;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagName("employee");
        employeeNode = elementList.item(1);

        {
            boolean success = false;
            try {
                employeeNode.setPrefix("xml");
            } catch (DOMException ex) {
                success = (ex.code == DOMException.NAMESPACE_ERR);
            }
            assertTrue("throw_NAMESPACE_ERR", success);
        }
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verifies that getPrefix method throws DOMException with NAMESPACE_ERR code.",
        method = "getPrefix",
        args = {}
    )
    public void testGetPrefix11() throws Throwable {
        Document doc;
        NodeList elementList;
        Node employeeNode;

        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagName("employee");
        employeeNode = elementList.item(1);
        employeeNode.getNamespaceURI();

        {
            boolean success = false;
            try {
                employeeNode.setPrefix("employee1");
            } catch (DOMException ex) {
                success = (ex.code == DOMException.NAMESPACE_ERR);
            }
            assertTrue("throw_NAMESPACE_ERR", success);
        }
    }
}
