/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPumper
implements Runnable {
    private static final int SIZE = 128;
    private InputStream is;
    private OutputStream os;
    private boolean finished;
    private boolean closeWhenExhausted;
    private boolean autoflush = false;

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        this.is = is;
        this.os = os;
        this.closeWhenExhausted = closeWhenExhausted;
    }

    public StreamPumper(InputStream is, OutputStream os) {
        this(is, os, false);
    }

    void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamPumper streamPumper = this;
        synchronized (streamPumper) {
            this.finished = false;
        }
        byte[] buf = new byte[128];
        try {
            int length;
            while ((length = this.is.read(buf)) > 0 && !this.finished) {
                this.os.write(buf, 0, length);
                if (!this.autoflush) continue;
                this.os.flush();
            }
        }
        catch (Exception e) {
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            StreamPumper streamPumper2 = this;
            synchronized (streamPumper2) {
                this.finished = true;
                this.notifyAll();
            }
        }
        finally {
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException e) {}
            }
            StreamPumper e = this;
            synchronized (e) {
                this.finished = true;
                this.notifyAll();
            }
        }
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }

    synchronized void stop() {
        this.finished = true;
        this.notifyAll();
    }
}

