/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;

public class Sync
extends Task {
    private MyCopy _copy;

    public void init() throws BuildException {
        this._copy = new MyCopy();
        this.configureTask(this._copy);
        this._copy.setFiltering(false);
        this._copy.setIncludeEmptyDirs(false);
        this._copy.setPreserveLastModified(true);
    }

    private void configureTask(Task helper) {
        helper.setProject(this.getProject());
        helper.setTaskName(this.getTaskName());
        helper.setOwningTarget(this.getOwningTarget());
        helper.init();
    }

    public void execute() throws BuildException {
        File toDir = this._copy.getToDir();
        Hashtable allFiles = this._copy._dest2src;
        boolean noRemovalNecessary = !toDir.exists() || toDir.list().length < 1;
        this.log("PASS#1: Copying files to " + toDir, 4);
        this._copy.execute();
        if (noRemovalNecessary) {
            this.log("NO removing necessary in " + toDir, 4);
            return;
        }
        this.log("PASS#2: Removing orphan files from " + toDir, 4);
        int[] removedFileCount = this.removeOrphanFiles(allFiles, toDir);
        this.logRemovedCount(removedFileCount[0], "dangling director", "y", "ies");
        this.logRemovedCount(removedFileCount[1], "dangling file", "", "s");
        if (!this._copy.getIncludeEmptyDirs()) {
            this.log("PASS#3: Removing empty directories from " + toDir, 4);
            int removedDirCount = this.removeEmptyDirectories(toDir, false);
            this.logRemovedCount(removedDirCount, "empty director", "y", "ies");
        }
    }

    private void logRemovedCount(int count, String prefix, String singularSuffix, String pluralSuffix) {
        File toDir = this._copy.getToDir();
        String what = prefix == null ? "" : prefix;
        what = what + (count < 2 ? singularSuffix : pluralSuffix);
        if (count > 0) {
            this.log("Removed " + count + " " + what + " from " + toDir, 2);
        } else {
            this.log("NO " + what + " to remove from " + toDir, 3);
        }
    }

    private int[] removeOrphanFiles(Hashtable nonOrphans, File file) {
        int[] removedCount = new int[]{0, 0, 0};
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                int[] temp = this.removeOrphanFiles(nonOrphans, children[i]);
                removedCount[0] = removedCount[0] + temp[0];
                removedCount[1] = removedCount[1] + temp[1];
                removedCount[2] = removedCount[2] + temp[2];
            }
            if (nonOrphans.get(file) == null && removedCount[2] == 0) {
                this.log("Removing orphan directory: " + file, 4);
                file.delete();
                removedCount[0] = removedCount[0] + 1;
            } else {
                removedCount[2] = 1;
            }
        } else if (nonOrphans.get(file) == null) {
            this.log("Removing orphan file: " + file, 4);
            file.delete();
            removedCount[1] = removedCount[1] + 1;
        } else {
            removedCount[2] = 1;
        }
        return removedCount;
    }

    private int removeEmptyDirectories(File dir, boolean removeIfEmpty) {
        int removedCount = 0;
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                File file = children[i];
                if (!file.isDirectory()) continue;
                removedCount += this.removeEmptyDirectories(file, true);
            }
            if (children.length > 0) {
                children = dir.listFiles();
            }
            if (children.length < 1 && removeIfEmpty) {
                this.log("Removing empty directory: " + dir, 4);
                dir.delete();
                ++removedCount;
            }
        }
        return removedCount;
    }

    public void setTodir(File destDir) {
        this._copy.setTodir(destDir);
    }

    public void setVerbose(boolean verbose) {
        this._copy.setVerbose(verbose);
    }

    public void setOverwrite(boolean overwrite) {
        this._copy.setOverwrite(overwrite);
    }

    public void setIncludeEmptyDirs(boolean includeEmpty) {
        this._copy.setIncludeEmptyDirs(includeEmpty);
    }

    public void setFailOnError(boolean failonerror) {
        this._copy.setFailOnError(failonerror);
    }

    public void addFileset(FileSet set) {
        this._copy.addFileset(set);
    }

    public void setGranularity(long granularity) {
        this._copy.setGranularity(granularity);
    }

    private static void assertTrue(String message, boolean condition) {
        if (!condition) {
            throw new BuildException("Assertion Error: " + message);
        }
    }

    public static class MyCopy
    extends Copy {
        private Hashtable _dest2src = new Hashtable();

        protected void buildMap(File fromDir, File toDir, String[] names, FileNameMapper mapper, Hashtable map) {
            Sync.assertTrue("No mapper", mapper instanceof IdentityMapper);
            super.buildMap(fromDir, toDir, names, mapper, map);
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                File dest = new File(toDir, name);
                this._dest2src.put(dest, fromDir);
            }
        }

        public File getToDir() {
            return this.destDir;
        }

        public boolean getIncludeEmptyDirs() {
            return this.includeEmpty;
        }
    }
}

