
#ifndef _REGS_ETH_H_
#define _REGS_ETH_H_

#define BIT(no) (1<<no)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Bits in RXCTL
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define RXCTL_SRxON	BIT(16)
#define RXCTL_RCRCA	BIT(13)
#define RXCTL_BA	BIT(10)
#define RXCTL_IA0	BIT(0)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Bits in TXCTL
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define TXCTL_STxON	BIT(0)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Bits in TESTCTL
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define TESTCTL_MFDX	BIT(6)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Bits in SELFCTL
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define SELFCTL_RESET	BIT(0)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Bits in GLINTMSK
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define GLINTMSK_INT	BIT(15)

// Bits in BMCTL
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define BMCTL_TxDis	BIT(9)
#define BMCTL_TxEn	BIT(8)
#define BMCTL_RxDis	BIT(1)
#define BMCTL_RxEn	BIT(0)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Bits in BMSTS
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define BMSTS_TxAct	BIT(7)
#define BMSTS_RxAct	BIT(3)

#endif
