#include <ep93xx/ioregs.h>
#include <target/io.h>
#include <target/memzero.h>
#include <target/flash.h>
#include "memregions.h"
#include "board.h"

#ifdef ENABLE_ETH
#include <target/net/eth_util.h>
#include "i2c_armadillo2x0.h"
#endif

board_type board_info;

/**
 *  __udelay() : just a temperary implementation.
 **/
#define __udelay()                       \
({                                       \
        __asm__ volatile(                \
                                " nop\n" \
                                " nop\n" \
                                " nop\n" \
                        );               \
})

void udelay(unsigned long usec){
  int i;
  for(i=0; i<usec; i++){
    __udelay();
  }
}

void mdelay(unsigned long msec){
  int i;
  for(i=0; i<msec; i++){
    udelay(1000);
  }
}

char *get_board_name(int id){
  switch(id){
  case BOARD_ID_A210:  return "Armadillo-210";
  case BOARD_ID_A220:  return "Armadillo-220";
  case BOARD_ID_A230:  return "Armadillo-230";
  case BOARD_ID_A240:  return "Armadillo-240";
  case BOARD_ID_A210C: return "Armadillo-210C";
  default:             return "Armadillo-2x0(Unknown)";
  }
}

void board_init(void){
  memzero(&board_info, sizeof(board_type));

  board_info.id    = get_board_id();
  board_info.flash = flash_get_size(FLASH_START);
  board_info.sdram = get_board_sdram32bit();
}

static int info_cmdfunc(int argc, char *argv[]){
  hprintf("id   : %p (%s)\n"
	  "flash: %s\n"
	  "sdram: %s\n",
	  board_info.id, get_board_name(board_info.id),
	  (board_info.flash == FLASH_8MiB ? "8MiB" : "4MiB"),
	  (board_info.sdram == SDRAM_32Bit ? "32Bit" : "16Bit"));
#ifdef ENABLE_ETH
  {
    unsigned char mac[6];
    arch_get_mac(mac);
    hprintf("mac  : "); print_mac(mac);
  }
#endif
  return 0;
}

const command_t info_command =
        { "info", "", "display board info",
	  &info_cmdfunc };


int jumper_mode = 0;
int check_mode_jumper(void){
#if defined RELOCATE
  if(IO_GPIO_PBDR & JP_MODE_BIT){
    //Linux-Boot Mode
    jumper_mode = 0;
  }else{
    //Hermit Mode
    jumper_mode = 1;
  }
#else
  jumper_mode = 1;
#endif
  return jumper_mode;
}
