#include <target/io.h>
#include <target/command.h>
#include "memregions.h"

/****************************************************************************
 * 
 ****************************************************************************/
void 
print_map(int index)
{
	if (regions[index].name[0]) {
		if (regions[index].type == MAP_TYPE_FLASH)
			PRINT_FLASH_MAP(index); 
		else
			PRINT_RAM_MAP(index);
	}
}

/****************************************************************************
 * 
 ****************************************************************************/
static int
memmap_cmdfunc(int argc, char *argv[])
{
	int i;
	for (i=0; i<MAX_REGION_NUM; i++)
		print_map(i);

	return 0;
}

/****************************************************************************
 * 
 ****************************************************************************/
const command_t memmap_command =
	{ "memmap", 0, "output memory map", &memmap_cmdfunc };

COMMAND(memmap_command);

