#include <hermit.h>
#include <target/memzero.h>
#include <target/mmu.h>
#include "memregions.h"

struct page_table {
	unsigned long paddr;
	unsigned long vaddr;
	unsigned long size;
	unsigned long option;
};

/****************************************************************************
 * 
 ****************************************************************************/
static void
mmu_create_page_table(struct page_table *pt)
{
	volatile unsigned long *table;
	unsigned long offset;
	unsigned long i;

	offset = MMU_TRANSLATION_TABLE_BASE + (pt->vaddr >> 18);
	for (i = 0; i < (pt->size >> 20); i++) {
		table = (volatile unsigned long *)(offset + (i << 2));
		*table = ((pt->paddr & 0xfff00000) | (i << 20) | pt->option);
	}
}

/****************************************************************************
 * 
 ****************************************************************************/
void
boost_on(int mode)
{
	int i;

	struct page_table pt_list[] = {
		/* Physical,  Virtual,    Size,       Option */
		/*-------------------------------------------*/
		/* Internal Register */
		{0x43f00000, 0x43f00000, 0x3c100000, 0xc02},
		/* SDRAM */
		{0x80000000, 0x80000000, 0x08000000, 0xc0e},
		/* Flash */
		{0xa0000000, 0xa0000000, 0x02000000, 0xc02},
		/* CS3 (SMSC911x) */
		{0xb2000000, 0xb2000000, 0x02000000, 0xc02},

	};

	memzero((void *)MMU_TRANSLATION_TABLE_BASE,
		MMU_TRANSLATION_TABLE_SIZE);

	for (i=0; i<ARRAY_SIZE(pt_list); i++)
		mmu_create_page_table(&pt_list[i]);

	__asm__ volatile 
	  (
	   "mov r0, #0;"
	   "mcr p15, 0, r0, c7, c7;"
	   "mcr p15, 0, r0, c7, c10, 4;"
	   "mcr p15, 0, r0, c8, c7;"
	   "mcr p15, 0, %0, c2, c0;"
	   "mov r0, #0x03;"
	   "mcr p15, 0, r0, c3, c0;"
	   "ldr r0, =0x0005387f;"
	   "ldr r6, =0x4107b360;"
	   "mrc p15, 0, r5, c0, c0, 0;"
	   "bic r5, r5, #0xf;"
	   "teq r5, r6;"
	   "orreq r0, r0, #(1 << 31);"
	   "mcr p15, 0, r0, c1, c0;"
	   :
	   : "r" (MMU_TRANSLATION_TABLE_BASE)
	   : "r0","r5","r6"
	   );
}

void v6_icache_inval_all(void)
{
	__asm__ volatile
	  (
	   "_v6_icache_inval_all:"
	   "mov r0, #0;"
	   "mrs r1, cpsr;"
	   "mcr p15, 0, r0, c7, c5, 0;"  /* invalidate entire I-cache */
	   "mcr p15, 0, r0, c7, c5, 0;"  /* invalidate entire I-cache */
	   "mcr p15, 0, r0, c7, c5, 0;"  /* invalidate entire I-cache */
	   "mcr p15, 0, r0, c7, c5, 0;"  /* invalidate entire I-cache */
	   "msr cpsr_cx, r1;"            /* restore interrupts */
	   "nop;"
	   "nop;"
	   "nop;"
	   "nop;"
	   "nop;"
	   "nop;"
	   "nop;"
	   "nop;"
	   "nop;"
	   "nop;"
	   "nop;"
	   :
	   :
	   : "r0","r1","memory"               /* clobber list */
	   );
}

/****************************************************************************
 * 
 ****************************************************************************/
void
boost_off(void)
{
	__asm__ volatile 
	  (
	   "mov r0, #0;"
	   "mcr p15, 0, r0, c7, c14, 0;" /* D cache clean+invalidate */
	   "mcr p15, 0, r0, c7, c10, 4;" /* drain write buffer */
	   :
	   :
	   : "r0","memory"               /* clobber list */
	   );

	v6_icache_inval_all();

	__asm__ volatile 
	  (
	   "mrc p15, 0, r0, c1, c0, 0;"  /* ctrl register */
	   "bic r0, r0, #0x07;"
	   "bic r0, r0, #0x1000;"
	   "bic r0, r0, #0x80000000;"
	   "mcr p15, 0, r0, c1, c0, 0;"  /* disable caches */
	   :
	   :
	   : "r0","memory"               /* clobber list */
	   );
}
