#include <netarm/ioregs.h>
#include "bootmode.h"

int arch_getchar(unsigned long timeout)
{
	unsigned int c;
	static unsigned int buf;
	static unsigned int remain = 0;

	if (!remain) {
		while (!(IO_SER1_STATA & RRDY)) {
			if (IO_SER1_STATA & SCSR_RBC) {
				IO_SER1_STATA = SCSR_RBC;
			}
		}
		if (IO_SER1_STATA & SCSR_RBC)
			IO_SER1_STATA = SCSR_RBC;
		remain = IO_SER1_STATA_RXFDB;
		buf = IO_SER1_FIFO_WORD;
		remain = remain ? remain : 4;
	}
	c = buf & 0xff;
	remain -= 1;
	buf >>= 8;
	return c;
}

int arch_putchar(int c, unsigned long timeout)
{
	if (!is_mfgi_hi()) {
		while (!(IO_SER1_STATA & TRDY));
		IO_SER1_FIFO_BYTE = (unsigned char) c;
	}
	return 0;
}
