/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */
#include <stddef.h>

#include <target/command.h>
#include <target/herrno.h>
#include <target/htypes.h>
#include <target/io.h>
#include <target/scan.h>
#include <target/str.h>

static int peek_cmdfunc(int argc, char *argv[])
{
	/* previous addr and width are remembered for "peeknext" */
	static addr_t addr;
	static size_t width = sizeof (word_t);

	if (argc > 2)
		return -H_EUSAGE;
	if (!strcmp(*argv, "peeknext"))
		addr += width;
	else {
		if (!strcmp(*argv, "peek8"))
			width = 1;
		else if (!strcmp(*argv, "peek16"))
			width = 2;
		else
			width = sizeof (word_t);
		if (argc > 1)
			if (scan(*++argv, &addr)) return -H_EADDR;
	}

	addr &= ~(addr_t)(width - 1);	/* align pointer */
	hprintf("*%p == 0x", addr);
	switch (width) {
	case 1:
		{
			unsigned char c = *(uint8_t*)addr;
			hprintf("%b", c);
			hprintf((c >= 32 && c < 127) ? " '%c'\n" : "\n", c);
		}
		break;
	case 2:
		hprintf("%h\n", *(uint16_t*)addr);
		break;
	case (sizeof (word_t)):
		hprintf("%x\n", *(word_t*)addr);
		break;
	}
	return 0;
}

const command_t peek8_command =
	{ "peek8", "[<addr>]", "8-bit memory peek", &peek_cmdfunc };
const command_t peek16_command =
	{ "peek16", "[<addr>]", "16-bit memory peek", &peek_cmdfunc };
const command_t peek_command =
	{ "peek", "[<addr>]", "word-size memory peek", &peek_cmdfunc };
const command_t peeknext_command =
	{ "peeknext", 0, "peek next address", &peek_cmdfunc };

