/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#ifndef _HERMIT_EP7211_MEMMAP_H_
#define _HERMIT_EP7211_MEMMAP_H_

#include <target/command.h>

#define FLASH_BANK1_START	0x00000000
#define FLASH_BANK1_LAST	0x007FFFFF
#define FLASH_BANK2_START	0x10000000
#define FLASH_BANK2_LAST	0x107FFFFF

#define SRAM_START		0x60000000
#define SRAM_LAST		0x600095FF

#define BOOTROM_START		0x70000000
#define BOOTROM_LAST		0x7000007F

/*
 * Note that these are not DRAM bank 1 and DRAM bank 2.  They are two
 * noncontiguous DRAM regions, both in DRAM bank 1.
 */
#define DRAM1_START		0xC0000000
#define DRAM1_LAST		0xC07FFFFF
#define DRAM2_START		0xC1000000
#define DRAM2_LAST		0xC17FFFFF

#ifdef BOOTMODE
#define FLASH_BANK1_MAPPED	0x70000000
#define FLASH_BANK2_MAPPED	0x60000000
#define SRAM_MAPPED		0x10000000
#define BOOTROM_MAPPED		0x00000000
#endif

/*
 * External I/O regions are remapped by boot mode as well.
 */
#ifdef BOOTMODE
#define EXT_CS8900_BASE		0x50000000
#define EXT_KBD_ADDR		0x40000000
#else
#define EXT_CS8900_BASE		0x20000000
#define EXT_KBD_ADDR		0x30000000
#endif

extern const command_t memmap_command;

#endif /* _HERMIT_EP7211_MEMMAP_H_ */

